/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.result;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.Result;
import com.google.zxing.client.result.ExpandedProductParsedResult;
import com.google.zxing.client.result.ResultParser;
import java.util.HashMap;

public final class ExpandedProductResultParser
extends ResultParser {
    @Override
    public ExpandedProductParsedResult parse(Result result) {
        String value;
        BarcodeFormat format = result.getBarcodeFormat();
        if (format != BarcodeFormat.RSS_EXPANDED) {
            return null;
        }
        String rawText = ExpandedProductResultParser.getMassagedText(result);
        String productID = null;
        String sscc = null;
        String lotNumber = null;
        String productionDate = null;
        String packagingDate = null;
        String bestBeforeDate = null;
        String expirationDate = null;
        String weight = null;
        String weightType = null;
        String weightIncrement = null;
        String price = null;
        String priceIncrement = null;
        String priceCurrency = null;
        HashMap<String, String> uncommonAIs = new HashMap<String, String>();
        for (int i = 0; i < rawText.length(); i += value.length()) {
            String ai = ExpandedProductResultParser.findAIvalue(i, rawText);
            if (ai == null) {
                return null;
            }
            value = ExpandedProductResultParser.findValue(i += ai.length() + 2, rawText);
            if ("00".equals(ai)) {
                sscc = value;
                continue;
            }
            if ("01".equals(ai)) {
                productID = value;
                continue;
            }
            if ("10".equals(ai)) {
                lotNumber = value;
                continue;
            }
            if ("11".equals(ai)) {
                productionDate = value;
                continue;
            }
            if ("13".equals(ai)) {
                packagingDate = value;
                continue;
            }
            if ("15".equals(ai)) {
                bestBeforeDate = value;
                continue;
            }
            if ("17".equals(ai)) {
                expirationDate = value;
                continue;
            }
            if ("3100".equals(ai) || "3101".equals(ai) || "3102".equals(ai) || "3103".equals(ai) || "3104".equals(ai) || "3105".equals(ai) || "3106".equals(ai) || "3107".equals(ai) || "3108".equals(ai) || "3109".equals(ai)) {
                weight = value;
                weightType = "KG";
                weightIncrement = ai.substring(3);
                continue;
            }
            if ("3200".equals(ai) || "3201".equals(ai) || "3202".equals(ai) || "3203".equals(ai) || "3204".equals(ai) || "3205".equals(ai) || "3206".equals(ai) || "3207".equals(ai) || "3208".equals(ai) || "3209".equals(ai)) {
                weight = value;
                weightType = "LB";
                weightIncrement = ai.substring(3);
                continue;
            }
            if ("3920".equals(ai) || "3921".equals(ai) || "3922".equals(ai) || "3923".equals(ai)) {
                price = value;
                priceIncrement = ai.substring(3);
                continue;
            }
            if ("3930".equals(ai) || "3931".equals(ai) || "3932".equals(ai) || "3933".equals(ai)) {
                if (value.length() < 4) {
                    return null;
                }
                price = value.substring(3);
                priceCurrency = value.substring(0, 3);
                priceIncrement = ai.substring(3);
                continue;
            }
            uncommonAIs.put(ai, value);
        }
        return new ExpandedProductParsedResult(rawText, productID, sscc, lotNumber, productionDate, packagingDate, bestBeforeDate, expirationDate, weight, weightType, weightIncrement, price, priceIncrement, priceCurrency, uncommonAIs);
    }

    private static String findAIvalue(int i, String rawText) {
        char c = rawText.charAt(i);
        if (c != '(') {
            return null;
        }
        String rawTextAux = rawText.substring(i + 1);
        StringBuilder buf = new StringBuilder();
        for (int index = 0; index < rawTextAux.length(); ++index) {
            char currentChar = rawTextAux.charAt(index);
            if (currentChar == ')') {
                return buf.toString();
            }
            if (currentChar < '0' || currentChar > '9') {
                return null;
            }
            buf.append(currentChar);
        }
        return buf.toString();
    }

    private static String findValue(int i, String rawText) {
        StringBuilder buf = new StringBuilder();
        String rawTextAux = rawText.substring(i);
        for (int index = 0; index < rawTextAux.length(); ++index) {
            char c = rawTextAux.charAt(index);
            if (c == '(') {
                if (ExpandedProductResultParser.findAIvalue(index, rawTextAux) != null) break;
                buf.append('(');
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }
}

