/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.spreadsheet;

import com.sun.javafx.scene.control.skin.VirtualFlow;
import impl.org.controlsfx.spreadsheet.CellView;
import impl.org.controlsfx.spreadsheet.GridRow;
import impl.org.controlsfx.spreadsheet.GridViewSkin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javafx.beans.binding.When;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.IndexedCell;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.TableRow;
import javafx.scene.layout.Region;
import javafx.scene.shape.Rectangle;
import org.controlsfx.control.spreadsheet.SpreadsheetView;

final class GridVirtualFlow<T extends IndexedCell<?>>
extends VirtualFlow<T> {
    private static final Comparator<GridRow> ROWCMP = new Comparator<GridRow>(){

        @Override
        public int compare(GridRow firstRow, GridRow secondRow) {
            return secondRow.getIndex() - firstRow.getIndex();
        }
    };
    private SpreadsheetView spreadSheetView;
    private final GridViewSkin gridViewSkin;
    private final ArrayList<T> myFixedCells = new ArrayList();
    public final List<Node> sheetChildren;
    private final ChangeListener<Number> hBarValueChangeListener = new ChangeListener<Number>(){

        public void changed(ObservableValue<? extends Number> ov, Number t, Number t1) {
            ((GridVirtualFlow)GridVirtualFlow.this).gridViewSkin.hBarValue.clear();
        }
    };

    public GridVirtualFlow(GridViewSkin gridViewSkin) {
        this.gridViewSkin = gridViewSkin;
        ChangeListener<Number> listenerY = new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> ov, Number t, Number t1) {
                GridVirtualFlow.this.layoutTotal();
            }
        };
        this.getVbar().valueProperty().addListener((ChangeListener)listenerY);
        this.getHbar().valueProperty().addListener(this.hBarValueChangeListener);
        this.widthProperty().addListener(this.hBarValueChangeListener);
        this.sheetChildren = this.findSheetChildren();
    }

    public void init(SpreadsheetView spv) {
        this.getHbar().maxProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                GridVirtualFlow.this.getHbar().setBlockIncrement(GridVirtualFlow.this.getWidth());
                GridVirtualFlow.this.getHbar().setUnitIncrement(newValue.doubleValue() / 20.0);
            }
        });
        this.spreadSheetView = spv;
        Rectangle rec = new Rectangle();
        rec.widthProperty().bind((ObservableValue)this.widthProperty().subtract((ObservableNumberValue)new When((ObservableBooleanValue)this.getVbar().visibleProperty()).then((ObservableNumberValue)this.getVbar().widthProperty()).otherwise(0)));
        rec.heightProperty().bind((ObservableValue)this.heightProperty().subtract((ObservableNumberValue)new When((ObservableBooleanValue)this.getHbar().visibleProperty()).then((ObservableNumberValue)this.getHbar().heightProperty()).otherwise(0)));
        this.gridViewSkin.rectangleSelection.setClip((Node)rec);
        this.getChildren().add((Object)this.gridViewSkin.rectangleSelection);
        spv.getFixedRows().addListener(observable -> {
            ArrayList<IndexedCell> toRemove = new ArrayList<IndexedCell>();
            for (IndexedCell cell : this.myFixedCells) {
                if (spv.getFixedRows().contains((Object)cell.getIndex())) continue;
                cell.setManaged(false);
                cell.setVisible(false);
                toRemove.add(cell);
            }
            this.myFixedCells.removeAll(toRemove);
        });
    }

    public void show(int index) {
        super.show(index);
        this.layoutTotal();
        this.layoutFixedRows();
    }

    public void scrollTo(int index) {
        if (!this.getCells().isEmpty() && this.spreadSheetView.getFixedRows().size() > 0) {
            for (double offset = this.gridViewSkin.getFixedRowHeight(); offset >= 0.0 && index > 0; offset -= this.gridViewSkin.getRowHeight(--index)) {
            }
        }
        super.scrollTo(index);
        this.layoutTotal();
        this.layoutFixedRows();
    }

    public double adjustPixels(double delta) {
        double returnValue = super.adjustPixels(delta);
        this.layoutTotal();
        this.layoutFixedRows();
        return returnValue;
    }

    List<T> getFixedCells() {
        return this.myFixedCells;
    }

    GridRow getTopRow() {
        if (!this.sheetChildren.isEmpty()) {
            return (GridRow)this.sheetChildren.get(this.sheetChildren.size() - 1);
        }
        return null;
    }

    protected void layoutChildren() {
        if (this.spreadSheetView != null) {
            this.sortRows();
            super.layoutChildren();
            this.layoutTotal();
            this.layoutFixedRows();
            if (this.getVbar().getVisibleAmount() == 0.0 && this.getVbar().isVisible() && this.getCells().size() != this.getCellCount()) {
                this.getVbar().setMax(1.0);
                this.getVbar().setVisibleAmount((double)((float)this.getCells().size() / (float)this.getCellCount()));
            }
        }
    }

    protected void layoutTotal() {
        this.sortRows();
        for (GridRow row : this.gridViewSkin.deportedCells.keySet()) {
            for (CellView cell : this.gridViewSkin.deportedCells.get((Object)row)) {
                row.removeCell(cell);
            }
        }
        this.gridViewSkin.deportedCells.clear();
        if (this.getCells().isEmpty()) {
            this.reconfigureCells();
        }
        for (GridRow cell : this.getCells()) {
            if (cell == null || this.gridViewSkin.hBarValue.get(cell.getIndex()) && !this.gridViewSkin.rowToLayout.get(cell.getIndex())) continue;
            cell.requestLayout();
        }
    }

    protected ScrollBar getVerticalBar() {
        return this.getVbar();
    }

    protected ScrollBar getHorizontalBar() {
        return this.getHbar();
    }

    protected List<T> getCells() {
        return super.getCells();
    }

    private List<Node> findSheetChildren() {
        Region region;
        if (!this.getChildren().isEmpty() && this.getChildren().get(0) instanceof Region && !(region = (Region)this.getChildren().get(0)).getChildrenUnmodifiable().isEmpty() && region.getChildrenUnmodifiable().get(0) instanceof Group) {
            return ((Group)region.getChildrenUnmodifiable().get(0)).getChildren();
        }
        return new ArrayList<Node>();
    }

    private void layoutFixedRows() {
        if (this.spreadSheetView.getFixedRows().size() > 0 && this.getFirstVisibleCellWithinViewPort() != null) {
            this.sortRows();
            Object row = null;
            block0: for (int i = this.spreadSheetView.getFixedRows().size() - 1; i >= 0; --i) {
                IndexedCell virtualFlowCells;
                Integer fixedRowIndex = (Integer)this.spreadSheetView.getFixedRows().get(i);
                IndexedCell lastCell = this.getLastVisibleCellWithinViewPort();
                if (lastCell != null && fixedRowIndex > lastCell.getIndex()) {
                    if (row == null) continue;
                    row.setVisible(false);
                    row.setManaged(false);
                    this.sheetChildren.remove(row);
                    continue;
                }
                Iterator<T> iterator = this.getCells().iterator();
                while (iterator.hasNext() && (virtualFlowCells = (IndexedCell)iterator.next()).getIndex() <= fixedRowIndex) {
                    if (virtualFlowCells.getIndex() != fixedRowIndex.intValue()) continue;
                    row = this.containsRows(fixedRowIndex);
                    if (row != null) {
                        row.setVisible(false);
                        row.setManaged(false);
                        this.sheetChildren.remove(row);
                    }
                    virtualFlowCells.toFront();
                    continue block0;
                }
                row = this.containsRows(fixedRowIndex);
                if (row == null) {
                    row = (IndexedCell)this.getCreateCell().call((Object)this);
                    row.getProperties().put((Object)"newcell", null);
                    this.setCellIndex((IndexedCell)row, fixedRowIndex);
                    this.resizeCellSize((IndexedCell)row);
                    this.myFixedCells.add(row);
                }
                if (!this.sheetChildren.contains(row)) {
                    this.sheetChildren.add((Node)row);
                }
                row.setManaged(true);
                row.setVisible(true);
                row.toFront();
                row.requestLayout();
            }
        }
    }

    private T containsRows(int i) {
        for (IndexedCell cell : this.myFixedCells) {
            if (cell.getIndex() != i) continue;
            return (T)cell;
        }
        return null;
    }

    private void sortRows() {
        List<T> temp = this.getCells();
        ArrayList<T> tset = new ArrayList<T>(temp);
        Collections.sort(tset, ROWCMP);
        for (TableRow r : tset) {
            r.toFront();
        }
    }
}

