/*
 * Decompiled with CFR 0.152.
 */
package de.jensd.fx.glyphs.control;

import de.jensd.fx.glyphs.GlyphIcon;
import de.jensd.fx.glyphs.control.skin.GlyphCheckBoxSkin;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIcon;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIconView;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Skin;

public class GlyphCheckBox
extends CheckBox {
    private ObjectProperty<GlyphIcon> notSelectedIcon;
    private ObjectProperty<GlyphIcon> selectedIcon;

    public GlyphCheckBox() {
        super("");
    }

    public GlyphCheckBox(GlyphIcon notSelectedIcon, GlyphIcon selectedIcon, String text) {
        super(text);
        this.setNotSelectedIcon(notSelectedIcon);
        this.setSelectedIcon(selectedIcon);
    }

    protected Skin createDefaultSkin() {
        return new GlyphCheckBoxSkin(this);
    }

    public ObjectProperty<GlyphIcon> notSelectedIconProperty() {
        if (this.notSelectedIcon == null) {
            this.notSelectedIcon = new SimpleObjectProperty((Object)new FontAwesomeIconView(FontAwesomeIcon.TOGGLE_OFF));
        }
        return this.notSelectedIcon;
    }

    public GlyphIcon getNotSelectedIcon() {
        return (GlyphIcon)((Object)this.notSelectedIconProperty().get());
    }

    public void setNotSelectedIcon(GlyphIcon icon) {
        this.notSelectedIconProperty().set((Object)icon);
    }

    public ObjectProperty<GlyphIcon> selectedIconProperty() {
        if (this.selectedIcon == null) {
            this.selectedIcon = new SimpleObjectProperty((Object)new FontAwesomeIconView(FontAwesomeIcon.TOGGLE_ON));
        }
        return this.selectedIcon;
    }

    public GlyphIcon getSelectedIcon() {
        return (GlyphIcon)((Object)this.selectedIconProperty().get());
    }

    public void setSelectedIcon(GlyphIcon icon) {
        this.selectedIconProperty().set((Object)icon);
    }
}

