/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.crosstabs.base;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import net.sf.jasperreports.crosstabs.JRCrosstabMeasure;
import net.sf.jasperreports.crosstabs.base.CrosstabBaseCloneFactory;
import net.sf.jasperreports.crosstabs.base.CrosstabBaseCloneable;
import net.sf.jasperreports.crosstabs.type.CrosstabPercentageEnum;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.type.CalculationEnum;
import net.sf.jasperreports.engine.util.JRClassLoader;
import net.sf.jasperreports.engine.util.JRCloneUtils;

public class JRBaseCrosstabMeasure
implements JRCrosstabMeasure,
Serializable,
CrosstabBaseCloneable {
    private static final long serialVersionUID = 10200L;
    public static final String EXCEPTION_MESSAGE_KEY_MEASURE_INCREMENTER_CLASS_LOAD_ERROR = "crosstabs.measure.incrementer.class.load.error";
    public static final String EXCEPTION_MESSAGE_KEY_MEASURE_PERCENTAGE_CALCULATOR_CLASS_LOAD_ERROR = "crosstabs.measure.percentage.calculator.class.load.error";
    public static final String EXCEPTION_MESSAGE_KEY_MEASURE_VALUE_CLASS_LOAD_ERROR = "crosstabs.measure.value.class.load.error";
    protected String name;
    protected String valueClassName;
    protected String valueClassRealName;
    protected Class<?> valueClass;
    protected JRExpression expression;
    protected CalculationEnum calculationValue = CalculationEnum.COUNT;
    protected String incrementerFactoryClassName;
    protected String incrementerFactoryClassRealName;
    protected Class<?> incrementerFactoryClass;
    protected CrosstabPercentageEnum percentageType = CrosstabPercentageEnum.NONE;
    protected String percentageCalculatorClassName;
    protected String percentageCalculatorClassRealName;
    protected Class<?> percentageCalculatorClass;
    protected JRVariable variable;
    private int PSEUDO_SERIAL_VERSION_UID = 60002;
    private byte percentageOfType;
    private byte calculation;

    protected JRBaseCrosstabMeasure() {
    }

    public JRBaseCrosstabMeasure(JRCrosstabMeasure measure, JRBaseObjectFactory factory) {
        factory.put(measure, this);
        this.name = measure.getName();
        this.valueClassName = measure.getValueClassName();
        this.expression = factory.getExpression(measure.getValueExpression());
        this.calculationValue = measure.getCalculationValue();
        this.incrementerFactoryClassName = measure.getIncrementerFactoryClassName();
        this.percentageType = measure.getPercentageType();
        this.percentageCalculatorClassName = measure.getPercentageCalculatorClassName();
        this.variable = factory.getVariable(measure.getVariable());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getValueClassName() {
        return this.valueClassName;
    }

    @Override
    public JRExpression getValueExpression() {
        return this.expression;
    }

    @Override
    public CalculationEnum getCalculationValue() {
        return this.calculationValue;
    }

    @Override
    public String getIncrementerFactoryClassName() {
        return this.incrementerFactoryClassName;
    }

    @Override
    public CrosstabPercentageEnum getPercentageType() {
        return this.percentageType;
    }

    @Override
    public Class<?> getIncrementerFactoryClass() {
        String className;
        if (this.incrementerFactoryClass == null && (className = this.getIncrementerFactoryClassRealName()) != null) {
            try {
                this.incrementerFactoryClass = JRClassLoader.loadClassForName(className);
            }
            catch (ClassNotFoundException e) {
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_MEASURE_INCREMENTER_CLASS_LOAD_ERROR, null, e);
            }
        }
        return this.incrementerFactoryClass;
    }

    private String getIncrementerFactoryClassRealName() {
        if (this.incrementerFactoryClassRealName == null) {
            this.incrementerFactoryClassRealName = JRClassLoader.getClassRealName(this.incrementerFactoryClassName);
        }
        return this.incrementerFactoryClassRealName;
    }

    @Override
    public Class<?> getValueClass() {
        String className;
        if (this.valueClass == null && (className = this.getValueClassRealName()) != null) {
            try {
                this.valueClass = JRClassLoader.loadClassForName(className);
            }
            catch (ClassNotFoundException e) {
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_MEASURE_VALUE_CLASS_LOAD_ERROR, null, e);
            }
        }
        return this.valueClass;
    }

    private String getValueClassRealName() {
        if (this.valueClassRealName == null) {
            this.valueClassRealName = JRClassLoader.getClassRealName(this.valueClassName);
        }
        return this.valueClassRealName;
    }

    @Override
    public JRVariable getVariable() {
        return this.variable;
    }

    @Override
    public String getPercentageCalculatorClassName() {
        return this.percentageCalculatorClassName;
    }

    @Override
    public Class<?> getPercentageCalculatorClass() {
        String className;
        if (this.percentageCalculatorClass == null && (className = this.getPercentageCalculatorClassRealName()) != null) {
            try {
                this.percentageCalculatorClass = JRClassLoader.loadClassForName(className);
            }
            catch (ClassNotFoundException e) {
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_MEASURE_PERCENTAGE_CALCULATOR_CLASS_LOAD_ERROR, null, e);
            }
        }
        return this.percentageCalculatorClass;
    }

    private String getPercentageCalculatorClassRealName() {
        if (this.percentageCalculatorClassRealName == null) {
            this.percentageCalculatorClassRealName = JRClassLoader.getClassRealName(this.percentageCalculatorClassName);
        }
        return this.percentageCalculatorClassRealName;
    }

    @Override
    public Object clone() {
        JRBaseCrosstabMeasure clone = null;
        try {
            clone = (JRBaseCrosstabMeasure)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new JRRuntimeException(e);
        }
        clone.expression = JRCloneUtils.nullSafeClone(this.expression);
        clone.variable = JRCloneUtils.nullSafeClone(this.variable);
        return clone;
    }

    @Override
    public Object clone(CrosstabBaseCloneFactory cloneFactory) {
        JRBaseCrosstabMeasure clone = (JRBaseCrosstabMeasure)this.clone();
        clone.variable = cloneFactory.clone(this.variable);
        return clone;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.PSEUDO_SERIAL_VERSION_UID < 30702) {
            this.percentageType = CrosstabPercentageEnum.getByValue(this.percentageOfType);
            this.calculationValue = CalculationEnum.getByValue(this.calculation);
        }
    }
}

