/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.data.cache;

import net.sf.jasperreports.data.cache.ColumnDataCacheHandler;
import net.sf.jasperreports.data.cache.ColumnStore;
import net.sf.jasperreports.data.cache.ColumnValues;
import net.sf.jasperreports.data.cache.EmptyColumnValues;
import net.sf.jasperreports.data.cache.NullableValues;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TypedColumnStore
implements ColumnStore {
    private static final Log log = LogFactory.getLog(TypedColumnStore.class);
    private final ColumnDataCacheHandler cacheHandler;
    private final Class<?> baseType;
    private ColumnStore valueStore;
    private Class<?> valueStoreType;
    private int count;
    private ColumnStore nullStore;

    public TypedColumnStore(ColumnDataCacheHandler cacheHandler, Class<?> baseType) {
        this.cacheHandler = cacheHandler;
        this.baseType = baseType;
        this.count = 0;
    }

    @Override
    public Class<?> getBaseValuesType() {
        return this.baseType;
    }

    @Override
    public void addValue(Object value) {
        if (value == null) {
            this.ensureNullStore();
            this.nullStore.addValue(true);
        } else {
            if (!this.ensureValueStore(value)) {
                return;
            }
            if (!this.valueStoreType.isInstance(value)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(this + ": value not instance of type " + this.baseType));
                }
                this.cacheHandler.disableCaching();
                return;
            }
            this.valueStore.addValue(value);
            if (this.nullStore != null) {
                this.nullStore.addValue(false);
            }
        }
        ++this.count;
    }

    protected void ensureNullStore() {
        if (this.nullStore == null) {
            this.nullStore = this.cacheHandler.createColumnStore(Boolean.class);
            if (log.isDebugEnabled()) {
                log.debug((Object)(this + ": created null store " + this.nullStore));
            }
            for (int i = 0; i < this.count; ++i) {
                this.nullStore.addValue(false);
            }
        }
    }

    protected boolean ensureValueStore(Object value) {
        if (this.valueStore == null) {
            Class<?> valueType = value.getClass();
            this.valueStore = this.cacheHandler.createColumnStore(valueType);
            if (log.isDebugEnabled()) {
                log.debug((Object)(this + ": created value store " + this.valueStore + " for type " + valueType));
            }
            if (this.valueStore == null) {
                this.cacheHandler.disableCaching();
                return false;
            }
            this.valueStoreType = this.valueStore.getBaseValuesType();
            if (!this.baseType.isAssignableFrom(this.valueStoreType)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(this + ": store type " + this.valueStoreType + " is not compatible with base type " + this.baseType));
                }
                this.cacheHandler.disableCaching();
                return false;
            }
        }
        return true;
    }

    @Override
    public ColumnValues createValues() {
        ColumnValues finalValues;
        EmptyColumnValues values;
        ColumnValues columnValues = values = this.valueStore == null ? EmptyColumnValues.instance() : this.valueStore.createValues();
        if (this.nullStore == null) {
            finalValues = values;
            if (log.isDebugEnabled()) {
                log.debug((Object)(this + ": created not null values of size " + values.size()));
            }
        } else {
            ColumnValues nullValues = this.nullStore.createValues();
            finalValues = new NullableValues(nullValues, values);
            if (log.isDebugEnabled()) {
                log.debug((Object)(this + ": created not nulluable values of size " + nullValues.size() + ", non null size " + values.size()));
            }
        }
        return finalValues;
    }

    public String toString() {
        return "TypedColumnStore@" + this.hashCode();
    }
}

