/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.util.JRLoader;

public final class JRSaver {
    public static final String EXCEPTION_MESSAGE_KEY_EXPRESSIONS_CLASS_FILE_SAVE_ERROR = "util.saver.expressions.class.file.save.error";
    public static final String EXCEPTION_MESSAGE_KEY_FILE_SAVE_ERROR = "util.saver.file.save.error";
    public static final String EXCEPTION_MESSAGE_KEY_OUTPUT_STREAM_SAVE_ERROR = "util.saver.output.stream.save.error";

    public static void saveObject(Object obj, String fileName) throws JRException {
        JRSaver.saveObject(obj, new File(fileName));
    }

    public static void saveObject(Object obj, File file) throws JRException {
        FileOutputStream fos = null;
        ObjectOutputStream oos = null;
        try {
            fos = new FileOutputStream(file);
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            oos = new ObjectOutputStream(bos);
            oos.writeObject(obj);
            oos.flush();
            bos.flush();
            fos.flush();
        }
        catch (IOException e) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_FILE_SAVE_ERROR, new Object[]{file}, e);
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException iOException) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void saveObject(Object obj, OutputStream os) throws JRException {
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(os);
            oos.writeObject(obj);
            oos.flush();
        }
        catch (IOException e) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_OUTPUT_STREAM_SAVE_ERROR, null, e);
        }
    }

    public static void saveClassSource(String source, File file) throws JRException {
        FileWriter fwriter = null;
        try {
            fwriter = new FileWriter(file);
            BufferedWriter bufferedWriter = new BufferedWriter(fwriter);
            bufferedWriter.write(source);
            bufferedWriter.flush();
            fwriter.flush();
        }
        catch (IOException e) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_EXPRESSIONS_CLASS_FILE_SAVE_ERROR, new Object[]{file}, e);
        }
        finally {
            if (fwriter != null) {
                try {
                    fwriter.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void saveResource(String resource, File file) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            fos.write(JRLoader.loadBytesFromResource(resource));
        }
        catch (JRException e) {
            throw new JRRuntimeException(e);
        }
        catch (IOException e) {
            throw new JRRuntimeException(e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private JRSaver() {
    }
}

