/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.types.date;

import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import net.sf.jasperreports.types.date.DateRange;
import net.sf.jasperreports.types.date.FixedDate;
import net.sf.jasperreports.types.date.FixedTimestamp;
import net.sf.jasperreports.types.date.InvalidDateRangeExpressionException;
import net.sf.jasperreports.types.date.RelativeDateRange;
import net.sf.jasperreports.types.date.RelativeTimestampRange;

public class DateRangeBuilder {
    private Date dateValue;
    private String expression;
    private String datePattern;
    private Class<? extends Date> valueClass;
    private TimeZone timeZone;
    private Integer weekStartDay;

    public DateRangeBuilder(Date dateValue) {
        this.dateValue = dateValue;
    }

    public DateRangeBuilder(String expression) {
        this.expression = expression;
    }

    public DateRangeBuilder set(String datePattern) {
        this.datePattern = datePattern;
        return this;
    }

    public DateRangeBuilder set(Class<? extends Date> valueClass) {
        this.valueClass = valueClass;
        return this;
    }

    public DateRangeBuilder set(TimeZone timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    public DateRangeBuilder set(Integer weekStartDay) {
        this.weekStartDay = weekStartDay;
        return this;
    }

    public DateRangeBuilder set(Locale locale) {
        Calendar cal = Calendar.getInstance(locale);
        this.weekStartDay = cal.getFirstDayOfWeek();
        return this;
    }

    public DateRange toDateRange() throws InvalidDateRangeExpressionException {
        if (this.dateValue != null) {
            if (this.valueClass == null) {
                if (Timestamp.class.equals(this.dateValue.getClass())) {
                    return new FixedTimestamp((Timestamp)this.dateValue);
                }
                return new FixedDate(this.dateValue);
            }
            if (Timestamp.class.equals(this.valueClass)) {
                return new FixedTimestamp(new Timestamp(this.dateValue.getTime()));
            }
            return new FixedDate(this.dateValue);
        }
        if (this.valueClass != null) {
            if (Timestamp.class.equals(this.valueClass)) {
                try {
                    return new FixedTimestamp(this.expression, this.timeZone, this.datePattern);
                }
                catch (Exception e) {
                    return new RelativeTimestampRange(this.expression, this.timeZone, this.weekStartDay);
                }
            }
            try {
                return new FixedDate(this.expression, this.timeZone, this.datePattern);
            }
            catch (Exception e) {
                return new RelativeDateRange(this.expression, this.timeZone, this.weekStartDay);
            }
        }
        if (this.datePattern != null) {
            try {
                if (this.isLikeTimestampPattern(this.datePattern)) {
                    return new FixedTimestamp(this.expression, this.timeZone, this.datePattern);
                }
                return new FixedDate(this.expression, this.timeZone, this.datePattern);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            return new FixedTimestamp(this.expression, this.timeZone, this.datePattern);
        }
        catch (Exception exception) {
            try {
                return new FixedDate(this.expression, this.timeZone, this.datePattern);
            }
            catch (Exception exception2) {
                return new RelativeDateRange(this.expression, this.timeZone, this.weekStartDay);
            }
        }
    }

    private boolean isLikeTimestampPattern(String pattern) {
        return pattern.matches(".*[hHmsS]+.*");
    }
}

