/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import mondrian.calc.IterCalc;
import mondrian.calc.ListCalc;
import mondrian.mdx.UnresolvedFunCall;
import mondrian.olap.Dimension;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.FunDef;
import mondrian.olap.Hierarchy;
import mondrian.olap.Member;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Syntax;
import mondrian.olap.Validator;
import mondrian.olap.fun.FunDefBase;
import mondrian.resource.MondrianResource;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapMember;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractAggregateFunDef
extends FunDefBase {
    public AbstractAggregateFunDef(FunDef dummyFunDef) {
        super(dummyFunDef);
    }

    @Override
    protected Exp validateArg(Validator validator, Exp[] args, int i, int category) {
        if (i == 0 && MondrianProperties.instance().EnableExpCache.get()) {
            Exp arg = args[0];
            UnresolvedFunCall cacheCall = new UnresolvedFunCall("Cache", Syntax.Function, new Exp[]{arg});
            return validator.validate(cacheCall, false);
        }
        return super.validateArg(validator, args, i, category);
    }

    protected static List evaluateCurrentList(ListCalc listCalc, Evaluator evaluator) {
        List tuples = listCalc.evaluateList(evaluator.push(false));
        int currLen = tuples.size();
        AbstractAggregateFunDef.crossProd(evaluator, currLen);
        return AbstractAggregateFunDef.processUnrelatedDimensions(tuples, evaluator);
    }

    protected Iterable evaluateCurrentIterable(IterCalc iterCalc, Evaluator evaluator) {
        Iterable iter = iterCalc.evaluateIterable(evaluator.push(false));
        int currLen = 0;
        AbstractAggregateFunDef.crossProd(evaluator, currLen);
        return iter;
    }

    private static void crossProd(Evaluator evaluator, int currLen) {
        long iterationLimit = MondrianProperties.instance().IterationLimit.get();
        if (iterationLimit > 0L) {
            int productLen = currLen;
            for (Evaluator parent = evaluator.getParent(); parent != null; parent = parent.getParent()) {
                productLen *= parent.getIterationLength();
            }
            if ((long)productLen > iterationLimit) {
                throw MondrianResource.instance().IterationLimitExceeded.ex(iterationLimit);
            }
        }
        evaluator.setIterationLength(currLen);
    }

    private static List processUnrelatedDimensions(List tuplesForAggregation, Evaluator evaluator) {
        if (tuplesForAggregation.size() == 0) {
            return tuplesForAggregation;
        }
        RolapMember measure = (RolapMember)evaluator.getMembers()[0];
        if (measure.isCalculated()) {
            return tuplesForAggregation;
        }
        RolapCube virtualCube = (RolapCube)evaluator.getCube();
        RolapCube baseCube = (RolapCube)evaluator.getMeasureCube();
        if (virtualCube.isVirtual() && baseCube != null) {
            if (virtualCube.shouldIgnoreUnrelatedDimensions(baseCube.getName())) {
                return AbstractAggregateFunDef.ignoreUnrelatedDimensions(tuplesForAggregation, baseCube);
            }
            if (MondrianProperties.instance().IgnoreMeasureForNonJoiningDimension.get()) {
                return AbstractAggregateFunDef.ignoreMeasureForNonJoiningDimension(tuplesForAggregation, baseCube);
            }
        }
        return tuplesForAggregation;
    }

    private static List ignoreMeasureForNonJoiningDimension(List tuplesForAggregation, RolapCube baseCube) {
        Set<Dimension> nonJoiningDimensions = AbstractAggregateFunDef.nonJoiningDimensions(baseCube, tuplesForAggregation);
        if (nonJoiningDimensions.size() > 0) {
            return new ArrayList();
        }
        return tuplesForAggregation;
    }

    private static List ignoreUnrelatedDimensions(List tuplesForAggregation, RolapCube baseCube) {
        Set<Dimension> nonJoiningDimensions = AbstractAggregateFunDef.nonJoiningDimensions(baseCube, tuplesForAggregation);
        LinkedHashSet<Object> processedTuples = new LinkedHashSet<Object>(tuplesForAggregation.size());
        for (int i = 0; i < tuplesForAggregation.size(); ++i) {
            Object[] tuples = AbstractAggregateFunDef.copy(AbstractAggregateFunDef.tupleAsArray(tuplesForAggregation.get(i)));
            for (int j = 0; j < tuples.length; ++j) {
                if (!nonJoiningDimensions.contains(tuples[j].getDimension())) continue;
                Hierarchy hierarchy = tuples[j].getDimension().getHierarchy();
                tuples[j] = hierarchy.hasAll() ? hierarchy.getAllMember() : hierarchy.getDefaultMember();
            }
            if (tuplesForAggregation.get(i) instanceof Member[]) {
                processedTuples.add(new MemberArray(tuples));
                continue;
            }
            processedTuples.add(tuples[0]);
        }
        return AbstractAggregateFunDef.tuplesAsList(processedTuples);
    }

    private static Set<Dimension> nonJoiningDimensions(RolapCube baseCube, List tuplesForAggregation) {
        Member[] tuple = AbstractAggregateFunDef.tupleAsArray(tuplesForAggregation.get(0));
        return baseCube.nonJoiningDimensions(tuple);
    }

    private static List tuplesAsList(Set tuples) {
        ArrayList<Object> results = new ArrayList<Object>(tuples.size());
        for (Object tuple : tuples) {
            if (tuple instanceof MemberArray) {
                results.add(((MemberArray)tuple).memberArray);
                continue;
            }
            results.add(tuple);
        }
        return results;
    }

    private static Member[] copy(Member[] members) {
        Member[] result = new Member[members.length];
        System.arraycopy(members, 0, result, 0, members.length);
        return result;
    }

    private static Member[] tupleAsArray(Object tuple) {
        Member[] result = tuple instanceof Member[] ? (Member[])tuple : new Member[]{(Member)tuple};
        return result;
    }

    private static class MemberArray {
        private Object[] memberArray;

        public MemberArray(Object[] memberArray) {
            this.memberArray = memberArray;
        }

        public int hashCode() {
            return Arrays.hashCode(this.memberArray);
        }

        public boolean equals(Object obj) {
            return Arrays.deepEquals(this.memberArray, ((MemberArray)obj).memberArray);
        }
    }
}

