/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.MemberListCalc;
import mondrian.calc.impl.AbstractListCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Dimension;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.FunDef;
import mondrian.olap.Level;
import mondrian.olap.Member;
import mondrian.olap.SchemaReader;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.MultiResolver;
import mondrian.olap.fun.Resolver;
import mondrian.olap.type.MemberType;
import mondrian.olap.type.SetType;
import mondrian.olap.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AddCalculatedMembersFunDef
extends FunDefBase {
    private static final AddCalculatedMembersFunDef instance = new AddCalculatedMembersFunDef();
    public static final Resolver resolver = new ResolverImpl();
    private static final String FLAG = "fxx";

    private AddCalculatedMembersFunDef() {
        super("AddCalculatedMembers", "Adds calculated members to a set.", FLAG);
    }

    @Override
    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        final MemberListCalc listCalc = (MemberListCalc)compiler.compileList(call.getArg(0));
        return new AbstractListCalc(call, new Calc[]{listCalc}){

            public List evaluateList(Evaluator evaluator) {
                List<Member> list = listCalc.evaluateMemberList(evaluator);
                return AddCalculatedMembersFunDef.this.addCalculatedMembers(list, evaluator);
            }
        };
    }

    private List<Member> addCalculatedMembers(List<Member> memberList, Evaluator evaluator) {
        HashMap levelMap = new HashMap();
        Dimension dim = null;
        for (Member member : memberList) {
            if (dim == null) {
                dim = member.getDimension();
            } else if (dim != member.getDimension()) {
                throw AddCalculatedMembersFunDef.newEvalException(this, "Only members from the same dimension are allowed in the AddCalculatedMembers set: " + dim.toString() + " vs " + member.getDimension().toString());
            }
            if (levelMap.containsKey(member.getLevel())) continue;
            levelMap.put(member.getLevel(), null);
        }
        ArrayList<Member> workingList = new ArrayList<Member>(memberList);
        SchemaReader schemaReader = evaluator.getQuery().getSchemaReader(true);
        for (Level level : levelMap.keySet()) {
            List<Member> calcMemberList = schemaReader.getCalculatedMembers(level);
            workingList.addAll(calcMemberList);
        }
        memberList = workingList;
        return memberList;
    }

    private static class ResolverImpl
    extends MultiResolver {
        public ResolverImpl() {
            super(instance.getName(), instance.getSignature(), instance.getDescription(), new String[]{AddCalculatedMembersFunDef.FLAG});
        }

        protected FunDef createFunDef(Exp[] args, FunDef dummyFunDef) {
            Exp arg;
            Type type1;
            if (args.length == 1 && (type1 = (arg = args[0]).getType()) instanceof SetType) {
                SetType type = (SetType)type1;
                if (type.getElementType() instanceof MemberType) {
                    return instance;
                }
                throw ResolverImpl.newEvalException(instance, "Only single dimension members allowed in set for AddCalculatedMembers");
            }
            return null;
        }
    }
}

