/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.ArrayList;
import java.util.List;
import mondrian.mdx.HierarchyExpr;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Exp;
import mondrian.olap.Id;
import mondrian.olap.MatchType;
import mondrian.olap.Member;
import mondrian.olap.OlapElement;
import mondrian.olap.Property;
import mondrian.olap.SchemaReader;
import mondrian.rolap.RolapCalculatedMember;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapCubeHierarchy;
import mondrian.rolap.RolapCubeLevel;
import mondrian.rolap.RolapMember;

public class RolapCubeMember
extends RolapMember {
    protected final String rolapAllMemberCubeName;
    protected final RolapMember rolapMember;
    protected final RolapCubeLevel rolapLevel;
    protected final RolapCube rolapCube;

    public RolapCubeMember(RolapCubeMember parent, RolapMember member, RolapCubeLevel level, RolapCube cube) {
        this.parentMember = parent;
        this.rolapMember = member;
        this.rolapLevel = level;
        this.rolapCube = cube;
        if (parent != null) {
            this.parentUniqueName = parent.getUniqueName();
        }
        if (member.isAll()) {
            if (member.getLevel().getHierarchy().getName().equals(level.getHierarchy().getName())) {
                this.rolapAllMemberCubeName = member.getName();
            } else {
                String replacement = level.getHierarchy().getName().replaceAll("\\$", "\\\\\\$");
                String memberLevelName = member.getLevel().getHierarchy().getName().replaceAll("\\.", "\\\\.");
                this.rolapAllMemberCubeName = member.getName().replaceAll(memberLevelName, replacement);
            }
            this.setUniqueName(this.rolapAllMemberCubeName);
        } else {
            this.rolapAllMemberCubeName = null;
            Object name = this.rolapMember.getPropertyValue(Property.NAME.name);
            if (!(name == null || this.rolapMember.getKey() != null && name.equals(this.rolapMember.getKey()))) {
                this.setUniqueName(name);
            } else if (this.rolapMember.getKey() != null) {
                this.setUniqueName(this.rolapMember.getKey());
            }
        }
    }

    public int getDepth() {
        return this.rolapMember.getDepth();
    }

    public boolean isNull() {
        return this.rolapMember.isNull();
    }

    public boolean isMeasure() {
        return this.rolapMember.isMeasure();
    }

    public boolean isAll() {
        return this.rolapMember.isAll();
    }

    public RolapMember getRolapMember() {
        return this.rolapMember;
    }

    public RolapCube getCube() {
        return this.rolapCube;
    }

    public Member getDataMember() {
        RolapMember member = (RolapMember)this.rolapMember.getDataMember();
        if (member != null) {
            RolapCubeMember cubeDataMember = new RolapCubeMember(this.getParentMember(), member, this.getLevel(), this.rolapCube);
            return cubeDataMember;
        }
        return null;
    }

    public int compareTo(Object o) {
        RolapCubeMember other = (RolapCubeMember)o;
        return this.rolapMember.compareTo(other.rolapMember);
    }

    public boolean equals(Object o) {
        return o == this || o instanceof RolapCubeMember && this.equals((RolapCubeMember)o);
    }

    public boolean equals(OlapElement o) {
        return o.getClass() == RolapCubeMember.class && this.equals((RolapCubeMember)o);
    }

    private boolean equals(RolapCubeMember that) {
        assert (that != null);
        return this.rolapLevel.equals(that.rolapLevel) && this.rolapMember.equals((OlapElement)that.rolapMember);
    }

    public Object getKey() {
        return this.rolapMember.getKey();
    }

    public RolapCubeHierarchy getHierarchy() {
        return (RolapCubeHierarchy)super.getHierarchy();
    }

    public RolapCubeLevel getLevel() {
        return this.rolapLevel;
    }

    public String getName() {
        if (this.rolapMember.isAll()) {
            return this.rolapAllMemberCubeName;
        }
        return this.rolapMember.getName();
    }

    public Comparable getOrderKey() {
        return this.rolapMember.getOrderKey();
    }

    void setOrderKey(Comparable orderKey) {
        throw new UnsupportedOperationException();
    }

    public int getOrdinal() {
        return this.rolapMember.getOrdinal();
    }

    void setOrdinal(int ordinal) {
        this.rolapMember.setOrdinal(ordinal);
    }

    public synchronized void setProperty(String name, Object value) {
        this.rolapMember.setProperty(name, value);
    }

    public Object getPropertyValue(String propertyName, boolean matchCase) {
        Property property = Property.lookup(propertyName, matchCase);
        if (property != null) {
            switch (property.ordinal) {
                case 4: {
                    ArrayList<RolapCubeMember> list = new ArrayList<RolapCubeMember>();
                    List origList = (List)this.rolapMember.getPropertyValue(propertyName, matchCase);
                    for (RolapMember member : origList) {
                        list.add(new RolapCubeMember(this, member, this.getLevel(), this.rolapCube));
                    }
                    return list;
                }
                case 13: {
                    return this.getHierarchy().getDimension().getUniqueName();
                }
                case 14: {
                    return this.getHierarchy().getUniqueName();
                }
                case 15: {
                    return this.getLevel().getUniqueName();
                }
                case 19: {
                    return this.getUniqueName();
                }
                case 18: {
                    return this.getName();
                }
                case 22: {
                    return this.getCaption();
                }
                case 25: {
                    RolapCubeMember parentMember = this.getParentMember();
                    return parentMember == null ? null : parentMember.getUniqueName();
                }
                case 23: {
                    if (this.rolapMember instanceof RolapCalculatedMember) {
                        return this.rolapMember.getPropertyValue(propertyName, matchCase);
                    }
                    return super.getPropertyValue(propertyName, matchCase);
                }
                case 45: 
                case 46: {
                    return this == this.getHierarchy().getAllMember() ? Integer.valueOf(0) : this.getKey();
                }
            }
        }
        return this.rolapMember.getPropertyValue(propertyName, matchCase);
    }

    public int getSolveOrder() {
        return this.rolapMember.getSolveOrder();
    }

    protected Object getPropertyFromMap(String propertyName, boolean matchCase) {
        return this.rolapMember.getPropertyFromMap(propertyName, matchCase);
    }

    public final Member.MemberType getMemberType() {
        return this.rolapMember.getMemberType();
    }

    public RolapCubeMember getParentMember() {
        return (RolapCubeMember)super.getParentMember();
    }

    public String getCaption() {
        return this.rolapMember.getCaption();
    }

    public boolean isCalculated() {
        return this.rolapMember.isCalculated();
    }

    public boolean isCalculatedInQuery() {
        return this.rolapMember.isCalculatedInQuery();
    }

    public Exp getExpression() {
        Exp exp = this.rolapMember.getExpression();
        if (exp instanceof ResolvedFunCall) {
            ResolvedFunCall fcall = (ResolvedFunCall)exp;
            for (int i = 0; i < fcall.getArgCount(); ++i) {
                HierarchyExpr expr;
                if (!(fcall.getArg(i) instanceof HierarchyExpr) || !(expr = (HierarchyExpr)fcall.getArg(i)).getHierarchy().equals(this.rolapMember.getHierarchy())) continue;
                fcall.getArgs()[i] = new HierarchyExpr(this.getHierarchy());
            }
        }
        return exp;
    }

    public OlapElement lookupChild(SchemaReader schemaReader, Id.Segment childName, MatchType matchType) {
        return schemaReader.lookupMemberChildByName(this, childName, matchType);
    }
}

