/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.agg;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mondrian.olap.Util;
import mondrian.rolap.BitKey;
import mondrian.rolap.RolapStar;
import mondrian.rolap.StarColumnPredicate;
import mondrian.rolap.StarPredicate;
import mondrian.rolap.agg.AndPredicate;
import mondrian.rolap.agg.ListColumnPredicate;
import mondrian.rolap.agg.LiteralStarPredicate;
import mondrian.rolap.agg.OrPredicate;
import mondrian.rolap.agg.ValueColumnPredicate;
import mondrian.rolap.sql.SqlQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractColumnPredicate
implements StarColumnPredicate {
    protected final RolapStar.Column constrainedColumn;
    private final BitKey constrainedColumnBitKey;

    protected AbstractColumnPredicate(RolapStar.Column constrainedColumn) {
        this.constrainedColumn = constrainedColumn;
        if (constrainedColumn != null && constrainedColumn.getTable() != null) {
            this.constrainedColumnBitKey = BitKey.Factory.makeBitKey(constrainedColumn.getStar().getColumnCount());
            this.constrainedColumnBitKey.clear();
            this.constrainedColumnBitKey.set(constrainedColumn.getBitPosition());
        } else {
            this.constrainedColumnBitKey = null;
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.constrainedColumn.getExpression().getGenericExpression());
        this.describe(buf);
        return buf.toString();
    }

    @Override
    public RolapStar.Column getConstrainedColumn() {
        return this.constrainedColumn;
    }

    @Override
    public List<RolapStar.Column> getConstrainedColumnList() {
        return Collections.singletonList(this.constrainedColumn);
    }

    @Override
    public BitKey getConstrainedColumnBitKey() {
        return this.constrainedColumnBitKey;
    }

    @Override
    public boolean evaluate(List<Object> valueList) {
        assert (valueList.size() == 1);
        return this.evaluate(valueList.get(0));
    }

    @Override
    public boolean equalConstraint(StarPredicate that) {
        return false;
    }

    @Override
    public StarPredicate or(StarPredicate predicate) {
        StarColumnPredicate starColumnPredicate;
        if (predicate instanceof StarColumnPredicate && (starColumnPredicate = (StarColumnPredicate)predicate).getConstrainedColumn() == this.getConstrainedColumn()) {
            return this.orColumn(starColumnPredicate);
        }
        ArrayList<StarPredicate> list = new ArrayList<StarPredicate>(2);
        list.add(this);
        list.add(predicate);
        return new OrPredicate(list);
    }

    @Override
    public StarColumnPredicate orColumn(StarColumnPredicate predicate) {
        assert (predicate.getConstrainedColumn() == this.getConstrainedColumn());
        if (predicate instanceof ListColumnPredicate) {
            ListColumnPredicate that = (ListColumnPredicate)predicate;
            ArrayList<StarColumnPredicate> list = new ArrayList<StarColumnPredicate>();
            list.add(this);
            list.addAll(that.getPredicates());
            return new ListColumnPredicate(this.getConstrainedColumn(), list);
        }
        ArrayList<StarColumnPredicate> list = new ArrayList<StarColumnPredicate>(2);
        list.add(this);
        list.add(predicate);
        return new ListColumnPredicate(this.getConstrainedColumn(), list);
    }

    @Override
    public StarPredicate and(StarPredicate predicate) {
        ArrayList<StarPredicate> list = new ArrayList<StarPredicate>(2);
        list.add(this);
        list.add(predicate);
        return new AndPredicate(list);
    }

    @Override
    public void toSql(SqlQuery sqlQuery, StringBuilder buf) {
        throw Util.needToImplement(this);
    }

    protected static List<StarColumnPredicate> cloneListWithColumn(RolapStar.Column column, List<StarColumnPredicate> list) {
        ArrayList<StarColumnPredicate> newList = new ArrayList<StarColumnPredicate>(list.size());
        for (StarColumnPredicate predicate : list) {
            newList.add(predicate.cloneWithColumn(column));
        }
        return newList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory {
        public static StarColumnPredicate equal(RolapStar.Column column, Object value) {
            return new ValueColumnPredicate(column, value);
        }

        public static StarColumnPredicate or(RolapStar.Column column, List<StarColumnPredicate> list) {
            return new ListColumnPredicate(column, list);
        }

        public static LiteralStarPredicate bool(boolean b) {
            return b ? LiteralStarPredicate.TRUE : LiteralStarPredicate.FALSE;
        }

        public static StarColumnPredicate equal(ValueColumnPredicate predicate) {
            return Factory.equal(predicate.getConstrainedColumn(), predicate.getValue());
        }
    }
}

