/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.agg;

import java.util.ArrayList;
import java.util.List;
import mondrian.rolap.RolapStar;
import mondrian.rolap.StarColumnPredicate;
import mondrian.rolap.StarPredicate;
import mondrian.rolap.agg.AbstractQuerySpec;
import mondrian.rolap.agg.GroupingSetsList;
import mondrian.rolap.agg.Segment;
import mondrian.rolap.sql.SqlQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SegmentArrayQuerySpec
extends AbstractQuerySpec {
    private final Segment[] segments;
    private final GroupingSetsList groupingSetsList;
    private final List<StarPredicate> compoundPredicateList;

    SegmentArrayQuerySpec(GroupingSetsList groupingSetsList, List<StarPredicate> compoundPredicateList) {
        super(groupingSetsList.getStar(), false);
        this.segments = groupingSetsList.getDefaultSegments();
        this.groupingSetsList = groupingSetsList;
        this.compoundPredicateList = compoundPredicateList;
        assert (this.isValid(true));
    }

    private boolean isValid(boolean fail) {
        assert (this.segments.length > 0);
        for (Segment segment : this.segments) {
            if (segment.aggregation != this.segments[0].aggregation) {
                assert (!fail);
                return false;
            }
            int n = segment.axes.length;
            if (n != this.segments[0].axes.length) {
                assert (!fail);
                return false;
            }
            for (int j = 0; j < segment.axes.length; ++j) {
                if (segment.axes[j].getPredicate() == this.segments[0].axes[j].getPredicate()) continue;
                assert (!fail);
                return false;
            }
        }
        return true;
    }

    @Override
    public int getMeasureCount() {
        return this.segments.length;
    }

    @Override
    public RolapStar.Measure getMeasure(int i) {
        return this.segments[i].measure;
    }

    @Override
    public String getMeasureAlias(int i) {
        return "m" + Integer.toString(i);
    }

    @Override
    public RolapStar.Column[] getColumns() {
        return this.segments[0].aggregation.getColumns();
    }

    @Override
    public String getColumnAlias(int i) {
        return "c" + Integer.toString(i);
    }

    @Override
    public StarColumnPredicate getColumnPredicate(int i) {
        return this.segments[0].axes[i].getPredicate();
    }

    @Override
    protected List<StarPredicate> getPredicateList() {
        if (this.compoundPredicateList == null) {
            return super.getPredicateList();
        }
        return this.compoundPredicateList;
    }

    @Override
    protected void addGroupingFunction(SqlQuery sqlQuery) {
        List<RolapStar.Column> list = this.groupingSetsList.getRollupColumns();
        for (RolapStar.Column column : list) {
            sqlQuery.addGroupingFunction(column.generateExprString(sqlQuery));
        }
    }

    @Override
    protected void addGroupingSets(SqlQuery sqlQuery) {
        List<RolapStar.Column[]> groupingSetsColumns = this.groupingSetsList.getGroupingSetsColumns();
        for (RolapStar.Column[] groupingSetsColumn : groupingSetsColumns) {
            ArrayList<String> groupingColumnsExpr = new ArrayList<String>();
            for (RolapStar.Column aColumn : groupingSetsColumn) {
                groupingColumnsExpr.add(aColumn.generateExprString(sqlQuery));
            }
            sqlQuery.addGroupingSet(groupingColumnsExpr);
        }
    }

    @Override
    protected boolean isAggregate() {
        return true;
    }
}

