/*
 * Decompiled with CFR 0.152.
 */
package mondrian.util;

import java.sql.Time;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import mondrian.util.Schedule;

class ScheduleUtil {
    static final Calendar epochDay = ScheduleUtil.createCalendar(new Date(0L));
    static final Calendar midnightTime = ScheduleUtil.createTimeCalendar(0, 0, 0);

    ScheduleUtil() {
    }

    public static void assertTrue(boolean b) {
        if (!b) {
            throw new Error("assertion failed");
        }
    }

    public static void assertTrue(boolean b, String s) {
        if (!b) {
            throw new Error("assertion failed: " + s);
        }
    }

    public static Error newInternal() {
        return new Error("internal error");
    }

    public static Error newInternal(Throwable e, String s) {
        return new Error("internal error '" + e + "': " + s);
    }

    public static Error newInternal(String s) {
        return new Error("internal error: " + s);
    }

    public static boolean lessThan(Time t1, Time t2, boolean strict) {
        if (strict) {
            return t1.getTime() < t2.getTime();
        }
        return t1.getTime() <= t2.getTime();
    }

    public static boolean lessThan(Date d1, Date d2, boolean strict) {
        if (strict) {
            return d1.getTime() < d2.getTime();
        }
        return d1.getTime() <= d2.getTime();
    }

    public static boolean is0000(Calendar calendar) {
        return calendar.get(11) == 0 && calendar.get(12) == 0 && calendar.get(13) == 0 && calendar.get(14) == 0;
    }

    public static boolean isTime(Calendar calendar) {
        return calendar.get(1) == epochDay.get(1) && calendar.get(6) == epochDay.get(6);
    }

    public static Calendar floor(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        calendar = (Calendar)calendar.clone();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar;
    }

    public static Calendar ceiling(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        if (ScheduleUtil.is0000(calendar)) {
            return calendar;
        }
        calendar = (Calendar)calendar.clone();
        calendar.add(5, 1);
        return calendar;
    }

    public static Calendar getTime(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        return ScheduleUtil.createTimeCalendar(calendar.get(11), calendar.get(12), calendar.get(13));
    }

    public static Calendar createCalendar(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(Schedule.utcTimeZone);
        calendar.setTime(date);
        return calendar;
    }

    public static Calendar createCalendar(int year, int month, int day, int hour, int minute, int second) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(Schedule.utcTimeZone);
        calendar.toString();
        calendar.set(1, year);
        calendar.set(2, month - 1);
        calendar.set(5, day);
        calendar.set(11, hour);
        calendar.set(12, minute);
        calendar.set(13, second);
        calendar.set(14, 0);
        return calendar;
    }

    public static Calendar createTimeCalendar(Time time) {
        Calendar calendar = (Calendar)epochDay.clone();
        calendar.setTimeZone(Schedule.utcTimeZone);
        calendar.setTime(time);
        return ScheduleUtil.createTimeCalendar(calendar.get(11), calendar.get(12), calendar.get(13));
    }

    public static Calendar createTimeCalendar(int hours, int minutes, int seconds) {
        Calendar calendar = (Calendar)epochDay.clone();
        calendar.set(11, hours);
        calendar.set(12, minutes);
        calendar.set(13, seconds);
        calendar.set(14, 0);
        return calendar;
    }

    public static Calendar createDateCalendar(int year, int month, int dayOfMonth) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(Schedule.utcTimeZone);
        calendar.set(1, year);
        calendar.set(2, month);
        calendar.set(5, dayOfMonth);
        return calendar;
    }

    public static Time createTime(int hour, int minutes, int second) {
        return new Time(ScheduleUtil.createTimeCalendar(hour, minutes, second).getTime().getTime());
    }

    public static int julianDay(Calendar calendar) {
        int year = calendar.get(1);
        int day = calendar.get(6);
        int leapDays = year / 4 - year / 100 + year / 400;
        return year * 365 + leapDays + day;
    }

    public static int timezoneOffset(TimeZone tz, Calendar calendar) {
        return tz.getOffset(calendar.get(0), calendar.get(1), calendar.get(2), calendar.get(5), calendar.get(7), 1000 * (60 * (60 * calendar.get(11) + calendar.get(12)) + calendar.get(13)) + calendar.get(14));
    }
}

