/*
 * Decompiled with CFR 0.152.
 */
package mondrian.xmla.impl;

import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import mondrian.olap.Util;
import mondrian.xmla.SaxWriter;
import mondrian.xmla.XmlaResponse;
import mondrian.xmla.XmlaUtil;
import mondrian.xmla.impl.DefaultSaxWriter;

public class DefaultXmlaResponse
implements XmlaResponse {
    private static final String MSG_ENCODING_ERROR = "Encoding unsupported: ";
    private final SaxWriter writer;

    public DefaultXmlaResponse(OutputStream outputStream, String encoding) {
        try {
            this.writer = new DefaultSaxWriter(outputStream, encoding);
        }
        catch (UnsupportedEncodingException uee) {
            throw Util.newError(uee, MSG_ENCODING_ERROR + encoding);
        }
    }

    public SaxWriter getWriter() {
        return this.writer;
    }

    public void error(Throwable t) {
        this.writer.completeBeforeElement("root");
        Throwable throwable = XmlaUtil.rootThrowable(t);
        this.writer.startElement("Messages");
        this.writer.startElement("Error", new String[]{"ErrorCode", throwable.getClass().getName(), "Description", throwable.getMessage(), "Source", "Mondrian", "Help", ""});
        this.writer.endElement();
        this.writer.endElement();
    }
}

