/*
 * Decompiled with CFR 0.152.
 */
package update;

import com.sun.java.swing.plaf.motif.MotifLookAndFeel;
import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import java.awt.GraphicsEnvironment;
import java.awt.Window;
import java.io.Serializable;
import javax.swing.JFrame;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class Look
implements Serializable {
    public static final int WINDOWS = 0;
    public static final int UNIX = 1;
    public static final int JAVA = 2;
    public static final int SYSTEM = 3;
    public static final int SYNTHETICA_BLACK_STAR = 4;
    public static final int SYNTHETICA_BLACK_MOON = 5;
    public static final int SYNTHETICA_ORANGE_METALIC = 6;
    public static final int SYNTHETICA_STANDARD = 7;

    private Look() {
    }

    private static MotifLookAndFeel getUnixLook() {
        return new MotifLookAndFeel();
    }

    private static WindowsLookAndFeel getWindowsLook() {
        return new WindowsLookAndFeel();
    }

    private static MetalLookAndFeel getJavaLook() {
        return new MetalLookAndFeel();
    }

    public static void setLook(int look) {
        try {
            switch (look) {
                case 0: {
                    UIManager.setLookAndFeel((LookAndFeel)Look.getWindowsLook());
                    break;
                }
                case 1: {
                    UIManager.setLookAndFeel(Look.getUnixLook());
                    break;
                }
                case 2: {
                    UIManager.setLookAndFeel(Look.getJavaLook());
                    break;
                }
                case 3: {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setLook(JFrame frame, int look) {
        Look.setLook(look);
        SwingUtilities.updateComponentTreeUI(frame);
    }

    public static void centerFrame(Window window) {
        window.setBounds((int)GraphicsEnvironment.getLocalGraphicsEnvironment().getCenterPoint().getX() - window.getWidth() / 2, (int)GraphicsEnvironment.getLocalGraphicsEnvironment().getCenterPoint().getY() - window.getHeight() / 2, window.getWidth(), window.getHeight());
    }
}

