/*
 * Decompiled with CFR 0.152.
 */
package update;

import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.LineBorder;

public class Main_Gui
extends JFrame {
    private Thread worker;
    private final String root = "update/";
    private JTextArea outText;
    private JButton cancle;
    private JButton launch;
    private JScrollPane sp;
    private JPanel pan1;
    private JPanel pan2;
    private JPanel pan3;
    private JProgressBar progressBar;
    private JLabel monitor1;
    private JLabel monitor2;
    private JLabel monitor3;
    private File f;

    public Main_Gui() {
        try {
            UIManager.setLookAndFeel((LookAndFeel)new WindowsLookAndFeel());
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(Main_Gui.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.initComponents();
        try {
            this.setIconImage(ImageIO.read(this.getClass().getResource("/update/Download.png")));
        }
        catch (IOException ex) {
            Logger.getLogger(Main_Gui.class.getName()).log(Level.SEVERE, null, ex);
        }
        Main_Gui.centerFrame(this);
        this.monitor1.setText("Contacting Download Server...");
        this.download();
    }

    private void initComponents() {
        this.setTitle("EK-systems update ...");
        this.setDefaultCloseOperation(3);
        this.setResizable(false);
        this.monitor1 = new JLabel();
        this.monitor2 = new JLabel();
        this.monitor3 = new JLabel();
        this.pan1 = new JPanel();
        BorderLayout b = new BorderLayout();
        this.pan1.setLayout(b);
        this.pan1.setBorder(BorderFactory.createTitledBorder(new LineBorder(new Color(0, 0, 0), 1, true), "Update application:"));
        this.pan2 = new JPanel();
        this.pan2.setLayout(new FlowLayout());
        this.pan3 = new JPanel();
        this.pan3.setLayout(new GridLayout(4, 1));
        this.pan3.add(this.monitor1);
        this.pan3.add(this.monitor2);
        this.launch = new JButton("Launch App");
        this.launch.setEnabled(false);
        this.launch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Main_Gui.this.launch();
            }
        });
        this.pan2.add(this.launch);
        this.cancle = new JButton("Cancel Update");
        this.cancle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("stop thread");
                Main_Gui.this.cleanup();
                System.exit(0);
            }
        });
        this.progressBar = new JProgressBar();
        this.progressBar.setValue(0);
        this.progressBar.setStringPainted(true);
        Color c = new Color(238, 64, 0);
        this.progressBar.setForeground(c);
        this.progressBar.setSize(350, 20);
        this.pan3.add(this.progressBar);
        this.pan3.add(this.monitor3);
        this.pan1.add((Component)this.pan3, "Center");
        this.pan1.add((Component)this.pan2, "South");
        this.add(this.pan1);
        this.setSize(550, 220);
    }

    public static void centerFrame(Window window) {
        window.setBounds((int)GraphicsEnvironment.getLocalGraphicsEnvironment().getCenterPoint().getX() - window.getWidth() / 2, (int)GraphicsEnvironment.getLocalGraphicsEnvironment().getCenterPoint().getY() - window.getHeight() / 2, window.getWidth(), window.getHeight());
    }

    private void download() {
        this.worker = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Main_Gui.this.downloadFile(Main_Gui.this.getDownloadLinkFromHost());
                    Main_Gui.this.unzip();
                    Main_Gui.this.copyFiles(new File("update/"), new File("").getAbsolutePath());
                    Main_Gui.this.cleanup();
                    Main_Gui.this.launch.setEnabled(true);
                    Main_Gui.this.progressBar.setString("Update Finished!");
                    Main_Gui.this.monitor1.setText("Update Finished!");
                    Main_Gui.this.monitor2.setText("");
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    JOptionPane.showMessageDialog(null, "An error occured while preforming update!");
                }
            }
        });
        this.worker.start();
    }

    private void launch() {
        String[] run = new String[]{"java", "-jar", "ZastitaNaRadu.jar"};
        try {
            Runtime.getRuntime().exec(run);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        System.exit(0);
    }

    private void cleanup() {
        this.monitor1.setText("Preforming clean up...");
        this.f = new File("update.zip");
        this.f.delete();
        this.monitor2.setText(this.f.getAbsolutePath());
        System.out.println("obriso file " + this.f.getAbsolutePath());
        this.remove(new File("update/"));
        new File("update/").delete();
    }

    private void remove(File f) {
        File[] files;
        for (File ff : files = f.listFiles()) {
            if (ff.isDirectory()) {
                this.remove(ff);
                this.monitor2.setText(ff.getAbsolutePath());
                System.out.println("obriso file " + ff.getAbsolutePath());
                ff.delete();
                continue;
            }
            this.monitor2.setText(ff.getAbsolutePath());
            System.out.println("obriso file " + ff.getAbsolutePath());
            ff.delete();
        }
    }

    private void copyFiles(File f, String dir) throws IOException {
        File[] files;
        this.progressBar.setString("Copy files...");
        this.monitor1.setText("Copy files...");
        for (File ff : files = f.listFiles()) {
            if (ff.isDirectory()) {
                new File(dir + "/" + ff.getName()).mkdir();
                this.monitor2.setText(dir + "/" + ff.getName());
                System.out.println(dir + "/" + ff.getName());
                this.copyFiles(ff, dir + "/" + ff.getName());
                continue;
            }
            System.out.println(dir + "/" + ff.getName());
            this.monitor2.setText(dir + "/" + ff.getName());
            this.copy(ff.getAbsolutePath(), dir + "/" + ff.getName());
        }
        this.progressBar.setString("Copy files...Done!");
        this.monitor1.setText("Copy files...Done!");
    }

    public void copy(String srFile, String dtFile) throws FileNotFoundException, IOException {
        int len;
        File f1 = new File(srFile);
        File f2 = new File(dtFile);
        FileInputStream in = new FileInputStream(f1);
        FileOutputStream out = new FileOutputStream(f2);
        byte[] buf = new byte[1024];
        while ((len = ((InputStream)in).read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }

    private void unzip() throws IOException {
        int BUFFER = 2048;
        BufferedOutputStream dest = null;
        BufferedInputStream is = null;
        ZipFile zipfile = new ZipFile("update.zip");
        Enumeration<? extends ZipEntry> e = zipfile.entries();
        new File("update/").mkdir();
        while (e.hasMoreElements()) {
            ZipEntry entry = e.nextElement();
            this.progressBar.setString("Extracting.......");
            this.monitor1.setText("Extracting.......");
            this.monitor2.setText("" + entry);
            if (entry.isDirectory()) {
                new File("update/" + entry.getName()).mkdir();
            } else {
                int count;
                new File("update/" + entry.getName()).createNewFile();
                is = new BufferedInputStream(zipfile.getInputStream(entry));
                byte[] data = new byte[BUFFER];
                FileOutputStream fos = new FileOutputStream("update/" + entry.getName());
                dest = new BufferedOutputStream(fos, BUFFER);
                while ((count = is.read(data, 0, BUFFER)) != -1) {
                    dest.write(data, 0, count);
                }
                dest.flush();
                dest.close();
                fos.close();
                is.close();
            }
            this.progressBar.setString("Extracting Done!");
            this.monitor1.setText("Extracting Done!");
        }
        zipfile.close();
    }

    private void downloadFile(String link) throws MalformedURLException, IOException {
        URL url = new URL(link);
        URLConnection conn = url.openConnection();
        InputStream is = conn.getInputStream();
        int max = conn.getContentLength();
        this.progressBar.setMaximum(max);
        this.monitor1.setText("<html>Downloding file...  <br/>  Update Size(compressed): " + this.preracunaj(Integer.toString(max)) + "  <html>");
        BufferedOutputStream fOut = new BufferedOutputStream(new FileOutputStream(new File("update.zip")));
        byte[] buffer = new byte[32768];
        int bytesRead = 0;
        int in = 0;
        while ((bytesRead = is.read(buffer)) != -1) {
            this.progressBar.setValue(in += bytesRead);
            this.monitor2.setText("Downloading " + this.preracunaj(Integer.toString(in)));
            fOut.write(buffer, 0, bytesRead);
        }
        fOut.flush();
        fOut.close();
        is.close();
        this.monitor1.setText("Download Complete!");
        this.progressBar.setString("Done!");
        this.monitor2.setText("Done!");
    }

    private String getDownloadLinkFromHost() throws MalformedURLException, IOException {
        String path = "http://update.eksystems.net/ZNRurlupdate.html";
        URL url = new URL(path);
        InputStream html = null;
        html = url.openStream();
        int c = 0;
        StringBuilder buffer = new StringBuilder("");
        while (c != -1) {
            c = html.read();
            buffer.append((char)c);
            System.out.print((char)c);
        }
        return buffer.substring(buffer.indexOf("[url]") + 5, buffer.indexOf("[/url]"));
    }

    private String preracunaj(String broj) {
        double br = Double.parseDouble(broj);
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        DecimalFormat dc = new DecimalFormat("#0.##", dfs);
        if (broj.length() < 4 && broj.length() > 0) {
            double rez = br;
            return dc.format(rez) + " bytes";
        }
        if (broj.length() > 3 && broj.length() < 7) {
            double rez = br / 1024.0;
            return dc.format(rez) + " KB (" + broj + " bytes)";
        }
        if (broj.length() > 6 && broj.length() < 10) {
            double rez = br / 1024.0 / 1024.0;
            return dc.format(rez) + " MB (" + broj + " bytes)";
        }
        if (broj.length() > 9 && broj.length() < 13) {
            double rez = br / 1024.0 / 1024.0 / 1024.0;
            return dc.format(rez) + " GB (" + broj + " bytes)";
        }
        if (broj.length() > 12 && broj.length() < 16) {
            double rez = br / 1024.0 / 1024.0 / 1024.0 / 1024.0;
            return dc.format(rez) + " TB (" + broj + " bytes)";
        }
        return null;
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new Main_Gui().setVisible(true);
            }
        });
    }
}

