/*
 * Decompiled with CFR 0.152.
 */
package TamplatePaneli;

import TamplatePaneli.ResizeListener;
import TamplatePaneli.TemplateController;
import TamplatePaneli.UndecoratedWindow;
import Utill.FxDialogs;
import Utill.Konekcija;
import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.function.DoubleConsumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.animation.FadeTransition;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableDoubleValue;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Insets;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.stage.Modality;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.WindowEvent;
import javafx.util.Callback;
import javafx.util.Duration;
import zastitanaradu.GlavniPanelController;

public class Template
extends UndecoratedWindow {
    private static Template tamplate;
    private Scene scene;
    private Stage stage;
    private TextField txtFilter;

    public static Template getTamplate() {
        tamplate = new Template();
        return tamplate;
    }

    public void showTemplate(String putanjaFxml, String id) {
        Parent rootTemplate = null;
        Parent rootSadrzaj = null;
        Scene scene = null;
        try {
            rootTemplate = (Parent)FXMLLoader.load((URL)this.getClass().getClassLoader().getResource("TamplatePaneli/Template.fxml"));
            rootSadrzaj = (Parent)FXMLLoader.load((URL)this.getClass().getClassLoader().getResource(putanjaFxml));
            final Stage stage = new Stage(StageStyle.TRANSPARENT);
            stage.initModality(Modality.APPLICATION_MODAL);
            scene = new Scene(rootTemplate);
            final AnchorPane n = (AnchorPane)rootSadrzaj.lookup("#" + id);
            n.setPadding(new Insets(1.0, 1.0, 1.0, 1.0));
            scene.setFill((Paint)Color.TRANSPARENT);
            ResizeListener listener = new ResizeListener(scene, stage);
            scene.setOnMouseMoved((EventHandler)listener);
            scene.setOnMousePressed((EventHandler)listener);
            scene.setOnMouseDragged((EventHandler)listener);
            stage.setScene(scene);
            stage.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

                public void handle(WindowEvent we) {
                    stage.hide();
                    stage.close();
                    n.getChildren().clear();
                    System.gc();
                }
            });
            FadeTransition ft = new FadeTransition(Duration.millis((double)1000.0), (Node)n);
            ft.setFromValue(0.0);
            ft.setToValue(1.0);
            Rectangle2D screen = Screen.getPrimary().getVisualBounds();
            double tockaX = screen.getWidth() / 2.0 - n.getPrefWidth() / 2.0;
            double tockaY = screen.getHeight() / 2.0 - n.getPrefHeight() / 2.0;
            try {
                TemplateController.getInstance().loadPanel((Node)n);
            }
            catch (IOException ex) {
                Logger.getLogger(Template.class.getName()).log(Level.SEVERE, null, ex);
            }
            stage.setX(tockaX);
            stage.setY(tockaY);
            stage.setHeight(n.getPrefHeight());
            stage.setWidth(n.getPrefWidth());
            TemplateController.getInstance().setStage(stage);
            stage.show();
        }
        catch (IOException ex) {
            Logger.getLogger(Template.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void showTemplate(String putanjaFxml, String id, String putanjaCSS) {
        String css = null;
        if (putanjaCSS != null) {
            css = this.getClass().getResource(putanjaCSS).toExternalForm();
        }
        Parent rootTemplate = null;
        Parent rootSadrzaj = null;
        Scene scene = null;
        try {
            rootTemplate = (Parent)FXMLLoader.load((URL)this.getClass().getClassLoader().getResource("TamplatePaneli/Template.fxml"));
            rootSadrzaj = (Parent)FXMLLoader.load((URL)this.getClass().getClassLoader().getResource(putanjaFxml));
            final Stage stage = new Stage(StageStyle.TRANSPARENT);
            stage.initModality(Modality.APPLICATION_MODAL);
            scene = new Scene(rootTemplate);
            if (css != null) {
                scene.getStylesheets().add((Object)css);
            }
            final AnchorPane n = (AnchorPane)rootSadrzaj.lookup("#" + id);
            n.setPadding(new Insets(1.0, 1.0, 1.0, 1.0));
            scene.setFill((Paint)Color.TRANSPARENT);
            ResizeListener listener = new ResizeListener(scene, stage);
            scene.setOnMouseMoved((EventHandler)listener);
            scene.setOnMousePressed((EventHandler)listener);
            scene.setOnMouseDragged((EventHandler)listener);
            stage.setScene(scene);
            stage.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

                public void handle(WindowEvent we) {
                    stage.hide();
                    stage.close();
                    n.getChildren().clear();
                    System.gc();
                }
            });
            FadeTransition ft = new FadeTransition(Duration.millis((double)1000.0), (Node)n);
            ft.setFromValue(0.0);
            ft.setToValue(1.0);
            Rectangle2D screen = Screen.getPrimary().getVisualBounds();
            double tockaX = screen.getWidth() / 2.0 - n.getPrefWidth() / 2.0;
            double tockaY = screen.getHeight() / 2.0 - n.getPrefHeight() / 2.0;
            try {
                TemplateController.getInstance().loadPanel((Node)n);
            }
            catch (IOException ex) {
                Logger.getLogger(Template.class.getName()).log(Level.SEVERE, null, ex);
            }
            stage.setX(tockaX);
            stage.setY(tockaY);
            stage.setHeight(n.getPrefHeight());
            stage.setWidth(n.getPrefWidth());
            TemplateController.getInstance().setStage(stage);
            stage.show();
        }
        catch (IOException ex) {
            Logger.getLogger(Template.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void sakriDialog(Stage stage) {
        double currentX = stage.getX();
        double currentY = stage.getY();
        double heigh = stage.getHeight();
        double width = stage.getWidth();
        SimpleDoubleProperty x = new SimpleDoubleProperty(currentX);
        x.addListener((obs, oldX, newX) -> {
            stage.setX(newX.doubleValue());
            if (!(stage.getX() > currentX)) {
                stage.setHeight(newX.doubleValue() / 2.0);
            } else {
                stage.setHeight(0.0);
            }
        });
        SimpleDoubleProperty y = new SimpleDoubleProperty(currentY);
        y.addListener((obs, oldY, newY) -> {
            stage.setY(newY.doubleValue());
            if (!(stage.getY() > currentY)) {
                stage.setWidth(newY.doubleValue() / 2.0);
            } else {
                stage.setWidth(0.0);
            }
        });
        Timeline animationY = new Timeline(new KeyFrame[]{new KeyFrame(Duration.seconds((double)0.5), new KeyValue[]{new KeyValue((WritableValue)x, (Object)0)}), new KeyFrame(Duration.seconds((double)0.5), new KeyValue[]{new KeyValue((WritableValue)y, (Object)0)})});
        animationY.play();
        animationY.setOnFinished(ef -> {
            stage.close();
            System.gc();
        });
    }

    public void showTemplateIspis(Scene scene, String id) {
        Parent rootTemplate = null;
        Parent rootSadrzaj = scene.getRoot();
        try {
            rootTemplate = (Parent)FXMLLoader.load((URL)this.getClass().getClassLoader().getResource("TamplatePaneli/Template.fxml"));
            this.stage = new Stage(StageStyle.TRANSPARENT);
            this.stage.initModality(Modality.APPLICATION_MODAL);
            scene = new Scene(rootTemplate);
            final VBox n = (VBox)rootSadrzaj.lookup("#" + id);
            n.setPadding(new Insets(15.0, 1.0, 1.0, 1.0));
            scene.setFill((Paint)Color.TRANSPARENT);
            ResizeListener listener = new ResizeListener(scene, this.stage);
            scene.setOnMouseMoved((EventHandler)listener);
            scene.setOnMousePressed((EventHandler)listener);
            scene.setOnMouseDragged((EventHandler)listener);
            this.stage.setScene(scene);
            this.stage.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

                public void handle(WindowEvent we) {
                    GlavniPanelController.getInstance().setBlurEfekt(null);
                    Template.this.stage.hide();
                    Template.this.stage.close();
                    Template.this.stage = null;
                    System.gc();
                }
            });
            final FadeTransition ft = new FadeTransition(Duration.millis((double)1000.0), (Node)n);
            ft.setFromValue(0.0);
            ft.setToValue(1.0);
            Rectangle2D screen = Screen.getPrimary().getVisualBounds();
            double tockaX = screen.getWidth() / 2.0 - n.getWidth() / 2.0;
            double tockaY = screen.getHeight() / 2.0 - n.getHeight() / 2.0;
            SimpleDoubleProperty x = new SimpleDoubleProperty(0.0);
            x.addListener((obs, oldX, newX) -> this.stage.setX(newX.doubleValue()));
            SimpleDoubleProperty y = new SimpleDoubleProperty(0.0);
            y.addListener((obs, oldY, newY) -> {
                this.stage.setY(newY.doubleValue());
                if (!(this.stage.getY() < tockaY)) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            try {
                                TemplateController.getInstance().loadPanel((Node)n);
                            }
                            catch (IOException ex) {
                                Logger.getLogger(Template.class.getName()).log(Level.SEVERE, null, ex);
                            }
                            Template.this.stage.setHeight(n.getHeight());
                            Template.this.stage.setWidth(n.getWidth());
                            TemplateController.getInstance().setStage(Template.this.stage);
                            ft.play();
                        }
                    });
                }
            });
            Interpolator WEB_EASE = Interpolator.SPLINE((double)0.25, (double)0.1, (double)0.25, (double)1.0);
            Timeline animationY = new Timeline(new KeyFrame[]{new KeyFrame(Duration.seconds((double)0.5), new KeyValue[]{new KeyValue((WritableValue)x, (Object)tockaX, WEB_EASE)}), new KeyFrame(Duration.seconds((double)0.5), new KeyValue[]{new KeyValue((WritableValue)y, (Object)tockaY, WEB_EASE)})});
            animationY.play();
            this.stage.show();
        }
        catch (IOException ex) {
            Logger.getLogger(Template.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void prikaziPeriodiku(String title, String nazivTablice) {
        Parent rootTemplate = null;
        try {
            rootTemplate = (Parent)FXMLLoader.load((URL)this.getClass().getClassLoader().getResource("TamplatePaneli/Template.fxml"));
        }
        catch (IOException ex) {
            Logger.getLogger(GlavniPanelController.class.getName()).log(Level.SEVERE, null, ex);
        }
        TableView tablica = this.dohvatiPeriodiku(nazivTablice);
        Text text = new Text(title);
        text.setFont(Font.font((String)"System", (FontWeight)FontWeight.BOLD, (double)20.0));
        text.setStyle("-fx-text-fill: #046272; ");
        this.txtFilter = new TextField();
        this.txtFilter.setPromptText("Filter");
        this.txtFilter.setId("textField");
        this.txtFilter.setMaxWidth(350.0);
        VBox vb = new VBox(new Node[]{this.txtFilter, tablica});
        VBox.setVgrow((Node)tablica, (Priority)Priority.ALWAYS);
        this.popuniFilter(tablica);
        BorderPane root = new BorderPane((Node)vb, (Node)new StackPane(new Node[]{text}), null, null, null);
        root.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        root.setPrefWidth(900.0);
        root.setPrefHeight(700.0);
        Stage dialog = new Stage();
        dialog.initStyle(StageStyle.TRANSPARENT);
        dialog.initModality(Modality.APPLICATION_MODAL);
        dialog.setTitle(title);
        Scene scene = new Scene(rootTemplate);
        scene.setFill((Paint)Color.TRANSPARENT);
        ResizeListener listener = new ResizeListener(scene, dialog);
        scene.setOnMouseMoved((EventHandler)listener);
        scene.setOnMousePressed((EventHandler)listener);
        scene.setOnMouseDragged((EventHandler)listener);
        dialog.setScene(scene);
        try {
            TemplateController.getInstance().loadPanel((Node)root);
        }
        catch (IOException ex) {
            Logger.getLogger(Template.class.getName()).log(Level.SEVERE, null, ex);
        }
        Screen screen = Screen.getPrimary();
        Rectangle2D sbounds = screen.getBounds();
        double sw = sbounds.getWidth();
        double sh = sbounds.getHeight();
        this.listenToSizeInitialization((ObservableDoubleValue)dialog.widthProperty(), w -> dialog.setX((sw - w) / 2.0));
        this.listenToSizeInitialization((ObservableDoubleValue)dialog.heightProperty(), h -> dialog.setY((sh - h) / 2.0));
        TemplateController.getInstance().setStage(dialog);
        dialog.show();
    }

    private void popuniFilter(final TableView tablicaKorisnici) {
        final ObservableList dataList = tablicaKorisnici.getItems();
        this.txtFilter.textProperty().addListener(new InvalidationListener(){

            public void invalidated(Observable observable) {
                if (((String)Template.this.txtFilter.textProperty().get()).isEmpty()) {
                    tablicaKorisnici.setItems(dataList);
                    return;
                }
                ObservableList tableItems = FXCollections.observableArrayList();
                ObservableList cols = tablicaKorisnici.getColumns();
                block0: for (int i = 0; i < dataList.size(); ++i) {
                    for (int j = 0; j < cols.size(); ++j) {
                        TableColumn col = (TableColumn)cols.get(j);
                        String cellValue = col.getCellData(dataList.get(i)).toString();
                        if (!(cellValue = cellValue.toLowerCase()).startsWith(((String)Template.this.txtFilter.textProperty().get()).toLowerCase())) continue;
                        tableItems.add(dataList.get(i));
                        continue block0;
                    }
                }
                tablicaKorisnici.setItems(tableItems);
            }
        });
    }

    private void listenToSizeInitialization(final ObservableDoubleValue size, final DoubleConsumer handler) {
        ChangeListener<Number> listener = new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> obs, Number oldSize, Number newSize) {
                if (newSize.doubleValue() != Double.NaN) {
                    handler.accept(newSize.doubleValue());
                    size.removeListener((ChangeListener)this);
                }
            }
        };
        size.addListener((ChangeListener)listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TableView dohvatiPeriodiku(String nazivTablice) {
        Konekcija k = new Konekcija();
        TableView tableview = new TableView();
        tableview.setEditable(true);
        ObservableList data = FXCollections.observableArrayList();
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = k.getConnection();
            stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery("SELECT * FROM " + nazivTablice);
            for (int i = 0; i < rs.getMetaData().getColumnCount(); ++i) {
                TableColumn col;
                final int j = i;
                if (rs.getMetaData().getColumnName(i + 1).equals("id")) {
                    col = new TableColumn("RED.BR");
                    col.setStyle("-fx-alignment: CENTER;");
                    col.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ObservableList, String>, ObservableValue<String>>(){

                        public ObservableValue<String> call(TableColumn.CellDataFeatures<ObservableList, String> param) {
                            return new SimpleStringProperty(((ObservableList)param.getValue()).get(j).toString());
                        }
                    });
                    tableview.getColumns().add(0, (Object)col);
                    continue;
                }
                if (rs.getMetaData().getColumnName(i + 1).equals("sifra")) {
                    col = new TableColumn("\u0160IFRA");
                    col.setStyle("-fx-alignment: CENTER;");
                    col.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ObservableList, String>, ObservableValue<String>>(){

                        public ObservableValue<String> call(TableColumn.CellDataFeatures<ObservableList, String> param) {
                            return new SimpleStringProperty(((ObservableList)param.getValue()).get(j).toString().replace(",", "."));
                        }
                    });
                    tableview.getColumns().add((Object)col);
                    continue;
                }
                col = new TableColumn(rs.getMetaData().getColumnName(i + 1).toUpperCase());
                col.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ObservableList, String>, ObservableValue<String>>(){

                    public ObservableValue<String> call(TableColumn.CellDataFeatures<ObservableList, String> param) {
                        return new SimpleStringProperty(((ObservableList)param.getValue()).get(j).toString());
                    }
                });
                tableview.getColumns().addAll(new Object[]{col});
            }
            while (rs.next()) {
                ObservableList row = FXCollections.observableArrayList();
                for (int i = 1; i <= rs.getMetaData().getColumnCount(); ++i) {
                    row.add((Object)rs.getString(i));
                }
                data.add((Object)row);
            }
            tableview.setItems(data);
        }
        catch (Exception e) {
            FxDialogs.showException("Gre\u0161ka spajanja sa bazom", "ERROR: ", e);
            e.printStackTrace();
            System.out.println("Error on Building Data");
        }
        finally {
            try {
                conn.close();
                stmt.close();
            }
            catch (SQLException ex) {
                FxDialogs.showException("Gre\u0161ka spajanja sa bazom", "ERROR: ", ex);
                Logger.getLogger(GlavniPanelController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return tableview;
    }
}

