/*
 * Decompiled with CFR 0.152.
 */
package Utill;

import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.TableCell;

public class CheckboxCell<S>
extends TableCell<S, Boolean> {
    private CheckBox checkBox = new CheckBox();

    public CheckboxCell() {
        this.checkBox.setDisable(true);
        this.checkBox.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (CheckboxCell.this.isEditing()) {
                    CheckboxCell.this.commitEdit(newValue == null ? false : newValue);
                }
            }
        });
        this.setEditable(true);
    }

    public void startEdit() {
        super.startEdit();
        if (this.isEmpty()) {
            return;
        }
        this.checkBox.setDisable(false);
        this.checkBox.requestFocus();
    }

    public void cancelEdit() {
        super.cancelEdit();
        this.checkBox.setDisable(true);
    }

    public void commitEdit(Boolean value) {
        super.commitEdit((Object)value);
        this.checkBox.setDisable(true);
    }

    public void updateItem(Boolean item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (!this.isEmpty()) {
            this.setGraphic((Node)this.checkBox);
            this.setAlignment(Pos.CENTER);
            this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
            this.checkBox.setSelected(item.booleanValue());
            if (this.checkBox.isSelected()) {
                this.setStyle(null);
            } else {
                this.setStyle("-fx-background-color:-fx-table-cell-border-color, tomato ;-fx-background-insets: 0, 0 0 1 0; -fx-padding: 0.0em;");
            }
        } else {
            this.setStyle(null);
            this.setText(null);
            this.setGraphic(null);
            this.setStyle(null);
        }
    }
}

