/*
 * Decompiled with CFR 0.152.
 */
package Utill;

import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.scene.control.ComboBox;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;

public class FxUtil {
    public static <T> void autoCompleteComboBox(final ComboBox<T> comboBox, final AutoCompleteMode mode) {
        final ObservableList data = comboBox.getItems();
        comboBox.setEditable(true);
        comboBox.getEditor().focusedProperty().addListener(observable -> {
            if (comboBox.getSelectionModel().getSelectedIndex() < 0) {
                comboBox.getEditor().setText(null);
            }
        });
        comboBox.addEventHandler(KeyEvent.KEY_PRESSED, t -> comboBox.hide());
        comboBox.addEventHandler(KeyEvent.KEY_RELEASED, (EventHandler)new EventHandler<KeyEvent>(){
            private boolean moveCaretToPos = false;
            private int caretPos;

            public void handle(KeyEvent event) {
                if (event.getCode() == KeyCode.UP) {
                    this.caretPos = -1;
                    this.moveCaret(comboBox.getEditor().getText().length());
                    return;
                }
                if (event.getCode() == KeyCode.DOWN) {
                    if (!comboBox.isShowing()) {
                        comboBox.show();
                    }
                    this.caretPos = -1;
                    this.moveCaret(comboBox.getEditor().getText().length());
                    return;
                }
                if (event.getCode() == KeyCode.BACK_SPACE) {
                    this.moveCaretToPos = true;
                    this.caretPos = comboBox.getEditor().getCaretPosition();
                } else if (event.getCode() == KeyCode.DELETE) {
                    this.moveCaretToPos = true;
                    this.caretPos = comboBox.getEditor().getCaretPosition();
                }
                if (event.getCode() == KeyCode.RIGHT || event.getCode() == KeyCode.LEFT || event.isControlDown() || event.getCode() == KeyCode.HOME || event.getCode() == KeyCode.END || event.getCode() == KeyCode.TAB) {
                    return;
                }
                ObservableList list = FXCollections.observableArrayList();
                for (Object aData : data) {
                    if (mode.equals((Object)AutoCompleteMode.STARTS_WITH) && aData.toString().toLowerCase().startsWith(comboBox.getEditor().getText().toLowerCase())) {
                        list.add(aData);
                        continue;
                    }
                    if (!mode.equals((Object)AutoCompleteMode.CONTAINING) || !aData.toString().toLowerCase().contains(comboBox.getEditor().getText().toLowerCase())) continue;
                    list.add(aData);
                }
                String t = comboBox.getEditor().getText();
                comboBox.setItems(list);
                comboBox.getEditor().setText(t);
                if (!this.moveCaretToPos) {
                    this.caretPos = -1;
                }
                this.moveCaret(t.length());
                if (!list.isEmpty()) {
                    comboBox.show();
                }
            }

            private void moveCaret(int textLength) {
                if (this.caretPos == -1) {
                    comboBox.getEditor().positionCaret(textLength);
                } else {
                    comboBox.getEditor().positionCaret(this.caretPos);
                }
                this.moveCaretToPos = false;
            }
        });
    }

    public static <T> T getComboBoxValue(ComboBox<T> comboBox) {
        if (comboBox.getSelectionModel().getSelectedIndex() < 0) {
            return null;
        }
        return (T)comboBox.getItems().get(comboBox.getSelectionModel().getSelectedIndex());
    }

    public static enum AutoCompleteMode {
        STARTS_WITH,
        CONTAINING;

    }
}

