/*
 * Decompiled with CFR 0.152.
 */
package Utill;

import Utill.TextUtils;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.text.Text;
import javafx.util.Callback;

public class ResizeComponent {
    public static void makeLabelResize(Label ... textLabel) {
        for (final Label tf : textLabel) {
            tf.setMinWidth(tf.getPrefWidth());
            tf.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

                public void changed(ObservableValue<? extends String> ob, String o, String n) {
                    tf.setPrefWidth(TextUtils.computeTextWidth(tf.getFont(), tf.getText(), 0.0) + 30.0);
                }
            });
        }
    }

    public static void makeTextFieldResize(TextField ... textField) {
        for (final TextField tf : textField) {
            tf.setMinWidth(tf.getPrefWidth());
            tf.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

                public void changed(ObservableValue<? extends String> ob, String o, String n) {
                    tf.setPrefWidth(TextUtils.computeTextWidth(tf.getFont(), tf.getText(), 0.0) + 30.0);
                }
            });
        }
    }

    public static void makeComboBoxResize(ComboBox ... comboBox) {
        for (final ComboBox cb : comboBox) {
            cb.valueProperty().addListener((ChangeListener)new ChangeListener<String>(){

                public void changed(ObservableValue ov, String t, String t1) {
                    ResizeComponent.sizeComboBoxToText(cb, t1);
                }
            });
            cb.setOnKeyPressed(e -> {
                if (e.getCode() == KeyCode.DELETE) {
                    cb.setValue(null);
                }
            });
        }
    }

    public static void sizeComboBoxToText(ComboBox cb, String text) {
        final Text t = new Text(text);
        cb.setCellFactory((Callback)new Callback<ListView<String>, ListCell<String>>(){

            public ListCell<String> call(ListView<String> param) {
                ListCell<String> cell = new ListCell<String>(){

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null) {
                            this.setText(item);
                            t.setFont(this.getFont());
                        } else {
                            this.setText(null);
                        }
                    }
                };
                return cell;
            }
        });
        cb.setMaxWidth(TextUtils.computeTextWidth(t.getFont(), t.getText(), 0.0) + 30.0);
        cb.setValue((Object)text);
    }

    public static void makeResizeTextArea(TextArea ... textArea) {
        for (final TextArea ta : textArea) {
            ta.setMinWidth(ta.getMinWidth());
            HBox.setHgrow((Node)ta, (Priority)Priority.ALWAYS);
            ta.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

                public void changed(ObservableValue ov, String t, String t1) {
                    ResizeComponent.sizeTextAreaToText(ta, ta.getText());
                }
            });
        }
    }

    private static void sizeTextAreaToText(TextArea textArea, String text) {
        Text t = new Text(text);
        t.setFont(textArea.getFont());
        StackPane pane = new StackPane(new Node[]{t});
        pane.layout();
        double width = t.getLayoutBounds().getWidth();
        double padding = 20.0;
        textArea.setMaxWidth(width + padding);
        textArea.setText(text);
    }

    public static void makeComboBoxDeleteItem(ComboBox ... comboBox) {
        for (ComboBox cb : comboBox) {
            cb.setOnKeyPressed(e -> {
                if (e.getCode() == KeyCode.DELETE) {
                    cb.setValue(null);
                }
            });
        }
    }
}

