/*
 * Decompiled with CFR 0.152.
 */
package Utill;

import javafx.animation.Transition;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.scene.control.SplitPane;
import javafx.scene.layout.Region;
import javafx.util.Duration;

public class SplitPaneDividerSlider {
    private final Direction direction;
    private final SplitPane splitPane;
    private final int dividerIndex;
    private BooleanProperty aimContentVisibleProperty;
    private DoubleProperty lastDividerPositionProperty;
    private DoubleProperty currentDividerPositionProperty;
    private Region content;
    private double contentInitialMinWidth;
    private double contentInitialMinHeight;
    private Transition slideTransition;
    private Duration cycleDuration;
    private SplitPane.Divider dividerToMove;

    public SplitPaneDividerSlider(SplitPane splitPane, int dividerIndex, Direction direction) {
        this(splitPane, dividerIndex, direction, Duration.millis((double)7000.0));
    }

    public SplitPaneDividerSlider(SplitPane splitPane, int dividerIndex, Direction direction, Duration cycleDuration) {
        this.direction = direction;
        this.splitPane = splitPane;
        this.dividerIndex = dividerIndex;
        this.cycleDuration = cycleDuration;
        this.init();
    }

    private void init() {
        this.slideTransition = new SlideTransition(this.cycleDuration);
        switch (this.direction) {
            case LEFT: 
            case UP: {
                this.content = (Region)this.splitPane.getItems().get(this.dividerIndex);
                break;
            }
            case RIGHT: 
            case DOWN: {
                this.content = (Region)this.splitPane.getItems().get(this.dividerIndex + 1);
            }
        }
        this.contentInitialMinHeight = this.content.getMinHeight();
        this.contentInitialMinWidth = this.content.getMinWidth();
        this.dividerToMove = (SplitPane.Divider)this.splitPane.getDividers().get(this.dividerIndex);
        this.aimContentVisibleProperty().addListener((observableValue, oldValue, newValue) -> {
            if (!newValue.booleanValue()) {
                this.setLastDividerPosition(((SplitPane.Divider)this.splitPane.getDividers().get(this.dividerIndex)).getPosition());
                this.setCurrentDividerPosition(this.getLastDividerPosition());
            }
            this.content.setMinSize(0.0, 0.0);
            this.slideTransition.play();
        });
    }

    private void restoreContentSize() {
        this.content.setMinHeight(this.contentInitialMinHeight);
        this.content.setMinWidth(this.contentInitialMinWidth);
        this.setCurrentDividerPosition(this.getLastDividerPosition());
    }

    public BooleanProperty aimContentVisibleProperty() {
        if (this.aimContentVisibleProperty == null) {
            this.aimContentVisibleProperty = new SimpleBooleanProperty(true);
        }
        return this.aimContentVisibleProperty;
    }

    public void setAimContentVisible(boolean aimContentVisible) {
        this.aimContentVisibleProperty().set(aimContentVisible);
    }

    public boolean isAimContentVisible() {
        return this.aimContentVisibleProperty().get();
    }

    public DoubleProperty lastDividerPositionProperty() {
        if (this.lastDividerPositionProperty == null) {
            this.lastDividerPositionProperty = new SimpleDoubleProperty();
        }
        return this.lastDividerPositionProperty;
    }

    public double getLastDividerPosition() {
        return this.lastDividerPositionProperty().get();
    }

    public void setLastDividerPosition(double lastDividerPosition) {
        this.lastDividerPositionProperty().set(lastDividerPosition);
    }

    public DoubleProperty currentDividerPositionProperty() {
        if (this.currentDividerPositionProperty == null) {
            this.currentDividerPositionProperty = new SimpleDoubleProperty();
        }
        return this.currentDividerPositionProperty;
    }

    public double getCurrentDividerPosition() {
        return this.currentDividerPositionProperty().get();
    }

    public void setCurrentDividerPosition(double currentDividerPosition) {
        this.currentDividerPositionProperty().set(currentDividerPosition);
        this.dividerToMove.setPosition(currentDividerPosition);
    }

    private class SlideTransition
    extends Transition {
        public SlideTransition(Duration cycleDuration) {
            this.setCycleDuration(cycleDuration);
        }

        protected void interpolate(double d) {
            switch (SplitPaneDividerSlider.this.direction) {
                case LEFT: 
                case UP: {
                    if (SplitPaneDividerSlider.this.isAimContentVisible()) {
                        if (SplitPaneDividerSlider.this.getCurrentDividerPosition() + d <= SplitPaneDividerSlider.this.getLastDividerPosition()) {
                            SplitPaneDividerSlider.this.setCurrentDividerPosition(SplitPaneDividerSlider.this.getCurrentDividerPosition() + d);
                            break;
                        }
                        SplitPaneDividerSlider.this.restoreContentSize();
                        this.stop();
                        break;
                    }
                    if (SplitPaneDividerSlider.this.getCurrentDividerPosition() > 0.0) {
                        SplitPaneDividerSlider.this.setCurrentDividerPosition(SplitPaneDividerSlider.this.getCurrentDividerPosition() - d);
                        break;
                    }
                    SplitPaneDividerSlider.this.setCurrentDividerPosition(0.0);
                    this.stop();
                    break;
                }
                case RIGHT: 
                case DOWN: {
                    if (SplitPaneDividerSlider.this.isAimContentVisible()) {
                        if (SplitPaneDividerSlider.this.getCurrentDividerPosition() - d >= SplitPaneDividerSlider.this.getLastDividerPosition()) {
                            SplitPaneDividerSlider.this.setCurrentDividerPosition(SplitPaneDividerSlider.this.getCurrentDividerPosition() - d);
                            break;
                        }
                        SplitPaneDividerSlider.this.restoreContentSize();
                        this.stop();
                        break;
                    }
                    if (SplitPaneDividerSlider.this.getCurrentDividerPosition() < 1.0) {
                        SplitPaneDividerSlider.this.setCurrentDividerPosition(SplitPaneDividerSlider.this.getCurrentDividerPosition() + d);
                        break;
                    }
                    SplitPaneDividerSlider.this.setCurrentDividerPosition(1.0);
                    this.stop();
                }
            }
        }
    }

    public static enum Direction {
        UP,
        DOWN,
        LEFT,
        RIGHT;

    }
}

