/*
 * Decompiled with CFR 0.152.
 */
package alkotestiranje;

import TamplatePaneli.Template;
import Utill.DateCell;
import Utill.DateUtil;
import Utill.FxDialogs;
import Utill.KlasaKorisneMetode;
import alkotestiranje.Alkotestiranje;
import alkotestiranje.BazaAlkotestiranje;
import alkotestiranje.UnosAlkotestiranjaController;
import ispisJasper.IspisReporta;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.ToolBar;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.util.Callback;
import zastitanaradu.GlavniPanelController;

public class PopisAlkotestiranjaController
implements Initializable {
    @FXML
    private Button btnUnos;
    @FXML
    private Button btnPromjena;
    @FXML
    private Button btnBrisanje;
    @FXML
    private Button btnIspis;
    @FXML
    private TableView<Alkotestiranje> tablicaPopisAlkotestiranja;
    @FXML
    private TableColumn<Alkotestiranje, String> kolPretraga;
    @FXML
    private TableColumn<Alkotestiranje, String> kolRedBr;
    @FXML
    private TableColumn<Alkotestiranje, LocalDate> kolDatumProvjere;
    @FXML
    private TableColumn<Alkotestiranje, String> kolBrojAlkotestiranja;
    @FXML
    private TableColumn<Alkotestiranje, String> kolOib;
    @FXML
    private TableColumn<Alkotestiranje, String> kolImePrezime;
    private static PopisAlkotestiranjaController instance;
    private ToolBar tbFilter;
    private TextField tfilter;
    private ComboBox cbFilter;
    private final ObservableList<Alkotestiranje> listaAlkotestiranja = FXCollections.observableArrayList();
    ProgressIndicator progressIndicator = new ProgressIndicator();
    BooleanProperty bp = new SimpleBooleanProperty(true);

    public static PopisAlkotestiranjaController getInstance() {
        return instance;
    }

    public void initialize(URL url, ResourceBundle rb) {
        instance = this;
        this.kreirajToolBarFilter();
        this.urediTablicuPopisAlkotestiranja();
        this.popuniTablicuPopisAlkotestiranja();
        this.urediFilter(this.tablicaPopisAlkotestiranja);
        this.btnUnos.setOnAction(e -> {
            if (!GlavniPanelController.getInstance().getTabByIdifExist("Unos Alkotestiranja")) {
                GlavniPanelController.getInstance().zatvoriTab("Unos Alkotestiranja");
                GlavniPanelController.getInstance().nadodajPanel("Unos Alkotestiranja", "/alkotestiranje/UnosAlkotestiranja.fxml");
            } else {
                GlavniPanelController.getInstance().nadodajPanel("Unos Alkotestiranja", "/alkotestiranje/UnosAlkotestiranja.fxml");
            }
        });
        this.btnPromjena.setOnAction(event -> {
            Alkotestiranje al;
            int selectdIndex = this.tablicaPopisAlkotestiranja.getSelectionModel().getSelectedIndex();
            if (selectdIndex != -1 && (al = (Alkotestiranje)this.tablicaPopisAlkotestiranja.getSelectionModel().getSelectedItem()) != null) {
                if (!GlavniPanelController.getInstance().getTabByIdifExist("Unos Alkotestiranja")) {
                    GlavniPanelController.getInstance().zatvoriTab("Unos Alkotestiranja");
                    GlavniPanelController.getInstance().nadodajPanel("Unos Alkotestiranja", "/alkotestiranje/UnosAlkotestiranja.fxml");
                    UnosAlkotestiranjaController.getInstance().izmjenaAlkotestiranja(al);
                    this.tablicaPopisAlkotestiranja.getSelectionModel().clearSelection();
                } else {
                    GlavniPanelController.getInstance().nadodajPanel("Unos Alkotestiranja", "/alkotestiranje/UnosAlkotestiranja.fxml");
                    UnosAlkotestiranjaController.getInstance().izmjenaAlkotestiranja(al);
                    this.tablicaPopisAlkotestiranja.getSelectionModel().clearSelection();
                }
            }
        });
        this.btnBrisanje.setOnAction(e -> {
            Alert alert;
            Optional result;
            int selectdIndex = this.tablicaPopisAlkotestiranja.getSelectionModel().getSelectedIndex();
            if (selectdIndex != -1 && this.tablicaPopisAlkotestiranja.getSelectionModel().getSelectedItems().size() < 2 && (result = (alert = FxDialogs.getDialog(Alert.AlertType.CONFIRMATION, "Brisanje", "\u017delite li obrisati alkotestiranje")).showAndWait()).get() == ButtonType.OK) {
                if (BazaAlkotestiranje.obrisiAlkotestiranje((Alkotestiranje)this.tablicaPopisAlkotestiranja.getSelectionModel().getSelectedItem())) {
                    this.popuniTablicuPopisAlkotestiranja();
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.BOTTOM_RIGHT, "Uspje\u0161no obrisana alkotestiranje", 1, "Information graphic");
                } else {
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161no obrisana alkotestiranje", 2, "Error graphic");
                }
            }
        });
        this.btnIspis.setOnAction(e -> {
            int selectdIndex = this.tablicaPopisAlkotestiranja.getSelectionModel().getSelectedIndex();
            if (selectdIndex != -1) {
                this.ispis((ObservableList<Alkotestiranje>)this.tablicaPopisAlkotestiranja.getSelectionModel().getSelectedItems());
            }
        });
    }

    private void urediFilter(TableView tablicaPregleda) {
        FilteredList filteredData = new FilteredList(this.listaAlkotestiranja, p -> true);
        this.tfilter.textProperty().addListener((observable, oldValue, newValue) -> filteredData.setPredicate(pregled -> {
            if (newValue == null || newValue.isEmpty()) {
                return true;
            }
            String lowerCaseFilter = newValue.toLowerCase();
            return this.cbFilter.getSelectionModel().getSelectedItem().equals("ImePrezime") ? pregled.getImePrezime() != null && pregled.getImePrezime().toLowerCase().contains(lowerCaseFilter) : this.cbFilter.getSelectionModel().getSelectedItem().equals("Oib") && pregled.getOib() != null && pregled.getOib().toLowerCase().startsWith(lowerCaseFilter);
        }));
        SortedList sortedData = new SortedList((ObservableList)filteredData);
        sortedData.comparatorProperty().bind((ObservableValue)tablicaPregleda.comparatorProperty());
        tablicaPregleda.refresh();
        tablicaPregleda.setItems((ObservableList)sortedData);
    }

    private void kreirajToolBarFilter() {
        this.tbFilter = new ToolBar();
        this.tfilter = new TextField();
        this.tfilter.setPromptText("Filter");
        this.tfilter.setId("textField");
        this.cbFilter = new ComboBox();
        ObservableList filter = FXCollections.observableArrayList((Object[])new String[]{"ImePrezime", "Oib"});
        this.cbFilter.getItems().addAll((Collection)filter);
        this.cbFilter.setValue((Object)"ImePrezime");
        this.cbFilter.setPrefWidth(250.0);
        this.cbFilter.setPrefHeight(25.0);
        this.tfilter.setPrefWidth(200.0);
        this.tfilter.setPrefHeight(25.0);
        this.tbFilter.getItems().addAll((Object[])new Node[]{this.tfilter, this.cbFilter});
    }

    private void urediTablicuPopisAlkotestiranja() {
        this.tablicaPopisAlkotestiranja.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.tablicaPopisAlkotestiranja.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent e) {
                if (e.getCode() == KeyCode.ESCAPE) {
                    PopisAlkotestiranjaController.this.tablicaPopisAlkotestiranja.getSelectionModel().clearSelection();
                    e.consume();
                    return;
                }
            }
        });
        this.kolRedBr.setCellValueFactory(cellData -> ((Alkotestiranje)cellData.getValue()).redBrojProperty());
        this.kolRedBr.prefWidthProperty().bind((ObservableValue)this.tablicaPopisAlkotestiranja.widthProperty().divide(10.0));
        this.kolRedBr.setStyle("-fx-alignment: CENTER;");
        Callback dateCellFactory = param -> new DateCell();
        this.kolDatumProvjere.setCellValueFactory(cellData -> ((Alkotestiranje)cellData.getValue()).datumProvjereProperty());
        this.kolDatumProvjere.setCellFactory(dateCellFactory);
        this.kolDatumProvjere.prefWidthProperty().bind((ObservableValue)this.tablicaPopisAlkotestiranja.widthProperty().divide(6.666666666666667));
        this.kolDatumProvjere.setStyle("-fx-alignment: CENTER;");
        this.kolDatumProvjere.setEditable(false);
        this.kolBrojAlkotestiranja.setCellValueFactory(cellData -> ((Alkotestiranje)cellData.getValue()).brojAlkotestaProperty());
        this.kolBrojAlkotestiranja.prefWidthProperty().bind((ObservableValue)this.tablicaPopisAlkotestiranja.widthProperty().divide(10.0));
        this.kolBrojAlkotestiranja.setStyle("-fx-alignment: CENTER;");
        this.kolOib.setCellValueFactory(cellData -> ((Alkotestiranje)cellData.getValue()).oibProperty());
        this.kolOib.prefWidthProperty().bind((ObservableValue)this.tablicaPopisAlkotestiranja.widthProperty().divide(6.666666666666667));
        this.kolOib.setStyle("-fx-alignment: CENTER;");
        this.kolImePrezime.setCellValueFactory(cellData -> ((Alkotestiranje)cellData.getValue()).imePrezimeProperty());
        this.kolImePrezime.prefWidthProperty().bind((ObservableValue)this.tablicaPopisAlkotestiranja.widthProperty().divide(2.5));
        this.kolImePrezime.setStyle("-fx-alignment: CENTER;");
        TableColumn kolPregledDjelatnika = new TableColumn("Pregled");
        kolPregledDjelatnika.setSortable(false);
        kolPregledDjelatnika.prefWidthProperty().bind((ObservableValue)this.tablicaPopisAlkotestiranja.widthProperty().divide(10.0));
        kolPregledDjelatnika.setStyle("-fx-alignment: CENTER;");
        kolPregledDjelatnika.setCellFactory((Callback)new Callback<TableColumn<Alkotestiranje, Boolean>, TableCell<Alkotestiranje, Boolean>>(){

            public TableCell<Alkotestiranje, Boolean> call(TableColumn<Alkotestiranje, Boolean> param) {
                return new ButtonCell();
            }
        });
        this.kolPretraga.setGraphic((Node)this.tbFilter);
        this.kolPretraga.getColumns().add((Object)kolPregledDjelatnika);
    }

    public void popuniTablicuPopisAlkotestiranja() {
        this.tablicaPopisAlkotestiranja.setPlaceholder((Node)this.progressIndicator);
        this.progressIndicator.setMaxSize(200.0, 200.0);
        this.progressIndicator.setVisible(true);
        Task task = this.createTask();
        new Thread((Runnable)task).start();
        this.progressIndicator.progressProperty().bind((ObservableValue)task.progressProperty());
        this.listaAlkotestiranja.clear();
        this.tablicaPopisAlkotestiranja.getItems().clear();
    }

    private Task createTask() {
        return new Task<Void>(){

            public Void call() {
                try {
                    this.updateProgress(-1.0, 1.0);
                    this.updateMessage("Waiting...");
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(PopisAlkotestiranjaController.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    this.updateMessage("Running...");
                    ResultSet rs = BazaAlkotestiranje.dajAlkotestiranja(GlavniPanelController.getOdabranaTvrtka());
                    PopisAlkotestiranjaController.this.popuniTablicuPopisAlkotestiranja(rs);
                }
                finally {
                    Platform.runLater(() -> PopisAlkotestiranjaController.this.progressIndicator.setVisible(false));
                }
                return null;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void popuniTablicuPopisAlkotestiranja(ResultSet rs) {
        Alkotestiranje al = null;
        int br = 1;
        try {
            while (rs.next()) {
                al = new Alkotestiranje();
                al.setId(rs.getInt("id"));
                al.setRedBroj(String.valueOf(br));
                al.setBrojAlkotesta(rs.getString("brojalkotesta"));
                al.setDatumProvjere(DateUtil.getLocalDate(rs.getDate("datumprovjere")));
                al.setOib(rs.getString("oib"));
                al.setImePrezime(rs.getString("imeprezime"));
                al.setMjestoProvjere(rs.getString("mjestoprovjere"));
                al.setSati(rs.getString("sat"));
                al.setPromili(rs.getString("promili"));
                al.setProsudbaJeNIje(rs.getBoolean("prosudba"));
                al.setZakljucakJeNIje(rs.getBoolean("zakljucak"));
                al.setOvlasteniDjelatnik1(rs.getString("od1"));
                al.setOvlasteniDjelatnik2(rs.getString("od2"));
                al.setOvlasteniDjelatnik3(rs.getString("od3"));
                al.setNazocniDjelatnik1(rs.getString("nd1"));
                al.setNazocniDjelatnik2(rs.getString("nd2"));
                al.setNazocniDjelatnik3(rs.getString("nd3"));
                al.setOpisProsudbe(rs.getString("opis"));
                this.listaAlkotestiranja.add((Object)al);
                ++br;
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(PopisAlkotestiranjaController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(PopisAlkotestiranjaController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.tablicaPopisAlkotestiranja.getItems().addAll(this.listaAlkotestiranja);
    }

    private void ispis(ObservableList<Alkotestiranje> listaAlkotestiranja) {
        String idArray = "";
        for (int i = 0; i < listaAlkotestiranja.size(); ++i) {
            idArray = i == 0 ? idArray + String.valueOf(((Alkotestiranje)listaAlkotestiranja.get(i)).getId()) : idArray + "," + String.valueOf(((Alkotestiranje)listaAlkotestiranja.get(i)).getId());
        }
        String sql = " SELECT DISTINCT \n\n    tvrtka.id as idtvrtka,\n    tvrtka.naziv_tvrtke,\n    tvrtka.pbr,\n    tvrtka.mjesto,\n    tvrtka.adresa,\n  alkotestiranje.*\n    FROM alkotestiranje,\n    tvrtka\n  \n  WHERE   alkotestiranje.idtvrtka =tvrtka.id and alkotestiranje.id  IN (select(unnest(ARRAY [" + idArray + "])))and idtvrtka='" + GlavniPanelController.getOdabranaTvrtka().getId() + "'";
        IspisReporta.ispisButtonSaSubreportom(sql, this.btnIspis, "Alkotestiranje.jrxml");
    }

    private class ButtonCell
    extends TableCell<Alkotestiranje, Boolean> {
        Button cellButton = new Button("Pregled");

        ButtonCell() {
            this.cellButton.setId("btnPregled");
            this.cellButton.setContentDisplay(ContentDisplay.LEFT);
            this.cellButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent t) {
                    Alkotestiranje al;
                    int selectdIndex = PopisAlkotestiranjaController.this.tablicaPopisAlkotestiranja.getSelectionModel().getSelectedIndex();
                    if (selectdIndex != -1 && (al = (Alkotestiranje)PopisAlkotestiranjaController.this.tablicaPopisAlkotestiranja.getSelectionModel().getSelectedItem()) != null) {
                        Template.getTamplate().showTemplate("alkotestiranje/UnosAlkotestiranja.fxml", "anchorPanel", "/ro2/ro2.css");
                        UnosAlkotestiranjaController.getInstance().izmjenaAlkotestiranja(al);
                        PopisAlkotestiranjaController.this.tablicaPopisAlkotestiranja.getSelectionModel().clearSelection();
                    }
                }
            });
        }

        protected void updateItem(Boolean t, boolean empty) {
            super.updateItem((Object)t, empty);
            if (!empty) {
                this.setGraphic((Node)this.cellButton);
                this.cellButton.disableProperty().bind((ObservableValue)PopisAlkotestiranjaController.this.tablicaPopisAlkotestiranja.getSelectionModel().selectedIndexProperty().isNotEqualTo(this.getTableRow().getIndex()));
            } else {
                this.setGraphic(null);
            }
        }
    }
}

