/*
 * Decompiled with CFR 0.152.
 */
package filter;

import filter.ComboBoxUtill;
import ispisJasper.IspisJasperButtonSaSubreportom;
import ispisJasper.JasperViewerFX;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.stage.Stage;
import kadrovska.BazaDjelatnik;
import kadrovska.Djelatnik;
import net.sf.jasperreports.engine.JasperPrint;
import odjeli.Odjel;
import poslovnejedinice.PoslovneJedinice;
import radnamjesta.RadnoMjesto;
import zastitanaradu.GlavniPanelController;

public class RadniciIspisController
implements Initializable {
    @FXML
    private ComboBox<PoslovneJedinice> cboxPoslovnaJedinica;
    @FXML
    private ComboBox<Odjel> cboxOdjel;
    @FXML
    private ComboBox<RadnoMjesto> cboxRadnoMjesto;
    @FXML
    private ComboBox<Djelatnik> cboxRadnik;
    @FXML
    private ComboBox<String> cboxStrucnaSprema;
    @FXML
    private CheckBox chboxPur;
    @FXML
    private CheckBox chboxRacunalo;
    @FXML
    private CheckBox chboxOdjavljen;
    @FXML
    private CheckBox chboxNo\u0107niRadnik;
    @FXML
    private ComboBox<String> cboxSortiraj;
    @FXML
    private DatePicker dateZaposlenjaOD;
    @FXML
    private DatePicker dateZaposlenjaDO;
    @FXML
    private Button btnIspis;
    @FXML
    private ComboBox<String> cboxVrstaUgovora;
    private final ObservableList<String> listaVrstaUgovora = FXCollections.observableArrayList((Object[])new String[]{"Ugovor na neodre\u0111eno", "Ugovor na odre\u0111eno"});

    public void initialize(URL url, ResourceBundle rb) {
        this.cboxPoslovnaJedinica = ComboBoxUtill.getCBoxPoslovnice(this.cboxPoslovnaJedinica);
        this.cboxOdjel = ComboBoxUtill.getCBoxOdjele(this.cboxOdjel);
        this.cboxRadnoMjesto = ComboBoxUtill.getCBoxRadnoMjesto(this.cboxRadnoMjesto);
        this.cboxRadnik = ComboBoxUtill.getCBoxRadnik(this.cboxRadnik);
        this.cboxSortiraj = ComboBoxUtill.getCBoxSortiraj((ObservableList<String>)FXCollections.observableArrayList((Object[])new String[]{"Radno mjesto", "Poslovna jedinica", "Radniku"}), this.cboxSortiraj);
        this.popuniCBoxStrucnaSprema();
        ComboBoxUtill.makeDatePickerDelete(this.dateZaposlenjaOD, this.dateZaposlenjaDO);
        this.cboxVrstaUgovora.setItems(this.listaVrstaUgovora);
        this.btnIspis.setOnAction(e -> this.ispis());
    }

    private void popuniCBoxStrucnaSprema() {
        ResultSet rs = BazaDjelatnik.dajStrucnuSpremu();
        try {
            while (rs.next()) {
                this.cboxStrucnaSprema.getItems().add((Object)rs.getString("naziv"));
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(RadniciIspisController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(RadniciIspisController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void ispis() {
        String sql = " select * from ispisradnika where idtvrtka=" + GlavniPanelController.getOdabranaTvrtka().getId();
        StringBuilder sb = new StringBuilder(sql);
        if (!this.cboxPoslovnaJedinica.getSelectionModel().isEmpty()) {
            sb.append(" and idposlovnajedinica=" + ((PoslovneJedinice)this.cboxPoslovnaJedinica.getValue()).getId());
        }
        if (!this.cboxOdjel.getSelectionModel().isEmpty()) {
            sb.append(" and idodjel=" + ((Odjel)this.cboxOdjel.getValue()).getId());
        }
        if (!this.cboxRadnoMjesto.getSelectionModel().isEmpty()) {
            sb.append(" and idradnomjesto=" + ((RadnoMjesto)this.cboxRadnoMjesto.getValue()).getId());
        }
        if (this.cboxStrucnaSprema.getValue() != null && !((String)this.cboxStrucnaSprema.getValue()).equals("")) {
            sb.append(" and strucnasprema='" + (String)this.cboxStrucnaSprema.getValue() + "'");
        }
        if (this.cboxVrstaUgovora.getValue() != null && !((String)this.cboxVrstaUgovora.getValue()).equals("")) {
            sb.append(" and vrstazaposlenja='" + (String)this.cboxVrstaUgovora.getValue() + "'");
        }
        if (!this.cboxRadnik.getSelectionModel().isEmpty()) {
            sb.append(" and iddjelatnik=" + ((Djelatnik)this.cboxRadnik.getValue()).getId());
        }
        if (this.dateZaposlenjaOD.getValue() != null & this.dateZaposlenjaDO.getValue() != null) {
            sb.append(" and datumzaposlenja  between '" + this.dateZaposlenjaOD.getValue() + "' and '" + this.dateZaposlenjaDO.getValue() + "'");
        }
        if (this.chboxPur.isSelected()) {
            sb.append(" and pur='PUR'");
        }
        if (this.chboxRacunalo.isSelected()) {
            sb.append(" and pracunalo='PRA\u010c'");
        }
        if (this.chboxNo\u0107niRadnik.isSelected()) {
            sb.append(" and nocnirad=true");
        }
        if (this.chboxOdjavljen.isSelected()) {
            sb.append(" and odjavljen=true");
        } else {
            sb.append(" and odjavljen=false");
        }
        if (!this.cboxSortiraj.getSelectionModel().isEmpty()) {
            switch ((String)this.cboxSortiraj.getValue()) {
                case "Radno mjesto": {
                    sb.append(" order by nazivradnogmjesta");
                    break;
                }
                case "Poslovna jedinica": {
                    sb.append(" order by nazivposlovnice");
                    break;
                }
                case "Radniku": {
                    sb.append(" order by prezime");
                    break;
                }
            }
        }
        final IspisJasperButtonSaSubreportom wb = new IspisJasperButtonSaSubreportom(this.btnIspis, sb.toString(), "RadniciPopis.jrxml");
        wb.setOnSucceeded((EventHandler)new EventHandler<WorkerStateEvent>(){

            public void handle(WorkerStateEvent t) {
                if (wb.getValue() != null) {
                    JasperViewerFX viewer = new JasperViewerFX(new Stage(), ((JasperPrint)wb.getValue()).getName(), (JasperPrint)wb.getValue());
                    viewer.show();
                }
            }
        });
        wb.setOnFailed((EventHandler)new EventHandler<WorkerStateEvent>(){

            public void handle(WorkerStateEvent t) {
                System.out.println("Connection error.");
            }
        });
        new Thread((Runnable)((Object)wb)).start();
    }
}

