/*
 * Decompiled with CFR 0.152.
 */
package grupeozs;

import Utill.FxDialogs;
import Utill.KlasaKorisneMetode;
import grupeozs.BazaGrupeOZS;
import grupeozs.GrupaOZS;
import grupeozs.UnosGrupeOZSController;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.concurrent.Task;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.ToolBar;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.util.Callback;
import odjeli.PopisOdjelaController;
import zastitanaradu.GlavniPanelController;

public class PopisGrupaOZSController
implements Initializable {
    @FXML
    private Button btnUnos;
    @FXML
    private Button btnPromjena;
    @FXML
    private Button btnBrisanje;
    @FXML
    private TableView<GrupaOZS> tablicaPopisGrupaOZS;
    @FXML
    private TableColumn<GrupaOZS, String> kolPretraga;
    @FXML
    private TableColumn<GrupaOZS, String> kolRedBr;
    @FXML
    private TableColumn<GrupaOZS, String> kolOznaka;
    @FXML
    private TableColumn<GrupaOZS, String> kolNaziv;
    private static PopisGrupaOZSController instance;
    private final ObservableList<GrupaOZS> listagrupa = FXCollections.observableArrayList();
    ProgressIndicator progressIndicator = new ProgressIndicator();
    private ToolBar tbFilter;
    private TextField tfilter;
    private ComboBox cbFilter;

    public static PopisGrupaOZSController getInstance() {
        return instance;
    }

    public void initialize(URL url, ResourceBundle rb) {
        instance = this;
        this.kreirajToolBarFilter();
        this.urediKoloneUTabliciGrupeOZS();
        this.popuniTablicuGrupeOZS();
        this.urediFilter(this.tablicaPopisGrupaOZS);
        this.btnUnos.setOnAction(e -> {
            if (!GlavniPanelController.getInstance().getTabByIdifExist("Unos grupeOZS")) {
                GlavniPanelController.getInstance().zatvoriTab("Unos grupeOZS");
                GlavniPanelController.getInstance().nadodajPanel("Unos grupeOZS", "/grupeozs/UnosGrupeOZS.fxml");
            } else {
                GlavniPanelController.getInstance().nadodajPanel("Unos grupeOZS", "/grupeozs/UnosGrupeOZS.fxml");
            }
        });
        this.btnPromjena.setOnAction(e -> {
            GrupaOZS g;
            int selectdIndex = this.tablicaPopisGrupaOZS.getSelectionModel().getSelectedIndex();
            if (selectdIndex != -1 && (g = (GrupaOZS)this.tablicaPopisGrupaOZS.getSelectionModel().getSelectedItem()) != null) {
                if (!GlavniPanelController.getInstance().getTabByIdifExist("Unos grupeOZS")) {
                    GlavniPanelController.getInstance().zatvoriTab("Unos grupeOZS");
                    GlavniPanelController.getInstance().nadodajPanel("Unos grupeOZS", "/grupeozs/UnosGrupeOZS.fxml");
                    UnosGrupeOZSController.getInstance().izmjenaGrupe(g);
                    this.tablicaPopisGrupaOZS.getSelectionModel().clearSelection();
                } else {
                    GlavniPanelController.getInstance().nadodajPanel("Unos grupeOZS", "/grupeozs/UnosGrupeOZS.fxml");
                    UnosGrupeOZSController.getInstance().izmjenaGrupe(g);
                    this.tablicaPopisGrupaOZS.getSelectionModel().clearSelection();
                }
            }
        });
        this.btnBrisanje.setOnAction(e -> {
            Alert alert;
            Optional result;
            int selectdIndex = this.tablicaPopisGrupaOZS.getSelectionModel().getSelectedIndex();
            if (selectdIndex != -1 && (result = (alert = FxDialogs.getDialog(Alert.AlertType.CONFIRMATION, "Brisanje", "\u017delite li obrisati grupu")).showAndWait()).get() == ButtonType.OK) {
                if (BazaGrupeOZS.obrisiOdjel((GrupaOZS)this.tablicaPopisGrupaOZS.getSelectionModel().getSelectedItem())) {
                    this.popuniTablicuGrupeOZS();
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.BOTTOM_RIGHT, "Uspje\u0161no obrisana grupa", 1, "Information graphic");
                } else {
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161no obrisana grupa", 2, "Error graphic");
                }
            }
        });
    }

    private void kreirajToolBarFilter() {
        this.tbFilter = new ToolBar();
        this.tfilter = new TextField();
        this.tfilter.setPromptText("Filter");
        this.tfilter.setId("textField");
        this.cbFilter = new ComboBox();
        ObservableList filter = FXCollections.observableArrayList((Object[])new String[]{"Oznaka", "Naziv"});
        this.cbFilter.getItems().addAll((Collection)filter);
        this.cbFilter.setValue((Object)"Naziv");
        this.cbFilter.setPrefWidth(250.0);
        this.cbFilter.setPrefHeight(25.0);
        this.tfilter.setPrefWidth(200.0);
        this.tfilter.setPrefHeight(25.0);
        this.tbFilter.getItems().addAll((Object[])new Node[]{this.tfilter, this.cbFilter});
    }

    private void urediFilter(TableView tablicaPregleda) {
        FilteredList filteredData = new FilteredList(this.listagrupa, p -> true);
        this.tfilter.textProperty().addListener((observable, oldValue, newValue) -> filteredData.setPredicate(pregled -> {
            if (newValue == null || newValue.isEmpty()) {
                return true;
            }
            String lowerCaseFilter = newValue.toLowerCase();
            return this.cbFilter.getSelectionModel().getSelectedItem().equals("Oznaka") ? pregled.getSifra() != null && pregled.getSifra().toLowerCase().startsWith(lowerCaseFilter) : this.cbFilter.getSelectionModel().getSelectedItem().equals("Naziv") && pregled.getNaziv() != null && pregled.getNaziv().toLowerCase().startsWith(lowerCaseFilter);
        }));
        SortedList sortedData = new SortedList((ObservableList)filteredData);
        sortedData.comparatorProperty().bind((ObservableValue)tablicaPregleda.comparatorProperty());
        tablicaPregleda.refresh();
        tablicaPregleda.setItems((ObservableList)sortedData);
    }

    private void urediKoloneUTabliciGrupeOZS() {
        this.tablicaPopisGrupaOZS.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent e) {
                if (e.getCode() == KeyCode.ESCAPE) {
                    PopisGrupaOZSController.this.tablicaPopisGrupaOZS.getSelectionModel().clearSelection();
                    e.consume();
                    return;
                }
            }
        });
        this.kolRedBr.setCellValueFactory((Callback)new PropertyValueFactory("redBroj"));
        this.kolRedBr.prefWidthProperty().bind((ObservableValue)this.tablicaPopisGrupaOZS.widthProperty().divide(10.0));
        this.kolRedBr.setStyle("-fx-alignment: CENTER;");
        this.kolOznaka.setCellValueFactory((Callback)new PropertyValueFactory("sifra"));
        this.kolOznaka.prefWidthProperty().bind((ObservableValue)this.tablicaPopisGrupaOZS.widthProperty().divide(5.0));
        this.kolOznaka.setStyle("-fx-alignment: CENTER;");
        this.kolNaziv.setCellValueFactory((Callback)new PropertyValueFactory("naziv"));
        this.kolNaziv.prefWidthProperty().bind((ObservableValue)this.tablicaPopisGrupaOZS.widthProperty().divide(1.4492753623188406));
        this.kolNaziv.setStyle("-fx-alignment: CENTER;");
        this.kolPretraga.setGraphic((Node)this.tbFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void popuniTablicu() {
        ResultSet rs = BazaGrupeOZS.dajGrupeOZS(GlavniPanelController.getOdabranaTvrtka());
        GrupaOZS g = null;
        int br = 1;
        try {
            while (rs.next()) {
                g = new GrupaOZS();
                g.setId(rs.getInt("id"));
                g.setRedBroj(String.valueOf(br));
                g.setSifra(rs.getString("sifra"));
                g.setNaziv(rs.getString("naziv"));
                this.listagrupa.add((Object)g);
                ++br;
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(PopisOdjelaController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(PopisGrupaOZSController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.tablicaPopisGrupaOZS.getItems().addAll(this.listagrupa);
    }

    public void popuniTablicuGrupeOZS() {
        this.tablicaPopisGrupaOZS.setPlaceholder((Node)this.progressIndicator);
        this.progressIndicator.setMaxSize(200.0, 200.0);
        this.progressIndicator.setVisible(true);
        Task<Void> task = this.createTask();
        new Thread((Runnable)task).start();
        this.progressIndicator.progressProperty().bind((ObservableValue)task.progressProperty());
        this.listagrupa.clear();
        this.tablicaPopisGrupaOZS.getItems().clear();
    }

    private Task<Void> createTask() {
        return new Task<Void>(){

            public Void call() {
                try {
                    this.updateProgress(-1.0, 1.0);
                    this.updateMessage("Waiting...");
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(PopisGrupaOZSController.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    this.updateMessage("Running...");
                    PopisGrupaOZSController.this.popuniTablicu();
                }
                finally {
                    Platform.runLater(() -> PopisGrupaOZSController.this.progressIndicator.setVisible(false));
                }
                return null;
            }
        };
    }
}

