/*
 * Decompiled with CFR 0.152.
 */
package ispisJasper;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javafx.concurrent.Task;
import javafx.embed.swing.SwingFXUtils;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Separator;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.ToolBar;
import javafx.scene.control.Tooltip;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;
import javafx.stage.FileChooser;
import javafx.stage.Modality;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import javax.imageio.ImageIO;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperPrintManager;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.PrintPageFormat;
import net.sf.jasperreports.engine.export.ooxml.JRDocxExporter;
import net.sf.jasperreports.engine.export.ooxml.JRXlsxExporter;
import net.sf.jasperreports.export.ExporterInput;
import net.sf.jasperreports.export.ExporterOutput;
import net.sf.jasperreports.export.ReportExportConfiguration;
import net.sf.jasperreports.export.SimpleDocxReportConfiguration;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimpleOutputStreamExporterOutput;
import net.sf.jasperreports.export.SimpleXlsxReportConfiguration;

public class JRPrintPreview
extends Stage {
    public static final int REPORT_DPI_RESOLUTION = 72;
    protected final int SPACING = 25;
    protected final float MIN_ZOOM = 0.5f;
    protected final float MAX_ZOOM = 10.0f;
    protected final int[] zooms = new int[]{50, 75, 100, 125, 150, 175, 200};
    protected float zoom = 0.0f;
    protected float realZoom = 0.0f;
    protected DecimalFormat zoomDecimalFormat = new DecimalFormat("#.##");
    protected JasperPrint jasperPrint;
    protected double screenResolution = 72.0;
    protected JasperReportsContext jasperReportsContext;
    protected ResourceBundle resourceBundle;
    protected ToggleButton btnActualSize;
    protected ToggleButton btnFitPage;
    protected ToggleButton btnFitWidth;
    protected Button btnFirst;
    protected Button btnLast;
    protected Button btnNext;
    protected Button btnPrevious;
    protected Button btnPrint;
    protected Button btnSaveAs;
    protected Button btnZoomIn;
    protected Button btnZoomOut;
    protected ComboBox<String> cmbZoom;
    protected Label lblStatus;
    protected VBox vBoxPage;
    protected HBox statusBar;
    protected ScrollPane scrollPane;
    protected ToolBar toolBar;
    protected TextField txtGoTo;
    protected DropShadow dropShadow = new DropShadow();
    protected int pageIndex;
    private ImageView iv;
    private VBox root;
    private Pane leftSpacer;
    private Pane rightSpacer;
    private ToggleGroup group;

    public JRPrintPreview(JasperPrint jasperPrint) {
        this(jasperPrint, null);
    }

    public JRPrintPreview(JasperPrint jasperPrint, ResourceBundle resBundle) {
        this((JasperReportsContext)DefaultJasperReportsContext.getInstance(), jasperPrint, resBundle);
    }

    public JRPrintPreview(JasperReportsContext jasperReportsContext, JasperPrint jasperPrint, ResourceBundle resBundle) {
        this.jasperReportsContext = jasperReportsContext;
        this.jasperPrint = jasperPrint;
        this.initResources(resBundle);
        this.screenResolution = Screen.getPrimary().getDpi();
        this.initComponents();
        this.setZoomRatio(1.0f);
        double width = this.vBoxPage.getBoundsInParent().getWidth() + 50.0 + 13.0;
        this.setWidth(width > 1000.0 ? 1000.0 : width);
    }

    protected void initResources(ResourceBundle resBundle) {
        this.resourceBundle = resBundle == null ? ResourceBundle.getBundle("net/sf/jasperreports/view/viewer", Locale.getDefault()) : resBundle;
    }

    private void initComponents() {
        this.setTitle("Ispis " + this.jasperPrint.getName());
        this.initModality(Modality.NONE);
        this.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent we) {
                JRPrintPreview.this.hide();
                JRPrintPreview.this.close();
                JRPrintPreview.this.jasperPrint.getPages().clear();
                System.gc();
            }
        });
        this.btnActualSize = new ToggleButton();
        this.btnFitPage = new ToggleButton();
        this.btnFitWidth = new ToggleButton();
        this.btnFirst = new Button();
        this.btnLast = new Button();
        this.btnNext = new Button();
        this.btnPrevious = new Button();
        this.btnPrint = new Button();
        this.btnSaveAs = new Button();
        this.btnZoomIn = new Button();
        this.btnZoomOut = new Button();
        this.cmbZoom = new ComboBox();
        this.lblStatus = new Label();
        this.vBoxPage = new VBox();
        this.statusBar = new HBox();
        this.scrollPane = new ScrollPane();
        this.toolBar = new ToolBar();
        this.txtGoTo = new TextField();
        this.group = new ToggleGroup();
        this.btnActualSize.setToggleGroup(this.group);
        this.btnFitPage.setToggleGroup(this.group);
        this.btnFitWidth.setToggleGroup(this.group);
        this.btnActualSize.setSelected(true);
        this.setMinHeight(150.0);
        this.setMinWidth(500.0);
        this.setHeight(600.0);
        this.setWidth(800.0);
        this.btnPrint.setGraphic((Node)new ImageView(new Image(((Object)((Object)this)).getClass().getResourceAsStream("/net/sf/jasperreports/view/images/print.GIF"))));
        this.btnPrint.setTooltip(new Tooltip(this.resourceBundle.getString("print")));
        this.btnPrint.setPrefSize(23.0, 23.0);
        this.btnPrint.setOnAction(e -> this.onBtnPrint());
        this.btnPrint.setFocusTraversable(false);
        this.btnPrint.setStyle("-fx-base: #ececec;  -fx-default-button: #ABD8ED;");
        this.btnSaveAs.setGraphic((Node)new ImageView(new Image(((Object)((Object)this)).getClass().getResourceAsStream("/net/sf/jasperreports/view/images/save.GIF"))));
        this.btnSaveAs.setTooltip(new Tooltip(this.resourceBundle.getString("save")));
        this.btnSaveAs.setPrefSize(23.0, 23.0);
        this.btnSaveAs.setOnAction(e -> this.onBtnSaveAsPrint());
        this.btnSaveAs.setFocusTraversable(false);
        this.btnSaveAs.setStyle("-fx-base: #ececec;  -fx-default-button: #ABD8ED;");
        this.btnFirst.setGraphic((Node)new ImageView(new Image(((Object)((Object)this)).getClass().getResourceAsStream("/net/sf/jasperreports/view/images/first.GIF"))));
        this.btnFirst.setTooltip(new Tooltip(this.resourceBundle.getString("first.page")));
        this.btnFirst.setPrefSize(23.0, 23.0);
        this.btnFirst.setOnAction(e -> this.onBtnFirstPressed());
        this.btnFirst.setFocusTraversable(false);
        this.btnFirst.setStyle("-fx-base: #ececec;  -fx-default-button: #ABD8ED;");
        this.btnPrevious.setGraphic((Node)new ImageView(new Image(((Object)((Object)this)).getClass().getResourceAsStream("/net/sf/jasperreports/view/images/previous.GIF"))));
        this.btnPrevious.setTooltip(new Tooltip(this.resourceBundle.getString("previous.page")));
        this.btnPrevious.setPrefSize(23.0, 23.0);
        this.btnPrevious.setOnAction(e -> this.onBtnPreviousPressed());
        this.btnPrevious.setFocusTraversable(false);
        this.btnPrevious.setStyle("-fx-base: #ececec;  -fx-default-button: #ABD8ED;");
        this.btnNext.setGraphic((Node)new ImageView(new Image(((Object)((Object)this)).getClass().getResourceAsStream("/net/sf/jasperreports/view/images/next.GIF"))));
        this.btnNext.setTooltip(new Tooltip(this.resourceBundle.getString("next.page")));
        this.btnNext.setPrefSize(23.0, 23.0);
        this.btnNext.setOnAction(e -> this.onBtnNextPressed());
        this.btnNext.setFocusTraversable(false);
        this.btnNext.setStyle("-fx-base: #ececec;  -fx-default-button: #ABD8ED;");
        this.btnLast.setGraphic((Node)new ImageView(new Image(((Object)((Object)this)).getClass().getResourceAsStream("/net/sf/jasperreports/view/images/last.GIF"))));
        this.btnLast.setTooltip(new Tooltip(this.resourceBundle.getString("last.page")));
        this.btnLast.setPrefSize(23.0, 23.0);
        this.btnLast.setOnAction(e -> this.onBtnLastPressed());
        this.btnLast.setFocusTraversable(false);
        this.btnLast.setStyle("-fx-base: #ececec;  -fx-default-button: #ABD8ED;");
        this.txtGoTo.setTooltip(new Tooltip(this.resourceBundle.getString("go.to.page")));
        this.txtGoTo.setAlignment(Pos.CENTER);
        this.txtGoTo.setPrefSize(40.0, 23.0);
        this.txtGoTo.setOnAction(e -> this.onGoToTextChanged());
        this.txtGoTo.setFocusTraversable(false);
        this.btnActualSize.setGraphic((Node)new ImageView(new Image(((Object)((Object)this)).getClass().getResourceAsStream("/net/sf/jasperreports/view/images/actualsize.GIF"))));
        this.btnActualSize.setTooltip(new Tooltip(this.resourceBundle.getString("actual.size")));
        this.btnActualSize.setPrefSize(23.0, 23.0);
        this.btnActualSize.setOnAction(e -> {
            if (((ToggleButton)e.getSource()).isSelected()) {
                this.onActualSizePressed();
            }
        });
        this.btnActualSize.setFocusTraversable(false);
        this.btnFitPage.setGraphic((Node)new ImageView(new Image(((Object)((Object)this)).getClass().getResourceAsStream("/net/sf/jasperreports/view/images/fitpage.GIF"))));
        this.btnFitPage.setTooltip(new Tooltip(this.resourceBundle.getString("fit.page")));
        this.btnFitPage.setPrefSize(23.0, 23.0);
        this.btnFitPage.setOnAction(e -> {
            if (((ToggleButton)e.getSource()).isSelected()) {
                this.onFitPagePressed();
            }
        });
        this.btnFitPage.setFocusTraversable(false);
        this.btnFitWidth.setGraphic((Node)new ImageView(new Image(((Object)((Object)this)).getClass().getResourceAsStream("/net/sf/jasperreports/view/images/fitwidth.GIF"))));
        this.btnFitWidth.setTooltip(new Tooltip(this.resourceBundle.getString("fit.width")));
        this.btnFitWidth.setPrefSize(23.0, 23.0);
        this.btnFitWidth.setOnAction(e -> {
            if (((ToggleButton)e.getSource()).isSelected()) {
                this.onSetFitToWidthPressed();
            }
        });
        this.btnFitWidth.setFocusTraversable(false);
        this.leftSpacer = new Pane();
        HBox.setHgrow((Node)this.leftSpacer, (Priority)Priority.SOMETIMES);
        this.rightSpacer = new Pane();
        HBox.setHgrow((Node)this.rightSpacer, (Priority)Priority.SOMETIMES);
        this.toolBar.getItems().addAll((Object[])new Node[]{this.leftSpacer, this.btnActualSize, this.btnFitPage, this.btnFitWidth, new Separator(), this.btnZoomIn, this.btnZoomOut, this.cmbZoom, new Separator(), this.btnFirst, this.btnPrevious, this.txtGoTo, this.btnNext, this.btnLast, new Separator(), this.btnPrint, this.btnSaveAs, this.rightSpacer});
        this.btnZoomIn.setGraphic((Node)new ImageView(new Image(((Object)((Object)this)).getClass().getResourceAsStream("/net/sf/jasperreports/view/images/zoomin.GIF"))));
        this.btnZoomIn.setTooltip(new Tooltip(this.resourceBundle.getString("zoom.in")));
        this.btnZoomIn.setPrefSize(23.0, 23.0);
        this.btnZoomIn.setOnAction(e -> this.onBtnZoomIn());
        this.btnZoomIn.setFocusTraversable(false);
        this.btnZoomIn.setStyle("-fx-base: #ececec;  -fx-default-button: #ABD8ED;");
        this.btnZoomOut.setGraphic((Node)new ImageView(new Image(((Object)((Object)this)).getClass().getResourceAsStream("/net/sf/jasperreports/view/images/zoomout.GIF"))));
        this.btnZoomOut.setTooltip(new Tooltip(this.resourceBundle.getString("zoom.out")));
        this.btnZoomOut.setPrefSize(23.0, 23.0);
        this.btnZoomOut.setOnAction(e -> this.onBtnZoomOut());
        this.btnZoomOut.setFocusTraversable(false);
        this.btnZoomOut.setStyle("-fx-base: #ececec;  -fx-default-button: #ABD8ED;");
        this.cmbZoom.setEditable(false);
        this.cmbZoom.setTooltip(new Tooltip(this.resourceBundle.getString("zoom.ratio")));
        this.cmbZoom.setPrefWidth(100.0);
        for (int zoom : this.zooms) {
            this.cmbZoom.getItems().add((Object)(zoom + "%"));
        }
        this.cmbZoom.getSelectionModel().select(2);
        this.cmbZoom.setFocusTraversable(false);
        this.cmbZoom.setOnAction(e -> this.onComboBoxZoomChanged());
        this.vBoxPage.setSpacing(25.0);
        this.vBoxPage.setPadding(new Insets(25.0));
        this.vBoxPage.setAlignment(Pos.CENTER);
        this.scrollPane.setVbarPolicy(ScrollPane.ScrollBarPolicy.ALWAYS);
        this.scrollPane.setHbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        this.scrollPane.setContent((Node)this.vBoxPage);
        this.scrollPane.viewportBoundsProperty().addListener((arg0, arg1, arg2) -> {
            if (this.btnFitWidth.isSelected()) {
                this.onSetFitToWidthPressed();
            }
            this.scrollPane.setFitToWidth(this.vBoxPage.prefWidth(-1.0) < arg2.getWidth());
            this.scrollPane.setFitToHeight(this.vBoxPage.prefHeight(-1.0) < arg2.getHeight());
        });
        this.scrollPane.vvalueProperty().addListener((observable, oldValue, newValue) -> {
            double low;
            double hi;
            int pagesNo = this.jasperPrint.getPages().size();
            double pageInterval = 1.0 / (double)pagesNo;
            int tmpPageIndex = this.pageIndex;
            if (hi < newValue.doubleValue() && this.pageIndex < pagesNo) {
                for (hi = low + pageInterval; hi < newValue.doubleValue(); hi += pageInterval) {
                    ++tmpPageIndex;
                }
                this.setPageIndex(tmpPageIndex);
            } else if (low > newValue.doubleValue() && this.pageIndex > 0) {
                for (low = (double)this.pageIndex * pageInterval; low > newValue.doubleValue(); low -= pageInterval) {
                    --tmpPageIndex;
                }
                this.setPageIndex(tmpPageIndex);
            }
        });
        this.lblStatus.setFont(new Font("Dialog", 10.0));
        this.statusBar.setAlignment(Pos.CENTER);
        this.statusBar.setMaxHeight(24.0);
        this.statusBar.getChildren().add((Object)this.lblStatus);
        this.root = new VBox();
        this.root.setId("vBoxPage");
        VBox.setVgrow((Node)this.scrollPane, (Priority)Priority.ALWAYS);
        this.root.getChildren().addAll((Object[])new Node[]{this.toolBar, this.scrollPane, this.statusBar});
        this.setScene(new Scene((Parent)this.root, 800.0, 600.0));
        this.dropShadow.setColor(Color.GREY);
        this.dropShadow.setOffsetX(2.0);
        this.dropShadow.setOffsetY(2.0);
    }

    protected void refresh() {
        this.vBoxPage.getChildren().clear();
        for (int pageIndex = 0; pageIndex < this.jasperPrint.getPages().size(); ++pageIndex) {
            try {
                BufferedImage image = (BufferedImage)JasperPrintManager.printPageToImage((JasperPrint)this.jasperPrint, (int)pageIndex, (float)this.zoom);
                WritableImage fxImage = new WritableImage(this.jasperPrint.getPageHeight(), this.jasperPrint.getPageWidth());
                this.iv = new ImageView((Image)SwingFXUtils.toFXImage((BufferedImage)image, (WritableImage)fxImage));
                this.iv.setEffect((Effect)this.dropShadow);
                this.setPageIndex(0);
                this.vBoxPage.getChildren().add((Object)this.iv);
                continue;
            }
            catch (JRException ex) {
                ex.printStackTrace();
            }
        }
    }

    protected void setZoomRatio(float newZoom) {
        if (newZoom > 0.0f) {
            this.cmbZoom.getEditor().setText(this.zoomDecimalFormat.format(newZoom * 100.0f) + "%");
            if (this.zoom != newZoom) {
                this.zoom = newZoom;
                this.realZoom = (float)((double)this.zoom * this.screenResolution / 72.0);
                this.refresh();
            }
        }
        this.btnZoomIn.setDisable(this.zoom >= (float)this.zooms[this.zooms.length - 1] / 100.0f);
        this.btnZoomOut.setDisable(this.zoom <= (float)this.zooms[0] / 100.0f);
    }

    private void setRealZoomRatio(float newZoom) {
        if (newZoom > 0.0f && this.realZoom != newZoom) {
            this.zoom = (float)((double)(newZoom * 72.0f) / this.screenResolution);
            this.realZoom = newZoom;
            this.cmbZoom.getEditor().setText(this.zoomDecimalFormat.format(this.zoom * 100.0f) + "%");
            this.refresh();
        }
        this.btnZoomIn.setDisable(this.zoom >= (float)this.zooms[this.zooms.length - 1] / 100.0f);
        this.btnZoomOut.setDisable(this.zoom <= (float)this.zooms[0] / 100.0f);
    }

    protected int getZoomRatio() {
        try {
            return this.zoomDecimalFormat.parse(this.cmbZoom.getEditor().getText()).intValue();
        }
        catch (ParseException e) {
            e.printStackTrace();
            return (int)this.zoom;
        }
    }

    private void onBtnZoomIn() {
        this.btnActualSize.setSelected(false);
        this.btnFitPage.setSelected(false);
        this.btnFitWidth.setSelected(false);
        int index = Arrays.binarySearch(this.zooms, this.getZoomRatio());
        if (index < 0) {
            this.cmbZoom.getSelectionModel().select((Object)(this.zoomDecimalFormat.format(this.zooms[-index - 1]) + "%"));
        } else if (index < this.cmbZoom.getItems().size() - 1) {
            this.cmbZoom.getSelectionModel().select((Object)(this.zoomDecimalFormat.format(this.zooms[index + 1]) + "%"));
        }
    }

    private void onBtnZoomOut() {
        this.btnActualSize.setSelected(false);
        this.btnFitPage.setSelected(false);
        this.btnFitWidth.setSelected(false);
        int index = Arrays.binarySearch(this.zooms, this.getZoomRatio());
        if (index > 0) {
            this.cmbZoom.getSelectionModel().select((Object)(this.zoomDecimalFormat.format(this.zooms[index - 1]) + "%"));
        } else if (index < -1) {
            this.cmbZoom.getSelectionModel().select((Object)(this.zoomDecimalFormat.format(this.zooms[-index - 2]) + "%"));
        }
    }

    private void onComboBoxZoomChanged() {
        try {
            if (this.cmbZoom.getValue() != null) {
                float newZoom = this.zoomDecimalFormat.parse((String)this.cmbZoom.getValue()).floatValue() / 100.0f;
                if (newZoom < 0.5f) {
                    newZoom = 0.5f;
                }
                if (newZoom > 10.0f) {
                    newZoom = 10.0f;
                }
                this.setZoomRatio(newZoom);
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    private void onGoToTextChanged() {
        try {
            int pageNumber = Integer.parseInt(this.txtGoTo.getText());
            if (pageNumber > 0 && pageNumber <= this.jasperPrint.getPages().size()) {
                this.setPage(pageNumber - 1);
            }
        }
        catch (NumberFormatException e) {
            this.setPageIndex(this.pageIndex);
        }
    }

    private void onBtnFirstPressed() {
        this.setPage(0);
    }

    private void onBtnPreviousPressed() {
        this.setPage(this.pageIndex - 1);
    }

    private void onBtnNextPressed() {
        this.setPage(this.pageIndex + 1);
    }

    private void onBtnLastPressed() {
        this.setPage(this.jasperPrint.getPages().size() - 1);
    }

    private void setPage(int index) {
        double contentsHeight = this.vBoxPage.getBoundsInLocal().getHeight();
        double viewportHeight = this.scrollPane.getViewportBounds().getHeight();
        this.iv = (ImageView)this.vBoxPage.getChildren().get(index);
        this.scrollPane.setVvalue(this.iv.getBoundsInParent().getMinY() / (contentsHeight - viewportHeight));
        this.setPageIndex(index);
    }

    protected void setPageIndex(int index) {
        int pagesNo = this.jasperPrint.getPages().size();
        this.btnFirst.setDisable(index == 0);
        this.btnPrevious.setDisable(index == 0);
        this.btnLast.setDisable(index == pagesNo - 1);
        this.btnNext.setDisable(index == pagesNo - 1);
        this.txtGoTo.setDisable(pagesNo == 1);
        this.txtGoTo.setText(String.valueOf(index + 1));
        this.lblStatus.setText("stranica " + (index + 1) + " od " + pagesNo);
        this.pageIndex = index;
    }

    private void onSetFitToWidthPressed() {
        this.cmbZoom.getSelectionModel().clearSelection();
        this.setRealZoomRatio((float)(this.scrollPane.getViewportBounds().getWidth() - 50.0 - 2.0) / (float)this.jasperPrint.getPageFormat(this.pageIndex).getPageWidth().intValue());
    }

    private void onActualSizePressed() {
        this.cmbZoom.getSelectionModel().select(2);
    }

    private void onFitPagePressed() {
        PrintPageFormat pageFormat = this.jasperPrint.getPageFormat(this.pageIndex);
        float heightRatio = ((float)this.scrollPane.getViewportBounds().getHeight() - 50.0f) / (float)pageFormat.getPageHeight().intValue();
        float widthRatio = ((float)this.scrollPane.getViewportBounds().getWidth() - 50.0f) / (float)pageFormat.getPageWidth().intValue();
        this.cmbZoom.getSelectionModel().clearSelection();
        this.setRealZoomRatio(heightRatio < widthRatio ? heightRatio : widthRatio);
    }

    private void onBtnPrint() {
        Task<Boolean> task = new Task<Boolean>(){

            protected Boolean call() throws Exception {
                try {
                    JRPrintPreview.this.btnPrint.setDisable(true);
                    JRPrintPreview.this.getScene().setCursor(Cursor.WAIT);
                    Boolean bl = JasperPrintManager.printReport((JasperPrint)JRPrintPreview.this.jasperPrint, (boolean)true);
                    return bl;
                }
                catch (JRException ex) {
                    ex.printStackTrace();
                }
                finally {
                    JRPrintPreview.this.getScene().setCursor(Cursor.DEFAULT);
                    JRPrintPreview.this.btnPrint.setDisable(false);
                }
                return false;
            }
        };
        task.run();
    }

    private void onBtnSaveAsPrint() {
        Task<Boolean> task = new Task<Boolean>(){

            protected Boolean call() throws Exception {
                try {
                    JRPrintPreview.this.btnSaveAs.setDisable(true);
                    JRPrintPreview.this.getScene().setCursor(Cursor.WAIT);
                    Boolean bl = JRPrintPreview.this.save();
                    return bl;
                }
                finally {
                    JRPrintPreview.this.getScene().setCursor(Cursor.DEFAULT);
                    JRPrintPreview.this.btnSaveAs.setDisable(false);
                }
            }
        };
        task.run();
    }

    public boolean save() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Save File");
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("PDF Document", Arrays.asList("*.pdf", "*.PDF")));
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("PNG image", Arrays.asList("*.png", "*.PNG")));
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("DOCX Document", Arrays.asList("*.docx", "*.DOCX")));
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("XLSX Document", Arrays.asList("*.xlsx", "*.XLSX")));
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("HTML Document", Arrays.asList("*.html", "*.HTML")));
        File file = fileChooser.showSaveDialog(this.getScene().getWindow());
        if (fileChooser.getSelectedExtensionFilter() != null && fileChooser.getSelectedExtensionFilter().getExtensions() != null) {
            List selectedExtension = fileChooser.getSelectedExtensionFilter().getExtensions();
            if (selectedExtension.contains("*.pdf")) {
                try {
                    JasperExportManager.exportReportToPdfFile((JasperPrint)this.jasperPrint, (String)file.getAbsolutePath());
                }
                catch (JRException e) {
                    e.printStackTrace();
                }
            } else if (selectedExtension.contains("*.png")) {
                for (int i = 0; i < this.jasperPrint.getPages().size(); ++i) {
                    String fileNumber = "0000" + Integer.toString(i + 1);
                    fileNumber = fileNumber.substring(fileNumber.length() - 4, fileNumber.length());
                    WritableImage image = this.getImage(i);
                    String[] fileTokens = file.getAbsolutePath().split("\\.");
                    String filename = "";
                    if (fileTokens.length > 0) {
                        for (int i2 = 0; i2 < fileTokens.length - 1; ++i2) {
                            filename = filename + fileTokens[i2] + (i2 < fileTokens.length - 2 ? "." : "");
                        }
                        filename = filename + fileNumber + "." + fileTokens[fileTokens.length - 1];
                    } else {
                        filename = file.getAbsolutePath() + fileNumber;
                    }
                    System.out.println(filename);
                    File imageFile = new File(filename);
                    try {
                        ImageIO.write((RenderedImage)SwingFXUtils.fromFXImage((Image)image, null), "png", imageFile);
                        System.out.println(imageFile.getAbsolutePath());
                        continue;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            } else if (selectedExtension.contains("*.html")) {
                try {
                    JasperExportManager.exportReportToHtmlFile((JasperPrint)this.jasperPrint, (String)file.getAbsolutePath());
                }
                catch (JRException e) {
                    e.printStackTrace();
                }
            } else if (selectedExtension.contains("*.docx")) {
                JRDocxExporter export = new JRDocxExporter();
                export.setExporterInput((ExporterInput)new SimpleExporterInput(this.jasperPrint));
                export.setExporterOutput((ExporterOutput)new SimpleOutputStreamExporterOutput(file.getAbsolutePath()));
                SimpleDocxReportConfiguration config = new SimpleDocxReportConfiguration();
                export.setConfiguration((ReportExportConfiguration)config);
                try {
                    export.exportReport();
                }
                catch (JRException e) {
                    e.printStackTrace();
                }
                System.out.println("docx");
            } else if (selectedExtension.contains("*.xlsx")) {
                JRXlsxExporter exporter = new JRXlsxExporter();
                exporter.setExporterInput((ExporterInput)new SimpleExporterInput(this.jasperPrint));
                exporter.setExporterOutput((ExporterOutput)new SimpleOutputStreamExporterOutput(file.getAbsolutePath()));
                SimpleXlsxReportConfiguration configuration = new SimpleXlsxReportConfiguration();
                configuration.setDetectCellType(Boolean.valueOf(true));
                configuration.setCollapseRowSpan(Boolean.valueOf(false));
                exporter.setConfiguration((ReportExportConfiguration)configuration);
                try {
                    exporter.exportReport();
                }
                catch (JRException e) {
                    e.printStackTrace();
                }
                System.out.println("xlsx");
            }
        }
        return false;
    }

    private WritableImage getImage(int pageNumber) {
        BufferedImage image = null;
        try {
            image = (BufferedImage)JasperPrintManager.printPageToImage((JasperPrint)this.jasperPrint, (int)pageNumber, (float)2.0f);
        }
        catch (JRException e) {
            e.printStackTrace();
        }
        WritableImage fxImage = new WritableImage(this.jasperPrint.getPageWidth(), this.jasperPrint.getPageHeight());
        return SwingFXUtils.toFXImage((BufferedImage)image, (WritableImage)fxImage);
    }
}

