/*
 * Decompiled with CFR 0.152.
 */
package ispisJasper;

import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.VBox;

public class ZoomableScrollPane
extends ScrollPane {
    private double scaleValue = 0.7;
    private double zoomIntensity = 0.02;
    private Node target;
    private Node zoomNode;

    public ZoomableScrollPane(Node target) {
        this.target = target;
        this.zoomNode = new Group(new Node[]{target});
        this.setContent(this.outerNode(this.zoomNode));
        this.setPannable(true);
        this.setFitToHeight(true);
        this.setFitToWidth(true);
        this.updateScale();
    }

    private Node outerNode(Node node) {
        Node outerNode = this.centeredNode(node);
        outerNode.setOnScroll(e -> {
            if (e.isControlDown()) {
                e.consume();
                this.onScroll(e.getTextDeltaY(), new Point2D(e.getX(), e.getY()));
            }
        });
        return outerNode;
    }

    private Node centeredNode(Node node) {
        VBox vBox = new VBox(new Node[]{node});
        vBox.setAlignment(Pos.CENTER);
        return vBox;
    }

    private void updateScale() {
        this.target.setScaleX(this.scaleValue);
        this.target.setScaleY(this.scaleValue);
    }

    private void onScroll(double wheelDelta, Point2D mousePoint) {
        double zoomFactor = Math.exp(wheelDelta * this.zoomIntensity);
        Bounds innerBounds = this.zoomNode.getLayoutBounds();
        Bounds viewportBounds = this.getViewportBounds();
        double valX = this.getHvalue() * (innerBounds.getWidth() - viewportBounds.getWidth());
        double valY = this.getVvalue() * (innerBounds.getHeight() - viewportBounds.getHeight());
        this.scaleValue *= zoomFactor;
        this.updateScale();
        this.layout();
        Point2D posInZoomTarget = this.target.parentToLocal(this.zoomNode.parentToLocal(mousePoint));
        Point2D adjustment = this.target.getLocalToParentTransform().deltaTransform(posInZoomTarget.multiply(zoomFactor - 1.0));
        Bounds updatedInnerBounds = this.zoomNode.getBoundsInLocal();
        this.setHvalue((valX + adjustment.getX()) / (updatedInnerBounds.getWidth() - viewportBounds.getWidth()));
        this.setVvalue((valY + adjustment.getY()) / (updatedInnerBounds.getHeight() - viewportBounds.getHeight()));
    }
}

