/*
 * Decompiled with CFR 0.152.
 */
package ispitivanja;

import Utill.FormValidation;
import Utill.FxDialogs;
import Utill.KlasaKorisneMetode;
import Utill.ResizeComponent;
import ispitivanja.BazaIspitivanja;
import ispitivanja.Ispitivanje;
import ispitivanja.PopisIspitivanjaController;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.TextField;
import javafx.scene.layout.VBox;
import javafx.stage.StageStyle;
import javafx.util.Callback;
import javafx.util.StringConverter;
import zastitanaradu.GlavniPanelController;

public class UnosIspitivanjaController
implements Initializable {
    @FXML
    private Button btnIspitivanje;
    @FXML
    private Button btnSpremi;
    @FXML
    private TextField txtNaziv;
    @FXML
    private TextField txtOznaka;
    @FXML
    private TextField txtPeriodika;
    private static UnosIspitivanjaController instance;
    private boolean izmjenaIspitivanja = false;
    private Ispitivanje i;

    public static UnosIspitivanjaController getInstance() {
        return instance;
    }

    public void initialize(URL url, ResourceBundle rb) {
        instance = this;
        ResizeComponent.makeTextFieldResize(this.txtNaziv);
        this.btnSpremi.setOnAction(e -> this.unosIspitivanja());
        this.btnIspitivanje.setOnAction(e -> this.popuniIspitivanja());
    }

    private void unosIspitivanja() {
        boolean bNazivOdjela = FormValidation.textFieldValidationonlyText(this.txtNaziv);
        if (bNazivOdjela) {
            if (this.izmjenaIspitivanja) {
                if (BazaIspitivanja.izmjenaIspitivanja(GlavniPanelController.getOdabranaTvrtka(), this.dajIspitivanje(), this.i.getId())) {
                    PopisIspitivanjaController.getInstance().popuniTablicuIspitivanja();
                    GlavniPanelController.getInstance().zatvoriTab("Unos ispitivanja");
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.BOTTOM_RIGHT, "Uspje\u0161na izmjena ispitivanja", 1, "Information graphic");
                } else {
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161na izmjena ispitivanja", 2, "Error graphic");
                }
            } else if (BazaIspitivanja.unesiNovoIspitivanje(GlavniPanelController.getOdabranaTvrtka(), this.dajIspitivanje())) {
                KlasaKorisneMetode.kreirajNotifikaciju(Pos.BOTTOM_RIGHT, "Uspje\u0161no unesena ispitivanja", 1, "Information graphic");
                PopisIspitivanjaController.getInstance().popuniTablicuIspitivanja();
                GlavniPanelController.getInstance().zatvoriTab("Unos ispitivanja");
                this.izmjenaIspitivanja = false;
            } else {
                KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161no unesena ispitivanja", 2, "Error graphic");
            }
        } else {
            Alert alert = FxDialogs.getDialog(Alert.AlertType.INFORMATION, "Upozorenje", "Morate unjeti naziv ispitivanja");
            alert.showAndWait();
        }
    }

    private Ispitivanje dajIspitivanje() {
        Ispitivanje i = new Ispitivanje();
        i.setOznaka(this.txtOznaka.getText());
        i.setNaziv(this.txtNaziv.getText());
        i.setPeriodika(this.txtPeriodika.getText());
        return i;
    }

    public void izmjenaIspitivanja(Ispitivanje i) {
        this.izmjenaIspitivanja = true;
        this.i = i;
        this.txtNaziv.setText(i.getNaziv());
        this.txtOznaka.setText(i.getOznaka());
        this.txtPeriodika.setText(i.getPeriodika());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void popuniIspitivanja() {
        ObservableList choices = FXCollections.observableArrayList();
        ResultSet rs = BazaIspitivanja.dajSvaIspitivanja();
        Ispitivanje i = null;
        try {
            while (rs.next()) {
                i = new Ispitivanje();
                i.setId(rs.getInt("id"));
                i.setOznaka(rs.getString("oznaka"));
                i.setNaziv(rs.getString("nazivpregleda"));
                i.setPeriodika(rs.getString("periodika"));
                choices.add((Object)i);
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(PopisIspitivanjaController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(PopisIspitivanjaController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        Dialog dialog = new Dialog();
        final ComboBox comboBox = new ComboBox(choices);
        comboBox.setPromptText("Odaberite ispitivanje");
        comboBox.setConverter((StringConverter)new StringConverter<Ispitivanje>(){

            public String toString(Ispitivanje i) {
                if (i == null) {
                    return null;
                }
                return i.getNaziv();
            }

            public Ispitivanje fromString(String userId) {
                return null;
            }
        });
        comboBox.setCellFactory((Callback)new Callback<ListView<Ispitivanje>, ListCell<Ispitivanje>>(){

            public ListCell<Ispitivanje> call(ListView<Ispitivanje> p) {
                ListCell<Ispitivanje> cell = new ListCell<Ispitivanje>(){

                    protected void updateItem(Ispitivanje t, boolean bln) {
                        super.updateItem((Object)t, bln);
                        if (t != null) {
                            this.setText(t.getNaziv());
                        } else {
                            this.setText(null);
                        }
                    }
                };
                return cell;
            }
        });
        dialog.setHeaderText("Izaberite ispitivanje:");
        dialog.initStyle(StageStyle.TRANSPARENT);
        dialog.getDialogPane().setContent((Node)new VBox(new Node[]{comboBox}));
        DialogPane dialogPane = dialog.getDialogPane();
        dialogPane.getStylesheets().add((Object)GlavniPanelController.getInstance().getCss());
        final ButtonType buttonTypeOk = new ButtonType("Ok", ButtonBar.ButtonData.OK_DONE);
        ButtonType buttonTypeCancel = new ButtonType("Cancel", ButtonBar.ButtonData.CANCEL_CLOSE);
        dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{buttonTypeOk, buttonTypeCancel});
        dialog.setResultConverter((Callback)new Callback<ButtonType, Ispitivanje>(){

            public Ispitivanje call(ButtonType b) {
                if (b == buttonTypeOk) {
                    return (Ispitivanje)comboBox.getSelectionModel().getSelectedItem();
                }
                return null;
            }
        });
        Optional result = dialog.showAndWait();
        if (result.isPresent()) {
            this.txtNaziv.setText(((Ispitivanje)result.get()).getNaziv());
            this.txtOznaka.setText(((Ispitivanje)result.get()).getOznaka());
            this.txtPeriodika.setText(((Ispitivanje)result.get()).getPeriodika());
        }
    }
}

