/*
 * Decompiled with CFR 0.152.
 */
package kalendar;

import java.io.IOException;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.AnchorPane;
import javafx.util.Pair;
import mjerniinstrumenti.MjerniInstrumentPodaci;
import mjerniinstrumenti.UnosMjernogInstrumentaController;
import monitoring.DjelatnikPregled;
import monitoring.MonitoringController;
import monitoring.ObjektNadzor;
import monitoringnovi.DjelatnikLjecnickiPregledPopupController;
import monitoringnovi.DjelatnikOsposobljavanjePopupController;
import monitoringnovi.DjelatnikOstaliPreglediPopupController;
import monitoringnovi.DjlatnikOZOPopupController;
import monitoringnovi.NadzorVAtrogasniAparat;
import monitoringnovi.ObjektNoviPopupController;
import monitoringnovi.VatrogasniAparatPopupController;
import org.controlsfx.control.PopOver;
import radnaoprema.StrojEvidencija;
import radnaoprema.UnosStrojevaController;
import radniokolis.MjernoMjestoFRO;
import radniokolis.UnosFROController;
import zastitanaradu.GlavniPanelController;

public class AppoitmentButton
extends Button {
    private PopOver item;

    public AppoitmentButton(Pair<Object, String> p) {
        this.dohvatiButton(p.getKey(), (String)p.getValue());
        this.setMaxWidth(Double.MAX_VALUE);
        AnchorPane.setLeftAnchor((Node)this, (Double)0.0);
        AnchorPane.setRightAnchor((Node)this, (Double)0.0);
        this.setAlignment(Pos.CENTER);
    }

    private void dohvatiButton(Object o, String d) {
        StringTokenizer st = new StringTokenizer(d);
        String poruka = st.nextToken();
        if (poruka.equalsIgnoreCase("LIJE\u010cNI\u010cKI")) {
            this.dajButtonLjecnicki(poruka, o);
        } else if (poruka.equalsIgnoreCase("ozo")) {
            this.dajButtonOZO(poruka, o);
        } else if (poruka.equalsIgnoreCase("FRO")) {
            this.dajButtonFRO(poruka, o);
        } else if (poruka.equalsIgnoreCase("OBJEKAT")) {
            this.dajButtonOBJEKAT(poruka, o);
        } else if (poruka.equalsIgnoreCase("STROJ")) {
            this.dajButtonSTROJ(poruka, o);
        } else if (poruka.equalsIgnoreCase("OSPOSOBLJAVANJA")) {
            this.dajButtonOsposobljavanja(poruka, o);
        } else if (poruka.equalsIgnoreCase("SJEDNICA")) {
            this.dajButtonSjednicaOdbora(poruka, o);
        } else if (poruka.equalsIgnoreCase("MJERNI-URE\u0110AJ")) {
            this.dajButtonMjerniInstrumenti(poruka, o);
        } else if (poruka.equalsIgnoreCase("PREGLED")) {
            this.dajButtonDrugiPregled(poruka, o);
        } else if (poruka.equalsIgnoreCase("VATROGASNI-APARAT")) {
            this.dajButtonVatrogasniAparat(poruka, o);
        }
    }

    private void dajButtonLjecnicki(String poruka, Object o) {
        DjelatnikPregled dj = (DjelatnikPregled)o;
        this.setText(dj.getIme() + " " + dj.getPrezime() + "\n " + poruka);
        this.setTooltip(new Tooltip(dj.getIme() + " " + dj.getPrezime() + " " + poruka));
        this.setStyle("-fx-background-color: cornflowerblue    ;-fx-border-color: gray;-fx-border-width: 0.5; ");
        this.setOnMouseClicked(e -> {
            FXMLLoader loader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("/monitoringnovi/DjelatnikLjecnickiPregledPopup.fxml"));
            Parent root = null;
            try {
                root = (Parent)loader.load();
            }
            catch (IOException ex) {
                Logger.getLogger(MonitoringController.class.getName()).log(Level.SEVERE, null, ex);
            }
            this.item = new PopOver();
            this.item.setContentNode((Node)root);
            DjelatnikLjecnickiPregledPopupController.getInstance().prikaziDjelatnika(dj, this.item);
            this.item.setArrowLocation(PopOver.ArrowLocation.LEFT_TOP);
            this.item.setCornerRadius(4.0);
            this.item.setTitle(poruka);
            this.item.show((Node)this.getParent(), e.getScreenX(), e.getScreenY());
        });
    }

    private void dajButtonOZO(String poruka, Object o) {
        DjelatnikPregled dj = (DjelatnikPregled)o;
        this.setText(dj.getIme() + " " + dj.getPrezime() + "\n " + poruka);
        this.setTooltip(new Tooltip(dj.getIme() + " " + dj.getPrezime() + " " + poruka));
        this.setStyle("-fx-background-color: lightcoral  ;-fx-border-color: gray;-fx-border-width: 0.5; ");
        this.setOnMouseClicked(e -> {
            FXMLLoader loader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("/monitoringnovi/DjlatnikOZOPopup.fxml"));
            Parent root = null;
            try {
                root = (Parent)loader.load();
            }
            catch (IOException ex) {
                Logger.getLogger(MonitoringController.class.getName()).log(Level.SEVERE, null, ex);
            }
            this.item = new PopOver();
            this.item.setContentNode((Node)root);
            DjlatnikOZOPopupController.getInstance().prikaziDjelatnika(dj, this.item);
            this.item.setArrowLocation(PopOver.ArrowLocation.LEFT_TOP);
            this.item.setCornerRadius(4.0);
            this.item.setTitle(poruka);
            this.item.show((Node)this.getParent(), e.getScreenX(), e.getScreenY());
        });
    }

    private void dajButtonFRO(String poruka, Object o) {
        MjernoMjestoFRO mm = (MjernoMjestoFRO)o;
        this.setText(mm.getNazivMjernogMjesta() + "\n " + poruka);
        this.setTooltip(new Tooltip(mm.getNazivMjernogMjesta() + "\n " + poruka));
        this.setStyle("-fx-background-color:olivedrab     ;-fx-border-color: gray;-fx-border-width: 0.5; ");
        this.setOnMouseClicked(e -> {
            if (!GlavniPanelController.getInstance().getTabByIdifExist("Unos mjernog mjesta")) {
                GlavniPanelController.getInstance().zatvoriTab("Unos mjernog mjesta");
                GlavniPanelController.getInstance().nadodajPanel("Unos mjernog mjesta", "/radniokolis/UnosFRO.fxml");
                UnosFROController.getInstance().izmjenaFRO(mm);
                UnosFROController.getInstance().getTabPanePodaci().getSelectionModel().select(1);
            } else {
                GlavniPanelController.getInstance().nadodajPanel("Unos mjernog mjesta", "/radniokolis/UnosFRO.fxml");
                UnosFROController.getInstance().izmjenaFRO(mm);
                UnosFROController.getInstance().getTabPanePodaci().getSelectionModel().select(1);
            }
        });
    }

    private void dajButtonOBJEKAT(String poruka, Object o) {
        ObjektNadzor on = (ObjektNadzor)o;
        this.setText(on.getNazivObjekta() + "\n " + poruka);
        this.setTooltip(new Tooltip(on.getNazivObjekta() + " " + poruka));
        this.setStyle("-fx-background-color: midnightblue    ;-fx-border-color: gray;-fx-border-width: 0.5; ");
        this.setOnMouseClicked(e -> {
            FXMLLoader loader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("/monitoringnovi/ObjektNoviPopup.fxml"));
            Parent root = null;
            try {
                root = (Parent)loader.load();
            }
            catch (IOException ex) {
                Logger.getLogger(MonitoringController.class.getName()).log(Level.SEVERE, null, ex);
            }
            this.item = new PopOver();
            this.item.setContentNode((Node)root);
            ObjektNoviPopupController.getInstance().prikaziObjekt(on, this.item);
            this.item.setArrowLocation(PopOver.ArrowLocation.LEFT_TOP);
            this.item.setCornerRadius(4.0);
            this.item.setTitle(poruka);
            this.item.show((Node)this.getParent(), e.getScreenX(), e.getScreenY());
        });
    }

    private void dajButtonSTROJ(String poruka, Object o) {
        StrojEvidencija se = (StrojEvidencija)o;
        this.setText(se.getNazivstroja() + "\n " + poruka);
        this.setTooltip(new Tooltip(se.getNazivstroja() + "\n " + poruka));
        this.setStyle("-fx-background-color: olivedrab    ;-fx-border-color: gray;-fx-border-width: 0.5; ");
        this.setOnMouseClicked(e -> {
            if (!GlavniPanelController.getInstance().getTabByIdifExist("Unos Stroja")) {
                GlavniPanelController.getInstance().zatvoriTab("Unos Stroja");
                GlavniPanelController.getInstance().nadodajPanel("Unos Stroja", "/radnaoprema/UnosStrojeva.fxml");
                UnosStrojevaController.getInstance().izmjenaStroja(se);
                UnosStrojevaController.getInstance().getTabPanePodaci().getSelectionModel().select(2);
            } else {
                GlavniPanelController.getInstance().nadodajPanel("Unos Stroja", "/radnaoprema/UnosStrojeva.fxml");
                UnosStrojevaController.getInstance().izmjenaStroja(se);
                UnosStrojevaController.getInstance().getTabPanePodaci().getSelectionModel().select(2);
            }
        });
    }

    private void dajButtonOsposobljavanja(String poruka, Object o) {
        DjelatnikPregled dj = (DjelatnikPregled)o;
        this.setText(dj.getIme() + " " + dj.getPrezime() + "\n " + poruka);
        this.setTooltip(new Tooltip(dj.getIme() + " " + dj.getPrezime() + " " + poruka));
        this.setStyle("-fx-background-color: coral  ;-fx-border-color: gray;-fx-border-width: 0.5; ");
        this.setOnMouseClicked(e -> {
            FXMLLoader loader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("/monitoringnovi/DjelatnikOsposobljavanjePopup.fxml"));
            Parent root = null;
            try {
                root = (Parent)loader.load();
            }
            catch (IOException ex) {
                Logger.getLogger(MonitoringController.class.getName()).log(Level.SEVERE, null, ex);
            }
            this.item = new PopOver();
            this.item.setContentNode((Node)root);
            DjelatnikOsposobljavanjePopupController.getInstance().prikaziDjelatnika(dj, this.item);
            this.item.setArrowLocation(PopOver.ArrowLocation.LEFT_TOP);
            this.item.setCornerRadius(4.0);
            this.item.setTitle(poruka);
            this.item.show((Node)this.getParent(), e.getScreenX(), e.getScreenY());
        });
    }

    private void dajButtonSjednicaOdbora(String poruka, Object o) {
        this.setText("ODBOR\n " + poruka);
        this.setTooltip(new Tooltip(poruka + " ODBORA"));
        this.setStyle("-fx-background-color: steelblue    ;-fx-border-color: gray;-fx-border-width: 0.5; ");
        this.setOnMouseClicked(e -> GlavniPanelController.getInstance().nadodajPanel("Odbor za\u0161tite na radu", "/odbor/Odbor.fxml"));
    }

    private void dajButtonMjerniInstrumenti(String poruka, Object o) {
        MjerniInstrumentPodaci se = (MjerniInstrumentPodaci)o;
        this.setText(se.getNazivstroja() + "\n " + poruka);
        this.setTooltip(new Tooltip(se.getNazivstroja() + "\n " + poruka));
        this.setStyle("-fx-background-color: chocolate   ;-fx-border-color: gray;-fx-border-width: 0.5; ");
        this.setOnMouseClicked(e -> {
            if (!GlavniPanelController.getInstance().getTabByIdifExist("Unos ure\u0111aja")) {
                GlavniPanelController.getInstance().zatvoriTab("Unos ure\u0111aja");
                GlavniPanelController.getInstance().nadodajPanel("Unos ure\u0111aja", "/mjerniinstrumenti/UnosMjernogInstrumenta.fxml");
                UnosMjernogInstrumentaController.getInstance().izmjenaUredjaja(se);
                UnosMjernogInstrumentaController.getInstance().getTabPanePodaci().getSelectionModel().select(2);
            } else {
                GlavniPanelController.getInstance().nadodajPanel("Unos ure\u0111aja", "/mjerniinstrumenti/UnosMjernogInstrumenta.fxml");
                UnosMjernogInstrumentaController.getInstance().izmjenaUredjaja(se);
                UnosMjernogInstrumentaController.getInstance().getTabPanePodaci().getSelectionModel().select(2);
            }
        });
    }

    private void dajButtonDrugiPregled(String poruka, Object o) {
        DjelatnikPregled dj = (DjelatnikPregled)o;
        this.setText(dj.getIme() + " " + dj.getPrezime() + "\n " + poruka);
        this.setTooltip(new Tooltip(dj.getIme() + " " + dj.getPrezime() + " " + poruka));
        this.setStyle("-fx-background-color: orchid   ;-fx-border-color: gray;-fx-border-width: 0.5; ");
        this.setOnMouseClicked(e -> {
            FXMLLoader loader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("/monitoringnovi/DjelatnikOstaliPreglediPopup.fxml"));
            Parent root = null;
            try {
                root = (Parent)loader.load();
            }
            catch (IOException ex) {
                Logger.getLogger(MonitoringController.class.getName()).log(Level.SEVERE, null, ex);
            }
            this.item = new PopOver();
            this.item.setContentNode((Node)root);
            DjelatnikOstaliPreglediPopupController.getInstance().prikaziDjelatnika(dj, this.item);
            this.item.setArrowLocation(PopOver.ArrowLocation.LEFT_TOP);
            this.item.setCornerRadius(4.0);
            this.item.setTitle(poruka);
            this.item.show((Node)this.getParent(), e.getScreenX(), e.getScreenY());
        });
    }

    private void dajButtonVatrogasniAparat(String poruka, Object o) {
        NadzorVAtrogasniAparat va = (NadzorVAtrogasniAparat)o;
        this.setText(va.getNazivAparata() + "\n " + va.getServisnaNaljepnica() + "\n " + poruka);
        this.setTooltip(new Tooltip(va.getNazivAparata() + " " + poruka));
        this.setStyle("-fx-background-color: red   ;-fx-border-color: gray;-fx-border-width: 0.5; ");
        this.setOnMouseClicked(e -> {
            FXMLLoader loader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("/monitoringnovi/VatrogasniAparatPopup.fxml"));
            Parent root = null;
            try {
                root = (Parent)loader.load();
            }
            catch (IOException ex) {
                Logger.getLogger(MonitoringController.class.getName()).log(Level.SEVERE, null, ex);
            }
            this.item = new PopOver();
            this.item.setContentNode((Node)root);
            VatrogasniAparatPopupController.getInstance().prikaziVAtrogasniAparat(va, this.item);
            this.item.setArrowLocation(PopOver.ArrowLocation.LEFT_TOP);
            this.item.setCornerRadius(4.0);
            this.item.setTitle(poruka);
            this.item.show((Node)this.getParent(), e.getScreenX(), e.getScreenY());
        });
    }
}

