/*
 * Decompiled with CFR 0.152.
 */
package kalendar;

import java.net.URL;
import java.time.LocalDate;
import java.time.Period;
import java.util.ArrayList;
import java.util.Map;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.property.ListProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import kalendar.Day;
import kalendar.DayComponent;
import kalendar.FileStore;
import kalendar.Store;
import monitoringnovi.TjedniPregledService;

public class CalendarController
implements Initializable {
    public final StringProperty firstWeekname = new SimpleStringProperty("");
    public final StringProperty secondWeekname = new SimpleStringProperty("");
    public final StringProperty thirdWeekname = new SimpleStringProperty("");
    public final StringProperty fourthWeekname = new SimpleStringProperty("");
    private final ListProperty<Day> days = new SimpleListProperty(FXCollections.observableArrayList());
    private static Store store;
    @FXML
    public GridPane root;
    @FXML
    private ArrayList<DayComponent> dayComponents;
    @FXML
    private StackPane stackPaneMask;
    private Region veil;
    private ProgressIndicator pmask;
    private boolean isShowing = false;
    private static CalendarController instance;
    private TjedniPregledService tpservice;

    public boolean isIsShowing() {
        return this.isShowing;
    }

    public void setIsShowing(boolean isShowing) {
        this.isShowing = isShowing;
    }

    public static CalendarController getInstance() {
        return instance;
    }

    public TjedniPregledService getTpservice() {
        return this.tpservice;
    }

    public void setTpservice(TjedniPregledService tpservice) {
        this.tpservice = tpservice;
    }

    public CalendarController() {
        this.firstWeekname.bind((ObservableValue)Bindings.createStringBinding(() -> this.getWeekname(0), (Observable[])new Observable[]{this.days}));
    }

    private String getWeekname(int weekNumber) {
        int dayNumber = Period.ofWeeks(weekNumber).getDays();
        if (this.days.size() <= dayNumber) {
            return "";
        }
        return String.format("Tjedan %02d\n%d", ((Day)this.days.get(dayNumber)).getDate().getDayOfYear() / Period.ofWeeks(1).getDays() + 1, ((Day)this.days.get(dayNumber)).getDate().getYear());
    }

    @FXML
    public void prev(ActionEvent actionEvent) {
        this.setDays(store.getDays(((Day)this.days.get(0)).getDate().minusWeeks(1L)));
    }

    @FXML
    public void next(ActionEvent actionEvent) {
        this.setDays(store.getDays(((Day)this.days.get(0)).getDate().plusWeeks(1L)));
    }

    public void initialize(URL location, ResourceBundle resources) {
        instance = this;
        this.setIsShowing(true);
        this.tpservice = new TjedniPregledService();
        this.tpservice.setOnSucceeded((EventHandler)new EventHandler<WorkerStateEvent>(){

            public void handle(WorkerStateEvent t) {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        store = new FileStore((Map)CalendarController.this.tpservice.getValue());
                        ArrayList<Day> daysWithToday = store.getDaysWithToday();
                        CalendarController.this.setDays(daysWithToday);
                    }
                });
            }
        });
        this.tpservice.start();
        this.veil = new Region();
        this.pmask = new ProgressIndicator();
        this.veil.setStyle("-fx-background-color: rgba(0, 0, 0, 0.4)");
        this.pmask.setMaxSize(150.0, 150.0);
        this.stackPaneMask.getChildren().addAll((Object[])new Node[]{this.veil, this.pmask});
        this.pmask.progressProperty().bind((ObservableValue)this.tpservice.progressProperty());
        this.veil.visibleProperty().bind((ObservableValue)this.tpservice.runningProperty());
        this.pmask.visibleProperty().bind((ObservableValue)this.tpservice.runningProperty());
    }

    private void setDays(ArrayList<Day> daysWithToday) {
        this.days.clear();
        this.days.addAll(daysWithToday);
        int i = 0;
        LocalDate now = LocalDate.now();
        for (DayComponent day : this.dayComponents) {
            if (day.dayProperty().isBound()) {
                day.dayProperty().unbind();
            }
            ObjectBinding dayI = Bindings.valueAt(this.days, (int)i++);
            day.styleProperty().bind((ObservableValue)Bindings.createStringBinding(() -> dayI.get() != null && ((Day)dayI.get()).getDate().equals(now) ? "-fx-background-color: pink;" : "", (Observable[])new Observable[]{dayI}));
            day.dayProperty().bind((ObservableValue)dayI);
        }
    }

    public String getFirstWeekname() {
        return (String)this.firstWeekname.get();
    }

    public StringProperty firstWeeknameProperty() {
        return this.firstWeekname;
    }

    public String getSecondWeekname() {
        return (String)this.secondWeekname.get();
    }

    public StringProperty secondWeeknameProperty() {
        return this.secondWeekname;
    }

    public String getThirdWeekname() {
        return (String)this.thirdWeekname.get();
    }

    public StringProperty thirdWeeknameProperty() {
        return this.thirdWeekname;
    }

    public String getFourthWeekname() {
        return (String)this.fourthWeekname.get();
    }

    public StringProperty fourthWeeknameProperty() {
        return this.fourthWeekname;
    }
}

