/*
 * Decompiled with CFR 0.152.
 */
package kalendar;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.Period;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javafx.util.Pair;
import kalendar.Day;
import kalendar.Store;
import monitoringnovi.TjedniPregledService;

public class FileStore
extends Store {
    private final HashMap<LocalDate, ArrayList<Pair<Object, String>>> appointmentsMap = new HashMap();
    private TjedniPregledService tpservice;

    public FileStore(Map<String, Pair<Object, LocalDate>> listaDatuma) {
        listaDatuma.forEach((k, v) -> {
            LocalDate key = (LocalDate)v.getValue();
            ArrayList<Pair> list = this.appointmentsMap.getOrDefault(key, new ArrayList());
            list.add(new Pair(v.getKey(), k));
            this.appointmentsMap.put(key, list);
        });
    }

    public TjedniPregledService getTpservice() {
        return this.tpservice;
    }

    public void setTpservice(TjedniPregledService tpservice) {
        this.tpservice = tpservice;
    }

    @Override
    public ArrayList<Day> getDays(LocalDate startWeek) {
        LocalDate startDay = startWeek.with(DayOfWeek.MONDAY);
        LocalDate endDay = startDay.plus(Period.ofWeeks(1));
        ArrayList<Day> days = new ArrayList<Day>();
        LocalDate date = startDay;
        while (date.isBefore(endDay)) {
            ArrayList<Pair<Object, String>> appointments = this.appointmentsMap.get(date);
            Day day = appointments != null ? new Day(date, appointments) : new Day(date);
            days.add(day);
            date = date.plusDays(1L);
        }
        return days;
    }
}

