/*
 * Decompiled with CFR 0.152.
 */
package login;

import Utill.DateUtil;
import Utill.FxDialogs;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.Period;
import java.time.temporal.ChronoUnit;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Text;
import login.LogFileMonitoring;
import login.LoginManager;
import tvrtka.BazaKorisnik;
import tvrtka.Korisnik;

public class LoginControler
implements Initializable {
    String checkUser;
    String checkPw;
    @FXML
    private URL location;
    @FXML
    private Button btnLogin;
    @FXML
    private Label lblMessage;
    @FXML
    private Label text;
    @FXML
    private PasswordField pf;
    @FXML
    private GridPane root;
    @FXML
    private TextField txtUserName;
    @FXML
    private Text textDole;
    LoginManager loginManager;
    Korisnik k = null;
    private static Korisnik loginUser;

    public static Korisnik getLoginUser() {
        return loginUser;
    }

    public static void setLoginUser(Korisnik k) {
        loginUser = k;
    }

    @FXML
    public void handleEnterPressed(KeyEvent event) {
        if (event.getCode() == KeyCode.ENTER) {
            this.login();
        }
    }

    public void initialize(URL url, ResourceBundle rb) {
        assert (this.btnLogin != null) : "fx:id=\"btnLogin\" was not injected: check your FXML file 'Login.fxml'.";
        assert (this.lblMessage != null) : "fx:id=\"lblMessage\" was not injected: check your FXML file 'Login.fxml'.";
        assert (this.pf != null) : "fx:id=\"pf\" was not injected: check your FXML file 'Login.fxml'.";
        assert (this.root != null) : "fx:id=\"root\" was not injected: check your FXML file 'Login.fxml'.";
        assert (this.txtUserName != null) : "fx:id=\"txtUserName\" was not injected: check your FXML file 'Login.fxml'.";
    }

    public void initManager(LoginManager loginManager) {
        this.loginManager = loginManager;
        this.btnLogin.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                LoginControler.this.login();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean dajKorisnika() {
        boolean uspjelo = false;
        ResultSet rs = BazaKorisnik.getKorisnik(this.txtUserName.getText(), this.pf.getText());
        try {
            uspjelo = rs.next();
        }
        catch (SQLException ex) {
            Logger.getLogger(LoginControler.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(LoginControler.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return uspjelo;
    }

    private void login() {
        if (this.dajKorisnika()) {
            ResultSet rs = BazaKorisnik.getKorisnik(this.txtUserName.getText(), this.pf.getText());
            try {
                while (rs.next()) {
                    this.k = new Korisnik();
                    this.k.setId(rs.getInt("id"));
                    this.k.setIme(rs.getString("ime"));
                    this.k.setPrezime(rs.getString("prezime"));
                    this.k.setUsername(rs.getString("username"));
                    this.k.setPassword(rs.getString("lozinka"));
                    this.k.setKorisnik(rs.getString("naziv_grupe"));
                    this.k.setBrojTvrtki(rs.getInt("brojtvrtki"));
                    this.k.setTvrtka(rs.getString("tvrtka"));
                    this.k.setDatumLicence(DateUtil.getLocalDate(rs.getDate("datumlicence")));
                    this.k.setImePrezime(rs.getString("ime") + " " + rs.getString("prezime"));
                }
            }
            catch (SQLException ex) {
                Logger.getLogger(LoginControler.class.getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                try {
                    rs.close();
                }
                catch (SQLException ex) {
                    Logger.getLogger(LoginControler.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            this.checkUser = this.txtUserName.getText();
            this.checkPw = this.pf.getText();
            if (this.checkUser.equals(this.k.getUsername()) && this.checkPw.equals(this.k.getPassword())) {
                loginUser = this.k;
                this.provjeriLicencu(this.k.getDatumLicence());
                try {
                    LogFileMonitoring.spremiULogInfo(loginUser);
                }
                catch (Exception ex) {
                    Logger.getLogger(LoginControler.class.getName()).log(Level.SEVERE, null, ex);
                }
                this.loginManager.authenticated();
            } else {
                this.lblMessage.setText("Korisni\u010dko ime ili lozinka nisu ispravni.");
                this.lblMessage.setTextFill((Paint)Color.RED);
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        LoginControler.this.txtUserName.requestFocus();
                    }
                });
            }
        } else {
            this.lblMessage.setText("Korisni\u010dko ime ili lozinka nisu ispravni.");
            this.lblMessage.setTextFill((Paint)Color.RED);
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    LoginControler.this.txtUserName.requestFocus();
                }
            });
        }
        this.txtUserName.setText("");
        this.pf.setText("");
    }

    private void provjeriLicencu(LocalDate licenca) {
        LocalDate datePocetni = LocalDate.now();
        LocalDate dateEnd = licenca;
        Period p = Period.between(datePocetni, dateEnd);
        long p2 = ChronoUnit.DAYS.between(datePocetni, dateEnd);
        if (p2 < 0L) {
            Alert alert = FxDialogs.getDialog(Alert.AlertType.INFORMATION, "Licenca programa", "Licenca je istekla obratite se vlasniku programa:\n email:  info@eksystems.net");
            alert.showAndWait();
            System.exit(0);
        } else if (p2 <= 30L) {
            Alert alert = FxDialogs.getDialog(Alert.AlertType.INFORMATION, "Licenca programa", "Licenca je pred istekom ostalo je jo\u0161 ukupno  " + p2 + "  dana");
            alert.showAndWait();
        }
    }
}

