/*
 * Decompiled with CFR 0.152.
 */
package login;

import Utill.FormValidation;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.PasswordField;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TextField;
import javafx.stage.Stage;
import login.Encryptor;
import login.Postavke;
import login.PostavkeStatic;

public class PostavkeBazeController
implements Initializable {
    @FXML
    private TextField txtNazivServera;
    @FXML
    private TextField txtPort;
    @FXML
    private TextField txtNazivBaze;
    @FXML
    private TextField txtKorisnik;
    @FXML
    private PasswordField txtPassword;
    @FXML
    private Button btnTest;
    @FXML
    private Button btnOdustani;
    @FXML
    private Button btnSpremi;
    @FXML
    private ProgressIndicator serviceRunningIndicator;
    @FXML
    private Label messagesLabel;
    private StringProperty statusMessagesProperty;
    private BooleanProperty connectedProperty;
    private ConnectService connectService;
    File direktorij = new File(PostavkeStatic.getPutanjaPostavkeDirektorij());
    File myFile = new File(PostavkeStatic.getPutanjaPostavkeBazeFile());
    private static PostavkeBazeController instance;
    private Stage scene;

    public static PostavkeBazeController getInstance() {
        return instance;
    }

    public void initialize(URL url, ResourceBundle rb) {
        instance = this;
        this.ucitajPostavke();
        this.connectService = new ConnectService();
        this.messagesLabel.textProperty().bind((ObservableValue)this.statusMessagesProperty());
        this.btnTest.disableProperty().bind((ObservableValue)this.connectService.runningProperty());
        this.serviceRunningIndicator.visibleProperty().bind((ObservableValue)this.connectService.runningProperty());
        this.connectService.setOnSucceeded((EventHandler)new EventHandler<WorkerStateEvent>(){

            public void handle(WorkerStateEvent t) {
                PostavkeBazeController.this.messagesLabel.setStyle(null);
                System.out.println(t.getSource().getValue());
                if (((Boolean)t.getSource().getValue()).booleanValue()) {
                    PostavkeBazeController.this.statusMessagesProperty().set((Object)"Connected successfully.");
                } else {
                    PostavkeBazeController.this.messagesLabel.setStyle("-fx-text-fill: red");
                    PostavkeBazeController.this.statusMessagesProperty().set((Object)"Connecting failed.");
                }
            }
        });
        this.btnOdustani.setOnAction(e1 -> {
            if (this.myFile.exists()) {
                this.scene.hide();
            } else {
                System.exit(0);
            }
        });
        this.btnSpremi.setOnAction(e1 -> {
            if (this.spremiBazu()) {
                this.scene.hide();
            }
        });
        this.btnTest.setOnAction(e -> this.connect());
    }

    public void connect() {
        this.statusMessagesProperty().set((Object)"");
        this.connectService.restart();
    }

    void ucitajPostavke() {
        try {
            this.ucitajpostavke();
        }
        catch (IOException ex) {
            Logger.getLogger(PostavkeBazeController.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(PostavkeBazeController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public boolean spremiBazu() {
        boolean bPass;
        boolean bKorisnik;
        boolean bNazivBaze;
        boolean bPort;
        boolean uspjelo = false;
        boolean bServer = FormValidation.textFieldValidationonlyText(this.txtNazivServera);
        if (bServer & (bPort = FormValidation.textFieldValidationonlyText(this.txtPort)) & (bNazivBaze = FormValidation.textFieldValidationonlyText(this.txtNazivBaze)) & (bKorisnik = FormValidation.textFieldValidationonlyText(this.txtKorisnik)) & (bPass = FormValidation.textFieldValidationonlyText((TextField)this.txtPassword))) {
            if (!this.direktorij.exists()) {
                this.direktorij.mkdirs();
            }
            Postavke b = new Postavke();
            b.setBazaServerNaziv(Encryptor.encrypt(this.txtNazivServera.getText()));
            b.setBazaServerPort(Encryptor.encrypt(this.txtPort.getText()));
            b.setBazaNaziv(Encryptor.encrypt(this.txtNazivBaze.getText()));
            b.setBazaKorisnik(Encryptor.encrypt(this.txtKorisnik.getText()));
            b.setBazaLozinka(Encryptor.encrypt(this.txtPassword.getText()));
            try {
                FileOutputStream fileOut = new FileOutputStream(this.myFile);
                ObjectOutputStream out = new ObjectOutputStream(fileOut);
                out.writeObject(b);
                out.flush();
                out.close();
                uspjelo = true;
            }
            catch (IOException i) {
                uspjelo = false;
            }
        } else {
            this.messagesLabel.setStyle("-fx-text-fill: red");
            this.statusMessagesProperty().set((Object)"Morate popuniti sva polja");
        }
        return uspjelo;
    }

    public void ucitajpostavke() throws IOException, ClassNotFoundException {
        Postavke p = PostavkeStatic.ucitajPostavkeBaze();
        this.popuniTxtPostavke(p);
    }

    private void popuniTxtPostavke(Postavke p) {
        if (p != null) {
            this.txtNazivServera.setText(PostavkeStatic.getBazaServerNaziv());
            this.txtPort.setText(PostavkeStatic.getBazaServerPort());
            this.txtNazivBaze.setText(PostavkeStatic.getBazaNaziv());
            this.txtKorisnik.setText(PostavkeStatic.getBazaKorisnik());
            this.txtPassword.setText(PostavkeStatic.getBazaLozinka());
        } else {
            this.txtNazivServera.setText("");
            this.txtPort.setText("");
            this.txtNazivBaze.setText("");
            this.txtKorisnik.setText("");
            this.txtPassword.setText("");
        }
    }

    public void setScene(Stage s) {
        this.scene = s;
    }

    private StringProperty statusMessagesProperty() {
        if (this.statusMessagesProperty == null) {
            this.statusMessagesProperty = new SimpleStringProperty();
        }
        return this.statusMessagesProperty;
    }

    private BooleanProperty connectedProperty() {
        if (this.connectedProperty == null) {
            this.connectedProperty = new SimpleBooleanProperty(Boolean.FALSE.booleanValue());
        }
        return this.connectedProperty;
    }

    private class ConnectService
    extends Service<Boolean> {
        private ConnectService() {
        }

        public boolean chechConnection(String imeServera, String port, String imeBaze, String imeUsera, String password) {
            boolean uspjelo = false;
            String Url = "jdbc:postgresql://" + imeServera + ":" + port + "/" + imeBaze + "?user=" + imeUsera + "&password=" + password;
            try {
                Class.forName("org.postgresql.Driver").newInstance();
                Connection connection = DriverManager.getConnection(Url);
                uspjelo = true;
            }
            catch (Exception e) {
                System.out.println("Unable to make connection with DB");
                uspjelo = false;
            }
            return uspjelo;
        }

        protected Task<Boolean> createTask() {
            return new Task<Boolean>(){

                protected Boolean call() throws Exception {
                    this.updateMessage("Connecting....");
                    Thread.sleep(500L);
                    boolean uspjelo = ConnectService.this.chechConnection(PostavkeBazeController.this.txtNazivServera.getText(), PostavkeBazeController.this.txtPort.getText(), PostavkeBazeController.this.txtNazivBaze.getText(), PostavkeBazeController.this.txtKorisnik.getText(), PostavkeBazeController.this.txtPassword.getText());
                    this.updateMessage("Waiting for server feedback.");
                    PostavkeBazeController.this.connectedProperty().set(uspjelo);
                    return uspjelo;
                }
            };
        }
    }
}

