/*
 * Decompiled with CFR 0.152.
 */
package login;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import login.Encryptor;
import login.Postavke;
import login.PostavkeBazeController;
import tvrtka.TvrtkaController;

public class PostavkeStatic
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static String bazaServerNaziv;
    private static String bazaServerPort;
    private static String bazaNaziv;
    private static String bazaKorisnik;
    private static String bazaLozinka;
    private static String putanjaPostavkeDirektorij;
    private static String putanjaPostavkeBazeFile;

    public static String getPutanjaPostavkeDirektorij() {
        return putanjaPostavkeDirektorij;
    }

    public static void setPutanjaPostavkeDirektorij(String putanjaPostavkeDirektorij) {
        PostavkeStatic.putanjaPostavkeDirektorij = putanjaPostavkeDirektorij;
    }

    public static void postaviPostavkeBaze() {
        if (new File(PostavkeStatic.getPutanjaPostavkeBazeFile()).exists()) {
            try {
                PostavkeStatic.ucitajPostavkeBaze();
            }
            catch (IOException | ClassNotFoundException ex) {
                Logger.getLogger(PostavkeStatic.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            try {
                FXMLLoader loader = new FXMLLoader(PostavkeStatic.class.getResource("PostavkeBaze.fxml"));
                Stage dialog = new Stage();
                dialog.initStyle(StageStyle.UTILITY);
                dialog.initModality(Modality.APPLICATION_MODAL);
                dialog.setTitle("Unos postavki");
                Scene scene = null;
                try {
                    Parent p = (Parent)loader.load();
                    scene = new Scene(p);
                }
                catch (IOException ex) {
                    Logger.getLogger(TvrtkaController.class.getName()).log(Level.SEVERE, null, ex);
                }
                dialog.setScene(scene);
                PostavkeBazeController.getInstance().setScene(dialog);
                dialog.showAndWait();
                PostavkeStatic.ucitajPostavkeBaze();
            }
            catch (IOException | ClassNotFoundException ex) {
                Logger.getLogger(PostavkeStatic.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public static Postavke ucitajPostavkeBaze() throws IOException, ClassNotFoundException {
        Postavke p = null;
        File myFile = new File(putanjaPostavkeBazeFile);
        if (myFile.exists()) {
            ObjectInputStream oin;
            try (FileInputStream fis = new FileInputStream(myFile);){
                oin = new ObjectInputStream(fis);
                p = (Postavke)oin.readObject();
            }
            oin.close();
            PostavkeStatic.setBazaServerNaziv(Encryptor.decrypt(p.getBazaServerNaziv()));
            PostavkeStatic.setBazaServerPort(Encryptor.decrypt(p.getBazaServerPort()));
            PostavkeStatic.setBazaNaziv(Encryptor.decrypt(p.getBazaNaziv()));
            PostavkeStatic.setBazaKorisnik(Encryptor.decrypt(p.getBazaKorisnik()));
            PostavkeStatic.setBazaLozinka(Encryptor.decrypt(p.getBazaLozinka()));
        }
        return p;
    }

    public static String getBazaServerNaziv() {
        return bazaServerNaziv;
    }

    public static void setBazaServerNaziv(String bazaServerNaziv) {
        PostavkeStatic.bazaServerNaziv = bazaServerNaziv;
    }

    public static String getBazaServerPort() {
        return bazaServerPort;
    }

    public static void setBazaServerPort(String bazaServerPort) {
        PostavkeStatic.bazaServerPort = bazaServerPort;
    }

    public static String getBazaNaziv() {
        return bazaNaziv;
    }

    public static void setBazaNaziv(String bazaNaziv) {
        PostavkeStatic.bazaNaziv = bazaNaziv;
    }

    public static String getBazaKorisnik() {
        return bazaKorisnik;
    }

    public static void setBazaKorisnik(String bazaKorisnik) {
        PostavkeStatic.bazaKorisnik = bazaKorisnik;
    }

    public static String getBazaLozinka() {
        return bazaLozinka;
    }

    public static void setBazaLozinka(String bazaLozinka) {
        PostavkeStatic.bazaLozinka = bazaLozinka;
    }

    public static String getPutanjaPostavkeBazeFile() {
        return putanjaPostavkeBazeFile;
    }

    public static void setPutanjaPostavkeBazeFile(String putanjaPostavkeBazeFile) {
        PostavkeStatic.putanjaPostavkeBazeFile = putanjaPostavkeBazeFile;
    }

    static {
        putanjaPostavkeDirektorij = new File("").getAbsolutePath() + "\\Props";
        putanjaPostavkeBazeFile = new File("").getAbsolutePath() + "\\Props\\ek.props";
    }
}

