/*
 * Decompiled with CFR 0.152.
 */
package monitoring;

import Utill.DateUtil;
import Utill.KlasaKorisneMetode;
import Utill.Konekcija;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import monitoring.BazaMonitoring;
import monitoring.FROPregled;
import monitoring.MonitoringController;
import radniokolis.BazaFRO;
import tvrtka.Tvrtka;
import zastitanaradu.GlavniPanelController;

public class FRONadzorService
extends Service<ObservableList<FROPregled>> {
    private final MonitoringController mk;

    public FRONadzorService(MonitoringController mk) {
        this.mk = mk;
    }

    protected Task<ObservableList<FROPregled>> createTask() {
        return new FRONadzorTask();
    }

    private void addFROUI(final ObservableList<FROPregled> listaFRO) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                FRONadzorService.this.mk.setListaFRO((ObservableList<FROPregled>)listaFRO);
            }
        });
    }

    private class FRONadzorTask
    extends Task<ObservableList<FROPregled>> {
        private Tvrtka t = GlavniPanelController.getOdabranaTvrtka();
        ObservableList<FROPregled> listaFRO = FXCollections.observableArrayList();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected ObservableList<FROPregled> call() throws Exception {
            ResultSet rs = BazaFRO.dajMjernaMjesta(this.t, BazaFRO.Opcije.otvorena_mjernamjesta);
            FROPregled mm = null;
            int br = 1;
            try {
                while (rs.next()) {
                    mm = new FROPregled();
                    mm.setId(rs.getInt("id"));
                    mm.setRedBroj(String.valueOf(br));
                    mm.setNazivMjernogMjesta(rs.getString("nazivmjernogmjrsta"));
                    mm.setPoslovnaJedinica(rs.getString("nazivposlovnice"));
                    mm.setOdjel(rs.getString("nazivodjela"));
                    mm.setMjestoAdresa(rs.getString("mjestoadresa"));
                    mm.setOznakaLokacije(rs.getString("oznakalokacije"));
                    mm.setZatvoren(rs.getBoolean("zatvoren"));
                    mm.setdatumIstekaPregleda(this.dajDatumIstekaPregleda(rs.getInt("id"), this.t.getId()));
                    this.listaFRO.add((Object)mm);
                    ++br;
                }
            }
            catch (SQLException ex) {
                Logger.getLogger(FRONadzorService.class.getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                try {
                    rs.close();
                }
                catch (SQLException ex) {
                    Logger.getLogger(FRONadzorService.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            this.sortirajFROTablicu();
            FRONadzorService.this.addFROUI((ObservableList<FROPregled>)this.listaFRO);
            return this.listaFRO;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private LocalDate dajDatumIstekaPregleda(int idFRO, int idTvrtka) {
            LocalDate datum = null;
            Konekcija k = new Konekcija();
            String sql = "select max (datumponovogispitivanja)as ispitivanje from froevidencijapregleda where idmjernomjesto='" + idFRO + "' and idtvrtka='" + idTvrtka + "'";
            ResultSet rs = k.getResultSet(sql, true);
            KlasaKorisneMetode.ispisiSql(sql);
            try {
                while (rs.next()) {
                    datum = DateUtil.getLocalDate(rs.getDate("ispitivanje"));
                }
            }
            catch (SQLException ex) {
                Logger.getLogger(BazaMonitoring.class.getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                try {
                    rs.close();
                }
                catch (SQLException ex) {
                    Logger.getLogger(BazaMonitoring.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            return datum;
        }

        private void sortirajFROTablicu() {
            Map<Object, Object> map = new HashMap();
            ObservableList listaNajmanjihDatuma = FXCollections.observableArrayList();
            for (int i = 0; i < this.listaFRO.size(); ++i) {
                if (((FROPregled)this.listaFRO.get(i)).getdatumIstekaPregleda() == null) continue;
                listaNajmanjihDatuma.add((Object)((FROPregled)this.listaFRO.get(i)).getdatumIstekaPregleda());
                FXCollections.sort((ObservableList)listaNajmanjihDatuma, Comparator.nullsLast(Comparator.naturalOrder()));
                if (listaNajmanjihDatuma.get(0) == null) {
                    map.put(this.listaFRO.get(i), listaNajmanjihDatuma.get(1));
                } else {
                    map.put(this.listaFRO.get(i), listaNajmanjihDatuma.get(0));
                }
                listaNajmanjihDatuma.clear();
            }
            map = this.sortByValue(map);
            this.listaFRO.clear();
            map.forEach((k, v) -> this.listaFRO.add(k));
            map.clear();
        }

        public <K, V extends Comparable<? super V>> Map<K, V> sortByValue(Map<K, V> map) {
            LinkedHashMap result = new LinkedHashMap();
            Stream st = map.entrySet().stream();
            st.sorted(Comparator.comparing(e -> (Comparable)e.getValue(), Comparator.nullsLast(Comparator.naturalOrder()))).forEachOrdered(e -> {
                Comparable cfr_ignored_0 = (Comparable)result.put(e.getKey(), e.getValue());
            });
            return result;
        }
    }
}

