/*
 * Decompiled with CFR 0.152.
 */
package monitoring;

import Utill.KlasaKorisneMetode;
import Utill.SplitPaneDividerSlider;
import java.io.IOException;
import java.net.URL;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.time.chrono.ChronoLocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.animation.TranslateTransition;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SplitPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToolBar;
import javafx.scene.control.Tooltip;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.TextAlignment;
import javafx.util.Callback;
import javafx.util.Duration;
import javafx.util.Pair;
import kadrovska.DjelatnikOZS;
import kadrovska.DjelatnikOsposobljavanja;
import kadrovska.DjelatnikOstaliPregledi;
import kadrovska.UnosDjelatnikaController;
import mjerniinstrumenti.MjerniInstrumentPodaci;
import mjerniinstrumenti.UnosMjernogInstrumentaController;
import monitoring.BazaMonitoring;
import monitoring.DatumPopupController;
import monitoring.DjelatnikNadzorService;
import monitoring.DjelatnikOstaliPregledPopupController;
import monitoring.DjelatnikPregled;
import monitoring.FRONadzorService;
import monitoring.FROPregled;
import monitoring.MjerniInstrumentiService;
import monitoring.NadzorMjerniInstrumentPregled;
import monitoring.NadzorStrojPregled;
import monitoring.ObjektNadzor;
import monitoring.ObjektNadzorService;
import monitoring.ObjektPopupController;
import monitoring.OsposobljavanjePopupController;
import monitoring.Poruka;
import monitoring.SjednicaOdboraService;
import monitoring.StrojNadzorService;
import objektiispitivanja.ObjekatEvidencijaPregleda;
import org.controlsfx.control.Notifications;
import org.controlsfx.control.PopOver;
import radnaoprema.StrojEvidencija;
import radnaoprema.UnosStrojevaController;
import radniokolis.MjernoMjestoFRO;
import radniokolis.UnosFROController;
import zastitanaradu.GlavniPanelController;

public class MonitoringController
implements Initializable {
    @FXML
    private ScrollPane scrollPoruka;
    @FXML
    private BorderPane glavniBorderPane;
    @FXML
    private ToggleButton btnPoruka;
    @FXML
    private SplitPane splitPaneD;
    @FXML
    private TabPane tabPaneMonitor;
    @FXML
    private Tab tabTjedniPregled;
    @FXML
    private ToolBar toolBarLegend;
    @FXML
    private SplitPane splitPaneDesni;
    @FXML
    private SplitPane spliPaneLijevi;
    @FXML
    private TableColumn kolPretragaDjelatnik;
    @FXML
    private TitledPane titleObjekti;
    @FXML
    private TableView<ObjektNadzor> tablicaObjekti;
    @FXML
    private TableColumn kolPretragaObjekti;
    @FXML
    private TitledPane titleStrojevi;
    @FXML
    private TableView<NadzorStrojPregled> tablicaStrojevi;
    @FXML
    private TableColumn kolPretragaStrojevi;
    @FXML
    private TitledPane titleFRO;
    @FXML
    private TableView<FROPregled> tablicaFRO;
    @FXML
    private TableColumn kolPretragaFRO;
    @FXML
    private Region regProsaoRok;
    @FXML
    private Region reg15;
    @FXML
    private Region reg30;
    @FXML
    private Region regviseod30;
    @FXML
    private TitledPane titleDjelatnik;
    @FXML
    private TableView<DjelatnikPregled> tablicaDjelatnik;
    @FXML
    private BorderPane borderPane;
    @FXML
    private Button btnOduzmi;
    @FXML
    private Label lblGodina;
    @FXML
    private Button btnNadodaj;
    @FXML
    private Label lblLegenda;
    private final LocalTime firstSlotStart = LocalTime.of(0, 0);
    private final java.time.Duration slotLength = java.time.Duration.ofMinutes(15L);
    private final LocalTime lastSlotStart = LocalTime.of(23, 59);
    private final List<TimeSlot> timeSlots = new ArrayList<TimeSlot>();
    private GridPane calendarView = null;
    private GridPane calendarDays = null;
    private LocalDate today = LocalDate.now();
    private LocalDate startOfWeek;
    private LocalDate endOfWeek;
    private ScrollPane scrollPane = null;
    private ScrollPane scroller;
    private List<LocalDate> lds = new ArrayList<LocalDate>();
    private ObservableList<DjelatnikPregled> listaDjelatnika = FXCollections.observableArrayList();
    private DjelatnikNadzorService dservice;
    private StrojNadzorService sservice;
    private FRONadzorService fservice;
    private ObjektNadzorService oservice;
    private MjerniInstrumentiService miservice;
    private SjednicaOdboraService soservice;
    private static MonitoringController instance;
    private ToolBar tbFilterDjelatnik;
    private ToolBar tbFilterStroj;
    private ToolBar tbFilterObjekt;
    private ToolBar tbFilterFRO;
    private TextField tfilterDjelatnik;
    private TextField tfilterStroj;
    private TextField tfilterObjekt;
    private TextField tfilterFRO;
    private ComboBox cbFilterDjelatnik;
    private ComboBox cbFilterStroj;
    private ComboBox cbFilterObjekt;
    private ComboBox cbFilterFRO;
    private ObservableList<NadzorMjerniInstrumentPregled> listaMjerniInstrumenti = FXCollections.observableArrayList();
    private ObservableList<NadzorStrojPregled> listaStrojeva = FXCollections.observableArrayList();
    private ObservableList<FROPregled> listaFRO = FXCollections.observableArrayList();
    private ObservableList<ObjektNadzor> listaObjekti = FXCollections.observableArrayList();
    private Map<String, Pair<Object, LocalDate>> listaDatuma = new HashMap<String, Pair<Object, LocalDate>>();
    private DateTimeFormatter dayFormatter = DateTimeFormatter.ofPattern("E\nd MMM ");
    private TimeSlot timeSlot = null;
    private LocalDate date = null;
    private StackPane p = null;
    private int slotIndex = 1;
    LocalDate datumSjedniceOdbora = null;
    private ToggleButton btnResizeDjelatnik;
    private ToggleButton btnResizeObjekti;
    private ToggleButton btnResizeStrojevi;
    private ToggleButton btnResizeFro;
    ObservableList<Node> listaPoruka = FXCollections.observableArrayList();
    private CustomPane root = new CustomPane();
    private boolean isShowing = false;

    public void setListaDjelatnika(ObservableList<DjelatnikPregled> listaDjelatnika) {
        this.listaDjelatnika = listaDjelatnika;
        this.tablicaDjelatnik.setItems(this.listaDjelatnika);
        int i = listaDjelatnika.size();
        if (i >= 50 && BazaMonitoring.provjeriUpozorenje(GlavniPanelController.getOdabranaTvrtka())) {
            this.kreirajNotifikacijuOdbor(Pos.CENTER, " Broj djelatnika je ve\u0107i od 49 morate osnovati odbor u tvrtci", 15);
        }
        this.urediFilterDjelatnik(this.tablicaDjelatnik);
        this.popuniRestart();
    }

    public DjelatnikNadzorService getDservice() {
        return this.dservice;
    }

    public StrojNadzorService getSservice() {
        return this.sservice;
    }

    public FRONadzorService getFservice() {
        return this.fservice;
    }

    public ObjektNadzorService getOservice() {
        return this.oservice;
    }

    public MjerniInstrumentiService getMjerniInstrumentiservice() {
        return this.miservice;
    }

    public SjednicaOdboraService getSjednicaOdboraService() {
        return this.soservice;
    }

    public static MonitoringController getInstance() {
        return instance;
    }

    public void setListaMjerniInstrumenti(ObservableList<NadzorMjerniInstrumentPregled> listaMjerniInstrumenti) {
        this.listaMjerniInstrumenti = listaMjerniInstrumenti;
        for (NadzorMjerniInstrumentPregled mi : listaMjerniInstrumenti) {
            LocalDate datePocetni = LocalDate.now();
            LocalDate dateEnd = mi.getdatumIstekaPregleda();
            Period p = Period.between(datePocetni, dateEnd);
            long p2 = ChronoUnit.DAYS.between(datePocetni, dateEnd);
            if (p2 < 15L && p2 >= 0L) {
                this.nadodajPoruku(new Poruka(" MJERNI INSTRUMENT \n" + mi.getNazivstroja() + "\n preostalo je jo\u0161 ukupno " + p2 + "  dana "));
                continue;
            }
            if (p2 >= 0L) continue;
            this.nadodajPoruku(new Poruka(" MJERNI INSTRUMENT \n" + mi.getNazivstroja() + " \n pro\u0161lo je ukupno " + p2 * -1L + "  dana "));
        }
        this.popuniRestart();
    }

    public void setListaStrojeva(ObservableList<NadzorStrojPregled> listaStrojeva) {
        this.listaStrojeva = listaStrojeva;
        this.tablicaStrojevi.setItems(this.listaStrojeva);
        this.urediFilterStoj(this.tablicaStrojevi);
        this.popuniRestart();
    }

    public void setListaFRO(ObservableList<FROPregled> listaFRO) {
        this.listaFRO = listaFRO;
        this.tablicaFRO.setItems(this.listaFRO);
        this.urediFiterFRO(this.tablicaFRO);
        this.popuniRestart();
    }

    public void setListaObjekti(ObservableList<ObjektNadzor> listaObjekti) {
        this.listaObjekti = listaObjekti;
        this.tablicaObjekti.setItems(this.listaObjekti);
        this.urediFiterObjekti(this.tablicaObjekti);
        this.popuniRestart();
    }

    void setListaMjerniInstrumenti(LocalDate ld) {
        this.datumSjedniceOdbora = ld;
        if (this.datumSjedniceOdbora != null) {
            this.datumSjedniceOdbora = this.datumSjedniceOdbora.plusMonths(3L);
            LocalDate datePocetni = LocalDate.now();
            LocalDate dateEnd = this.datumSjedniceOdbora;
            Period p = Period.between(datePocetni, dateEnd);
            long p2 = ChronoUnit.DAYS.between(datePocetni, dateEnd);
            if (p2 < 10L && p2 >= 0L) {
                this.nadodajPoruku(new Poruka(" SJEDNICA ODBORA \n preostalo je jo\u0161 ukupno " + p2 + "  dana "));
            } else if (p2 < 0L) {
                this.nadodajPoruku(new Poruka(" SJEDNICA ODBORA \n pro\u0161lo je ukupno " + p2 * -1L + "  dana "));
            }
        }
        this.popuniRestart();
    }

    public boolean isIsShowing() {
        return this.isShowing;
    }

    public void setIsShowing(boolean isShowing) {
        this.isShowing = isShowing;
    }

    public void initialize(URL url, ResourceBundle rb) {
        instance = this;
        this.setIsShowing(true);
        this.dservice = new DjelatnikNadzorService(this);
        this.sservice = new StrojNadzorService(this);
        this.fservice = new FRONadzorService(this);
        this.oservice = new ObjektNadzorService(this);
        this.miservice = new MjerniInstrumentiService(this);
        this.soservice = new SjednicaOdboraService(this);
        this.titleDjelatnik.heightProperty().addListener((observable, oldValue, newValue) -> Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                MonitoringController.this.tablicaDjelatnik.setPrefHeight(MonitoringController.this.titleDjelatnik.getHeight());
            }
        }));
        this.titleObjekti.heightProperty().addListener((observable, oldValue, newValue) -> Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                MonitoringController.this.tablicaObjekti.setPrefHeight(MonitoringController.this.titleObjekti.getHeight());
            }
        }));
        this.titleStrojevi.heightProperty().addListener((observable, oldValue, newValue) -> Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                MonitoringController.this.tablicaStrojevi.setPrefHeight(MonitoringController.this.titleStrojevi.getHeight());
            }
        }));
        this.titleFRO.heightProperty().addListener((observable, oldValue, newValue) -> Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                MonitoringController.this.tablicaFRO.setPrefHeight(MonitoringController.this.titleFRO.getHeight());
            }
        }));
        this.lblLegenda.heightProperty().addListener((observable, oldValue, newValue) -> Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                MonitoringController.this.regProsaoRok.setPrefSize(MonitoringController.this.lblLegenda.getHeight(), MonitoringController.this.lblLegenda.getHeight());
                MonitoringController.this.reg15.setPrefSize(MonitoringController.this.lblLegenda.getHeight(), MonitoringController.this.lblLegenda.getHeight());
                MonitoringController.this.reg30.setPrefSize(MonitoringController.this.lblLegenda.getHeight(), MonitoringController.this.lblLegenda.getHeight());
                MonitoringController.this.regviseod30.setPrefSize(MonitoringController.this.lblLegenda.getHeight(), MonitoringController.this.lblLegenda.getHeight());
            }
        }));
        this.tabPaneMonitor.getSelectionModel().selectedItemProperty().addListener((observable, oldTab, newTab) -> {
            if (newTab == this.tabTjedniPregled) {
                this.toolBarLegend.setVisible(false);
            } else {
                this.toolBarLegend.setVisible(true);
            }
        });
        this.popuniDjelatnikNadzor();
        this.popuniStrojNadzor();
        this.popuniFRONadzor();
        this.popuniObjektNadzor();
        this.popuniMjerniInstrumentiNadzor();
        this.popuniSjednicaOdboraNadzor();
        this.btnNadodaj.setOnAction(e -> Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                MonitoringController.this.nadodajTjedan();
            }
        }));
        this.btnOduzmi.setOnAction(e -> Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                MonitoringController.this.oduzmiTjedan();
            }
        }));
        this.kreirajResizeDjelatnik();
        this.kreirajResizeObjekti();
        this.kreirajResizeStrojevi();
        this.kreirajResizeFRO();
        this.kreirajPanelPoruke();
    }

    private void popuniObjektNadzor() {
        ProgressIndicator progressIndicator3 = new ProgressIndicator();
        this.kreirajToolBarFIlterObjekt();
        this.urediKoloneUTabliciObjekt();
        this.tablicaObjekti.setPlaceholder((Node)progressIndicator3);
        progressIndicator3.setMaxSize(200.0, 200.0);
        progressIndicator3.progressProperty().bind((ObservableValue)this.oservice.progressProperty());
        progressIndicator3.visibleProperty().bind((ObservableValue)this.oservice.runningProperty());
        this.oservice.start();
    }

    private void popuniFRONadzor() {
        ProgressIndicator progressIndicator2 = new ProgressIndicator();
        this.kreirajToolBarFIlterFRO();
        this.urediKoloneUTabliciFRO();
        this.tablicaFRO.setPlaceholder((Node)progressIndicator2);
        progressIndicator2.setMaxSize(200.0, 200.0);
        progressIndicator2.progressProperty().bind((ObservableValue)this.fservice.progressProperty());
        progressIndicator2.visibleProperty().bind((ObservableValue)this.fservice.runningProperty());
        this.fservice.start();
    }

    private void popuniStrojNadzor() {
        ProgressIndicator progressIndicator1 = new ProgressIndicator();
        this.kreirajToolBarFIlterStroj();
        this.urediKoloneUTabliciStrojevi();
        this.tablicaStrojevi.setPlaceholder((Node)progressIndicator1);
        progressIndicator1.setMaxSize(200.0, 200.0);
        progressIndicator1.progressProperty().bind((ObservableValue)this.sservice.progressProperty());
        progressIndicator1.visibleProperty().bind((ObservableValue)this.sservice.runningProperty());
        this.sservice.start();
    }

    private void popuniMjerniInstrumentiNadzor() {
        this.miservice.start();
    }

    private void kreirajToolBarFIlterStroj() {
        this.tbFilterStroj = new ToolBar();
        this.tfilterStroj = new TextField();
        this.tfilterStroj.setPromptText("Filter");
        this.tfilterStroj.setId("textField");
        this.cbFilterStroj = new ComboBox();
        ObservableList filter = FXCollections.observableArrayList((Object[])new String[]{"Naziv", "Inventurni broj", "Poslovna jedinica", "Tv. Broj"});
        this.cbFilterStroj.getItems().addAll((Collection)filter);
        this.cbFilterStroj.setValue((Object)"Naziv");
        this.cbFilterStroj.setPrefWidth(200.0);
        this.tfilterStroj.setPrefWidth(200.0);
        this.tfilterStroj.setPrefHeight(25.0);
        this.btnResizeStrojevi = new ToggleButton();
        this.btnResizeStrojevi.setId("btnResize");
        this.tbFilterStroj.getItems().addAll((Object[])new Node[]{this.tfilterStroj, this.cbFilterStroj, this.btnResizeStrojevi});
    }

    private void urediKoloneUTabliciStrojevi() {
        TableColumn pj = new TableColumn("POSLOVNA JEDINICA");
        pj.setCellValueFactory(cellData -> ((NadzorStrojPregled)cellData.getValue()).poslovnajedinicaProperty());
        pj.prefWidthProperty().bind((ObservableValue)this.tablicaStrojevi.widthProperty().divide(5.0));
        pj.setStyle("-fx-alignment: CENTER;");
        TableColumn invBroj = new TableColumn("INV. BROJ");
        invBroj.setCellValueFactory(cellData -> ((NadzorStrojPregled)cellData.getValue()).inventurnibrojProperty());
        invBroj.prefWidthProperty().bind((ObservableValue)this.tablicaStrojevi.widthProperty().divide(10.0));
        invBroj.setStyle("-fx-alignment: CENTER;");
        TableColumn tvBroj = new TableColumn("TV. BROJ");
        tvBroj.setCellValueFactory(cellData -> ((NadzorStrojPregled)cellData.getValue()).tvornickibrojProperty());
        tvBroj.prefWidthProperty().bind((ObservableValue)this.tablicaStrojevi.widthProperty().divide(10.0));
        tvBroj.setStyle("-fx-alignment: CENTER;");
        TableColumn naziv = new TableColumn("NAZIV");
        naziv.setCellValueFactory(cellData -> ((NadzorStrojPregled)cellData.getValue()).nazivstrojaProperty());
        naziv.prefWidthProperty().bind((ObservableValue)this.tablicaStrojevi.widthProperty().divide(3.3333333333333335));
        naziv.setStyle("-fx-alignment: CENTER;");
        Callback dateCellFactory1 = param -> new DatumValueCell();
        TableColumn datumIspitivanja = new TableColumn("DATUM ISPITIVANJA");
        datumIspitivanja.setCellValueFactory((Callback)new PropertyValueFactory("datumIstekaPregleda"));
        datumIspitivanja.prefWidthProperty().bind((ObservableValue)this.tablicaStrojevi.widthProperty().divide(3.4482758620689653));
        datumIspitivanja.setCellFactory(dateCellFactory1);
        datumIspitivanja.setStyle("-fx-alignment: CENTER;");
        this.kolPretragaStrojevi.setGraphic((Node)this.tbFilterStroj);
        this.kolPretragaStrojevi.getColumns().addAll(new Object[]{invBroj, tvBroj, naziv, datumIspitivanja, pj});
    }

    private void popuniDjelatnikNadzor() {
        ProgressIndicator progressIndicatorDjelatnik = new ProgressIndicator();
        this.kreirajToolBarFIlterDjelatnik();
        this.urediKoloneUTablicuDjeletnici();
        this.tablicaDjelatnik.setPlaceholder((Node)progressIndicatorDjelatnik);
        progressIndicatorDjelatnik.setMaxSize(200.0, 200.0);
        progressIndicatorDjelatnik.progressProperty().bind((ObservableValue)this.dservice.progressProperty());
        progressIndicatorDjelatnik.visibleProperty().bind((ObservableValue)this.dservice.runningProperty());
        this.dservice.start();
    }

    private void kreirajToolBarFIlterDjelatnik() {
        this.tbFilterDjelatnik = new ToolBar();
        this.tfilterDjelatnik = new TextField();
        this.tfilterDjelatnik.setPromptText("Filter");
        this.tfilterDjelatnik.setId("textField");
        this.cbFilterDjelatnik = new ComboBox();
        ObservableList filter = FXCollections.observableArrayList((Object[])new String[]{"OIB", "Prezime", "Poslovna jedinica"});
        this.cbFilterDjelatnik.getItems().addAll((Collection)filter);
        this.cbFilterDjelatnik.setValue((Object)"OIB");
        this.cbFilterDjelatnik.setPrefWidth(200.0);
        this.tfilterDjelatnik.setPrefWidth(200.0);
        this.tfilterDjelatnik.setPrefHeight(25.0);
        this.btnResizeDjelatnik = new ToggleButton();
        this.btnResizeDjelatnik.setId("btnResize");
        this.tbFilterDjelatnik.getItems().addAll((Object[])new Node[]{this.tfilterDjelatnik, this.cbFilterDjelatnik, this.btnResizeDjelatnik});
    }

    private void urediFilterDjelatnik(TableView tablicaPregleda) {
        FilteredList filteredData = new FilteredList(this.listaDjelatnika, p -> true);
        this.tfilterDjelatnik.textProperty().addListener((observable, oldValue, newValue) -> filteredData.setPredicate(pregled -> {
            if (newValue == null || newValue.isEmpty()) {
                return true;
            }
            String lowerCaseFilter = newValue.toLowerCase();
            return this.cbFilterDjelatnik.getSelectionModel().getSelectedItem().equals("OIB") ? pregled.getOIB() != null && pregled.getOIB().toLowerCase().startsWith(lowerCaseFilter) : (this.cbFilterDjelatnik.getSelectionModel().getSelectedItem().equals("Prezime") ? pregled.getPrezime() != null && pregled.getPrezime().toLowerCase().startsWith(lowerCaseFilter) : this.cbFilterDjelatnik.getSelectionModel().getSelectedItem().equals("Poslovna jedinica") && pregled.getPoslovnaJedinica() != null && pregled.getPoslovnaJedinica().toLowerCase().startsWith(lowerCaseFilter));
        }));
        SortedList sortedData = new SortedList((ObservableList)filteredData);
        sortedData.comparatorProperty().bind((ObservableValue)tablicaPregleda.comparatorProperty());
        tablicaPregleda.setItems((ObservableList)sortedData);
    }

    private void urediKoloneUTablicuDjeletnici() {
        Callback dateCellFactory1 = param -> new DatumValueCell();
        TableColumn poslovnaJedninica = new TableColumn("POSLOVNA JEDINICA");
        poslovnaJedninica.setCellValueFactory(cellData -> ((DjelatnikPregled)cellData.getValue()).poslovnaJedinicaProperty());
        poslovnaJedninica.prefWidthProperty().bind((ObservableValue)this.tablicaDjelatnik.widthProperty().divide(6.666666666666667));
        poslovnaJedninica.setStyle("-fx-alignment: CENTER;");
        TableColumn oib = new TableColumn("OIB");
        oib.setCellValueFactory(cellData -> ((DjelatnikPregled)cellData.getValue()).OIBProperty());
        oib.prefWidthProperty().bind((ObservableValue)this.tablicaDjelatnik.widthProperty().divide(6.666666666666667));
        oib.setStyle("-fx-alignment: CENTER;");
        TableColumn ime = new TableColumn("IME");
        ime.setCellValueFactory(cellData -> ((DjelatnikPregled)cellData.getValue()).imeProperty());
        ime.prefWidthProperty().bind((ObservableValue)this.tablicaDjelatnik.widthProperty().divide(5.0));
        ime.setStyle("-fx-alignment: CENTER;");
        TableColumn prezime = new TableColumn("PREZIME");
        prezime.setCellValueFactory(cellData -> ((DjelatnikPregled)cellData.getValue()).prezimeProperty());
        prezime.prefWidthProperty().bind((ObservableValue)this.tablicaDjelatnik.widthProperty().divide(5.0));
        prezime.setStyle("-fx-alignment: CENTER;");
        TableColumn kolPregledObavljen = new TableColumn("IZDANA UPUTNICA");
        kolPregledObavljen.setCellValueFactory(cellData -> ((DjelatnikPregled)cellData.getValue()).datumIzdavanjaUputniceProperty());
        kolPregledObavljen.prefWidthProperty().bind((ObservableValue)this.tablicaDjelatnik.widthProperty().divide(6.666666666666667));
        kolPregledObavljen.setStyle("-fx-alignment: CENTER;");
        kolPregledObavljen.setEditable(false);
        kolPregledObavljen.setCellFactory((Callback)new Callback<TableColumn<DjelatnikPregled, LocalDate>, TableCell<DjelatnikPregled, LocalDate>>(){

            public TableCell<DjelatnikPregled, LocalDate> call(TableColumn<DjelatnikPregled, LocalDate> stringStringTableColumn) {
                return new TableCell<DjelatnikPregled, LocalDate>(){

                    protected void updateItem(LocalDate item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        DjelatnikPregled d = (DjelatnikPregled)this.getTableRow().getItem();
                        this.addEventFilter(MouseEvent.MOUSE_CLICKED, (EventHandler)new EventHandler<MouseEvent>(){

                            public void handle(MouseEvent event) {
                                if (event.getClickCount() > 1) {
                                    TableCell c = (TableCell)event.getSource();
                                    if (!GlavniPanelController.getInstance().getTabByIdifExist("Popis RA-1 uputnica")) {
                                        GlavniPanelController.getInstance().zatvoriTab("Popis RA-1 uputnica");
                                        GlavniPanelController.getInstance().nadodajPanel("Popis RA-1 uputnica", "/uputnice/PregledRA1.fxml");
                                    } else {
                                        GlavniPanelController.getInstance().nadodajPanel("Popis RA-1 uputnica", "/uputnice/PregledRA1.fxml");
                                    }
                                }
                            }
                        });
                        if (empty) {
                            this.setText(null);
                            this.setGraphic(null);
                            this.setStyle(null);
                            this.setTooltip(null);
                        } else if (item == null) {
                            this.setText("---");
                            this.setStyle(null);
                            this.setTooltip(null);
                            this.setGraphic(null);
                        } else if (item != null) {
                            this.setCursor(Cursor.HAND);
                            if (d != null) {
                                this.izracunaj(item, d);
                            }
                        } else {
                            this.setText(null);
                            this.setGraphic(null);
                        }
                    }

                    private void izracunaj(LocalDate d, DjelatnikPregled dj) {
                        Tooltip tip = new Tooltip();
                        tip.setStyle("-fx-font-size:12pt;-fx-text-fill:white");
                        LocalDate datePocetni = d;
                        LocalDate dateEnd = dj.getDatumIstekaLJPregleda();
                        if (dateEnd != null) {
                            Period p = Period.between(datePocetni, dateEnd);
                            long p2 = ChronoUnit.DAYS.between(datePocetni, dateEnd);
                            if (p2 < 0L) {
                                this.setStyle("-fx-background-color:-fx-table-cell-border-color, darkgray ;-fx-background-insets: 0, 0 0 1 0; -fx-padding: 0.0em; -fx-alignment: CENTER;");
                                this.setText(d.format(DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM)));
                                tip.setText("Pro\u0161lo je vi\u0161e od " + p.getYears() + " god. " + p.getMonths() + " mj. ,\n i  " + p.getDays() + " dana od izdavanja uputnice za obavljanje pregleda .\n ( ukupno  " + p2 + "  dana )");
                                this.setTooltip(tip);
                                this.setGraphic(null);
                            } else if (p2 <= 15L || p2 == 0L) {
                                this.setStyle("-fx-background-color:-fx-table-cell-border-color, red ;-fx-background-insets: 0, 0 0 1 0; -fx-padding: 0.0em; -fx-alignment: CENTER;");
                                this.setText(d.format(DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM)));
                                tip.setText("Preostalo jo\u0161 " + p.getYears() + " god. " + p.getMonths() + " mj.,\n i " + p.getDays() + "  dana do sljede\u0107eg lje\u010dni\u010dkog pregleda. \n( ukupno  " + p2 + "  dana )");
                                this.setTooltip(tip);
                                this.setGraphic(null);
                            } else if (p2 <= 30L) {
                                this.setStyle("-fx-background-color:-fx-table-cell-border-color, goldenrod ;-fx-background-insets: 0, 0 0 1 0; -fx-padding: 0.0em; -fx-alignment: CENTER;");
                                this.setText(d.format(DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM)));
                                tip.setText("Preostalo jo\u0161 " + p.getYears() + " god. " + p.getMonths() + " mj,\n i " + p.getDays() + "  dana do sljede\u0107eg lje\u010dni\u010dkog pregleda. \n( ukupno  " + p2 + "  dana )");
                                this.setTooltip(tip);
                                this.setGraphic(null);
                            } else if (p2 > 30L) {
                                this.setStyle("-fx-background-color:-fx-table-cell-border-color, yellowgreen ;-fx-background-insets: 0, 0 0 1 0; -fx-padding: 0.0em; -fx-alignment: CENTER;");
                                this.setText(d.format(DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM)));
                                tip.setText("Preostalo jo\u0161 " + p.getYears() + " god. " + p.getMonths() + " mj,\n i " + p.getDays() + "  dana sljede\u0107eg lje\u010dni\u010dkog pregleda. \n( ukupno  " + p2 + "  dana )");
                                this.setTooltip(tip);
                                this.setGraphic(null);
                            } else {
                                this.setTooltip(null);
                                this.setGraphic(null);
                                Tooltip.uninstall((Node)this, (Tooltip)tip);
                            }
                        } else {
                            this.setText("---");
                            this.setStyle(null);
                            this.setTooltip(null);
                            this.setGraphic(null);
                            Tooltip.uninstall((Node)this, (Tooltip)tip);
                        }
                    }
                };
            }
        });
        TableColumn colRa = new TableColumn("LJE\u010cNI\u010cKI PREGLED");
        colRa.setCellValueFactory((Callback)new PropertyValueFactory("datumIstekaLJPregleda"));
        colRa.prefWidthProperty().bind((ObservableValue)this.tablicaDjelatnik.widthProperty().divide(6.666666666666667));
        colRa.setCellFactory(dateCellFactory1);
        colRa.setStyle("-fx-alignment: CENTER;");
        Callback dateCellozo = param -> new DatumValueCell();
        TableColumn ozo = new TableColumn("OZO");
        ozo.prefWidthProperty().bind((ObservableValue)this.tablicaDjelatnik.widthProperty().divide(10.0));
        ozo.setCellValueFactory(cellData -> ((DjelatnikPregled)cellData.getValue()).ozoProperty());
        ozo.setCellFactory(dateCellozo);
        ozo.setStyle("-fx-alignment: CENTER;");
        TableColumn osposobljavanje = new TableColumn("OSPOSOBLJAVANJE");
        osposobljavanje.prefWidthProperty().bind((ObservableValue)this.tablicaDjelatnik.widthProperty().divide(10.0));
        osposobljavanje.setCellValueFactory(cellData -> ((DjelatnikPregled)cellData.getValue()).osposobljavanjeProperty());
        osposobljavanje.setCellFactory(dateCellozo);
        osposobljavanje.setStyle("-fx-alignment: CENTER;");
        TableColumn ostaliPregled = new TableColumn("OSTALI PREGLEDI");
        ostaliPregled.prefWidthProperty().bind((ObservableValue)this.tablicaDjelatnik.widthProperty().divide(10.0));
        ostaliPregled.setCellValueFactory(cellData -> ((DjelatnikPregled)cellData.getValue()).ostaliPregledProperty());
        ostaliPregled.setCellFactory(dateCellozo);
        ostaliPregled.setStyle("-fx-alignment: CENTER;");
        this.kolPretragaDjelatnik.setGraphic((Node)this.tbFilterDjelatnik);
        this.kolPretragaDjelatnik.getColumns().addAll(new Object[]{oib, ime, prezime, kolPregledObavljen, colRa, ozo, osposobljavanje, ostaliPregled, poslovnaJedninica});
    }

    private void postaviTjedniRaspored() {
        VBox vb = new VBox();
        vb.getChildren().clear();
        this.calendarView = new GridPane();
        this.calendarDays = new GridPane();
        this.scrollPane = new ScrollPane((Node)this.calendarView);
        vb.getChildren().addAll((Object[])new Node[]{this.calendarDays, this.scrollPane});
        this.scrollPane.widthProperty().addListener((observable, oldValue, newValue) -> this.calendarView.setPrefWidth(this.scrollPane.getWidth()));
        this.calendarView.getStyleClass().add((Object)"game-grid");
        this.calendarDays.getStyleClass().add((Object)"game-grid");
        this.startOfWeek = this.today.minusDays(this.today.getDayOfWeek().getValue() - 1);
        this.endOfWeek = this.startOfWeek.plusDays(6L);
        this.date = this.startOfWeek;
        while (!this.date.isAfter(this.endOfWeek)) {
            this.slotIndex = 1;
            this.listaDatuma.forEach((k, v) -> {
                this.timeSlot = new TimeSlot(this.date.atTime(this.firstSlotStart), this.slotLength, v.getKey(), (String)k);
                if (v.getValue() != null && this.date.isEqual((ChronoLocalDate)v.getValue())) {
                    this.p = new StackPane();
                    this.p.setPadding(new Insets(1.0, 0.0, 1.0, 0.0));
                    this.p.setPrefSize(250.0, 55.0);
                    DayOfWeek day = this.date.getDayOfWeek();
                    if (day == DayOfWeek.SATURDAY || day == DayOfWeek.SUNDAY) {
                        this.p.setStyle("-fx-background-color: lightgray ;-fx-border-color: gray;-fx-border-width: 0.5; ");
                    } else {
                        this.p.setStyle("-fx-background-color: whitesmoke ;-fx-border-color: gray;-fx-border-width: 0.5; ");
                    }
                    if (this.timeSlot.getView() != null) {
                        this.p.getChildren().add((Object)this.timeSlot.getView());
                    }
                    StackPane.setAlignment((Node)this.p, (Pos)Pos.CENTER_LEFT);
                    this.calendarView.add((Node)this.p, this.timeSlot.getDayOfWeek().getValue(), this.slotIndex);
                    ++this.slotIndex;
                }
            });
            while (this.slotIndex < this.listaDatuma.size()) {
                this.p = new StackPane();
                this.p.setPrefSize(250.0, 55.0);
                DayOfWeek day = this.date.getDayOfWeek();
                if (day == DayOfWeek.SATURDAY || day == DayOfWeek.SUNDAY) {
                    this.p.setStyle("-fx-background-color: lightgray    ;-fx-border-color: gray;-fx-border-width: 0.5; ");
                } else {
                    this.p.setStyle("-fx-background-color: whitesmoke ;-fx-border-color: gray;-fx-border-width: 0.5; ");
                }
                StackPane.setAlignment((Node)this.p, (Pos)Pos.CENTER_LEFT);
                this.calendarView.add((Node)this.p, this.timeSlot.getDayOfWeek().getValue(), this.slotIndex);
                ++this.slotIndex;
            }
            this.date = this.date.plusDays(1L);
        }
        LocalDate date = this.startOfWeek;
        while (!date.isAfter(this.endOfWeek)) {
            Label label = new Label(date.format(this.dayFormatter));
            label.setPadding(new Insets(1.0));
            label.setStyle("-fx-font-weight: bold;-fx-font-size: 1.5em;  -fx-font-family:Arial");
            label.setTextAlignment(TextAlignment.CENTER);
            GridPane.setHalignment((Node)label, (HPos)HPos.CENTER);
            StackPane p = new StackPane();
            p.setPrefWidth(250.0);
            p.setMinHeight(60.0);
            StackPane.setAlignment((Node)p, (Pos)Pos.CENTER);
            DayOfWeek day = date.getDayOfWeek();
            if (day == DayOfWeek.SATURDAY || day == DayOfWeek.SUNDAY) {
                label.setTextFill((Paint)Color.RED);
                p.setStyle("-fx-background-color: lightgray ;-fx-border-color: gray;-fx-border-width: 0.5; ");
            } else {
                p.setStyle("-fx-background-color: white ;-fx-border-color: gray;-fx-border-width: 0.5; ");
            }
            if (date.equals(this.today)) {
                p.setStyle("-fx-background-color: lightsteelblue;-fx-border-color: red;-fx-border-width: 2; ");
            }
            p.getChildren().add((Object)label);
            this.lblGodina.setText(String.valueOf(date.getYear()));
            this.calendarDays.add((Node)p, date.getDayOfWeek().getValue(), 0);
            date = date.plusDays(1L);
        }
        StackPane.setAlignment((Node)this.calendarDays, (Pos)Pos.CENTER);
        this.borderPane.setCenter((Node)vb);
    }

    private void nadodajTjedan() {
        VBox vb = new VBox();
        vb.getChildren().clear();
        this.calendarView = new GridPane();
        this.calendarDays = new GridPane();
        this.scrollPane = new ScrollPane((Node)this.calendarView);
        vb.getChildren().addAll((Object[])new Node[]{this.calendarDays, this.scrollPane});
        this.calendarView.getStyleClass().add((Object)"game-grid");
        this.calendarDays.getStyleClass().add((Object)"game-grid");
        this.scrollPane.widthProperty().addListener((observable, oldValue, newValue) -> this.calendarView.setPrefWidth(this.scrollPane.getWidth()));
        this.startOfWeek = this.endOfWeek;
        this.endOfWeek = this.startOfWeek.plusDays(7L);
        this.date = this.startOfWeek.plusDays(1L);
        while (!this.date.isAfter(this.endOfWeek)) {
            this.slotIndex = 1;
            this.listaDatuma.forEach((k, v) -> {
                this.timeSlot = new TimeSlot(this.date.atTime(this.firstSlotStart), this.slotLength, v.getKey(), (String)k);
                if (v.getValue() != null && this.date.isEqual((ChronoLocalDate)v.getValue())) {
                    this.p = new StackPane();
                    this.p.setPrefSize(250.0, 55.0);
                    DayOfWeek day = this.date.getDayOfWeek();
                    if (day == DayOfWeek.SATURDAY || day == DayOfWeek.SUNDAY) {
                        this.p.setStyle("-fx-background-color: lightgray    ;-fx-border-color: gray;-fx-border-width: 0.5; ");
                    } else {
                        this.p.setStyle("-fx-background-color: whitesmoke ;-fx-border-color: gray;-fx-border-width: 0.5; ");
                    }
                    if (this.timeSlot.getView() != null) {
                        this.p.getChildren().add((Object)this.timeSlot.getView());
                    }
                    StackPane.setAlignment((Node)this.p, (Pos)Pos.CENTER_LEFT);
                    this.calendarView.add((Node)this.p, this.timeSlot.getDayOfWeek().getValue(), this.slotIndex);
                    ++this.slotIndex;
                }
            });
            while (this.slotIndex < this.listaDatuma.size()) {
                StackPane p = new StackPane();
                p.setPrefSize(250.0, 55.0);
                DayOfWeek day = this.date.getDayOfWeek();
                if (day == DayOfWeek.SATURDAY || day == DayOfWeek.SUNDAY) {
                    p.setStyle("-fx-background-color: lightgray    ;-fx-border-color: gray;-fx-border-width: 0.5; ");
                } else {
                    p.setStyle("-fx-background-color: whitesmoke ;-fx-border-color: gray;-fx-border-width: 0.5; ");
                }
                StackPane.setAlignment((Node)p, (Pos)Pos.CENTER_LEFT);
                this.calendarView.add((Node)p, this.timeSlot.getDayOfWeek().getValue(), this.slotIndex);
                ++this.slotIndex;
            }
            this.date = this.date.plusDays(1L);
        }
        LocalDate date = this.startOfWeek.plusDays(1L);
        while (!date.isAfter(this.endOfWeek)) {
            Label label = new Label(date.format(this.dayFormatter));
            label.setPadding(new Insets(1.0));
            label.setStyle("-fx-font-weight: bold;-fx-font-size: 1.5em;  -fx-font-family:Arial");
            label.setTextAlignment(TextAlignment.CENTER);
            GridPane.setHalignment((Node)label, (HPos)HPos.CENTER);
            StackPane p = new StackPane();
            p.setPrefWidth(250.0);
            p.setMinHeight(60.0);
            StackPane.setAlignment((Node)p, (Pos)Pos.CENTER_LEFT);
            DayOfWeek day = date.getDayOfWeek();
            if (day == DayOfWeek.SATURDAY || day == DayOfWeek.SUNDAY) {
                label.setTextFill((Paint)Color.RED);
                p.setStyle("-fx-background-color: lightgray ;-fx-border-color: gray;-fx-border-width: 0.5; ");
            } else {
                p.setStyle("-fx-background-color: white ;-fx-border-color: gray;-fx-border-width: 0.5; ");
            }
            if (date.equals(this.today)) {
                p.setStyle("-fx-background-color: lightsteelblue  ;-fx-border-color: red;-fx-border-width: 2; ");
            }
            p.getChildren().add((Object)label);
            this.lblGodina.setText(String.valueOf(date.getYear()));
            this.calendarDays.add((Node)p, date.getDayOfWeek().getValue(), 0);
            date = date.plusDays(1L);
        }
        StackPane.setAlignment((Node)this.calendarDays, (Pos)Pos.CENTER);
        this.borderPane.setCenter((Node)vb);
    }

    private void oduzmiTjedan() {
        VBox vb = new VBox();
        vb.getChildren().clear();
        this.calendarView = new GridPane();
        this.calendarDays = new GridPane();
        this.scrollPane = new ScrollPane((Node)this.calendarView);
        vb.getChildren().addAll((Object[])new Node[]{this.calendarDays, this.scrollPane});
        this.calendarView.getStyleClass().add((Object)"game-grid");
        this.calendarDays.getStyleClass().add((Object)"game-grid");
        this.scrollPane.widthProperty().addListener((observable, oldValue, newValue) -> this.calendarView.setPrefWidth(this.scrollPane.getWidth()));
        this.startOfWeek = this.endOfWeek;
        this.endOfWeek = this.startOfWeek.minusDays(7L);
        this.date = this.startOfWeek;
        while (!this.date.isBefore(this.endOfWeek.plusDays(1L))) {
            this.slotIndex = 1;
            this.listaDatuma.forEach((k, v) -> {
                this.timeSlot = new TimeSlot(this.date.atTime(this.firstSlotStart), this.slotLength, v.getKey(), (String)k);
                if (v.getValue() != null && this.date.isEqual((ChronoLocalDate)v.getValue())) {
                    this.p = new StackPane();
                    this.p.setPrefSize(250.0, 55.0);
                    DayOfWeek day = this.date.getDayOfWeek();
                    if (day == DayOfWeek.SATURDAY || day == DayOfWeek.SUNDAY) {
                        this.p.setStyle("-fx-background-color: lightgray    ;-fx-border-color: gray;-fx-border-width: 0.5; ");
                    } else {
                        this.p.setStyle("-fx-background-color: whitesmoke ;-fx-border-color: gray;-fx-border-width: 0.5; ");
                    }
                    if (this.timeSlot.getView() != null) {
                        this.p.getChildren().add((Object)this.timeSlot.getView());
                    }
                    StackPane.setAlignment((Node)this.p, (Pos)Pos.CENTER_LEFT);
                    this.calendarView.add((Node)this.p, this.timeSlot.getDayOfWeek().getValue(), this.slotIndex);
                    ++this.slotIndex;
                }
            });
            while (this.slotIndex < this.listaDatuma.size()) {
                StackPane p = new StackPane();
                p.setPrefSize(250.0, 55.0);
                DayOfWeek day = this.date.getDayOfWeek();
                if (day == DayOfWeek.SATURDAY || day == DayOfWeek.SUNDAY) {
                    p.setStyle("-fx-background-color: lightgray    ;-fx-border-color: gray;-fx-border-width: 0.5; ");
                } else {
                    p.setStyle("-fx-background-color: whitesmoke ;-fx-border-color: gray;-fx-border-width: 0.5; ");
                }
                StackPane.setAlignment((Node)p, (Pos)Pos.CENTER_LEFT);
                this.calendarView.add((Node)p, this.timeSlot.getDayOfWeek().getValue(), this.slotIndex);
                ++this.slotIndex;
            }
            this.date = this.date.minusDays(1L);
        }
        LocalDate date = this.startOfWeek;
        while (!date.isBefore(this.endOfWeek.plusDays(1L))) {
            Label label = new Label(date.format(this.dayFormatter));
            label.setPadding(new Insets(1.0));
            label.setTextAlignment(TextAlignment.CENTER);
            GridPane.setHalignment((Node)label, (HPos)HPos.CENTER);
            label.setStyle("-fx-font-weight: bold;-fx-font-size: 1.5em;  -fx-font-family:Arial");
            StackPane p = new StackPane();
            p.setPrefWidth(250.0);
            p.setMinHeight(60.0);
            StackPane.setAlignment((Node)p, (Pos)Pos.CENTER_LEFT);
            DayOfWeek day = date.getDayOfWeek();
            if (day == DayOfWeek.SATURDAY || day == DayOfWeek.SUNDAY) {
                label.setTextFill((Paint)Color.RED);
                p.setStyle("-fx-background-color: lightgray ;-fx-border-color: gray;-fx-border-width: 0.5; ");
            } else {
                p.setStyle("-fx-background-color: white ;-fx-border-color: gray;-fx-border-width: 0.5; ");
            }
            if (date.equals(this.today)) {
                p.setStyle("-fx-background-color: lightsteelblue  ;-fx-border-color: red;-fx-border-width: 2; ");
            }
            p.getChildren().add((Object)label);
            this.calendarDays.add((Node)p, date.getDayOfWeek().getValue(), 0);
            this.lblGodina.setText(String.valueOf(date.getYear()));
            date = date.minusDays(1L);
        }
        StackPane.setAlignment((Node)this.calendarDays, (Pos)Pos.CENTER);
        this.borderPane.setCenter((Node)vb);
    }

    private void popuniDatume() {
        int j = 0;
        for (DjelatnikPregled dp : this.listaDjelatnika) {
            this.listaDatuma.put("LIJE\u010cNI\u010cKI " + j++, (Pair<Object, LocalDate>)new Pair((Object)dp, (Object)dp.getDatumIstekaLJPregleda()));
            if (dp.getListaOZO().isEmpty()) continue;
            for (DjelatnikOZS dz : dp.getListaOZO()) {
                this.listaDatuma.put("OZO " + j++, (Pair<Object, LocalDate>)new Pair((Object)dp, (Object)dz.getDatumIsteka()));
            }
            for (Object d : dp.getListaOsposobljavanje()) {
                this.listaDatuma.put("OSPOSOBLJAVANJA " + j++, (Pair<Object, LocalDate>)new Pair((Object)dp, (Object)((DjelatnikOsposobljavanja)d).getDatumIsteka()));
            }
            for (Object d : dp.getListaOstaliPregledi()) {
                this.listaDatuma.put("PREGLED " + j++, (Pair<Object, LocalDate>)new Pair((Object)dp, (Object)((DjelatnikOstaliPregledi)d).getDatumIsteka()));
            }
        }
        for (FROPregled fro : this.listaFRO) {
            this.listaDatuma.put("FRO " + j++, (Pair<Object, LocalDate>)new Pair((Object)fro, (Object)fro.getdatumIstekaPregleda()));
        }
        for (ObjektNadzor on : this.listaObjekti) {
            if (on.getListaPregleda().isEmpty()) continue;
            for (ObjekatEvidencijaPregleda o : on.getListaPregleda()) {
                this.listaDatuma.put("OBJEKAT " + j++, (Pair<Object, LocalDate>)new Pair((Object)on, (Object)o.getDatumPonovogIspitivanja()));
            }
        }
        for (NadzorStrojPregled nsp : this.listaStrojeva) {
            this.listaDatuma.put("STROJ " + j++, (Pair<Object, LocalDate>)new Pair((Object)nsp, (Object)nsp.getdatumIstekaPregleda()));
        }
        if (this.datumSjedniceOdbora != null) {
            this.listaDatuma.put("SJEDNICA " + j++, (Pair<Object, LocalDate>)new Pair((Object)this.datumSjedniceOdbora, (Object)this.datumSjedniceOdbora));
        }
        for (NadzorMjerniInstrumentPregled mi : this.listaMjerniInstrumenti) {
            this.listaDatuma.put("MJERNI-URE\u0110AJ " + j++, (Pair<Object, LocalDate>)new Pair((Object)mi, (Object)mi.getdatumIstekaPregleda()));
        }
    }

    private void urediFilterStoj(TableView<NadzorStrojPregled> tablicaStrojevi) {
        FilteredList filteredData = new FilteredList(this.listaStrojeva, p -> true);
        this.tfilterStroj.textProperty().addListener((observable, oldValue, newValue) -> filteredData.setPredicate(pregled -> {
            if (newValue == null || newValue.isEmpty()) {
                return true;
            }
            String lowerCaseFilter = newValue.toLowerCase();
            return this.cbFilterStroj.getSelectionModel().getSelectedItem().equals("Naziv") ? pregled.getNazivstroja() != null && pregled.getNazivstroja().toLowerCase().startsWith(lowerCaseFilter) : (this.cbFilterStroj.getSelectionModel().getSelectedItem().equals("Inventurni broj") ? pregled.getInventurnibroj() != null && pregled.getInventurnibroj().toLowerCase().startsWith(lowerCaseFilter) : (this.cbFilterStroj.getSelectionModel().getSelectedItem().equals("Poslovna jedinica") ? pregled.getPoslovnajedinica() != null && pregled.getPoslovnajedinica().toLowerCase().startsWith(lowerCaseFilter) : this.cbFilterStroj.getSelectionModel().getSelectedItem().equals("Tv. Broj") && pregled.getTvornickibroj() != null && pregled.getTvornickibroj().toLowerCase().startsWith(lowerCaseFilter)));
        }));
        SortedList sortedData = new SortedList((ObservableList)filteredData);
        sortedData.comparatorProperty().bind((ObservableValue)tablicaStrojevi.comparatorProperty());
        tablicaStrojevi.setItems((ObservableList)sortedData);
    }

    private void kreirajToolBarFIlterFRO() {
        this.tbFilterFRO = new ToolBar();
        this.tfilterFRO = new TextField();
        this.tfilterFRO.setPromptText("Filter");
        this.tfilterFRO.setId("textField");
        this.cbFilterFRO = new ComboBox();
        ObservableList filter = FXCollections.observableArrayList((Object[])new String[]{"Poslovna jedinica", "Mjerno mjesto"});
        this.cbFilterFRO.getItems().addAll((Collection)filter);
        this.cbFilterFRO.setValue((Object)"Mjerno mjesto");
        this.cbFilterFRO.setPrefWidth(200.0);
        this.tfilterFRO.setPrefWidth(200.0);
        this.tfilterFRO.setPrefHeight(25.0);
        this.btnResizeFro = new ToggleButton();
        this.btnResizeFro.setId("btnResize");
        this.tbFilterFRO.getItems().addAll((Object[])new Node[]{this.tfilterFRO, this.cbFilterFRO, this.btnResizeFro});
    }

    private void urediKoloneUTabliciFRO() {
        TableColumn pj = new TableColumn("POSLOVNA JEDINICA");
        pj.setCellValueFactory(cellData -> ((FROPregled)cellData.getValue()).poslovnaJedinicaProperty());
        pj.prefWidthProperty().bind((ObservableValue)this.tablicaFRO.widthProperty().divide(3.3333333333333335));
        pj.setStyle("-fx-alignment: CENTER;");
        TableColumn mjernoMjesto = new TableColumn("MJERNO MJESTO");
        mjernoMjesto.setCellValueFactory(cellData -> ((FROPregled)cellData.getValue()).nazivMjernogMjestaProperty());
        mjernoMjesto.prefWidthProperty().bind((ObservableValue)this.tablicaFRO.widthProperty().divide(2.5));
        mjernoMjesto.setStyle("-fx-alignment: CENTER;");
        Callback dateCellFactory1 = param -> new DatumValueCell();
        TableColumn datumIspitivanja = new TableColumn("DATUM ISPITIVANJA M.M");
        datumIspitivanja.setCellValueFactory((Callback)new PropertyValueFactory("datumIstekaPregleda"));
        datumIspitivanja.prefWidthProperty().bind((ObservableValue)this.tablicaFRO.widthProperty().divide(3.3333333333333335));
        datumIspitivanja.setCellFactory(dateCellFactory1);
        datumIspitivanja.setStyle("-fx-alignment: CENTER;");
        this.kolPretragaFRO.setGraphic((Node)this.tbFilterFRO);
        this.kolPretragaFRO.getColumns().addAll(new Object[]{pj, mjernoMjesto, datumIspitivanja});
    }

    private void urediFiterFRO(TableView<FROPregled> tablicaFRO) {
        FilteredList filteredData = new FilteredList(this.listaFRO, p -> true);
        this.tfilterFRO.textProperty().addListener((observable, oldValue, newValue) -> filteredData.setPredicate(pregled -> {
            if (newValue == null || newValue.isEmpty()) {
                return true;
            }
            String lowerCaseFilter = newValue.toLowerCase();
            return this.cbFilterFRO.getSelectionModel().getSelectedItem().equals("Poslovna jedinica") ? pregled.getPoslovnaJedinica() != null && pregled.getPoslovnaJedinica().toLowerCase().startsWith(lowerCaseFilter) : this.cbFilterFRO.getSelectionModel().getSelectedItem().equals("Mjerno mjesto") && pregled.getNazivMjernogMjesta() != null && pregled.getNazivMjernogMjesta().toLowerCase().startsWith(lowerCaseFilter);
        }));
        SortedList sortedData = new SortedList((ObservableList)filteredData);
        sortedData.comparatorProperty().bind((ObservableValue)tablicaFRO.comparatorProperty());
        tablicaFRO.setItems((ObservableList)sortedData);
    }

    private void kreirajToolBarFIlterObjekt() {
        this.tbFilterObjekt = new ToolBar();
        this.tfilterObjekt = new TextField();
        this.tfilterObjekt.setPromptText("Filter");
        this.tfilterObjekt.setId("textField");
        this.cbFilterObjekt = new ComboBox();
        ObservableList filter = FXCollections.observableArrayList((Object[])new String[]{"Poslovna jedinica", "Naziv objekta"});
        this.cbFilterObjekt.getItems().addAll((Collection)filter);
        this.cbFilterObjekt.setValue((Object)"Naziv objekta");
        this.cbFilterObjekt.setPrefWidth(200.0);
        this.tfilterObjekt.setPrefWidth(200.0);
        this.tfilterObjekt.setPrefHeight(25.0);
        this.btnResizeObjekti = new ToggleButton();
        this.btnResizeObjekti.setId("btnResize");
        this.tbFilterObjekt.getItems().addAll((Object[])new Node[]{this.tfilterObjekt, this.cbFilterObjekt, this.btnResizeObjekti});
    }

    private void urediKoloneUTabliciObjekt() {
        TableColumn pjo = new TableColumn("POSLOVNA JEDINICA");
        pjo.setCellValueFactory(cellData -> ((ObjektNadzor)cellData.getValue()).poslovnaJedinicaProperty());
        pjo.prefWidthProperty().bind((ObservableValue)this.tablicaObjekti.widthProperty().divide(3.3333333333333335));
        pjo.setStyle("-fx-alignment: CENTER;");
        TableColumn objekt = new TableColumn("MJERNO MJESTO");
        objekt.setCellValueFactory(cellData -> ((ObjektNadzor)cellData.getValue()).nazivObjektaProperty());
        objekt.prefWidthProperty().bind((ObservableValue)this.tablicaObjekti.widthProperty().divide(2.5));
        objekt.setStyle("-fx-alignment: CENTER;");
        Callback dateCellFactory1 = param -> new DatumValueCell();
        TableColumn datumPonovogIspitivanja = new TableColumn("DATUM ISPITIVANJA OBJEKTA");
        datumPonovogIspitivanja.setCellValueFactory((Callback)new PropertyValueFactory("datumPonovogIspitivanja"));
        datumPonovogIspitivanja.prefWidthProperty().bind((ObservableValue)this.tablicaObjekti.widthProperty().divide(3.3333333333333335));
        datumPonovogIspitivanja.setCellFactory(dateCellFactory1);
        datumPonovogIspitivanja.setStyle("-fx-alignment: CENTER;");
        this.kolPretragaObjekti.setGraphic((Node)this.tbFilterObjekt);
        this.kolPretragaObjekti.getColumns().addAll(new Object[]{pjo, objekt, datumPonovogIspitivanja});
    }

    private void urediFiterObjekti(TableView<ObjektNadzor> tablicaObjekti) {
        FilteredList filteredData = new FilteredList(this.listaObjekti, p -> true);
        this.tfilterObjekt.textProperty().addListener((observable, oldValue, newValue) -> filteredData.setPredicate(pregled -> {
            if (newValue == null || newValue.isEmpty()) {
                return true;
            }
            String lowerCaseFilter = newValue.toLowerCase();
            return this.cbFilterObjekt.getSelectionModel().getSelectedItem().equals("Poslovna jedinica") ? pregled.getPoslovnaJedinica() != null && pregled.getPoslovnaJedinica().toLowerCase().startsWith(lowerCaseFilter) : this.cbFilterObjekt.getSelectionModel().getSelectedItem().equals("Naziv objekta") && pregled.getNazivObjekta() != null && pregled.getNazivObjekta().toLowerCase().startsWith(lowerCaseFilter);
        }));
        SortedList sortedData = new SortedList((ObservableList)filteredData);
        sortedData.comparatorProperty().bind((ObservableValue)tablicaObjekti.comparatorProperty());
        tablicaObjekti.setItems((ObservableList)sortedData);
    }

    private void kreirajResizeDjelatnik() {
        SplitPaneDividerSlider rightSplitPaneDividerSlider = new SplitPaneDividerSlider(this.splitPaneD, 0, SplitPaneDividerSlider.Direction.RIGHT, Duration.millis((double)1000.0));
        SplitPaneDividerSlider rightSplitPaneDividerSlider2 = new SplitPaneDividerSlider(this.spliPaneLijevi, 0, SplitPaneDividerSlider.Direction.DOWN, Duration.millis((double)1000.0));
        this.btnResizeDjelatnik.selectedProperty().addListener((ov, t, t1) -> {
            rightSplitPaneDividerSlider.setAimContentVisible((boolean)t);
            rightSplitPaneDividerSlider2.setAimContentVisible((boolean)t);
            if (t.booleanValue()) {
                this.btnResizeDjelatnik.setId("btnResize");
            } else {
                this.btnResizeDjelatnik.setId("btnResize-");
            }
        });
    }

    private void kreirajResizeObjekti() {
        SplitPaneDividerSlider objekt1 = new SplitPaneDividerSlider(this.splitPaneD, 0, SplitPaneDividerSlider.Direction.RIGHT, Duration.millis((double)1000.0));
        SplitPaneDividerSlider objekt2 = new SplitPaneDividerSlider(this.spliPaneLijevi, 0, SplitPaneDividerSlider.Direction.UP, Duration.millis((double)1000.0));
        this.btnResizeObjekti.selectedProperty().addListener((ov, t, t1) -> {
            objekt1.setAimContentVisible((boolean)t);
            objekt2.setAimContentVisible((boolean)t);
            if (t.booleanValue()) {
                this.btnResizeObjekti.setId("btnResize");
            } else {
                this.btnResizeObjekti.setId("btnResize-");
            }
        });
    }

    private void kreirajResizeStrojevi() {
        SplitPaneDividerSlider stroj1 = new SplitPaneDividerSlider(this.splitPaneD, 0, SplitPaneDividerSlider.Direction.LEFT, Duration.millis((double)1000.0));
        SplitPaneDividerSlider stroj2 = new SplitPaneDividerSlider(this.splitPaneDesni, 0, SplitPaneDividerSlider.Direction.DOWN, Duration.millis((double)1000.0));
        this.btnResizeStrojevi.selectedProperty().addListener((ov, t, t1) -> {
            stroj1.setAimContentVisible((boolean)t);
            stroj2.setAimContentVisible((boolean)t);
            if (t.booleanValue()) {
                this.btnResizeStrojevi.setId("btnResize");
            } else {
                this.btnResizeStrojevi.setId("btnResize-");
            }
        });
    }

    private void kreirajResizeFRO() {
        SplitPaneDividerSlider fro1 = new SplitPaneDividerSlider(this.splitPaneD, 0, SplitPaneDividerSlider.Direction.LEFT, Duration.millis((double)1000.0));
        SplitPaneDividerSlider fro2 = new SplitPaneDividerSlider(this.splitPaneDesni, 0, SplitPaneDividerSlider.Direction.UP, Duration.millis((double)1000.0));
        this.btnResizeFro.selectedProperty().addListener((ov, t, t1) -> {
            fro1.setAimContentVisible((boolean)t);
            fro2.setAimContentVisible((boolean)t);
            if (t.booleanValue()) {
                this.btnResizeFro.setId("btnResize");
            } else {
                this.btnResizeFro.setId("btnResize-");
            }
        });
    }

    void nadodajPoruku(Poruka p) {
        Poruka.setFadeNode((Node)p);
        this.root.getChildren().add((Object)p);
    }

    private void setColorStringFromColor(StringProperty colorStringProperty, ObjectProperty<Color> color) {
        colorStringProperty.set((Object)("rgba(" + (int)(((Color)color.get()).getRed() * 255.0) + "," + (int)(((Color)color.get()).getGreen() * 255.0) + "," + (int)(((Color)color.get()).getBlue() * 255.0) + "," + ((Color)color.get()).getOpacity() + ")"));
    }

    private StringProperty createWarningColorStringProperty(ObjectProperty<Color> warningColor) {
        SimpleStringProperty colorStringProperty = new SimpleStringProperty();
        this.setColorStringFromColor((StringProperty)colorStringProperty, warningColor);
        warningColor.addListener((ChangeListener)new ChangeListener<Color>((StringProperty)colorStringProperty, warningColor){
            final /* synthetic */ StringProperty val$colorStringProperty;
            final /* synthetic */ ObjectProperty val$warningColor;
            {
                this.val$colorStringProperty = stringProperty;
                this.val$warningColor = objectProperty;
            }

            public void changed(ObservableValue<? extends Color> observableValue, Color oldColor, Color newColor) {
                MonitoringController.this.setColorStringFromColor(this.val$colorStringProperty, (ObjectProperty<Color>)this.val$warningColor);
            }
        });
        return colorStringProperty;
    }

    private void createWarningButton(ToggleButton warningButton) {
        SimpleObjectProperty warningColor = new SimpleObjectProperty((Object)Color.web((String)"#ececec"));
        StringProperty colorStringProperty = this.createWarningColorStringProperty((ObjectProperty<Color>)warningColor);
        warningButton.styleProperty().bind((ObservableValue)new SimpleStringProperty("-fx-base: ").concat((Object)colorStringProperty).concat((Object)";"));
        Timeline flash = new Timeline(new KeyFrame[]{new KeyFrame(Duration.seconds((double)0.0), new KeyValue[]{new KeyValue((WritableValue)warningColor, (Object)Color.web((String)"#ececec"), Interpolator.LINEAR)}), new KeyFrame(Duration.seconds((double)0.25), new KeyValue[]{new KeyValue((WritableValue)warningColor, (Object)Color.web((String)"#ececec"), Interpolator.LINEAR)}), new KeyFrame(Duration.seconds((double)1.0), new KeyValue[]{new KeyValue((WritableValue)warningColor, (Object)Color.RED, Interpolator.LINEAR)}), new KeyFrame(Duration.seconds((double)1.25), new KeyValue[]{new KeyValue((WritableValue)warningColor, (Object)Color.RED, Interpolator.LINEAR)})});
        flash.setCycleCount(10);
        flash.setAutoReverse(true);
        flash.setOnFinished(e -> this.btnPoruka.setId("btnPorukaIma"));
        flash.play();
    }

    private void kreirajPanelPoruke() {
        Tooltip to = new Tooltip();
        this.root.setPadding(new Insets(1.0));
        this.btnPoruka.setTooltip(to);
        this.btnPoruka.setId("btnPoruka");
        if (this.root.getChildren().size() < 1) {
            this.btnPoruka.setText("");
            to.setText(" Nema poruka ");
            this.btnPoruka.setId("btnPoruka");
        } else {
            this.btnPoruka.setText(String.valueOf(this.root.getChildren().size()));
            to.setText("Imate  " + this.root.getChildren().size() + "   poruka ");
        }
        ObservableList listaPoruka1 = this.root.getChildren();
        listaPoruka1.addListener(change -> {
            while (change.next()) {
                if (change.wasUpdated() || change.wasPermutated()) continue;
                for (Node remitem : change.getRemoved()) {
                    if (this.root.getChildren().size() < 1) {
                        this.btnPoruka.setText("");
                        to.setText("Nema poruka");
                        this.btnPoruka.setId("btnPoruka");
                        continue;
                    }
                    this.btnPoruka.setText(String.valueOf(this.root.getChildren().size()));
                    to.setText("Imate  " + this.root.getChildren().size() + "   poruka ");
                    this.btnPoruka.setId("btnPorukaIma");
                }
                for (Node additem : change.getAddedSubList()) {
                    if (this.root.getChildren().size() < 1) {
                        this.btnPoruka.setText("");
                        to.setText("Nema poruka");
                        this.btnPoruka.setId("btnPoruka");
                        continue;
                    }
                    this.btnPoruka.setText(String.valueOf(this.root.getChildren().size()));
                    to.setText("Imate  " + this.root.getChildren().size() + "   poruka ");
                    this.createWarningButton(this.btnPoruka);
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.BOTTOM_RIGHT, "Nova  poruka ", 2, "Information graphic");
                }
            }
        });
        this.scrollPoruka.widthProperty().addListener((observable, oldValue, newValue) -> this.root.setPrefWidth(this.scrollPoruka.getWidth() - 10.0));
        this.scrollPoruka.setContent((Node)this.root);
        TranslateTransition openNav = new TranslateTransition(new Duration(350.0), (Node)this.scrollPoruka);
        openNav.setToX(0.0);
        TranslateTransition closeNav = new TranslateTransition(new Duration(350.0), (Node)this.scrollPoruka);
        this.btnPoruka.setOnAction(evt -> {
            if (this.scrollPoruka.getTranslateX() != 0.0) {
                openNav.play();
            } else {
                closeNav.setToX(this.scrollPoruka.getWidth());
                closeNav.play();
            }
        });
    }

    private void popuniRestart() {
        if (!this.dservice.isRunning() | !this.oservice.isRunning() | !this.fservice.isRunning() | !this.sservice.isRunning() | !this.miservice.isRunning() | !this.soservice.isRunning()) {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    MonitoringController.this.listaDatuma.clear();
                    MonitoringController.this.popuniDatume();
                    MonitoringController.this.postaviTjedniRaspored();
                }
            });
        }
    }

    private void popuniSjednicaOdboraNadzor() {
        this.soservice.start();
    }

    public void kreirajNotifikacijuOdbor(Pos pos, String text, int duration) {
        Notifications notificationBuilder = null;
        final CheckBox cb = new CheckBox("Ne prikazuj ovu poruku");
        cb.setStyle("-fx-text-fill: white; -fx-font-size: 0.8em;");
        cb.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> ov, Boolean old_val, Boolean new_val) {
                if (cb.isSelected()) {
                    if (!BazaMonitoring.potvrdiProvjeru(cb.isSelected(), GlavniPanelController.getOdabranaTvrtka())) {
                        KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161an unos", 2, "Error graphic");
                    }
                    cb.setDisable(true);
                }
            }
        });
        Label poruka = new Label(text);
        poruka.setAlignment(Pos.CENTER);
        poruka.setWrapText(true);
        poruka.setTextAlignment(TextAlignment.RIGHT);
        Label TitleLable = new Label("Poruka");
        TitleLable.setAlignment(Pos.TOP_LEFT);
        TitleLable.setStyle("-fx-font-weight: bold;-fx-font-size: 1.2em;");
        BorderPane bp = new BorderPane();
        bp.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        bp.setLeft((Node)new VBox(new Node[]{TitleLable}));
        cb.setAlignment(Pos.BOTTOM_LEFT);
        VBox vb = new VBox(new Node[]{poruka, cb});
        vb.setSpacing(10.0);
        bp.setBottom((Node)vb);
        notificationBuilder = Notifications.create().graphic((Node)bp).position(pos).darkStyle();
        notificationBuilder.show();
    }

    class DatumValueCell<S>
    extends TableCell<S, LocalDate> {
        PopOver item = new PopOver();

        public DatumValueCell() {
            this.addEventFilter(MouseEvent.MOUSE_CLICKED, (EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent event) {
                    if (event.getClickCount() > 1) {
                        TableCell c = (TableCell)event.getSource();
                        DjelatnikPregled d = (DjelatnikPregled)MonitoringController.this.tablicaDjelatnik.getSelectionModel().getSelectedItem();
                        StrojEvidencija se = (StrojEvidencija)MonitoringController.this.tablicaStrojevi.getSelectionModel().getSelectedItem();
                        MjernoMjestoFRO mm = (MjernoMjestoFRO)MonitoringController.this.tablicaFRO.getSelectionModel().getSelectedItem();
                        ObjektNadzor on = (ObjektNadzor)MonitoringController.this.tablicaObjekti.getSelectionModel().getSelectedItem();
                        if (c.getTableColumn().getText().equalsIgnoreCase("lje\u010dni\u010dki pregled")) {
                            if (!GlavniPanelController.getInstance().getTabByIdifExist("Unos Djelatnika")) {
                                GlavniPanelController.getInstance().zatvoriTab("Unos Djelatnika");
                                GlavniPanelController.getInstance().nadodajPanel("Unos Djelatnika", "/kadrovska/UnosDjelatnika.fxml");
                                UnosDjelatnikaController.getInstance().izmjenaDjelatnika(d);
                                UnosDjelatnikaController.getInstance().getTabPanePodaci().getSelectionModel().select(2);
                            } else {
                                GlavniPanelController.getInstance().nadodajPanel("Unos Djelatnika", "/kadrovska/UnosDjelatnika.fxml");
                                UnosDjelatnikaController.getInstance().izmjenaDjelatnika(d);
                                UnosDjelatnikaController.getInstance().getTabPanePodaci().getSelectionModel().select(2);
                            }
                        } else if (c.getTableColumn().getText().equalsIgnoreCase("ozo")) {
                            FXMLLoader loader = new FXMLLoader(this.getClass().getResource("DatumPopup.fxml"));
                            Parent root = null;
                            try {
                                root = (Parent)loader.load();
                            }
                            catch (IOException ex) {
                                Logger.getLogger(MonitoringController.class.getName()).log(Level.SEVERE, null, ex);
                            }
                            DatumValueCell.this.item.setContentNode((Node)root);
                            DatumPopupController.getInstance().prikaziDjelatnika(d, DatumValueCell.this.item);
                            DatumValueCell.this.item.setArrowLocation(PopOver.ArrowLocation.LEFT_TOP);
                            DatumValueCell.this.item.setCornerRadius(4.0);
                            DatumValueCell.this.item.setTitle(c.getTableColumn().getText());
                            if (!c.isEmpty()) {
                                DatumValueCell.this.item.show((Node)MonitoringController.this.tablicaDjelatnik.getParent(), event.getScreenX(), event.getScreenY());
                            }
                        } else if (c.getTableColumn().getText().equalsIgnoreCase("DATUM ISPITIVANJA")) {
                            if (!GlavniPanelController.getInstance().getTabByIdifExist("Unos Stroja")) {
                                GlavniPanelController.getInstance().zatvoriTab("Unos Stroja");
                                GlavniPanelController.getInstance().nadodajPanel("Unos Stroja", "/radnaoprema/UnosStrojeva.fxml");
                                UnosStrojevaController.getInstance().izmjenaStroja(se);
                                UnosStrojevaController.getInstance().getTabPanePodaci().getSelectionModel().select(2);
                            } else {
                                GlavniPanelController.getInstance().nadodajPanel("Unos Stroja", "/radnaoprema/UnosStrojeva.fxml");
                                UnosStrojevaController.getInstance().izmjenaStroja(se);
                                UnosStrojevaController.getInstance().getTabPanePodaci().getSelectionModel().select(2);
                            }
                        } else if (c.getTableColumn().getText().equalsIgnoreCase("DATUM ISPITIVANJA M.M")) {
                            if (!GlavniPanelController.getInstance().getTabByIdifExist("Unos mjernog mjesta")) {
                                GlavniPanelController.getInstance().zatvoriTab("Unos mjernog mjesta");
                                GlavniPanelController.getInstance().nadodajPanel("Unos mjernog mjesta", "/radniokolis/UnosFRO.fxml");
                                UnosFROController.getInstance().izmjenaFRO(mm);
                                UnosFROController.getInstance().getTabPanePodaci().getSelectionModel().select(1);
                            } else {
                                GlavniPanelController.getInstance().nadodajPanel("Unos mjernog mjesta", "/radniokolis/UnosFRO.fxml");
                                UnosFROController.getInstance().izmjenaFRO(mm);
                                UnosFROController.getInstance().getTabPanePodaci().getSelectionModel().select(1);
                            }
                        } else if (c.getTableColumn().getText().equalsIgnoreCase("DATUM ISPITIVANJA OBJEKTA")) {
                            FXMLLoader loader = new FXMLLoader(this.getClass().getResource("ObjektPopup.fxml"));
                            Parent root = null;
                            try {
                                root = (Parent)loader.load();
                            }
                            catch (IOException ex) {
                                Logger.getLogger(MonitoringController.class.getName()).log(Level.SEVERE, null, ex);
                            }
                            DatumValueCell.this.item.setContentNode((Node)root);
                            ObjektPopupController.getInstance().prikaziObjekt(on, DatumValueCell.this.item);
                            DatumValueCell.this.item.setArrowLocation(PopOver.ArrowLocation.LEFT_TOP);
                            DatumValueCell.this.item.setCornerRadius(4.0);
                            DatumValueCell.this.item.setTitle(c.getTableColumn().getText());
                            if (!c.isEmpty()) {
                                DatumValueCell.this.item.show((Node)MonitoringController.this.tablicaObjekti.getParent(), event.getScreenX(), event.getScreenY());
                            }
                        } else if (c.getTableColumn().getText().equalsIgnoreCase("IZDANA UPUTNICA")) {
                            if (!GlavniPanelController.getInstance().getTabByIdifExist("Popis RA-1 uputnica")) {
                                GlavniPanelController.getInstance().zatvoriTab("Popis RA-1 uputnica");
                                GlavniPanelController.getInstance().nadodajPanel("Popis RA-1 uputnica", "/uputnice/PregledRA1.fxml");
                            } else {
                                GlavniPanelController.getInstance().nadodajPanel("Popis RA-1 uputnica", "/uputnice/PregledRA1.fxml");
                            }
                        } else if (c.getTableColumn().getText().equalsIgnoreCase("OSPOSOBLJAVANJE")) {
                            FXMLLoader loader = new FXMLLoader(this.getClass().getResource("OsposobljavanjePopup.fxml"));
                            Parent root = null;
                            try {
                                root = (Parent)loader.load();
                            }
                            catch (IOException ex) {
                                Logger.getLogger(MonitoringController.class.getName()).log(Level.SEVERE, null, ex);
                            }
                            DatumValueCell.this.item.setContentNode((Node)root);
                            OsposobljavanjePopupController.getInstance().prikaziDjelatnika(d, DatumValueCell.this.item);
                            DatumValueCell.this.item.setArrowLocation(PopOver.ArrowLocation.LEFT_TOP);
                            DatumValueCell.this.item.setCornerRadius(4.0);
                            DatumValueCell.this.item.setTitle(c.getTableColumn().getText());
                            if (!c.isEmpty()) {
                                DatumValueCell.this.item.show((Node)MonitoringController.this.tablicaDjelatnik.getParent(), event.getScreenX(), event.getScreenY());
                            }
                        } else if (c.getTableColumn().getText().equalsIgnoreCase("OSTALI PREGLEDI")) {
                            FXMLLoader loader = new FXMLLoader(this.getClass().getResource("DjelatnikOstaliPregledPopup.fxml"));
                            Parent root = null;
                            try {
                                root = (Parent)loader.load();
                            }
                            catch (IOException ex) {
                                Logger.getLogger(MonitoringController.class.getName()).log(Level.SEVERE, null, ex);
                            }
                            DatumValueCell.this.item.setContentNode((Node)root);
                            DjelatnikOstaliPregledPopupController.getInstance().prikaziDjelatnika(d, DatumValueCell.this.item);
                            DatumValueCell.this.item.setArrowLocation(PopOver.ArrowLocation.LEFT_TOP);
                            DatumValueCell.this.item.setCornerRadius(4.0);
                            DatumValueCell.this.item.setTitle(c.getTableColumn().getText());
                            if (!c.isEmpty()) {
                                DatumValueCell.this.item.show((Node)MonitoringController.this.tablicaDjelatnik.getParent(), event.getScreenX(), event.getScreenY());
                            }
                        }
                    }
                }
            });
        }

        protected void updateItem(LocalDate item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (empty) {
                this.setText(null);
                this.setGraphic(null);
                this.setStyle(null);
                this.setTooltip(null);
            } else if (item == null) {
                this.setText("---");
                this.setStyle(null);
                this.setTooltip(null);
                this.setGraphic(null);
            } else if (item != null) {
                this.setCursor(Cursor.HAND);
                this.izracunaj(item);
            } else {
                this.setText(null);
                this.setGraphic(null);
            }
        }

        private void izracunaj(LocalDate d) {
            Tooltip tip = new Tooltip();
            tip.setStyle("-fx-font-size:12pt;-fx-text-fill:white");
            LocalDate datePocetni = LocalDate.now();
            LocalDate dateEnd = d;
            Period p = Period.between(datePocetni, dateEnd);
            long p2 = ChronoUnit.DAYS.between(datePocetni, dateEnd);
            if (p2 < 0L) {
                this.setStyle("-fx-background-color:-fx-table-cell-border-color, darkgray ;-fx-background-insets: 0, 0 0 1 0; -fx-padding: 0.0em; -fx-alignment: CENTER;");
                this.setText(d.format(DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM)));
                tip.setText("Pro\u0161lo je vi\u0161e od " + p.getYears() + " god. " + p.getMonths() + " mj. ,\n i  " + p.getDays() + " dana od potrebnog pregleda .\n ( ukupno  " + p2 + "  dana )");
                this.setTooltip(tip);
                this.setGraphic(null);
            } else if (p2 <= 15L || p2 == 0L) {
                this.setStyle("-fx-background-color:-fx-table-cell-border-color, red ;-fx-background-insets: 0, 0 0 1 0; -fx-padding: 0.0em; -fx-alignment: CENTER;");
                this.setText(d.format(DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM)));
                tip.setText("Preostalo jo\u0161 " + p.getYears() + " god. " + p.getMonths() + " mj.,\n i " + p.getDays() + "  dana do sljede\u0107eg pregleda. \n( ukupno  " + p2 + "  dana )");
                this.setTooltip(tip);
                this.setGraphic(null);
            } else if (p2 <= 30L) {
                this.setStyle("-fx-background-color:-fx-table-cell-border-color, goldenrod ;-fx-background-insets: 0, 0 0 1 0; -fx-padding: 0.0em; -fx-alignment: CENTER;");
                this.setText(d.format(DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM)));
                tip.setText("Preostalo jo\u0161 " + p.getYears() + " god. " + p.getMonths() + " mj,\n i " + p.getDays() + "  dana do sljede\u0107eg pregleda. \n( ukupno  " + p2 + "  dana )");
                this.setTooltip(tip);
                this.setGraphic(null);
            } else if (p2 > 30L) {
                this.setStyle("-fx-background-color:-fx-table-cell-border-color, yellowgreen ;-fx-background-insets: 0, 0 0 1 0; -fx-padding: 0.0em; -fx-alignment: CENTER;");
                this.setText(d.format(DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM)));
                tip.setText("Preostalo jo\u0161 " + p.getYears() + " god. " + p.getMonths() + " mj,\n i " + p.getDays() + "  dana do sljede\u0107eg pregleda. \n( ukupno  " + p2 + "  dana )");
                this.setTooltip(tip);
                this.setGraphic(null);
            } else {
                this.setTooltip(null);
                this.setGraphic(null);
                Tooltip.uninstall((Node)this, (Tooltip)tip);
            }
        }
    }

    public static class TimeSlot {
        private final LocalDateTime start;
        private java.time.Duration duration = null;
        private Button b = null;
        PopOver item = new PopOver();

        public TimeSlot(LocalDateTime start, java.time.Duration duration, Object o, String d) {
            this.start = start;
            this.duration = duration;
            StringTokenizer st = new StringTokenizer(d);
            String poruka = st.nextToken();
            if (poruka.equalsIgnoreCase("LIJE\u010cNI\u010cKI")) {
                this.b = this.dajButtonLjecnicki(poruka, o);
            } else if (poruka.equalsIgnoreCase("ozo")) {
                this.b = this.dajButtonOZO(poruka, o);
            } else if (poruka.equalsIgnoreCase("FRO")) {
                this.b = this.dajButtonFRO(poruka, o);
            } else if (poruka.equalsIgnoreCase("OBJEKAT")) {
                this.b = this.dajButtonOBJEKAT(poruka, o);
            } else if (poruka.equalsIgnoreCase("STROJ")) {
                this.b = this.dajButtonSTROJ(poruka, o);
            } else if (poruka.equalsIgnoreCase("OSPOSOBLJAVANJA")) {
                this.b = this.dajButtonOsposobljavanja(poruka, o);
            } else if (poruka.equalsIgnoreCase("SJEDNICA")) {
                this.b = this.dajButtonSjednicaOdbora(poruka, o);
            } else if (poruka.equalsIgnoreCase("MJERNI-URE\u0110AJ")) {
                this.b = this.dajButtonMjerniInstrumenti(poruka, o);
            } else if (poruka.equalsIgnoreCase("PREGLED")) {
                this.b = this.dajButtonDrugiPregled(poruka, o);
            }
        }

        public LocalDateTime getStart() {
            return this.start;
        }

        public LocalTime getTime() {
            return this.start.toLocalTime();
        }

        public DayOfWeek getDayOfWeek() {
            return this.start.getDayOfWeek();
        }

        public java.time.Duration getDuration() {
            return this.duration;
        }

        public Node getView() {
            return this.b;
        }

        private Button dajButtonLjecnicki(String poruka, Object o) {
            Button b = null;
            DjelatnikPregled dj = (DjelatnikPregled)o;
            b = new Button(dj.getIme() + " " + dj.getPrezime() + "\n " + poruka);
            b.setTooltip(new Tooltip(dj.getIme() + " " + dj.getPrezime() + " " + poruka));
            b.setPrefWidth(200.0);
            b.setStyle("-fx-background-color: cornflowerblue    ;-fx-border-color: gray;-fx-border-width: 0.5; ");
            b.setOnAction(e -> {
                if (!GlavniPanelController.getInstance().getTabByIdifExist("Unos Djelatnika")) {
                    GlavniPanelController.getInstance().zatvoriTab("Unos Djelatnika");
                    GlavniPanelController.getInstance().nadodajPanel("Unos Djelatnika", "/kadrovska/UnosDjelatnika.fxml");
                    UnosDjelatnikaController.getInstance().izmjenaDjelatnika(dj);
                    UnosDjelatnikaController.getInstance().getTabPanePodaci().getSelectionModel().select(2);
                } else {
                    GlavniPanelController.getInstance().nadodajPanel("Unos Djelatnika", "/kadrovska/UnosDjelatnika.fxml");
                    UnosDjelatnikaController.getInstance().izmjenaDjelatnika(dj);
                    UnosDjelatnikaController.getInstance().getTabPanePodaci().getSelectionModel().select(2);
                }
            });
            return b;
        }

        private Button dajButtonOZO(String poruka, Object o) {
            Button b = null;
            DjelatnikPregled dj = (DjelatnikPregled)o;
            b = new Button(dj.getIme() + " " + dj.getPrezime() + "\n " + poruka);
            b.setTooltip(new Tooltip(dj.getIme() + " " + dj.getPrezime() + " " + poruka));
            b.setPrefWidth(200.0);
            b.setStyle("-fx-background-color: red  ;-fx-border-color: gray;-fx-border-width: 0.5; ");
            b.setOnMouseClicked(e -> {
                FXMLLoader loader = new FXMLLoader(this.getClass().getResource("DatumPopup.fxml"));
                Parent root = null;
                try {
                    root = (Parent)loader.load();
                }
                catch (IOException ex) {
                    Logger.getLogger(MonitoringController.class.getName()).log(Level.SEVERE, null, ex);
                }
                this.item.setContentNode((Node)root);
                DatumPopupController.getInstance().prikaziDjelatnika(dj, this.item);
                this.item.setArrowLocation(PopOver.ArrowLocation.LEFT_TOP);
                this.item.setCornerRadius(4.0);
                this.item.setTitle(poruka);
                this.item.show((Node)this.getView().getParent(), e.getScreenX(), e.getScreenY());
            });
            return b;
        }

        private Button dajButtonFRO(String poruka, Object o) {
            Button b = null;
            MjernoMjestoFRO mm = (MjernoMjestoFRO)o;
            b = new Button(mm.getNazivMjernogMjesta() + "\n " + poruka);
            b.setTooltip(new Tooltip(mm.getNazivMjernogMjesta() + "\n " + poruka));
            b.setPrefWidth(200.0);
            b.setStyle("-fx-background-color:olivedrab     ;-fx-border-color: gray;-fx-border-width: 0.5; ");
            b.setOnMouseClicked(e -> {
                if (!GlavniPanelController.getInstance().getTabByIdifExist("Unos mjernog mjesta")) {
                    GlavniPanelController.getInstance().zatvoriTab("Unos mjernog mjesta");
                    GlavniPanelController.getInstance().nadodajPanel("Unos mjernog mjesta", "/radniokolis/UnosFRO.fxml");
                    UnosFROController.getInstance().izmjenaFRO(mm);
                    UnosFROController.getInstance().getTabPanePodaci().getSelectionModel().select(1);
                } else {
                    GlavniPanelController.getInstance().nadodajPanel("Unos mjernog mjesta", "/radniokolis/UnosFRO.fxml");
                    UnosFROController.getInstance().izmjenaFRO(mm);
                    UnosFROController.getInstance().getTabPanePodaci().getSelectionModel().select(1);
                }
            });
            return b;
        }

        private Button dajButtonOBJEKAT(String poruka, Object o) {
            Button b = null;
            ObjektNadzor on = (ObjektNadzor)o;
            b = new Button(on.getNazivObjekta() + "\n " + poruka);
            b.setTooltip(new Tooltip(on.getNazivObjekta() + " " + poruka));
            b.setPrefWidth(200.0);
            b.setStyle("-fx-background-color: midnightblue    ;-fx-border-color: gray;-fx-border-width: 0.5; ");
            b.setOnMouseClicked(e -> {
                FXMLLoader loader = new FXMLLoader(this.getClass().getResource("ObjektPopup.fxml"));
                Parent root = null;
                try {
                    root = (Parent)loader.load();
                }
                catch (IOException ex) {
                    Logger.getLogger(MonitoringController.class.getName()).log(Level.SEVERE, null, ex);
                }
                this.item.setContentNode((Node)root);
                ObjektPopupController.getInstance().prikaziObjekt(on, this.item);
                this.item.setArrowLocation(PopOver.ArrowLocation.LEFT_TOP);
                this.item.setCornerRadius(4.0);
                this.item.setTitle(poruka);
                this.item.show((Node)this.getView().getParent(), e.getScreenX(), e.getScreenY());
            });
            return b;
        }

        private Button dajButtonSTROJ(String poruka, Object o) {
            Button b = null;
            StrojEvidencija se = (StrojEvidencija)o;
            b = new Button(se.getNazivstroja() + "\n " + poruka);
            b.setTooltip(new Tooltip(se.getNazivstroja() + "\n " + poruka));
            b.setPrefWidth(200.0);
            b.setStyle("-fx-background-color: olivedrab    ;-fx-border-color: gray;-fx-border-width: 0.5; ");
            b.setOnMouseClicked(e -> {
                if (!GlavniPanelController.getInstance().getTabByIdifExist("Unos Stroja")) {
                    GlavniPanelController.getInstance().zatvoriTab("Unos Stroja");
                    GlavniPanelController.getInstance().nadodajPanel("Unos Stroja", "/radnaoprema/UnosStrojeva.fxml");
                    UnosStrojevaController.getInstance().izmjenaStroja(se);
                    UnosStrojevaController.getInstance().getTabPanePodaci().getSelectionModel().select(2);
                } else {
                    GlavniPanelController.getInstance().nadodajPanel("Unos Stroja", "/radnaoprema/UnosStrojeva.fxml");
                    UnosStrojevaController.getInstance().izmjenaStroja(se);
                    UnosStrojevaController.getInstance().getTabPanePodaci().getSelectionModel().select(2);
                }
            });
            return b;
        }

        private Button dajButtonOsposobljavanja(String poruka, Object o) {
            Button b = null;
            DjelatnikPregled dj = (DjelatnikPregled)o;
            b = new Button(dj.getIme() + " " + dj.getPrezime() + "\n " + poruka);
            b.setTooltip(new Tooltip(dj.getIme() + " " + dj.getPrezime() + " " + poruka));
            b.setPrefWidth(200.0);
            b.setStyle("-fx-background-color: coral  ;-fx-border-color: gray;-fx-border-width: 0.5; ");
            b.setOnMouseClicked(e -> {
                FXMLLoader loader = new FXMLLoader(this.getClass().getResource("OsposobljavanjePopup.fxml"));
                Parent root = null;
                try {
                    root = (Parent)loader.load();
                }
                catch (IOException ex) {
                    Logger.getLogger(MonitoringController.class.getName()).log(Level.SEVERE, null, ex);
                }
                this.item.setContentNode((Node)root);
                OsposobljavanjePopupController.getInstance().prikaziDjelatnika(dj, this.item);
                this.item.setArrowLocation(PopOver.ArrowLocation.LEFT_TOP);
                this.item.setCornerRadius(4.0);
                this.item.setTitle(poruka);
                this.item.show((Node)this.getView().getParent(), e.getScreenX(), e.getScreenY());
            });
            return b;
        }

        private Button dajButtonSjednicaOdbora(String poruka, Object o) {
            Button b = null;
            String dj = o.toString();
            b = new Button("ODBOR\n " + poruka);
            b.setTooltip(new Tooltip(poruka + " ODBORA"));
            b.setPrefWidth(200.0);
            b.setStyle("-fx-background-color: steelblue    ;-fx-border-color: gray;-fx-border-width: 0.5; ");
            b.setOnMouseClicked(e -> GlavniPanelController.getInstance().nadodajPanel("Odbor za\u0161tite na radu", "/odbor/Odbor.fxml"));
            return b;
        }

        private Button dajButtonMjerniInstrumenti(String poruka, Object o) {
            Button b = null;
            MjerniInstrumentPodaci se = (MjerniInstrumentPodaci)o;
            b = new Button(se.getNazivstroja() + "\n " + poruka);
            b.setTooltip(new Tooltip(se.getNazivstroja() + "\n " + poruka));
            b.setPrefWidth(200.0);
            b.setStyle("-fx-background-color: chocolate   ;-fx-border-color: gray;-fx-border-width: 0.5; ");
            b.setOnMouseClicked(e -> {
                if (!GlavniPanelController.getInstance().getTabByIdifExist("Unos ure\u0111aja")) {
                    GlavniPanelController.getInstance().zatvoriTab("Unos ure\u0111aja");
                    GlavniPanelController.getInstance().nadodajPanel("Unos ure\u0111aja", "/mjerniinstrumenti/UnosMjernogInstrumenta.fxml");
                    UnosMjernogInstrumentaController.getInstance().izmjenaUredjaja(se);
                    UnosMjernogInstrumentaController.getInstance().getTabPanePodaci().getSelectionModel().select(2);
                } else {
                    GlavniPanelController.getInstance().nadodajPanel("Unos ure\u0111aja", "/mjerniinstrumenti/UnosMjernogInstrumenta.fxml");
                    UnosMjernogInstrumentaController.getInstance().izmjenaUredjaja(se);
                    UnosMjernogInstrumentaController.getInstance().getTabPanePodaci().getSelectionModel().select(2);
                }
            });
            return b;
        }

        private Button dajButtonDrugiPregled(String poruka, Object o) {
            Button b = null;
            DjelatnikPregled dj = (DjelatnikPregled)o;
            b = new Button(dj.getIme() + " " + dj.getPrezime() + "\n " + poruka);
            b.setTooltip(new Tooltip(dj.getIme() + " " + dj.getPrezime() + " " + poruka));
            b.setPrefWidth(200.0);
            b.setStyle("-fx-background-color: orchid   ;-fx-border-color: gray;-fx-border-width: 0.5; ");
            b.setOnMouseClicked(e -> {
                FXMLLoader loader = new FXMLLoader(this.getClass().getResource("DjelatnikOstaliPregledPopup.fxml"));
                Parent root = null;
                try {
                    root = (Parent)loader.load();
                }
                catch (IOException ex) {
                    Logger.getLogger(MonitoringController.class.getName()).log(Level.SEVERE, null, ex);
                }
                this.item.setContentNode((Node)root);
                DjelatnikOstaliPregledPopupController.getInstance().prikaziDjelatnika(dj, this.item);
                this.item.setArrowLocation(PopOver.ArrowLocation.LEFT_TOP);
                this.item.setCornerRadius(4.0);
                this.item.setTitle(poruka);
                this.item.show((Node)this.getView().getParent(), e.getScreenX(), e.getScreenY());
            });
            return b;
        }
    }

    public class CustomPane
    extends VBox {
        public CustomPane() {
            this.setStyle("-fx-background-color:transparent;");
        }

        public CustomPane getPane() {
            return this;
        }
    }
}

