/*
 * Decompiled with CFR 0.152.
 */
package monitoringnovi;

import Utill.DateUtil;
import Utill.Konekcija;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import monitoring.DjelatnikPregled;
import monitoringnovi.BazaMonitoringNovi;
import monitoringnovi.MonitoringNoviController;
import tvrtka.Tvrtka;
import zastitanaradu.GlavniPanelController;

public class DjelatniciNadzorServiceNovi
extends Service<ObservableList<DjelatnikPregled>> {
    private final MonitoringNoviController nadzor;

    DjelatniciNadzorServiceNovi(MonitoringNoviController nadzor) {
        this.nadzor = nadzor;
    }

    private void addDjelatnikaUI(final ObservableList<DjelatnikPregled> listaDjelatnika) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                DjelatniciNadzorServiceNovi.this.nadzor.setListaDjelatnika((ObservableList<DjelatnikPregled>)listaDjelatnika);
            }
        });
    }

    protected Task<ObservableList<DjelatnikPregled>> createTask() {
        return new DjelatnikNadzorTaskNovi();
    }

    public class DjelatnikNadzorTaskNovi
    extends Task<ObservableList<DjelatnikPregled>> {
        private final Tvrtka odabranaTvrtka = GlavniPanelController.getOdabranaTvrtka();
        ObservableList<DjelatnikPregled> listaDjelatnika = FXCollections.observableArrayList();
        Konekcija k = new Konekcija();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected ObservableList<DjelatnikPregled> call() throws Exception {
            ResultSet rs = BazaMonitoringNovi.dajDjelatnike(this.odabranaTvrtka);
            DjelatnikPregled d = null;
            try {
                while (rs.next()) {
                    d = new DjelatnikPregled();
                    d.setId(rs.getInt("id"));
                    d.setIme(rs.getString("ime"));
                    d.setPrezime(rs.getString("prezime"));
                    d.setPoslovnaJedinica(rs.getString("nazivposlovnice"));
                    d.setOdjel(rs.getString("nazivodjela"));
                    d.setOIB(rs.getString("oib"));
                    d.setDatumIzdavanjaUputnice(DateUtil.getLocalDate(rs.getDate("ra1izdanauputnica")));
                    d.setDatumIzdavanjaNr1Uputnice(DateUtil.getLocalDate(rs.getDate("nr1izdanauputnica")));
                    d.setDatumIstekaLJPregleda(DateUtil.getLocalDate(rs.getDate("ljecnickipregled")));
                    d.setOzo(DateUtil.getLocalDate(rs.getDate("ozo")));
                    d.setOsposobljavanje(DateUtil.getLocalDate(rs.getDate("osposobljavanje")));
                    d.setOstaliPregled(DateUtil.getLocalDate(rs.getDate("ostalipregledi")));
                    this.listaDjelatnika.add((Object)d);
                }
            }
            catch (SQLException ex) {
                Logger.getLogger(DjelatniciNadzorServiceNovi.class.getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                try {
                    rs.close();
                }
                catch (SQLException ex) {
                    Logger.getLogger(DjelatniciNadzorServiceNovi.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            this.sortirajDjelatnikTablicu();
            DjelatniciNadzorServiceNovi.this.addDjelatnikaUI((ObservableList<DjelatnikPregled>)this.listaDjelatnika);
            return this.listaDjelatnika;
        }

        void sortirajDjelatnikTablicu() {
            Map<Object, Object> map = new HashMap();
            ObservableList listaNajmanjihDatuma = FXCollections.observableArrayList();
            for (int i = 0; i < this.listaDjelatnika.size(); ++i) {
                listaNajmanjihDatuma.add((Object)((DjelatnikPregled)this.listaDjelatnika.get(i)).getDatumIstekaLJPregleda());
                listaNajmanjihDatuma.add((Object)((DjelatnikPregled)this.listaDjelatnika.get(i)).getOzo());
                listaNajmanjihDatuma.add((Object)((DjelatnikPregled)this.listaDjelatnika.get(i)).getOstaliPregled());
                listaNajmanjihDatuma.add((Object)((DjelatnikPregled)this.listaDjelatnika.get(i)).getOsposobljavanje());
                FXCollections.sort((ObservableList)listaNajmanjihDatuma, Comparator.nullsLast(Comparator.naturalOrder()));
                if (listaNajmanjihDatuma.get(0) == null) {
                    map.put(this.listaDjelatnika.get(i), listaNajmanjihDatuma.get(1));
                } else {
                    map.put(this.listaDjelatnika.get(i), listaNajmanjihDatuma.get(0));
                }
                listaNajmanjihDatuma.clear();
            }
            map = this.sortByValue(map);
            this.listaDjelatnika.clear();
            map.forEach((k, v) -> this.listaDjelatnika.add(k));
            map.clear();
        }

        public <K, V extends Comparable<? super V>> Map<K, V> sortByValue(Map<K, V> map) {
            LinkedHashMap result = new LinkedHashMap();
            Stream st = map.entrySet().stream();
            st.sorted(Comparator.comparing(e -> (Comparable)e.getValue(), Comparator.nullsLast(Comparator.naturalOrder()))).forEachOrdered(e -> {
                Comparable cfr_ignored_0 = (Comparable)result.put(e.getKey(), e.getValue());
            });
            return result;
        }
    }
}

