/*
 * Decompiled with CFR 0.152.
 */
package monitoringnovi;

import Utill.DateUtil;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.Period;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.time.temporal.ChronoUnit;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;
import javafx.util.Callback;
import kadrovska.DjelatnikOsposobljavanja;
import kadrovska.UnosDjelatnikaController;
import monitoring.DjelatnikPregled;
import monitoringnovi.BazaMonitoringNovi;
import org.controlsfx.control.PopOver;
import zastitanaradu.GlavniPanelController;

public class DjelatnikOsposobljavanjePopupController
implements Initializable {
    @FXML
    private Label lblImePrezime;
    @FXML
    private Label lblOdjel;
    @FXML
    private Label lblPoslovnica;
    @FXML
    private TableView<DjelatnikOsposobljavanja> tablicaOsposobljavanje;
    @FXML
    private TableColumn<DjelatnikOsposobljavanja, String> kolNaziv;
    @FXML
    private TableColumn<DjelatnikOsposobljavanja, LocalDate> kolDatumIzdavanja;
    @FXML
    private TableColumn<DjelatnikOsposobljavanja, LocalDate> kolDatumIsteka;
    @FXML
    private Button btnCancel;
    @FXML
    private Button btnPrikaziDjelatnika;
    private DjelatnikPregled dp;
    private ObservableList<DjelatnikOsposobljavanja> listaDjelatnikOsposobljavanje = FXCollections.observableArrayList();
    private static DjelatnikOsposobljavanjePopupController instance;
    private PopOver p = null;

    public static DjelatnikOsposobljavanjePopupController getInstance() {
        return instance;
    }

    public void initialize(URL url, ResourceBundle rb) {
        instance = this;
        this.urediTablicuOsposobljavanje();
        this.btnCancel.setOnAction(e -> this.p.hide());
        this.btnPrikaziDjelatnika.setOnAction(e -> {
            if (!GlavniPanelController.getInstance().getTabByIdifExist("Unos Djelatnika")) {
                GlavniPanelController.getInstance().zatvoriTab("Unos Djelatnika");
                GlavniPanelController.getInstance().nadodajPanel("Unos Djelatnika", "/kadrovska/UnosDjelatnika.fxml");
                UnosDjelatnikaController.getInstance().izmjenaDjelatnikaPopup(this.dp);
            } else {
                GlavniPanelController.getInstance().nadodajPanel("Unos Djelatnika", "/kadrovska/UnosDjelatnika.fxml");
                UnosDjelatnikaController.getInstance().izmjenaDjelatnikaPopup(this.dp);
            }
            UnosDjelatnikaController.getInstance().getTabPanePodaci().getSelectionModel().select(1);
            this.p.hide();
        });
    }

    private void urediTablicuOsposobljavanje() {
        Callback dateCellFactory = param -> new DatumValueCell();
        this.kolNaziv.setCellValueFactory(cellData -> ((DjelatnikOsposobljavanja)cellData.getValue()).nazivOsposobljavanjaProperty());
        this.kolNaziv.prefWidthProperty().bind((ObservableValue)this.tablicaOsposobljavanje.widthProperty().divide(2.5));
        this.kolNaziv.setStyle("-fx-alignment: CENTER;");
        this.kolDatumIzdavanja.setCellValueFactory(cellData -> ((DjelatnikOsposobljavanja)cellData.getValue()).datumIzdavanjaProperty());
        this.kolDatumIzdavanja.prefWidthProperty().bind((ObservableValue)this.tablicaOsposobljavanje.widthProperty().divide(3.3333333333333335));
        this.kolDatumIzdavanja.setStyle("-fx-alignment: CENTER;");
        this.kolDatumIzdavanja.setCellFactory(dateCellFactory);
        this.kolDatumIsteka.setCellValueFactory(cellData -> ((DjelatnikOsposobljavanja)cellData.getValue()).datumIstekaProperty());
        this.kolDatumIsteka.prefWidthProperty().bind((ObservableValue)this.tablicaOsposobljavanje.widthProperty().divide(3.4482758620689653));
        this.kolDatumIsteka.setStyle("-fx-alignment: CENTER;");
        this.kolDatumIsteka.setCellFactory(dateCellFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prikaziDjelatnika(DjelatnikPregled dp, PopOver p) {
        this.p = p;
        ResultSet rs = BazaMonitoringNovi.dajDjelatnikOsposobljavanja(dp.getId());
        DjelatnikOsposobljavanja d = null;
        try {
            while (rs.next()) {
                d = new DjelatnikOsposobljavanja();
                d.setIddjelatnik(rs.getInt("iddjelatnik"));
                d.setOznaka(rs.getString("oznaka"));
                d.setNazivOsposobljavanja(rs.getString("nazivosposobljavanja"));
                d.setDatumTeorija(DateUtil.getLocalDate(rs.getDate("datumteorija")));
                d.setDatumIzdavanja(DateUtil.getLocalDate(rs.getDate("datumizdavanja")));
                d.setDatumIsteka(DateUtil.getLocalDate(rs.getDate("osdatumisteka")));
                this.listaDjelatnikOsposobljavanje.add((Object)d);
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(DjelatnikOsposobljavanjePopupController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(DjelatnikOsposobljavanjePopupController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        dp.setListaOsposobljavanje(this.listaDjelatnikOsposobljavanje);
        this.lblImePrezime.setText(dp.getIme() + " " + dp.getPrezime());
        this.lblPoslovnica.setText(dp.getPoslovnaJedinica());
        this.lblOdjel.setText(dp.getOdjel());
        this.tablicaOsposobljavanje.setItems(this.listaDjelatnikOsposobljavanje);
        this.dp = dp;
    }

    class DatumValueCell
    extends TableCell<DjelatnikOsposobljavanja, LocalDate> {
        DatumValueCell() {
        }

        protected void updateItem(LocalDate item, boolean empty) {
            super.updateItem((Object)item, empty);
            Object lol = null;
            if (empty) {
                this.setText(null);
                this.setGraphic(null);
                this.setStyle(null);
                this.setTooltip(null);
            } else if (item == null) {
                this.setText("---");
                this.setStyle(null);
                this.setTooltip(null);
                this.setGraphic(null);
            } else if (item != null) {
                if (this.getTableColumn().getText().equals("Datum izdavanja")) {
                    this.setText(item.format(DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM)));
                } else {
                    this.izracunaj(item);
                }
            } else {
                this.setText(null);
                this.setGraphic(null);
            }
        }

        private void izracunaj(LocalDate d) {
            Tooltip tip = new Tooltip();
            tip.setStyle("-fx-font-size:12pt;-fx-text-fill:white");
            LocalDate datePocetni = LocalDate.now();
            LocalDate dateEnd = d;
            Period p = Period.between(datePocetni, dateEnd);
            long p2 = ChronoUnit.DAYS.between(datePocetni, dateEnd);
            if (p2 < 0L) {
                this.setStyle("-fx-background-color:-fx-table-cell-border-color, darkgray ;-fx-background-insets: 0, 0 0 1 0; -fx-padding: 0.0em; -fx-alignment: CENTER;");
                this.setText(d.format(DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM)));
                tip.setText("Pro\u0161lo je vi\u0161e od " + p.getYears() + " god. " + p.getMonths() + " mj. ,\n i  " + p.getDays() + " dana od isteka.\n ( ukupno  " + p2 + "  dana )");
                this.setTooltip(tip);
                this.setGraphic(null);
            } else if (p2 <= 15L || p2 == 0L) {
                this.setStyle("-fx-background-color:-fx-table-cell-border-color, red ;-fx-background-insets: 0, 0 0 1 0; -fx-padding: 0.0em; -fx-alignment: CENTER;");
                this.setText(d.format(DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM)));
                tip.setText("Preostalo jo\u0161 " + p.getYears() + " god. " + p.getMonths() + " mj.,\n i " + p.getDays() + "  dana do isteka. \n( ukupno  " + p2 + "  dana )");
                this.setTooltip(tip);
                this.setGraphic(null);
            } else if (p2 <= 30L) {
                this.setStyle("-fx-background-color:-fx-table-cell-border-color, goldenrod ;-fx-background-insets: 0, 0 0 1 0; -fx-padding: 0.0em; -fx-alignment: CENTER;");
                this.setText(d.format(DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM)));
                tip.setText("Preostalo jo\u0161 " + p.getYears() + " god. " + p.getMonths() + " mj,\n i " + p.getDays() + "  dana do isteka. \n( ukupno  " + p2 + "  dana )");
                this.setTooltip(tip);
                this.setGraphic(null);
            } else if (p2 > 30L) {
                this.setStyle("-fx-background-color:-fx-table-cell-border-color, yellowgreen ;-fx-background-insets: 0, 0 0 1 0; -fx-padding: 0.0em; -fx-alignment: CENTER;");
                this.setText(d.format(DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM)));
                tip.setText("Preostalo jo\u0161 " + p.getYears() + " god. " + p.getMonths() + " mj,\n i " + p.getDays() + "  dana do isteka. \n( ukupno  " + p2 + "  dana )");
                this.setTooltip(tip);
                this.setGraphic(null);
            } else {
                this.setTooltip(null);
                this.setGraphic(null);
                Tooltip.uninstall((Node)this, (Tooltip)tip);
            }
        }
    }
}

