/*
 * Decompiled with CFR 0.152.
 */
package monitoringnovi;

import Utill.DateUtil;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import monitoring.FROPregled;
import monitoringnovi.BazaMonitoringNovi;
import monitoringnovi.MonitoringNoviController;
import tvrtka.Tvrtka;
import zastitanaradu.GlavniPanelController;

public class FRONadzorService
extends Service<ObservableList<FROPregled>> {
    private final MonitoringNoviController mk;

    public FRONadzorService(MonitoringNoviController mk) {
        this.mk = mk;
    }

    protected Task<ObservableList<FROPregled>> createTask() {
        return new FRONadzorTask();
    }

    private void addFROUI(final ObservableList<FROPregled> listaFRO) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                FRONadzorService.this.mk.setListaFRO((ObservableList<FROPregled>)listaFRO);
            }
        });
    }

    private class FRONadzorTask
    extends Task<ObservableList<FROPregled>> {
        private Tvrtka t = GlavniPanelController.getOdabranaTvrtka();
        ObservableList<FROPregled> listaFRO = FXCollections.observableArrayList();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected ObservableList<FROPregled> call() throws Exception {
            ResultSet rs = BazaMonitoringNovi.dajMjernaMjesta(this.t);
            FROPregled mm = null;
            int br = 1;
            try {
                while (rs.next()) {
                    mm = new FROPregled();
                    mm.setId(rs.getInt("id"));
                    mm.setRedBroj(String.valueOf(br));
                    mm.setNazivMjernogMjesta(rs.getString("nazivmjernogmjrsta"));
                    mm.setPoslovnaJedinica(rs.getString("nazivposlovnice"));
                    mm.setOdjel(rs.getString("odjelnaziv"));
                    mm.setMjestoAdresa(rs.getString("mjestoadresa"));
                    mm.setOznakaLokacije(rs.getString("oznakalokacije"));
                    mm.setZatvoren(rs.getBoolean("zatvoren"));
                    mm.setdatumIstekaPregleda(DateUtil.getLocalDate(rs.getDate("ispitivanje")));
                    this.listaFRO.add((Object)mm);
                    ++br;
                }
            }
            catch (SQLException ex) {
                Logger.getLogger(FRONadzorService.class.getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                try {
                    rs.close();
                }
                catch (SQLException ex) {
                    Logger.getLogger(FRONadzorService.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            FRONadzorService.this.addFROUI((ObservableList<FROPregled>)this.listaFRO);
            return this.listaFRO;
        }

        private void sortirajFROTablicu() {
            Map<Object, Object> map = new HashMap();
            ObservableList listaNajmanjihDatuma = FXCollections.observableArrayList();
            for (int i = 0; i < this.listaFRO.size(); ++i) {
                if (((FROPregled)this.listaFRO.get(i)).getdatumIstekaPregleda() == null) continue;
                listaNajmanjihDatuma.add((Object)((FROPregled)this.listaFRO.get(i)).getdatumIstekaPregleda());
                FXCollections.sort((ObservableList)listaNajmanjihDatuma, Comparator.nullsLast(Comparator.naturalOrder()));
                if (listaNajmanjihDatuma.get(0) == null) {
                    map.put(this.listaFRO.get(i), listaNajmanjihDatuma.get(1));
                } else {
                    map.put(this.listaFRO.get(i), listaNajmanjihDatuma.get(0));
                }
                listaNajmanjihDatuma.clear();
            }
            map = this.sortByValue(map);
            this.listaFRO.clear();
            map.forEach((k, v) -> this.listaFRO.add(k));
            map.clear();
        }

        public <K, V extends Comparable<? super V>> Map<K, V> sortByValue(Map<K, V> map) {
            LinkedHashMap result = new LinkedHashMap();
            Stream st = map.entrySet().stream();
            st.sorted(Comparator.comparing(e -> (Comparable)e.getValue(), Comparator.nullsLast(Comparator.naturalOrder()))).forEachOrdered(e -> {
                Comparable cfr_ignored_0 = (Comparable)result.put(e.getKey(), e.getValue());
            });
            return result;
        }
    }
}

