/*
 * Decompiled with CFR 0.152.
 */
package monitoringnovi;

import Utill.KlasaKorisneMetode;
import Utill.SplitPaneDividerSlider;
import filter.MenuButtonReporti;
import java.io.IOException;
import java.net.URL;
import java.time.LocalDate;
import java.time.Period;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.animation.TranslateTransition;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToolBar;
import javafx.scene.control.Tooltip;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.text.TextAlignment;
import javafx.util.Callback;
import javafx.util.Duration;
import kadrovska.Djelatnik;
import login.LoginControler;
import mjerniinstrumenti.MjerniInstrumentPodaci;
import mjerniinstrumenti.UnosMjernogInstrumentaController;
import monitoring.BazaMonitoring;
import monitoring.DjelatnikPregled;
import monitoring.FROPregled;
import monitoring.MonitoringController;
import monitoring.NadzorMjerniInstrumentPregled;
import monitoring.NadzorStrojPregled;
import monitoring.ObjektNadzor;
import monitoringnovi.DjelatniciNadzorServiceNovi;
import monitoringnovi.DjelatniciPotrebnaOsposobljavanja;
import monitoringnovi.DjelatnikLjecnickiPregledPopupController;
import monitoringnovi.DjelatnikOsposobljavanjePopupController;
import monitoringnovi.DjelatnikOstaliPreglediPopupController;
import monitoringnovi.DjelatnikPotrebnaOsposobljavanjaService;
import monitoringnovi.DjlatnikOZOPopupController;
import monitoringnovi.FRONadzorService;
import monitoringnovi.MjerniInstrumentiService;
import monitoringnovi.NadzorVAtrogasniAparat;
import monitoringnovi.ObjektNadzorNoviService;
import monitoringnovi.ObjektNoviPopupController;
import monitoringnovi.Poruka;
import monitoringnovi.SjednicaOdboraService;
import monitoringnovi.StrojNadzorService;
import monitoringnovi.VatrogasniAparatNadzorService;
import monitoringnovi.VatrogasniAparatPopupController;
import org.controlsfx.control.Notifications;
import org.controlsfx.control.PopOver;
import postavke.PostavkePrograma;
import radnaoprema.StrojEvidencija;
import radnaoprema.UnosStrojevaController;
import radniokolis.MjernoMjestoFRO;
import radniokolis.UnosFROController;
import zastitanaradu.GlavniPanelController;

public class MonitoringNoviController
implements Initializable {
    @FXML
    private VBox vBoxVatrogasniAparati;
    @FXML
    private VBox vBoxRadnaOkolina;
    @FXML
    private VBox vBoxRadnaOprema;
    @FXML
    private VBox vBoxObjekti;
    @FXML
    private VBox vBoxMjernaOprema;
    @FXML
    private SplitPane glavniSP;
    @FXML
    private SplitPane lijeviSP;
    @FXML
    private ToggleButton btnDjelatnik;
    @FXML
    private ToggleButton btnObjekt;
    @FXML
    private ToggleButton btnMjerniUredjaj;
    @FXML
    private SplitPane desniSP;
    @FXML
    private ToggleButton btnStroj;
    @FXML
    private ToggleButton btnRAdnaOkolina;
    @FXML
    private ToggleButton btnVatrogasniAparat;
    @FXML
    private BorderPane glavniBorderPane;
    @FXML
    private StackPane stackpane;
    @FXML
    private SplitPane splitPaneD;
    @FXML
    private SplitPane spliPaneLijevi;
    @FXML
    private TitledPane titleDjelatnik;
    @FXML
    private TableView<DjelatnikPregled> tablicaDjelatnik;
    @FXML
    private TableColumn kolPretragaDjelatnik;
    @FXML
    private TitledPane titleObjekti;
    @FXML
    private TableView<ObjektNadzor> tablicaObjekti;
    @FXML
    private TableColumn kolPretragaObjekti;
    @FXML
    private SplitPane splitPaneDesni;
    @FXML
    private TitledPane titleStrojevi;
    @FXML
    private TableView<NadzorStrojPregled> tablicaStrojevi;
    @FXML
    private TableColumn kolPretragaStrojevi;
    @FXML
    private TableView<NadzorMjerniInstrumentPregled> tablicaMjerniUredjaji;
    @FXML
    private TableColumn kolPretragaMJerniUredjaji;
    @FXML
    private TitledPane titleFRO;
    @FXML
    private TableView<FROPregled> tablicaFRO;
    @FXML
    private TableColumn kolPretragaFRO;
    @FXML
    private TableView<NadzorVAtrogasniAparat> tablicaVatrogasniAparati;
    @FXML
    private TableColumn kolPretragaVatrogasniAparati;
    @FXML
    private BorderPane borderPane;
    @FXML
    private Button btnOduzmi;
    @FXML
    private Label lblGodina;
    @FXML
    private Button btnNadodaj;
    @FXML
    private ToolBar toolBarLegend;
    @FXML
    private Region regProsaoRok;
    @FXML
    private Label lblLegenda;
    @FXML
    private Region reg15;
    @FXML
    private Region reg30;
    @FXML
    private Region regviseod30;
    @FXML
    private ToggleButton btnPoruka;
    @FXML
    private ScrollPane scrollPoruka;
    private ObservableList<DjelatnikPregled> listaDjelatnika = FXCollections.observableArrayList();
    private ObservableList<NadzorMjerniInstrumentPregled> listaMjerniInstrumenti = FXCollections.observableArrayList();
    LocalDate datumSjedniceOdbora = null;
    private ObservableList<NadzorStrojPregled> listaStrojeva = FXCollections.observableArrayList();
    private ObservableList<NadzorVAtrogasniAparat> listaVatrogasnihAparata = FXCollections.observableArrayList();
    private ObservableList<FROPregled> listaFRO = FXCollections.observableArrayList();
    private ObservableList<ObjektNadzor> listaObjekti = FXCollections.observableArrayList();
    private ObservableList<DjelatniciPotrebnaOsposobljavanja> listaDjelatniciPotrebnaOsposobljavanja = FXCollections.observableArrayList();
    private static MonitoringNoviController instance;
    private ToolBar tbFilterDjelatnik;
    private ToolBar tbFilterStroj;
    private ToolBar tbFilterObjekt;
    private ToolBar tbFilterFRO;
    private ToolBar tbFilterMjerniUredjaj;
    private ToolBar tbFilterVatrogasniAparat;
    private TextField tfilterDjelatnik;
    private TextField tfilterStroj;
    private TextField tfilterObjekt;
    private TextField tfilterFRO;
    private TextField tfilterMjerniUredjaj;
    private TextField tfilterVatrogasniAparat;
    private ComboBox cbFilterDjelatnik;
    private ComboBox cbFilterStroj;
    private ComboBox cbFilterObjekt;
    private ComboBox cbFilterFRO;
    private ComboBox cbFilterMjerniUredjaj;
    private ComboBox cbFilterVatrogasniAparat;
    private DjelatniciNadzorServiceNovi dservice;
    private ObjektNadzorNoviService oservice;
    private StrojNadzorService sservice;
    private FRONadzorService fservice;
    private MjerniInstrumentiService miservice;
    private SjednicaOdboraService soservice;
    private VatrogasniAparatNadzorService vaservice;
    private DjelatnikPotrebnaOsposobljavanjaService dposervice;
    private boolean isShowing = false;
    ObservableList<Node> listaPoruka = FXCollections.observableArrayList();
    private final CustomPane root = new CustomPane();
    @FXML
    private VBox vBoxRadnici;

    public void setListaDjelatnika(ObservableList<DjelatnikPregled> listaDjelatnika) {
        this.listaDjelatnika = listaDjelatnika;
        this.tablicaDjelatnik.setItems(this.listaDjelatnika);
        int brojDjelatnika = listaDjelatnika.size();
        if (brojDjelatnika >= 50 && BazaMonitoring.provjeriUpozorenje(GlavniPanelController.getOdabranaTvrtka())) {
            this.kreirajNotifikacijuOdbor(Pos.CENTER, " Broj djelatnika je ve\u0107i od 49 morate osnovati odbor u tvrtci", 15);
        }
        this.urediFilterDjelatnik(this.tablicaDjelatnik);
    }

    public void setListaMjerniInstrumenti(ObservableList<NadzorMjerniInstrumentPregled> listaMjerniInstrumenti) {
        this.listaMjerniInstrumenti = listaMjerniInstrumenti;
        this.tablicaMjerniUredjaji.setItems(this.listaMjerniInstrumenti);
        this.urediFilterMJerniUredjaj(this.tablicaMjerniUredjaji);
    }

    void setListaOdbor(LocalDate ld) {
        this.datumSjedniceOdbora = ld;
        if (this.datumSjedniceOdbora != null) {
            this.datumSjedniceOdbora = this.datumSjedniceOdbora.plusMonths(6L);
            LocalDate datePocetni = LocalDate.now();
            LocalDate dateEnd = this.datumSjedniceOdbora;
            Period p = Period.between(datePocetni, dateEnd);
            long p2 = ChronoUnit.DAYS.between(datePocetni, dateEnd);
            if (p2 <= 10L && p2 >= 0L) {
                this.nadodajPoruku(new Poruka("SJEDNICA-ODBORA \npreostalo je jo\u0161 ukupno " + p2 + "  dana "));
            } else if (p2 < 0L) {
                this.nadodajPoruku(new Poruka("SJEDNICA-ODBORA \npro\u0161lo je ukupno " + p2 * -1L + "  dana "));
            }
        }
    }

    public void setListaStrojeva(ObservableList<NadzorStrojPregled> listaStrojeva) {
        this.listaStrojeva = listaStrojeva;
        this.tablicaStrojevi.setItems(this.listaStrojeva);
        this.urediFilterStoj(this.tablicaStrojevi);
    }

    public void setListaVatrogasnihAparata(ObservableList<NadzorVAtrogasniAparat> listaVatrogasnihAparata) {
        this.listaVatrogasnihAparata = listaVatrogasnihAparata;
        this.tablicaVatrogasniAparati.setItems(this.listaVatrogasnihAparata);
        this.urediFilterVatrogasniAparati(this.tablicaVatrogasniAparati);
    }

    public void setListaFRO(ObservableList<FROPregled> listaFRO) {
        this.listaFRO = listaFRO;
        this.tablicaFRO.setItems(this.listaFRO);
        this.urediFiterFRO(this.tablicaFRO);
    }

    public void setListaObjekti(ObservableList<ObjektNadzor> listaObjekti) {
        this.listaObjekti = listaObjekti;
        this.tablicaObjekti.setItems(this.listaObjekti);
        this.urediFiterObjekti(this.tablicaObjekti);
    }

    public void setListaDjelatniciPotrebnaOsposobljavanja(ObservableList<DjelatniciPotrebnaOsposobljavanja> listaDjelatniciPotrebnaOsposobljavanja) {
        this.listaDjelatniciPotrebnaOsposobljavanja = listaDjelatniciPotrebnaOsposobljavanja;
        StringBuilder poruka = new StringBuilder();
        Map<Integer, List<DjelatniciPotrebnaOsposobljavanja>> radniciOsposobljavanja = listaDjelatniciPotrebnaOsposobljavanja.stream().collect(Collectors.groupingBy(Djelatnik::getId));
        for (Map.Entry<Integer, List<DjelatniciPotrebnaOsposobljavanja>> temp : radniciOsposobljavanja.entrySet()) {
            poruka.setLength(0);
            String name = temp.getValue().stream().filter(x -> ((Integer)temp.getKey()).intValue() == x.getId()).map(DjelatniciPotrebnaOsposobljavanja::getDjelatnikOpis).findAny().orElse("");
            poruka.append(name);
            poruka.append("\n____________________________________");
            poruka.append("\nPOTREBNA OSPOSOBLJAVANJA");
            poruka.append("\n---------------------------------------\n");
            temp.getValue().stream().filter(line -> ((Integer)temp.getKey()).intValue() == line.getId()).forEach(l -> poruka.append(l.getNazivOsposobljavanja() + "\n"));
            poruka.append(" ");
            this.nadodajPoruku(new Poruka("DJELATNIK-OSPOSOBLJAVANJE\n" + poruka.toString(), temp.getKey()));
        }
    }

    public static MonitoringNoviController getInstance() {
        return instance;
    }

    public DjelatnikPotrebnaOsposobljavanjaService getDposervice() {
        return this.dposervice;
    }

    public void setDposervice(DjelatnikPotrebnaOsposobljavanjaService dposervice) {
        this.dposervice = dposervice;
    }

    public VatrogasniAparatNadzorService getVaservice() {
        return this.vaservice;
    }

    public void setVaservice(VatrogasniAparatNadzorService vaservice) {
        this.vaservice = vaservice;
    }

    public DjelatniciNadzorServiceNovi getDservice() {
        return this.dservice;
    }

    public void setDservice(DjelatniciNadzorServiceNovi dservice) {
        this.dservice = dservice;
    }

    public ObjektNadzorNoviService getOservice() {
        return this.oservice;
    }

    public void setOservice(ObjektNadzorNoviService oservice) {
        this.oservice = oservice;
    }

    public StrojNadzorService getSservice() {
        return this.sservice;
    }

    public void setSservice(StrojNadzorService sservice) {
        this.sservice = sservice;
    }

    public FRONadzorService getFservice() {
        return this.fservice;
    }

    public void setFservice(FRONadzorService fservice) {
        this.fservice = fservice;
    }

    public MjerniInstrumentiService getMiservice() {
        return this.miservice;
    }

    public void setMiservice(MjerniInstrumentiService miservice) {
        this.miservice = miservice;
    }

    public SjednicaOdboraService getSoservice() {
        return this.soservice;
    }

    public void setSoservice(SjednicaOdboraService soservice) {
        this.soservice = soservice;
    }

    public boolean isIsShowing() {
        return this.isShowing;
    }

    public void setIsShowing(boolean isShowing) {
        this.isShowing = isShowing;
    }

    public void initialize(URL url, ResourceBundle rb) {
        instance = this;
        this.setIsShowing(true);
        this.dservice = new DjelatniciNadzorServiceNovi(this);
        this.oservice = new ObjektNadzorNoviService(this);
        this.sservice = new StrojNadzorService(this);
        this.fservice = new FRONadzorService(this);
        this.miservice = new MjerniInstrumentiService(this);
        this.soservice = new SjednicaOdboraService(this);
        this.vaservice = new VatrogasniAparatNadzorService(this);
        this.dposervice = new DjelatnikPotrebnaOsposobljavanjaService(this);
        SplitPaneDividerSlider glavnidesno0 = new SplitPaneDividerSlider(this.glavniSP, 0, SplitPaneDividerSlider.Direction.RIGHT, Duration.millis((double)1000.0));
        SplitPaneDividerSlider glavnilijevo0 = new SplitPaneDividerSlider(this.glavniSP, 0, SplitPaneDividerSlider.Direction.LEFT, Duration.millis((double)1000.0));
        SplitPaneDividerSlider ljevidole1 = new SplitPaneDividerSlider(this.lijeviSP, 1, SplitPaneDividerSlider.Direction.DOWN, Duration.millis((double)1000.0));
        SplitPaneDividerSlider ljevidole0 = new SplitPaneDividerSlider(this.lijeviSP, 0, SplitPaneDividerSlider.Direction.DOWN, Duration.millis((double)1000.0));
        SplitPaneDividerSlider ljevigore1 = new SplitPaneDividerSlider(this.lijeviSP, 1, SplitPaneDividerSlider.Direction.UP, Duration.millis((double)1000.0));
        SplitPaneDividerSlider ljevigore0 = new SplitPaneDividerSlider(this.lijeviSP, 0, SplitPaneDividerSlider.Direction.UP, Duration.millis((double)1000.0));
        SplitPaneDividerSlider desnidole1 = new SplitPaneDividerSlider(this.desniSP, 1, SplitPaneDividerSlider.Direction.DOWN, Duration.millis((double)1000.0));
        SplitPaneDividerSlider desnidole0 = new SplitPaneDividerSlider(this.desniSP, 0, SplitPaneDividerSlider.Direction.DOWN, Duration.millis((double)1000.0));
        SplitPaneDividerSlider desnigore1 = new SplitPaneDividerSlider(this.desniSP, 1, SplitPaneDividerSlider.Direction.UP, Duration.millis((double)1000.0));
        SplitPaneDividerSlider desnigore0 = new SplitPaneDividerSlider(this.desniSP, 0, SplitPaneDividerSlider.Direction.UP, Duration.millis((double)1000.0));
        this.btnDjelatnik.selectedProperty().addListener((ov, t, t1) -> {
            System.out.println("usao u else " + this.lijeviSP.getDividers().size());
            switch (this.lijeviSP.getDividers().size()) {
                case 0: {
                    glavnidesno0.setAimContentVisible((boolean)t1);
                    break;
                }
                case 1: {
                    this.lijeviSP.setDividerPositions(new double[]{0.5});
                    SplitPaneDividerSlider ljevidole01 = new SplitPaneDividerSlider(this.lijeviSP, 0, SplitPaneDividerSlider.Direction.DOWN, Duration.millis((double)1000.0));
                    glavnidesno0.setAimContentVisible((boolean)t1);
                    ljevidole01.setAimContentVisible((boolean)t1);
                    break;
                }
                case 2: {
                    glavnidesno0.setAimContentVisible((boolean)t1);
                    ljevidole1.setAimContentVisible((boolean)t1);
                    ljevidole0.setAimContentVisible((boolean)t1);
                    break;
                }
            }
            if (!t.booleanValue()) {
                this.btnDjelatnik.setId("btnResize");
            } else {
                this.btnDjelatnik.setId("btnResize-");
            }
        });
        this.btnStroj.selectedProperty().addListener((ov, t, t1) -> {
            switch (this.desniSP.getDividers().size()) {
                case 1: {
                    this.desniSP.setDividerPositions(new double[]{0.5});
                    SplitPaneDividerSlider desnidole01 = new SplitPaneDividerSlider(this.desniSP, 0, SplitPaneDividerSlider.Direction.DOWN, Duration.millis((double)1000.0));
                    glavnilijevo0.setAimContentVisible((boolean)t1);
                    desnidole01.setAimContentVisible((boolean)t1);
                    break;
                }
                case 2: {
                    glavnilijevo0.setAimContentVisible((boolean)t1);
                    desnidole0.setAimContentVisible((boolean)t1);
                    desnidole1.setAimContentVisible((boolean)t1);
                    break;
                }
                default: {
                    System.out.println("usao u else " + this.lijeviSP.getDividers().size());
                    glavnilijevo0.setAimContentVisible((boolean)t1);
                }
            }
            if (!t.booleanValue()) {
                this.btnStroj.setId("btnResize");
            } else {
                this.btnStroj.setId("btnResize-");
            }
        });
        this.btnObjekt.selectedProperty().addListener((ov, t, t1) -> {
            System.out.println("usao u else " + this.lijeviSP.getDividers().size());
            switch (this.lijeviSP.getDividers().size()) {
                case 1: {
                    this.lijeviSP.setDividerPositions(new double[]{0.5});
                    SplitPaneDividerSlider ljevidole00 = new SplitPaneDividerSlider(this.lijeviSP, 0, SplitPaneDividerSlider.Direction.DOWN, Duration.millis((double)1000.0));
                    SplitPaneDividerSlider ljevigore00 = new SplitPaneDividerSlider(this.lijeviSP, 0, SplitPaneDividerSlider.Direction.UP, Duration.millis((double)1000.0));
                    glavnidesno0.setAimContentVisible((boolean)t1);
                    if (!PostavkePrograma.getInstance().isRadnici()) {
                        ljevidole00.setAimContentVisible((boolean)t1);
                    }
                    if (PostavkePrograma.getInstance().isMjernaIspitnaOprema()) break;
                    ljevigore00.setAimContentVisible((boolean)t1);
                    break;
                }
                case 2: {
                    glavnidesno0.setAimContentVisible((boolean)t1);
                    ljevidole1.setAimContentVisible((boolean)t1);
                    ljevigore0.setAimContentVisible((boolean)t1);
                    break;
                }
                default: {
                    glavnidesno0.setAimContentVisible((boolean)t1);
                }
            }
            if (!t.booleanValue()) {
                this.btnObjekt.setId("btnResize");
            } else {
                this.btnObjekt.setId("btnResize-");
            }
        });
        this.btnRAdnaOkolina.selectedProperty().addListener((ov, t, t1) -> {
            switch (this.desniSP.getDividers().size()) {
                case 1: {
                    this.desniSP.setDividerPositions(new double[]{0.5});
                    SplitPaneDividerSlider ljevidole00 = new SplitPaneDividerSlider(this.desniSP, 0, SplitPaneDividerSlider.Direction.DOWN, Duration.millis((double)1000.0));
                    SplitPaneDividerSlider ljevigore00 = new SplitPaneDividerSlider(this.desniSP, 0, SplitPaneDividerSlider.Direction.UP, Duration.millis((double)1000.0));
                    glavnilijevo0.setAimContentVisible((boolean)t1);
                    if (!PostavkePrograma.getInstance().isRadnaOprema()) {
                        ljevidole00.setAimContentVisible((boolean)t1);
                    }
                    if (PostavkePrograma.getInstance().isVatrogasniAparati()) break;
                    ljevigore00.setAimContentVisible((boolean)t1);
                    break;
                }
                case 2: {
                    glavnilijevo0.setAimContentVisible((boolean)t1);
                    desnigore0.setAimContentVisible((boolean)t1);
                    desnidole1.setAimContentVisible((boolean)t1);
                    break;
                }
                default: {
                    glavnilijevo0.setAimContentVisible((boolean)t1);
                }
            }
            if (!t.booleanValue()) {
                this.btnRAdnaOkolina.setId("btnResize");
            } else {
                this.btnRAdnaOkolina.setId("btnResize-");
            }
        });
        this.btnMjerniUredjaj.selectedProperty().addListener((ov, t, t1) -> {
            System.out.println("usao u btnMjerniUredjaj " + this.lijeviSP.getDividers().size());
            switch (this.lijeviSP.getDividers().size()) {
                case 1: {
                    this.lijeviSP.setDividerPositions(new double[]{0.5});
                    SplitPaneDividerSlider ljevidole01 = new SplitPaneDividerSlider(this.lijeviSP, 0, SplitPaneDividerSlider.Direction.UP, Duration.millis((double)1000.0));
                    glavnidesno0.setAimContentVisible((boolean)t1);
                    ljevidole01.setAimContentVisible((boolean)t1);
                    break;
                }
                case 2: {
                    glavnidesno0.setAimContentVisible((boolean)t1);
                    ljevigore1.setAimContentVisible((boolean)t1);
                    ljevigore0.setAimContentVisible((boolean)t1);
                    break;
                }
                default: {
                    glavnidesno0.setAimContentVisible((boolean)t1);
                }
            }
            if (!t.booleanValue()) {
                this.btnMjerniUredjaj.setId("btnResize");
            } else {
                this.btnMjerniUredjaj.setId("btnResize-");
            }
        });
        this.btnVatrogasniAparat.selectedProperty().addListener((ov, t, t1) -> {
            System.out.println("usao u btnVatrogasniAparat " + this.lijeviSP.getDividers().size());
            switch (this.desniSP.getDividers().size()) {
                case 1: {
                    this.desniSP.setDividerPositions(new double[]{0.5});
                    SplitPaneDividerSlider desnidole01 = new SplitPaneDividerSlider(this.desniSP, 0, SplitPaneDividerSlider.Direction.UP, Duration.millis((double)1000.0));
                    glavnilijevo0.setAimContentVisible((boolean)t1);
                    desnidole01.setAimContentVisible((boolean)t1);
                    break;
                }
                case 2: {
                    glavnilijevo0.setAimContentVisible((boolean)t1);
                    desnigore0.setAimContentVisible((boolean)t1);
                    desnigore1.setAimContentVisible((boolean)t1);
                    break;
                }
                default: {
                    glavnilijevo0.setAimContentVisible((boolean)t1);
                }
            }
            if (!t.booleanValue()) {
                this.btnVatrogasniAparat.setId("btnResize");
            } else {
                this.btnVatrogasniAparat.setId("btnResize-");
            }
        });
        this.lblLegenda.heightProperty().addListener((observable, oldValue, newValue) -> Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                MonitoringNoviController.this.regProsaoRok.setPrefSize(MonitoringNoviController.this.lblLegenda.getHeight(), MonitoringNoviController.this.lblLegenda.getHeight());
                MonitoringNoviController.this.reg15.setPrefSize(MonitoringNoviController.this.lblLegenda.getHeight(), MonitoringNoviController.this.lblLegenda.getHeight());
                MonitoringNoviController.this.reg30.setPrefSize(MonitoringNoviController.this.lblLegenda.getHeight(), MonitoringNoviController.this.lblLegenda.getHeight());
                MonitoringNoviController.this.regviseod30.setPrefSize(MonitoringNoviController.this.lblLegenda.getHeight(), MonitoringNoviController.this.lblLegenda.getHeight());
            }
        }));
        this.popuniDjelatnikNadzor();
        this.popuniObjektNadzor();
        this.popuniStrojNadzor();
        this.popuniFRONadzor();
        this.popuniMjerniInstrumentiNadzor();
        this.popuniSjednicaOdboraNadzor();
        this.popuniVatrogasniAparatNadzor();
        this.popuniDjelatnikPotrebnaOsposobljavanja();
        if (LoginControler.getLoginUser().getKorisnik().equals("Korisnik")) {
            if (!PostavkePrograma.getInstance().isObjekti() & !PostavkePrograma.getInstance().isRadnici() & !PostavkePrograma.getInstance().isMjernaIspitnaOprema()) {
                this.glavniSP.getItems().remove((Object)this.lijeviSP);
            }
            if (!PostavkePrograma.getInstance().isRadnaOprema() & !PostavkePrograma.getInstance().isRadnaOkolina() & !PostavkePrograma.getInstance().isVatrogasniAparati()) {
                this.glavniSP.getItems().remove((Object)this.desniSP);
            }
            if (!PostavkePrograma.getInstance().isRadnici()) {
                this.lijeviSP.getItems().remove((Object)this.vBoxRadnici);
                this.lijeviSP.setDividerPositions(new double[]{0.5});
            }
            if (!PostavkePrograma.getInstance().isObjekti()) {
                this.lijeviSP.getItems().remove((Object)this.vBoxObjekti);
                this.lijeviSP.setDividerPositions(new double[]{0.5});
            }
            if (!PostavkePrograma.getInstance().isMjernaIspitnaOprema()) {
                this.lijeviSP.getItems().remove((Object)this.vBoxMjernaOprema);
                this.lijeviSP.setDividerPositions(new double[]{0.5});
            }
            if (!PostavkePrograma.getInstance().isRadnaOprema()) {
                this.desniSP.getItems().remove((Object)this.vBoxRadnaOprema);
                this.desniSP.setDividerPositions(new double[]{0.5});
            }
            if (!PostavkePrograma.getInstance().isRadnaOkolina()) {
                this.desniSP.getItems().remove((Object)this.vBoxRadnaOkolina);
                this.desniSP.setDividerPositions(new double[]{0.5});
            }
            if (!PostavkePrograma.getInstance().isVatrogasniAparati()) {
                this.desniSP.getItems().remove((Object)this.vBoxVatrogasniAparati);
                this.desniSP.setDividerPositions(new double[]{0.5});
            }
            if (this.glavniSP.getDividers().isEmpty() & this.lijeviSP.getDividers().isEmpty()) {
                this.btnDjelatnik.setDisable(true);
                this.btnMjerniUredjaj.setDisable(true);
                this.btnObjekt.setDisable(true);
            }
            if (this.glavniSP.getDividers().isEmpty() & this.desniSP.getDividers().isEmpty()) {
                this.btnStroj.setDisable(true);
                this.btnRAdnaOkolina.setDisable(true);
                this.btnVatrogasniAparat.setDisable(true);
            }
            if (!PostavkePrograma.getInstance().isPoruke()) {
                this.btnPoruka.setDisable(true);
            } else {
                this.kreirajPanelPoruke();
            }
        } else {
            this.kreirajPanelPoruke();
        }
    }

    private void popuniSjednicaOdboraNadzor() {
        this.soservice.start();
    }

    private void popuniDjelatnikPotrebnaOsposobljavanja() {
        this.dposervice.start();
    }

    private void popuniMjerniInstrumentiNadzor() {
        ProgressIndicator progressIndicator1 = new ProgressIndicator();
        this.kreirajToolBarFIlterMjerniUredjaj();
        this.urediKoloneUTabliciMJerniUredjaj();
        this.tablicaMjerniUredjaji.setPlaceholder((Node)progressIndicator1);
        progressIndicator1.setMaxSize(200.0, 200.0);
        progressIndicator1.progressProperty().bind((ObservableValue)this.miservice.progressProperty());
        progressIndicator1.visibleProperty().bind((ObservableValue)this.miservice.runningProperty());
        this.miservice.start();
    }

    private void popuniFRONadzor() {
        ProgressIndicator progressIndicator2 = new ProgressIndicator();
        this.kreirajToolBarFIlterFRO();
        this.urediKoloneUTabliciFRO();
        this.tablicaFRO.setPlaceholder((Node)progressIndicator2);
        progressIndicator2.setMaxSize(200.0, 200.0);
        progressIndicator2.progressProperty().bind((ObservableValue)this.fservice.progressProperty());
        progressIndicator2.visibleProperty().bind((ObservableValue)this.fservice.runningProperty());
        this.fservice.start();
    }

    private void kreirajToolBarFIlterFRO() {
        this.tbFilterFRO = new ToolBar();
        this.tfilterFRO = new TextField();
        this.tfilterFRO.setPromptText("Filter");
        this.tfilterFRO.setId("textField");
        this.cbFilterFRO = new ComboBox();
        ObservableList filter = FXCollections.observableArrayList((Object[])new String[]{"Poslovna jedinica", "Mjerno mjesto"});
        this.cbFilterFRO.getItems().addAll((Collection)filter);
        this.cbFilterFRO.setValue((Object)"Mjerno mjesto");
        this.cbFilterFRO.setPrefWidth(200.0);
        this.tfilterFRO.setPrefWidth(200.0);
        this.tfilterFRO.setPrefHeight(25.0);
        this.tbFilterFRO.getItems().addAll((Object[])new Node[]{this.tfilterFRO, this.cbFilterFRO, MenuButtonReporti.getMenuButtonFROIspis()});
    }

    private void urediKoloneUTabliciFRO() {
        TableColumn pj = new TableColumn("POSLOVNA JEDINICA");
        pj.setCellValueFactory(cellData -> ((FROPregled)cellData.getValue()).poslovnaJedinicaProperty());
        pj.prefWidthProperty().bind((ObservableValue)this.tablicaFRO.widthProperty().divide(3.3333333333333335));
        pj.setStyle("-fx-alignment: CENTER;");
        TableColumn mjernoMjesto = new TableColumn("MJERNO MJESTO");
        mjernoMjesto.setCellValueFactory(cellData -> ((FROPregled)cellData.getValue()).nazivMjernogMjestaProperty());
        mjernoMjesto.prefWidthProperty().bind((ObservableValue)this.tablicaFRO.widthProperty().divide(2.5));
        mjernoMjesto.setStyle("-fx-alignment: CENTER;");
        Callback dateCellFactory1 = param -> new DatumValueCell();
        TableColumn datumIspitivanja = new TableColumn("DATUM ISPITIVANJA M.M");
        datumIspitivanja.setCellValueFactory((Callback)new PropertyValueFactory("datumIstekaPregleda"));
        datumIspitivanja.prefWidthProperty().bind((ObservableValue)this.tablicaFRO.widthProperty().divide(3.3333333333333335));
        datumIspitivanja.setCellFactory(dateCellFactory1);
        datumIspitivanja.setStyle("-fx-alignment: CENTER;");
        this.kolPretragaFRO.setGraphic((Node)this.tbFilterFRO);
        this.kolPretragaFRO.getColumns().addAll(new Object[]{pj, mjernoMjesto, datumIspitivanja});
    }

    private void urediFiterFRO(TableView<FROPregled> tablicaFRO) {
        FilteredList filteredData = new FilteredList(this.listaFRO, p -> true);
        this.tfilterFRO.textProperty().addListener((observable, oldValue, newValue) -> filteredData.setPredicate(pregled -> {
            if (newValue == null || newValue.isEmpty()) {
                return true;
            }
            String lowerCaseFilter = newValue.toLowerCase();
            return this.cbFilterFRO.getSelectionModel().getSelectedItem().equals("Poslovna jedinica") ? pregled.getPoslovnaJedinica() != null && pregled.getPoslovnaJedinica().toLowerCase().startsWith(lowerCaseFilter) : this.cbFilterFRO.getSelectionModel().getSelectedItem().equals("Mjerno mjesto") && pregled.getNazivMjernogMjesta() != null && pregled.getNazivMjernogMjesta().toLowerCase().startsWith(lowerCaseFilter);
        }));
        SortedList sortedData = new SortedList((ObservableList)filteredData);
        sortedData.comparatorProperty().bind((ObservableValue)tablicaFRO.comparatorProperty());
        tablicaFRO.setItems((ObservableList)sortedData);
    }

    private void popuniStrojNadzor() {
        ProgressIndicator progressIndicator1 = new ProgressIndicator();
        this.kreirajToolBarFIlterStroj();
        this.urediKoloneUTabliciStrojevi();
        this.tablicaStrojevi.setPlaceholder((Node)progressIndicator1);
        progressIndicator1.setMaxSize(200.0, 200.0);
        progressIndicator1.progressProperty().bind((ObservableValue)this.sservice.progressProperty());
        progressIndicator1.visibleProperty().bind((ObservableValue)this.sservice.runningProperty());
        this.sservice.start();
    }

    private void urediKoloneUTabliciStrojevi() {
        TableColumn pj = new TableColumn("POSLOVNA JEDINICA");
        pj.setCellValueFactory(cellData -> ((NadzorStrojPregled)cellData.getValue()).poslovnajedinicaProperty());
        pj.prefWidthProperty().bind((ObservableValue)this.tablicaStrojevi.widthProperty().divide(5.0));
        pj.setStyle("-fx-alignment: CENTER;");
        TableColumn od = new TableColumn("ODJEL");
        od.setCellValueFactory(cellData -> ((NadzorStrojPregled)cellData.getValue()).odjelProperty());
        od.prefWidthProperty().bind((ObservableValue)this.tablicaStrojevi.widthProperty().divide(6.666666666666667));
        od.setStyle("-fx-alignment: CENTER;");
        TableColumn invBroj = new TableColumn("INV. BROJ");
        invBroj.setCellValueFactory(cellData -> ((NadzorStrojPregled)cellData.getValue()).inventurnibrojProperty());
        invBroj.prefWidthProperty().bind((ObservableValue)this.tablicaStrojevi.widthProperty().divide(10.0));
        invBroj.setStyle("-fx-alignment: CENTER;");
        TableColumn tvBroj = new TableColumn("TV. BROJ");
        tvBroj.setCellValueFactory(cellData -> ((NadzorStrojPregled)cellData.getValue()).tvornickibrojProperty());
        tvBroj.prefWidthProperty().bind((ObservableValue)this.tablicaStrojevi.widthProperty().divide(10.0));
        tvBroj.setStyle("-fx-alignment: CENTER;");
        TableColumn naziv = new TableColumn("NAZIV");
        naziv.setCellValueFactory(cellData -> ((NadzorStrojPregled)cellData.getValue()).nazivstrojaProperty());
        naziv.prefWidthProperty().bind((ObservableValue)this.tablicaStrojevi.widthProperty().divide(3.3333333333333335));
        naziv.setStyle("-fx-alignment: CENTER;");
        Callback dateCellFactory1 = param -> new DatumValueCell();
        TableColumn datumIspitivanja = new TableColumn("DATUM ISPITIVANJA");
        datumIspitivanja.setCellValueFactory((Callback)new PropertyValueFactory("datumIstekaPregleda"));
        datumIspitivanja.prefWidthProperty().bind((ObservableValue)this.tablicaStrojevi.widthProperty().divide(7.142857142857143));
        datumIspitivanja.setCellFactory(dateCellFactory1);
        datumIspitivanja.setStyle("-fx-alignment: CENTER;");
        this.kolPretragaStrojevi.setGraphic((Node)this.tbFilterStroj);
        this.kolPretragaStrojevi.getColumns().addAll(new Object[]{invBroj, tvBroj, naziv, datumIspitivanja, pj, od});
    }

    private void kreirajToolBarFIlterStroj() {
        this.tbFilterStroj = new ToolBar();
        this.tfilterStroj = new TextField();
        this.tfilterStroj.setPromptText("Filter");
        this.tfilterStroj.setId("textField");
        this.cbFilterStroj = new ComboBox();
        ObservableList filter = FXCollections.observableArrayList((Object[])new String[]{"Naziv", "Inventurni broj", "Poslovna jedinica", "Tv. Broj"});
        this.cbFilterStroj.getItems().addAll((Collection)filter);
        this.cbFilterStroj.setValue((Object)"Naziv");
        this.cbFilterStroj.setPrefWidth(200.0);
        this.tfilterStroj.setPrefWidth(200.0);
        this.tfilterStroj.setPrefHeight(25.0);
        this.tbFilterStroj.getItems().addAll((Object[])new Node[]{this.tfilterStroj, this.cbFilterStroj, MenuButtonReporti.getMenuButtonIspisStrojeva()});
    }

    private void popuniObjektNadzor() {
        ProgressIndicator progressIndicator3 = new ProgressIndicator();
        this.kreirajToolBarFIlterObjekt();
        this.urediKoloneUTabliciObjekt();
        this.tablicaObjekti.setPlaceholder((Node)progressIndicator3);
        progressIndicator3.setMaxSize(200.0, 200.0);
        progressIndicator3.progressProperty().bind((ObservableValue)this.oservice.progressProperty());
        progressIndicator3.visibleProperty().bind((ObservableValue)this.oservice.runningProperty());
        this.oservice.start();
    }

    private void urediKoloneUTabliciObjekt() {
        TableColumn pjo = new TableColumn("POSLOVNA JEDINICA");
        pjo.setCellValueFactory(cellData -> ((ObjektNadzor)cellData.getValue()).poslovnaJedinicaProperty());
        pjo.prefWidthProperty().bind((ObservableValue)this.tablicaObjekti.widthProperty().divide(3.3333333333333335));
        pjo.setStyle("-fx-alignment: CENTER;");
        TableColumn objekt = new TableColumn("NAZIV OBJEKTA");
        objekt.setCellValueFactory(cellData -> ((ObjektNadzor)cellData.getValue()).nazivObjektaProperty());
        objekt.prefWidthProperty().bind((ObservableValue)this.tablicaObjekti.widthProperty().divide(2.5));
        objekt.setStyle("-fx-alignment: CENTER;");
        Callback dateCellFactory1 = param -> new DatumValueCell();
        TableColumn datumPonovogIspitivanja = new TableColumn("DATUM ISPITIVANJA OBJEKTA");
        datumPonovogIspitivanja.setCellValueFactory((Callback)new PropertyValueFactory("datumPonovogIspitivanja"));
        datumPonovogIspitivanja.prefWidthProperty().bind((ObservableValue)this.tablicaObjekti.widthProperty().divide(3.3333333333333335));
        datumPonovogIspitivanja.setCellFactory(dateCellFactory1);
        datumPonovogIspitivanja.setStyle("-fx-alignment: CENTER;");
        this.kolPretragaObjekti.setGraphic((Node)this.tbFilterObjekt);
        this.kolPretragaObjekti.getColumns().addAll(new Object[]{pjo, objekt, datumPonovogIspitivanja});
    }

    private void kreirajToolBarFIlterObjekt() {
        this.tbFilterObjekt = new ToolBar();
        this.tfilterObjekt = new TextField();
        this.tfilterObjekt.setPromptText("Filter");
        this.tfilterObjekt.setId("textField");
        this.cbFilterObjekt = new ComboBox();
        ObservableList filter = FXCollections.observableArrayList((Object[])new String[]{"Poslovna jedinica", "Naziv objekta"});
        this.cbFilterObjekt.getItems().addAll((Collection)filter);
        this.cbFilterObjekt.setValue((Object)"Naziv objekta");
        this.cbFilterObjekt.setPrefWidth(200.0);
        this.tfilterObjekt.setPrefWidth(200.0);
        this.tfilterObjekt.setPrefHeight(25.0);
        this.tbFilterObjekt.getItems().addAll((Object[])new Node[]{this.tfilterObjekt, this.cbFilterObjekt, MenuButtonReporti.getMenuButtonObjektiIspis()});
    }

    private void popuniDjelatnikNadzor() {
        ProgressIndicator progressIndicatorDjelatnik = new ProgressIndicator();
        this.kreirajToolBarFIlterDjelatnik();
        this.urediKoloneUTablicuDjeletnici();
        this.tablicaDjelatnik.setPlaceholder((Node)progressIndicatorDjelatnik);
        progressIndicatorDjelatnik.setMaxSize(200.0, 200.0);
        progressIndicatorDjelatnik.progressProperty().bind((ObservableValue)this.dservice.progressProperty());
        progressIndicatorDjelatnik.visibleProperty().bind((ObservableValue)this.dservice.runningProperty());
        this.dservice.start();
    }

    private void urediKoloneUTablicuDjeletnici() {
        Callback dateCellFactory1 = param -> new DatumValueCell();
        TableColumn poslovnaJedninica = new TableColumn("POSLOVNA JEDINICA");
        poslovnaJedninica.setCellValueFactory(cellData -> ((DjelatnikPregled)cellData.getValue()).poslovnaJedinicaProperty());
        poslovnaJedninica.prefWidthProperty().bind((ObservableValue)this.tablicaDjelatnik.widthProperty().divide(6.666666666666667));
        poslovnaJedninica.setStyle("-fx-alignment: CENTER;");
        TableColumn oib = new TableColumn("OIB");
        oib.setCellValueFactory(cellData -> ((DjelatnikPregled)cellData.getValue()).OIBProperty());
        oib.prefWidthProperty().bind((ObservableValue)this.tablicaDjelatnik.widthProperty().divide(6.666666666666667));
        oib.setMaxWidth(120.0);
        oib.setStyle("-fx-alignment: CENTER;");
        TableColumn ime = new TableColumn("IME");
        ime.setCellValueFactory(cellData -> ((DjelatnikPregled)cellData.getValue()).imeProperty());
        ime.prefWidthProperty().bind((ObservableValue)this.tablicaDjelatnik.widthProperty().divide(5.0));
        ime.setMaxWidth(200.0);
        ime.setStyle("-fx-alignment: CENTER;");
        TableColumn prezime = new TableColumn("PREZIME");
        prezime.setCellValueFactory(cellData -> ((DjelatnikPregled)cellData.getValue()).prezimeProperty());
        prezime.prefWidthProperty().bind((ObservableValue)this.tablicaDjelatnik.widthProperty().divide(5.0));
        prezime.setMaxWidth(200.0);
        prezime.setStyle("-fx-alignment: CENTER;");
        TableColumn kolRA1 = new TableColumn("RA-1");
        kolRA1.setCellValueFactory(cellData -> ((DjelatnikPregled)cellData.getValue()).datumIzdavanjaUputniceProperty());
        kolRA1.setStyle("-fx-alignment: CENTER;");
        kolRA1.setEditable(false);
        kolRA1.setCellFactory((Callback)new Callback<TableColumn<DjelatnikPregled, LocalDate>, TableCell<DjelatnikPregled, LocalDate>>(){

            public TableCell<DjelatnikPregled, LocalDate> call(TableColumn<DjelatnikPregled, LocalDate> stringStringTableColumn) {
                return new TableCell<DjelatnikPregled, LocalDate>(){

                    protected void updateItem(LocalDate item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        DjelatnikPregled d = (DjelatnikPregled)this.getTableRow().getItem();
                        this.addEventFilter(MouseEvent.MOUSE_CLICKED, (EventHandler)new EventHandler<MouseEvent>(){

                            public void handle(MouseEvent event) {
                                if (event.getClickCount() > 1) {
                                    TableCell c = (TableCell)event.getSource();
                                    if (!GlavniPanelController.getInstance().getTabByIdifExist("Obrazac RA-1")) {
                                        GlavniPanelController.getInstance().zatvoriTab("Obrazac RA-1");
                                        GlavniPanelController.getInstance().nadodajPanel("Obrazac RA-1", "/uputnice/PregledRA1.fxml");
                                    } else {
                                        GlavniPanelController.getInstance().nadodajPanel("Obrazac RA-1", "/uputnice/PregledRA1.fxml");
                                    }
                                }
                            }
                        });
                        if (empty) {
                            this.setText(null);
                            this.setGraphic(null);
                            this.setStyle(null);
                            this.setTooltip(null);
                        } else if (item == null) {
                            this.setText("---");
                            this.setStyle(null);
                            this.setTooltip(null);
                            this.setGraphic(null);
                        } else if (item != null) {
                            this.setCursor(Cursor.HAND);
                            if (d != null) {
                                if (d.getDatumIstekaLJPregleda() != null) {
                                    this.izracunaj(item, d);
                                } else {
                                    this.setText(item.format(DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM)));
                                    this.setStyle("-fx-background-color:-fx-table-cell-border-color, lightblue  ;-fx-background-insets: 0, 0 0 1 0; -fx-padding: 0.0em; -fx-alignment: CENTER;");
                                }
                            }
                        } else {
                            this.setText(null);
                            this.setGraphic(null);
                        }
                    }

                    private void izracunaj(LocalDate d, DjelatnikPregled dj) {
                        Tooltip tip = new Tooltip();
                        tip.setStyle("-fx-font-size:12pt;-fx-text-fill:white");
                        LocalDate datePocetni = LocalDate.now();
                        LocalDate dateEnd = dj.getDatumIstekaLJPregleda();
                        if (dateEnd != null) {
                            Period p = Period.between(datePocetni, dateEnd);
                            long p2 = ChronoUnit.DAYS.between(datePocetni, dateEnd);
                            if (p2 < 0L) {
                                this.setStyle("-fx-background-color:-fx-table-cell-border-color, darkgray ;-fx-background-insets: 0, 0 0 1 0; -fx-padding: 0.0em; -fx-alignment: CENTER;");
                                this.setText(d.format(DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM)));
                                tip.setText("Pro\u0161lo je vi\u0161e od " + p.getYears() + " god. " + p.getMonths() + " mj. ,\n i  " + p.getDays() + " dana od izdavanja uputnice za obavljanje pregleda .\n ( ukupno  " + p2 + "  dana )");
                                this.setTooltip(tip);
                                this.setGraphic(null);
                            } else if (p2 <= 15L || p2 == 0L) {
                                this.setStyle("-fx-background-color:-fx-table-cell-border-color, red ;-fx-background-insets: 0, 0 0 1 0; -fx-padding: 0.0em; -fx-alignment: CENTER;");
                                this.setText(d.format(DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM)));
                                tip.setText("Preostalo jo\u0161 " + p.getYears() + " god. " + p.getMonths() + " mj.,\n i " + p.getDays() + "  dana do sljede\u0107eg lje\u010dni\u010dkog pregleda. \n( ukupno  " + p2 + "  dana )");
                                this.setTooltip(tip);
                                this.setGraphic(null);
                            } else if (p2 <= 30L) {
                                this.setStyle("-fx-background-color:-fx-table-cell-border-color, goldenrod ;-fx-background-insets: 0, 0 0 1 0; -fx-padding: 0.0em; -fx-alignment: CENTER;");
                                this.setText(d.format(DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM)));
                                tip.setText("Preostalo jo\u0161 " + p.getYears() + " god. " + p.getMonths() + " mj,\n i " + p.getDays() + "  dana do sljede\u0107eg lje\u010dni\u010dkog pregleda. \n( ukupno  " + p2 + "  dana )");
                                this.setTooltip(tip);
                                this.setGraphic(null);
                            } else if (p2 > 30L) {
                                this.setStyle("-fx-background-color:-fx-table-cell-border-color, yellowgreen ;-fx-background-insets: 0, 0 0 1 0; -fx-padding: 0.0em; -fx-alignment: CENTER;");
                                this.setText(d.format(DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM)));
                                tip.setText("Preostalo jo\u0161 " + p.getYears() + " god. " + p.getMonths() + " mj,\n i " + p.getDays() + "  dana sljede\u0107eg lje\u010dni\u010dkog pregleda. \n( ukupno  " + p2 + "  dana )");
                                this.setTooltip(tip);
                                this.setGraphic(null);
                            } else {
                                this.setTooltip(null);
                                this.setGraphic(null);
                                Tooltip.uninstall((Node)this, (Tooltip)tip);
                            }
                        } else {
                            this.setText("---");
                            this.setStyle(null);
                            this.setTooltip(null);
                            this.setGraphic(null);
                            Tooltip.uninstall((Node)this, (Tooltip)tip);
                        }
                    }
                };
            }
        });
        TableColumn kolNr1 = new TableColumn("NR-1");
        kolNr1.setCellValueFactory(cellData -> ((DjelatnikPregled)cellData.getValue()).datumIzdavanjaNr1UputniceProperty());
        kolNr1.setStyle("-fx-alignment: CENTER;");
        kolNr1.setCellFactory((Callback)new Callback<TableColumn<DjelatnikPregled, LocalDate>, TableCell<DjelatnikPregled, LocalDate>>(){

            public TableCell<DjelatnikPregled, LocalDate> call(TableColumn<DjelatnikPregled, LocalDate> stringStringTableColumn) {
                return new TableCell<DjelatnikPregled, LocalDate>(){

                    protected void updateItem(LocalDate item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        DjelatnikPregled d = (DjelatnikPregled)this.getTableRow().getItem();
                        this.addEventFilter(MouseEvent.MOUSE_CLICKED, (EventHandler)new EventHandler<MouseEvent>(){

                            public void handle(MouseEvent event) {
                                if (event.getClickCount() > 1) {
                                    TableCell c = (TableCell)event.getSource();
                                    if (!GlavniPanelController.getInstance().getTabByIdifExist("Obrazac NR-1")) {
                                        GlavniPanelController.getInstance().zatvoriTab("Obrazac NR-1");
                                        GlavniPanelController.getInstance().nadodajPanel("Obrazac NR-1", "/nr1/PregledNR1.fxml");
                                    } else {
                                        GlavniPanelController.getInstance().nadodajPanel("Obrazac NR-1", "/nr1/PregledNR1.fxml");
                                    }
                                }
                            }
                        });
                        if (empty) {
                            this.setText(null);
                            this.setGraphic(null);
                            this.setStyle(null);
                            this.setTooltip(null);
                        } else if (item == null) {
                            this.setText("---");
                            this.setStyle(null);
                            this.setTooltip(null);
                            this.setGraphic(null);
                        } else if (item != null) {
                            this.setCursor(Cursor.HAND);
                            if (d != null) {
                                if (d.getDatumIstekaLJPregleda() != null) {
                                    this.izracunaj(item, d);
                                } else {
                                    this.setText(item.format(DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM)));
                                    this.setStyle("-fx-background-color:-fx-table-cell-border-color, lightblue  ;-fx-background-insets: 0, 0 0 1 0; -fx-padding: 0.0em; -fx-alignment: CENTER;");
                                }
                            }
                        } else {
                            this.setText(null);
                            this.setGraphic(null);
                        }
                    }

                    private void izracunaj(LocalDate d, DjelatnikPregled dj) {
                        Tooltip tip = new Tooltip();
                        tip.setStyle("-fx-font-size:12pt;-fx-text-fill:white");
                        LocalDate datePocetni = LocalDate.now();
                        LocalDate dateEnd = dj.getDatumIstekaLJPregleda();
                        if (dateEnd != null) {
                            Period p = Period.between(datePocetni, dateEnd);
                            long p2 = ChronoUnit.DAYS.between(datePocetni, dateEnd);
                            if (p2 < 0L) {
                                this.setStyle("-fx-background-color:-fx-table-cell-border-color, darkgray ;-fx-background-insets: 0, 0 0 1 0; -fx-padding: 0.0em; -fx-alignment: CENTER;");
                                this.setText(d.format(DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM)));
                                tip.setText("Pro\u0161lo je vi\u0161e od " + p.getYears() + " god. " + p.getMonths() + " mj. ,\n i  " + p.getDays() + " dana od izdavanja uputnice za obavljanje pregleda .\n ( ukupno  " + p2 + "  dana )");
                                this.setTooltip(tip);
                                this.setGraphic(null);
                            } else if (p2 <= 15L || p2 == 0L) {
                                this.setStyle("-fx-background-color:-fx-table-cell-border-color, red ;-fx-background-insets: 0, 0 0 1 0; -fx-padding: 0.0em; -fx-alignment: CENTER;");
                                this.setText(d.format(DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM)));
                                tip.setText("Preostalo jo\u0161 " + p.getYears() + " god. " + p.getMonths() + " mj.,\n i " + p.getDays() + "  dana do sljede\u0107eg lje\u010dni\u010dkog pregleda. \n( ukupno  " + p2 + "  dana )");
                                this.setTooltip(tip);
                                this.setGraphic(null);
                            } else if (p2 <= 30L) {
                                this.setStyle("-fx-background-color:-fx-table-cell-border-color, goldenrod ;-fx-background-insets: 0, 0 0 1 0; -fx-padding: 0.0em; -fx-alignment: CENTER;");
                                this.setText(d.format(DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM)));
                                tip.setText("Preostalo jo\u0161 " + p.getYears() + " god. " + p.getMonths() + " mj,\n i " + p.getDays() + "  dana do sljede\u0107eg lje\u010dni\u010dkog pregleda. \n( ukupno  " + p2 + "  dana )");
                                this.setTooltip(tip);
                                this.setGraphic(null);
                            } else if (p2 > 30L) {
                                this.setStyle("-fx-background-color:-fx-table-cell-border-color, yellowgreen ;-fx-background-insets: 0, 0 0 1 0; -fx-padding: 0.0em; -fx-alignment: CENTER;");
                                this.setText(d.format(DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM)));
                                tip.setText("Preostalo jo\u0161 " + p.getYears() + " god. " + p.getMonths() + " mj,\n i " + p.getDays() + "  dana sljede\u0107eg lje\u010dni\u010dkog pregleda. \n( ukupno  " + p2 + "  dana )");
                                this.setTooltip(tip);
                                this.setGraphic(null);
                            } else {
                                this.setTooltip(null);
                                this.setGraphic(null);
                                Tooltip.uninstall((Node)this, (Tooltip)tip);
                            }
                        } else {
                            this.setText("---");
                            this.setStyle(null);
                            this.setTooltip(null);
                            this.setGraphic(null);
                            Tooltip.uninstall((Node)this, (Tooltip)tip);
                        }
                    }
                };
            }
        });
        TableColumn kolUputnice = new TableColumn("IZDANE UPUTNICE");
        kolUputnice.getColumns().addAll((Object[])new TableColumn[]{kolRA1, kolNr1});
        kolRA1.prefWidthProperty().bind((ObservableValue)kolUputnice.widthProperty().divide(2.0408163265306123));
        kolNr1.prefWidthProperty().bind((ObservableValue)kolUputnice.widthProperty().divide(2.0408163265306123));
        TableColumn colRa = new TableColumn("LJE\u010cNI\u010cKI PREGLED");
        colRa.setCellValueFactory((Callback)new PropertyValueFactory("datumIstekaLJPregleda"));
        colRa.prefWidthProperty().bind((ObservableValue)this.tablicaDjelatnik.widthProperty().divide(6.666666666666667));
        colRa.setCellFactory(dateCellFactory1);
        colRa.setStyle("-fx-alignment: CENTER;");
        Callback dateCellozo = param -> new DatumValueCell();
        TableColumn ozo = new TableColumn("OZO");
        ozo.prefWidthProperty().bind((ObservableValue)this.tablicaDjelatnik.widthProperty().divide(10.0));
        ozo.setCellValueFactory(cellData -> ((DjelatnikPregled)cellData.getValue()).ozoProperty());
        ozo.setCellFactory(dateCellozo);
        ozo.setStyle("-fx-alignment: CENTER;");
        TableColumn osposobljavanje = new TableColumn("OSPOSOBLJAVANJE");
        osposobljavanje.prefWidthProperty().bind((ObservableValue)this.tablicaDjelatnik.widthProperty().divide(10.0));
        osposobljavanje.setCellValueFactory(cellData -> ((DjelatnikPregled)cellData.getValue()).osposobljavanjeProperty());
        osposobljavanje.setCellFactory(dateCellozo);
        osposobljavanje.setStyle("-fx-alignment: CENTER;");
        TableColumn ostaliPregled = new TableColumn("OSTALI PREGLEDI");
        ostaliPregled.prefWidthProperty().bind((ObservableValue)this.tablicaDjelatnik.widthProperty().divide(10.0));
        ostaliPregled.setCellValueFactory(cellData -> ((DjelatnikPregled)cellData.getValue()).ostaliPregledProperty());
        ostaliPregled.setCellFactory(dateCellozo);
        ostaliPregled.setStyle("-fx-alignment: CENTER;");
        this.kolPretragaDjelatnik.setGraphic((Node)this.tbFilterDjelatnik);
        this.kolPretragaDjelatnik.getColumns().addAll(new Object[]{oib, ime, prezime, kolUputnice, colRa, ozo, osposobljavanje, ostaliPregled, poslovnaJedninica});
    }

    private void kreirajToolBarFIlterDjelatnik() {
        this.tbFilterDjelatnik = new ToolBar();
        this.tfilterDjelatnik = new TextField();
        this.tfilterDjelatnik.setPromptText("Filter");
        this.tfilterDjelatnik.setId("textField");
        this.cbFilterDjelatnik = new ComboBox();
        ObservableList filter = FXCollections.observableArrayList((Object[])new String[]{"OIB", "Prezime", "Poslovna jedinica"});
        this.cbFilterDjelatnik.getItems().addAll((Collection)filter);
        this.cbFilterDjelatnik.setValue((Object)"OIB");
        this.cbFilterDjelatnik.setPrefWidth(200.0);
        this.tfilterDjelatnik.setPrefWidth(200.0);
        this.tfilterDjelatnik.setPrefHeight(25.0);
        this.tbFilterDjelatnik.getItems().addAll((Object[])new Node[]{this.tfilterDjelatnik, this.cbFilterDjelatnik, MenuButtonReporti.getMenuButtonIspisRadnika()});
    }

    private void urediFilterDjelatnik(TableView tablicaPregleda) {
        FilteredList filteredData = new FilteredList(this.listaDjelatnika, p -> true);
        this.tfilterDjelatnik.textProperty().addListener((observable, oldValue, newValue) -> filteredData.setPredicate(pregled -> {
            if (newValue == null || newValue.isEmpty()) {
                return true;
            }
            String lowerCaseFilter = newValue.toLowerCase();
            return this.cbFilterDjelatnik.getSelectionModel().getSelectedItem().equals("OIB") ? pregled.getOIB() != null && pregled.getOIB().toLowerCase().startsWith(lowerCaseFilter) : (this.cbFilterDjelatnik.getSelectionModel().getSelectedItem().equals("Prezime") ? pregled.getPrezime() != null && pregled.getPrezime().toLowerCase().startsWith(lowerCaseFilter) : this.cbFilterDjelatnik.getSelectionModel().getSelectedItem().equals("Poslovna jedinica") && pregled.getPoslovnaJedinica() != null && pregled.getPoslovnaJedinica().toLowerCase().startsWith(lowerCaseFilter));
        }));
        SortedList sortedData = new SortedList((ObservableList)filteredData);
        sortedData.comparatorProperty().bind((ObservableValue)tablicaPregleda.comparatorProperty());
        tablicaPregleda.setItems((ObservableList)sortedData);
    }

    private void urediFiterObjekti(TableView<ObjektNadzor> tablicaObjekti) {
        FilteredList filteredData = new FilteredList(this.listaObjekti, p -> true);
        this.tfilterObjekt.textProperty().addListener((observable, oldValue, newValue) -> filteredData.setPredicate(pregled -> {
            if (newValue == null || newValue.isEmpty()) {
                return true;
            }
            String lowerCaseFilter = newValue.toLowerCase();
            return this.cbFilterObjekt.getSelectionModel().getSelectedItem().equals("Poslovna jedinica") ? pregled.getPoslovnaJedinica() != null && pregled.getPoslovnaJedinica().toLowerCase().startsWith(lowerCaseFilter) : this.cbFilterObjekt.getSelectionModel().getSelectedItem().equals("Naziv objekta") && pregled.getNazivObjekta() != null && pregled.getNazivObjekta().toLowerCase().startsWith(lowerCaseFilter);
        }));
        SortedList sortedData = new SortedList((ObservableList)filteredData);
        sortedData.comparatorProperty().bind((ObservableValue)tablicaObjekti.comparatorProperty());
        tablicaObjekti.setItems((ObservableList)sortedData);
    }

    public void kreirajNotifikacijuOdbor(Pos pos, String text, int duration) {
        Notifications notificationBuilder = null;
        final CheckBox cb = new CheckBox("Ne prikazuj ovu poruku");
        cb.setStyle("-fx-text-fill: white; -fx-font-size: 0.8em;");
        cb.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> ov, Boolean old_val, Boolean new_val) {
                if (cb.isSelected()) {
                    if (!BazaMonitoring.potvrdiProvjeru(cb.isSelected(), GlavniPanelController.getOdabranaTvrtka())) {
                        KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161an unos", 2, "Error graphic");
                    }
                    cb.setDisable(true);
                }
            }
        });
        Label poruka = new Label(text);
        poruka.setAlignment(Pos.CENTER);
        poruka.setWrapText(true);
        poruka.setTextAlignment(TextAlignment.RIGHT);
        Label TitleLable = new Label("Poruka");
        TitleLable.setAlignment(Pos.TOP_LEFT);
        TitleLable.setStyle("-fx-font-weight: bold;-fx-font-size: 1.2em;");
        BorderPane bp = new BorderPane();
        bp.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        bp.setLeft((Node)new VBox(new Node[]{TitleLable}));
        cb.setAlignment(Pos.BOTTOM_LEFT);
        VBox vb = new VBox(new Node[]{poruka, cb});
        vb.setSpacing(10.0);
        bp.setBottom((Node)vb);
        notificationBuilder = Notifications.create().graphic((Node)bp).position(pos).darkStyle();
        notificationBuilder.show();
    }

    private void urediFilterStoj(TableView<NadzorStrojPregled> tablicaStrojevi) {
        FilteredList filteredData = new FilteredList(this.listaStrojeva, p -> true);
        this.tfilterStroj.textProperty().addListener((observable, oldValue, newValue) -> filteredData.setPredicate(pregled -> {
            if (newValue == null || newValue.isEmpty()) {
                return true;
            }
            String lowerCaseFilter = newValue.toLowerCase();
            return this.cbFilterStroj.getSelectionModel().getSelectedItem().equals("Naziv") ? pregled.getNazivstroja() != null && pregled.getNazivstroja().toLowerCase().startsWith(lowerCaseFilter) : (this.cbFilterStroj.getSelectionModel().getSelectedItem().equals("Inventurni broj") ? pregled.getInventurnibroj() != null && pregled.getInventurnibroj().toLowerCase().startsWith(lowerCaseFilter) : (this.cbFilterStroj.getSelectionModel().getSelectedItem().equals("Poslovna jedinica") ? pregled.getPoslovnajedinica() != null && pregled.getPoslovnajedinica().toLowerCase().startsWith(lowerCaseFilter) : this.cbFilterStroj.getSelectionModel().getSelectedItem().equals("Tv. Broj") && pregled.getTvornickibroj() != null && pregled.getTvornickibroj().toLowerCase().startsWith(lowerCaseFilter)));
        }));
        SortedList sortedData = new SortedList((ObservableList)filteredData);
        sortedData.comparatorProperty().bind((ObservableValue)tablicaStrojevi.comparatorProperty());
        tablicaStrojevi.setItems((ObservableList)sortedData);
    }

    private void setColorStringFromColor(StringProperty colorStringProperty, ObjectProperty<Color> color) {
        colorStringProperty.set((Object)("rgba(" + (int)(((Color)color.get()).getRed() * 255.0) + "," + (int)(((Color)color.get()).getGreen() * 255.0) + "," + (int)(((Color)color.get()).getBlue() * 255.0) + "," + ((Color)color.get()).getOpacity() + ")"));
    }

    private StringProperty createWarningColorStringProperty(ObjectProperty<Color> warningColor) {
        SimpleStringProperty colorStringProperty = new SimpleStringProperty();
        this.setColorStringFromColor((StringProperty)colorStringProperty, warningColor);
        warningColor.addListener((ChangeListener)new ChangeListener<Color>((StringProperty)colorStringProperty, warningColor){
            final /* synthetic */ StringProperty val$colorStringProperty;
            final /* synthetic */ ObjectProperty val$warningColor;
            {
                this.val$colorStringProperty = stringProperty;
                this.val$warningColor = objectProperty;
            }

            public void changed(ObservableValue<? extends Color> observableValue, Color oldColor, Color newColor) {
                MonitoringNoviController.this.setColorStringFromColor(this.val$colorStringProperty, (ObjectProperty<Color>)this.val$warningColor);
            }
        });
        return colorStringProperty;
    }

    private void createWarningButton(ToggleButton warningButton) {
        SimpleObjectProperty warningColor = new SimpleObjectProperty((Object)Color.web((String)"#ececec"));
        StringProperty colorStringProperty = this.createWarningColorStringProperty((ObjectProperty<Color>)warningColor);
        warningButton.styleProperty().bind((ObservableValue)new SimpleStringProperty("-fx-base: ").concat((Object)colorStringProperty).concat((Object)";"));
        Timeline flash = new Timeline(new KeyFrame[]{new KeyFrame(Duration.seconds((double)0.0), new KeyValue[]{new KeyValue((WritableValue)warningColor, (Object)Color.web((String)"#ececec"), Interpolator.LINEAR)}), new KeyFrame(Duration.seconds((double)0.25), new KeyValue[]{new KeyValue((WritableValue)warningColor, (Object)Color.web((String)"#ececec"), Interpolator.LINEAR)}), new KeyFrame(Duration.seconds((double)1.0), new KeyValue[]{new KeyValue((WritableValue)warningColor, (Object)Color.RED, Interpolator.LINEAR)}), new KeyFrame(Duration.seconds((double)1.25), new KeyValue[]{new KeyValue((WritableValue)warningColor, (Object)Color.RED, Interpolator.LINEAR)})});
        flash.setCycleCount(10);
        flash.setAutoReverse(true);
        flash.setOnFinished(e -> warningButton.setId("btnPorukaIma"));
        flash.play();
    }

    void nadodajPoruku(Poruka p) {
        this.root.getChildren().add((Object)p);
    }

    private void kreirajPanelPoruke() {
        Tooltip to = new Tooltip();
        this.root.setPadding(new Insets(1.0));
        this.btnPoruka.setTooltip(to);
        this.btnPoruka.setId("btnPoruka");
        if (this.root.getChildren().size() < 1) {
            this.btnPoruka.setText("");
            to.setText(" Nema poruka ");
            this.btnPoruka.setId("btnPoruka");
        } else {
            this.btnPoruka.setText(String.valueOf(this.root.getChildren().size()));
            to.setText("Imate  " + this.root.getChildren().size() + "   poruka ");
        }
        ObservableList listaPoruka1 = this.root.getChildren();
        listaPoruka1.addListener(change -> {
            while (change.next()) {
                if (change.wasUpdated() || change.wasPermutated()) continue;
                for (Node remitem : change.getRemoved()) {
                    if (this.root.getChildren().size() < 1) {
                        this.btnPoruka.setText("");
                        to.setText("Nema poruka");
                        this.btnPoruka.setId("btnPoruka");
                        continue;
                    }
                    this.btnPoruka.setText(String.valueOf(this.root.getChildren().size()));
                    to.setText("Imate  " + this.root.getChildren().size() + "   poruka ");
                    this.btnPoruka.setId("btnPorukaIma");
                }
                for (Node additem : change.getAddedSubList()) {
                    if (this.root.getChildren().size() < 1) {
                        this.btnPoruka.setText("");
                        to.setText("Nema poruka");
                        this.btnPoruka.setId("btnPoruka");
                        continue;
                    }
                    this.btnPoruka.setText(String.valueOf(this.root.getChildren().size()));
                    to.setText("Imate  " + this.root.getChildren().size() + "   poruka ");
                    this.createWarningButton(this.btnPoruka);
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.BOTTOM_RIGHT, "Nova  poruka ", 2, "Information graphic");
                }
            }
        });
        this.scrollPoruka.widthProperty().addListener((observable, oldValue, newValue) -> this.root.setPrefWidth(this.scrollPoruka.getWidth() - 10.0));
        this.scrollPoruka.setContent((Node)this.root);
        TranslateTransition openNav = new TranslateTransition(new Duration(350.0), (Node)this.scrollPoruka);
        openNav.setToX(0.0);
        TranslateTransition closeNav = new TranslateTransition(new Duration(350.0), (Node)this.scrollPoruka);
        this.btnPoruka.setOnAction(evt -> {
            if (this.scrollPoruka.getTranslateX() != 0.0) {
                openNav.play();
            } else {
                closeNav.setToX(this.scrollPoruka.getWidth());
                closeNav.play();
            }
        });
        this.scrollPoruka.setOnMouseExited(e -> {
            if (this.scrollPoruka.getTranslateX() != 0.0) {
                openNav.play();
            } else {
                closeNav.setToX(this.scrollPoruka.getWidth());
                closeNav.play();
            }
        });
    }

    private void urediKoloneUTabliciMJerniUredjaj() {
        TableColumn pj = new TableColumn("POSLOVNA JEDINICA");
        pj.setCellValueFactory(cellData -> ((NadzorMjerniInstrumentPregled)cellData.getValue()).poslovnajedinicaProperty());
        pj.prefWidthProperty().bind((ObservableValue)this.tablicaMjerniUredjaji.widthProperty().divide(5.0));
        pj.setStyle("-fx-alignment: CENTER;");
        TableColumn invBroj = new TableColumn("INV. BROJ");
        invBroj.setCellValueFactory(cellData -> ((NadzorMjerniInstrumentPregled)cellData.getValue()).inventurnibrojProperty());
        invBroj.prefWidthProperty().bind((ObservableValue)this.tablicaMjerniUredjaji.widthProperty().divide(10.0));
        invBroj.setStyle("-fx-alignment: CENTER;");
        TableColumn tvBroj = new TableColumn("TV. BROJ");
        tvBroj.setCellValueFactory(cellData -> ((NadzorMjerniInstrumentPregled)cellData.getValue()).tvornickibrojProperty());
        tvBroj.prefWidthProperty().bind((ObservableValue)this.tablicaMjerniUredjaji.widthProperty().divide(10.0));
        tvBroj.setStyle("-fx-alignment: CENTER;");
        TableColumn naziv = new TableColumn("NAZIV");
        naziv.setCellValueFactory(cellData -> ((NadzorMjerniInstrumentPregled)cellData.getValue()).nazivstrojaProperty());
        naziv.prefWidthProperty().bind((ObservableValue)this.tablicaMjerniUredjaji.widthProperty().divide(3.3333333333333335));
        naziv.setStyle("-fx-alignment: CENTER;");
        Callback dateCellFactory1 = param -> new DatumValueCell();
        TableColumn datumIspitivanja = new TableColumn("DATUM UMJERAVANJA URE\u0110AJA");
        datumIspitivanja.setCellValueFactory((Callback)new PropertyValueFactory("datumIstekaPregleda"));
        datumIspitivanja.prefWidthProperty().bind((ObservableValue)this.tablicaMjerniUredjaji.widthProperty().divide(3.4482758620689653));
        datumIspitivanja.setCellFactory(dateCellFactory1);
        datumIspitivanja.setStyle("-fx-alignment: CENTER;");
        this.kolPretragaMJerniUredjaji.setGraphic((Node)this.tbFilterMjerniUredjaj);
        this.kolPretragaMJerniUredjaji.getColumns().addAll(new Object[]{invBroj, tvBroj, naziv, datumIspitivanja, pj});
    }

    private void kreirajToolBarFIlterMjerniUredjaj() {
        this.tbFilterMjerniUredjaj = new ToolBar();
        this.tfilterMjerniUredjaj = new TextField();
        this.tfilterMjerniUredjaj.setPromptText("Filter");
        this.tfilterMjerniUredjaj.setId("textField");
        this.cbFilterMjerniUredjaj = new ComboBox();
        ObservableList filter = FXCollections.observableArrayList((Object[])new String[]{"Naziv", "Inventurni broj", "Poslovna jedinica", "Tv. Broj"});
        this.cbFilterMjerniUredjaj.getItems().addAll((Collection)filter);
        this.cbFilterMjerniUredjaj.setValue((Object)"Naziv");
        this.cbFilterMjerniUredjaj.setPrefWidth(200.0);
        this.tfilterMjerniUredjaj.setPrefWidth(200.0);
        this.tfilterMjerniUredjaj.setPrefHeight(25.0);
        this.tbFilterMjerniUredjaj.getItems().addAll((Object[])new Node[]{this.tfilterMjerniUredjaj, this.cbFilterMjerniUredjaj, MenuButtonReporti.getMenuButtonMjerniUredjajiIspis()});
    }

    private void urediFilterMJerniUredjaj(TableView<NadzorMjerniInstrumentPregled> tablicaMjerniUredjaji) {
        FilteredList filteredData = new FilteredList(this.listaMjerniInstrumenti, p -> true);
        this.tfilterMjerniUredjaj.textProperty().addListener((observable, oldValue, newValue) -> filteredData.setPredicate(pregled -> {
            if (newValue == null || newValue.isEmpty()) {
                return true;
            }
            String lowerCaseFilter = newValue.toLowerCase();
            return this.cbFilterMjerniUredjaj.getSelectionModel().getSelectedItem().equals("Naziv") ? pregled.getNazivstroja() != null && pregled.getNazivstroja().toLowerCase().startsWith(lowerCaseFilter) : (this.cbFilterMjerniUredjaj.getSelectionModel().getSelectedItem().equals("Inventurni broj") ? pregled.getInventurnibroj() != null && pregled.getInventurnibroj().toLowerCase().startsWith(lowerCaseFilter) : (this.cbFilterMjerniUredjaj.getSelectionModel().getSelectedItem().equals("Poslovna jedinica") ? pregled.getPoslovnajedinica() != null && pregled.getPoslovnajedinica().toLowerCase().startsWith(lowerCaseFilter) : this.cbFilterMjerniUredjaj.getSelectionModel().getSelectedItem().equals("Tv. Broj") && pregled.getTvornickibroj() != null && pregled.getTvornickibroj().toLowerCase().startsWith(lowerCaseFilter)));
        }));
        SortedList sortedData = new SortedList((ObservableList)filteredData);
        sortedData.comparatorProperty().bind((ObservableValue)tablicaMjerniUredjaji.comparatorProperty());
        tablicaMjerniUredjaji.setItems((ObservableList)sortedData);
    }

    private void popuniVatrogasniAparatNadzor() {
        ProgressIndicator progressIndicator1 = new ProgressIndicator();
        this.kreirajToolBarFIlterVatrogasniAparati();
        this.urediKoloneUTabliciVAtrogasniAparati();
        this.tablicaVatrogasniAparati.setPlaceholder((Node)progressIndicator1);
        progressIndicator1.setMaxSize(200.0, 200.0);
        progressIndicator1.progressProperty().bind((ObservableValue)this.vaservice.progressProperty());
        progressIndicator1.visibleProperty().bind((ObservableValue)this.vaservice.runningProperty());
        this.vaservice.start();
    }

    private void urediKoloneUTabliciVAtrogasniAparati() {
        TableColumn pj = new TableColumn("POSLOVNA JEDINICA");
        pj.setCellValueFactory(cellData -> ((NadzorVAtrogasniAparat)cellData.getValue()).poslovnajedinicaProperty());
        pj.prefWidthProperty().bind((ObservableValue)this.tablicaVatrogasniAparati.widthProperty().divide(5.0));
        pj.setStyle("-fx-alignment: CENTER;");
        TableColumn invBroj = new TableColumn("INV. BROJ");
        invBroj.setCellValueFactory(cellData -> ((NadzorVAtrogasniAparat)cellData.getValue()).inventurnibrojProperty());
        invBroj.prefWidthProperty().bind((ObservableValue)this.tablicaVatrogasniAparati.widthProperty().divide(10.0));
        invBroj.setStyle("-fx-alignment: CENTER;");
        TableColumn tvBroj = new TableColumn("TV. BROJ");
        tvBroj.setCellValueFactory(cellData -> ((NadzorVAtrogasniAparat)cellData.getValue()).tvornickibrojProperty());
        tvBroj.prefWidthProperty().bind((ObservableValue)this.tablicaVatrogasniAparati.widthProperty().divide(10.0));
        tvBroj.setStyle("-fx-alignment: CENTER;");
        TableColumn vrstaVA = new TableColumn("VRSTA");
        vrstaVA.setCellValueFactory(cellData -> ((NadzorVAtrogasniAparat)cellData.getValue()).vrstaAparataProperty());
        vrstaVA.prefWidthProperty().bind((ObservableValue)this.tablicaVatrogasniAparati.widthProperty().divide(10.0));
        vrstaVA.setStyle("-fx-alignment: CENTER;");
        TableColumn naziv = new TableColumn("NAZIV");
        naziv.setCellValueFactory(cellData -> ((NadzorVAtrogasniAparat)cellData.getValue()).nazivAparataProperty());
        naziv.prefWidthProperty().bind((ObservableValue)this.tablicaVatrogasniAparati.widthProperty().divide(3.3333333333333335));
        naziv.setStyle("-fx-alignment: CENTER;");
        Callback dateCellFactory1 = param -> new DatumValueCell();
        TableColumn datumIspitivanja = new TableColumn("DATUM PREGLEDA V.A");
        datumIspitivanja.setCellValueFactory((Callback)new PropertyValueFactory("datumIstekaPregleda"));
        datumIspitivanja.prefWidthProperty().bind((ObservableValue)this.tablicaVatrogasniAparati.widthProperty().divide(5.2631578947368425));
        datumIspitivanja.setCellFactory(dateCellFactory1);
        datumIspitivanja.setStyle("-fx-alignment: CENTER;");
        this.kolPretragaVatrogasniAparati.setGraphic((Node)this.tbFilterVatrogasniAparat);
        this.kolPretragaVatrogasniAparati.getColumns().addAll(new Object[]{invBroj, tvBroj, vrstaVA, naziv, datumIspitivanja, pj});
    }

    private void kreirajToolBarFIlterVatrogasniAparati() {
        this.tbFilterVatrogasniAparat = new ToolBar();
        this.tfilterVatrogasniAparat = new TextField();
        this.tfilterVatrogasniAparat.setPromptText("Filter");
        this.tfilterVatrogasniAparat.setId("textField");
        this.cbFilterVatrogasniAparat = new ComboBox();
        ObservableList filter = FXCollections.observableArrayList((Object[])new String[]{"Naziv", "Vrsta", "Inventurni broj", "Poslovna jedinica", "Tv. Broj"});
        this.cbFilterVatrogasniAparat.getItems().addAll((Collection)filter);
        this.cbFilterVatrogasniAparat.setValue((Object)"Inventurni broj");
        this.cbFilterVatrogasniAparat.setPrefWidth(200.0);
        this.tfilterVatrogasniAparat.setPrefWidth(200.0);
        this.tfilterVatrogasniAparat.setPrefHeight(25.0);
        this.tbFilterVatrogasniAparat.getItems().addAll((Object[])new Node[]{this.tfilterVatrogasniAparat, this.cbFilterVatrogasniAparat, MenuButtonReporti.getMenuButtonVatrogasniAparatiIspis()});
    }

    private void urediFilterVatrogasniAparati(TableView<NadzorVAtrogasniAparat> tablicaVatrogasniAparati) {
        FilteredList filteredData = new FilteredList(this.listaVatrogasnihAparata, p -> true);
        this.tfilterVatrogasniAparat.textProperty().addListener((observable, oldValue, newValue) -> filteredData.setPredicate(pregled -> {
            if (newValue == null || newValue.isEmpty()) {
                return true;
            }
            String lowerCaseFilter = newValue.toLowerCase();
            return this.cbFilterVatrogasniAparat.getSelectionModel().getSelectedItem().equals("Naziv") ? pregled.getNazivAparata() != null && pregled.getNazivAparata().toLowerCase().startsWith(lowerCaseFilter) : (this.cbFilterVatrogasniAparat.getSelectionModel().getSelectedItem().equals("Inventurni broj") ? pregled.getInventurnibroj() != null && pregled.getInventurnibroj().toLowerCase().startsWith(lowerCaseFilter) : (this.cbFilterVatrogasniAparat.getSelectionModel().getSelectedItem().equals("Poslovna jedinica") ? pregled.getPoslovnajedinica() != null && pregled.getPoslovnajedinica().toLowerCase().startsWith(lowerCaseFilter) : (this.cbFilterVatrogasniAparat.getSelectionModel().getSelectedItem().equals("Tv. Broj") ? pregled.getTvornickibroj() != null && pregled.getTvornickibroj().toLowerCase().startsWith(lowerCaseFilter) : this.cbFilterVatrogasniAparat.getSelectionModel().getSelectedItem().equals("Vrsta") && pregled.getVrstaAparata() != null && pregled.getVrstaAparata().toLowerCase().startsWith(lowerCaseFilter))));
        }));
        SortedList sortedData = new SortedList((ObservableList)filteredData);
        sortedData.comparatorProperty().bind((ObservableValue)tablicaVatrogasniAparati.comparatorProperty());
        tablicaVatrogasniAparati.setItems((ObservableList)sortedData);
    }

    class DatumValueCell<S>
    extends TableCell<S, LocalDate> {
        PopOver item = null;

        public DatumValueCell() {
            this.addEventFilter(MouseEvent.MOUSE_CLICKED, (EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent event) {
                    if (event.getClickCount() > 1) {
                        TableCell c = (TableCell)event.getSource();
                        DjelatnikPregled d = (DjelatnikPregled)MonitoringNoviController.this.tablicaDjelatnik.getSelectionModel().getSelectedItem();
                        StrojEvidencija se = (StrojEvidencija)MonitoringNoviController.this.tablicaStrojevi.getSelectionModel().getSelectedItem();
                        MjernoMjestoFRO mm = (MjernoMjestoFRO)MonitoringNoviController.this.tablicaFRO.getSelectionModel().getSelectedItem();
                        ObjektNadzor on = (ObjektNadzor)MonitoringNoviController.this.tablicaObjekti.getSelectionModel().getSelectedItem();
                        MjerniInstrumentPodaci mi = (MjerniInstrumentPodaci)MonitoringNoviController.this.tablicaMjerniUredjaji.getSelectionModel().getSelectedItem();
                        NadzorVAtrogasniAparat va = (NadzorVAtrogasniAparat)MonitoringNoviController.this.tablicaVatrogasniAparati.getSelectionModel().getSelectedItem();
                        if (c.getTableColumn().getText().equalsIgnoreCase("lje\u010dni\u010dki pregled")) {
                            FXMLLoader loader = new FXMLLoader(this.getClass().getResource("DjelatnikLjecnickiPregledPopup.fxml"));
                            Parent root = null;
                            try {
                                root = (Parent)loader.load();
                            }
                            catch (IOException ex) {
                                Logger.getLogger(MonitoringController.class.getName()).log(Level.SEVERE, null, ex);
                            }
                            DatumValueCell.this.item = new PopOver();
                            DatumValueCell.this.item.setContentNode((Node)root);
                            DjelatnikLjecnickiPregledPopupController.getInstance().prikaziDjelatnika(d, DatumValueCell.this.item);
                            DatumValueCell.this.item.setArrowLocation(PopOver.ArrowLocation.LEFT_TOP);
                            DatumValueCell.this.item.setCornerRadius(4.0);
                            DatumValueCell.this.item.setTitle(c.getTableColumn().getText());
                            if (!c.isEmpty()) {
                                DatumValueCell.this.item.show((Node)MonitoringNoviController.this.tablicaDjelatnik.getParent(), event.getScreenX(), event.getScreenY());
                            }
                        } else if (c.getTableColumn().getText().equalsIgnoreCase("ozo")) {
                            FXMLLoader loader = new FXMLLoader(this.getClass().getResource("DjlatnikOZOPopup.fxml"));
                            Parent root = null;
                            try {
                                root = (Parent)loader.load();
                            }
                            catch (IOException ex) {
                                Logger.getLogger(MonitoringController.class.getName()).log(Level.SEVERE, null, ex);
                            }
                            DatumValueCell.this.item = new PopOver();
                            DatumValueCell.this.item.setContentNode((Node)root);
                            DjlatnikOZOPopupController.getInstance().prikaziDjelatnika(d, DatumValueCell.this.item);
                            DatumValueCell.this.item.setArrowLocation(PopOver.ArrowLocation.LEFT_TOP);
                            DatumValueCell.this.item.setCornerRadius(4.0);
                            DatumValueCell.this.item.setTitle(c.getTableColumn().getText());
                            if (!c.isEmpty()) {
                                DatumValueCell.this.item.show((Node)MonitoringNoviController.this.tablicaDjelatnik.getParent(), event.getScreenX(), event.getScreenY());
                            }
                        } else if (c.getTableColumn().getText().equalsIgnoreCase("DATUM ISPITIVANJA")) {
                            if (!GlavniPanelController.getInstance().getTabByIdifExist("Unos Stroja")) {
                                GlavniPanelController.getInstance().zatvoriTab("Unos Stroja");
                                GlavniPanelController.getInstance().nadodajPanel("Unos Stroja", "/radnaoprema/UnosStrojeva.fxml");
                                UnosStrojevaController.getInstance().izmjenaStroja(se);
                                UnosStrojevaController.getInstance().getTabPanePodaci().getSelectionModel().select(2);
                            } else {
                                GlavniPanelController.getInstance().nadodajPanel("Unos Stroja", "/radnaoprema/UnosStrojeva.fxml");
                                UnosStrojevaController.getInstance().izmjenaStroja(se);
                                UnosStrojevaController.getInstance().getTabPanePodaci().getSelectionModel().select(2);
                            }
                        } else if (c.getTableColumn().getText().equalsIgnoreCase("DATUM ISPITIVANJA M.M")) {
                            if (!GlavniPanelController.getInstance().getTabByIdifExist("Unos mjernog mjesta")) {
                                GlavniPanelController.getInstance().zatvoriTab("Unos mjernog mjesta");
                                GlavniPanelController.getInstance().nadodajPanel("Unos mjernog mjesta", "/radniokolis/UnosFRO.fxml");
                                UnosFROController.getInstance().izmjenaFRO(mm);
                                UnosFROController.getInstance().getTabPanePodaci().getSelectionModel().select(1);
                            } else {
                                GlavniPanelController.getInstance().nadodajPanel("Unos mjernog mjesta", "/radniokolis/UnosFRO.fxml");
                                UnosFROController.getInstance().izmjenaFRO(mm);
                                UnosFROController.getInstance().getTabPanePodaci().getSelectionModel().select(1);
                            }
                        } else if (c.getTableColumn().getText().equalsIgnoreCase("DATUM ISPITIVANJA OBJEKTA")) {
                            FXMLLoader loader = new FXMLLoader(this.getClass().getResource("ObjektNoviPopup.fxml"));
                            Parent root = null;
                            try {
                                root = (Parent)loader.load();
                            }
                            catch (IOException ex) {
                                Logger.getLogger(MonitoringController.class.getName()).log(Level.SEVERE, null, ex);
                            }
                            DatumValueCell.this.item = new PopOver();
                            DatumValueCell.this.item.setContentNode((Node)root);
                            ObjektNoviPopupController.getInstance().prikaziObjekt(on, DatumValueCell.this.item);
                            DatumValueCell.this.item.setArrowLocation(PopOver.ArrowLocation.LEFT_TOP);
                            DatumValueCell.this.item.setCornerRadius(4.0);
                            DatumValueCell.this.item.setTitle(c.getTableColumn().getText());
                            if (!c.isEmpty()) {
                                DatumValueCell.this.item.show((Node)MonitoringNoviController.this.tablicaObjekti.getParent(), event.getScreenX(), event.getScreenY());
                            }
                        } else if (c.getTableColumn().getText().equalsIgnoreCase("IZDANA UPUTNICA")) {
                            if (!GlavniPanelController.getInstance().getTabByIdifExist("Popis RA-1 uputnica")) {
                                GlavniPanelController.getInstance().zatvoriTab("Popis RA-1 uputnica");
                                GlavniPanelController.getInstance().nadodajPanel("Popis RA-1 uputnica", "/uputnice/PregledRA1.fxml");
                            } else {
                                GlavniPanelController.getInstance().nadodajPanel("Popis RA-1 uputnica", "/uputnice/PregledRA1.fxml");
                            }
                        } else if (c.getTableColumn().getText().equalsIgnoreCase("OSPOSOBLJAVANJE")) {
                            FXMLLoader loader = new FXMLLoader(this.getClass().getResource("DjelatnikOsposobljavanjePopup.fxml"));
                            Parent root = null;
                            try {
                                root = (Parent)loader.load();
                            }
                            catch (IOException ex) {
                                Logger.getLogger(MonitoringController.class.getName()).log(Level.SEVERE, null, ex);
                            }
                            DatumValueCell.this.item = new PopOver();
                            DatumValueCell.this.item.setContentNode((Node)root);
                            DjelatnikOsposobljavanjePopupController.getInstance().prikaziDjelatnika(d, DatumValueCell.this.item);
                            DatumValueCell.this.item.setArrowLocation(PopOver.ArrowLocation.LEFT_TOP);
                            DatumValueCell.this.item.setCornerRadius(4.0);
                            DatumValueCell.this.item.setTitle(c.getTableColumn().getText());
                            if (!c.isEmpty()) {
                                DatumValueCell.this.item.show((Node)MonitoringNoviController.this.tablicaDjelatnik.getParent(), event.getScreenX(), event.getScreenY());
                            }
                        } else if (c.getTableColumn().getText().equalsIgnoreCase("OSTALI PREGLEDI")) {
                            FXMLLoader loader = new FXMLLoader(this.getClass().getResource("DjelatnikOstaliPreglediPopup.fxml"));
                            Parent root = null;
                            try {
                                root = (Parent)loader.load();
                            }
                            catch (IOException ex) {
                                Logger.getLogger(MonitoringController.class.getName()).log(Level.SEVERE, null, ex);
                            }
                            DatumValueCell.this.item = new PopOver();
                            DatumValueCell.this.item.setContentNode((Node)root);
                            DjelatnikOstaliPreglediPopupController.getInstance().prikaziDjelatnika(d, DatumValueCell.this.item);
                            DatumValueCell.this.item.setArrowLocation(PopOver.ArrowLocation.LEFT_TOP);
                            DatumValueCell.this.item.setCornerRadius(4.0);
                            DatumValueCell.this.item.setTitle(c.getTableColumn().getText());
                            if (!c.isEmpty()) {
                                DatumValueCell.this.item.show((Node)MonitoringNoviController.this.tablicaDjelatnik.getParent(), event.getScreenX(), event.getScreenY());
                            }
                        } else if (c.getTableColumn().getText().equalsIgnoreCase("DATUM PREGLEDA V.A")) {
                            FXMLLoader loader = new FXMLLoader(this.getClass().getResource("VatrogasniAparatPopup.fxml"));
                            Parent root = null;
                            try {
                                root = (Parent)loader.load();
                            }
                            catch (IOException ex) {
                                Logger.getLogger(MonitoringController.class.getName()).log(Level.SEVERE, null, ex);
                            }
                            DatumValueCell.this.item = new PopOver();
                            DatumValueCell.this.item.setContentNode((Node)root);
                            VatrogasniAparatPopupController.getInstance().prikaziVAtrogasniAparat(va, DatumValueCell.this.item);
                            DatumValueCell.this.item.setArrowLocation(PopOver.ArrowLocation.LEFT_TOP);
                            DatumValueCell.this.item.setCornerRadius(4.0);
                            DatumValueCell.this.item.setTitle(c.getTableColumn().getText());
                            if (!c.isEmpty()) {
                                DatumValueCell.this.item.show((Node)MonitoringNoviController.this.tablicaVatrogasniAparati.getParent(), event.getScreenX(), event.getScreenY());
                            }
                        } else if (c.getTableColumn().getText().equalsIgnoreCase("DATUM ISPITIVANJA URE\u0110AJA")) {
                            GlavniPanelController.getInstance().zatvoriTab("Unos ure\u0111aja");
                            GlavniPanelController.getInstance().nadodajPanel("Unos ure\u0111aja", "/mjerniinstrumenti/UnosMjernogInstrumenta.fxml");
                            UnosMjernogInstrumentaController.getInstance().izmjenaUredjaja(mi);
                            UnosMjernogInstrumentaController.getInstance().getTabPanePodaci().getSelectionModel().select(2);
                        } else {
                            GlavniPanelController.getInstance().nadodajPanel("Unos ure\u0111aja", "/mjerniinstrumenti/UnosMjernogInstrumenta.fxml");
                            UnosMjernogInstrumentaController.getInstance().izmjenaUredjaja(mi);
                            UnosMjernogInstrumentaController.getInstance().getTabPanePodaci().getSelectionModel().select(2);
                        }
                    }
                }
            });
        }

        protected void updateItem(LocalDate item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (empty) {
                this.setText(null);
                this.setGraphic(null);
                this.setStyle(null);
                this.setTooltip(null);
            } else if (item == null) {
                this.setText("---");
                this.setStyle(null);
                this.setTooltip(null);
                this.setGraphic(null);
            } else if (item != null) {
                this.setCursor(Cursor.HAND);
                this.izracunaj(item);
            } else {
                this.setStyle(null);
                this.setText(null);
                this.setGraphic(null);
            }
        }

        private void izracunaj(LocalDate d) {
            Tooltip tip = new Tooltip();
            tip.setStyle("-fx-font-size:12pt;-fx-text-fill:white");
            LocalDate datePocetni = LocalDate.now();
            LocalDate dateEnd = d;
            Period p = Period.between(datePocetni, dateEnd);
            long p2 = ChronoUnit.DAYS.between(datePocetni, dateEnd);
            if (p2 < 0L) {
                this.setStyle("-fx-background-color:-fx-table-cell-border-color, darkgray ;-fx-background-insets: 0, 0 0 1 0; -fx-padding: 0.0em; -fx-alignment: CENTER;");
                this.setText(d.format(DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM)));
                tip.setText("Pro\u0161lo je vi\u0161e od " + p.getYears() + " god. " + p.getMonths() + " mj. ,\n i  " + p.getDays() + " dana od potrebnog pregleda .\n ( ukupno  " + p2 + "  dana )");
                this.setTooltip(tip);
                this.setGraphic(null);
            } else if (p2 <= 15L || p2 == 0L) {
                this.setStyle("-fx-background-color:-fx-table-cell-border-color, red ;-fx-background-insets: 0, 0 0 1 0; -fx-padding: 0.0em; -fx-alignment: CENTER;");
                this.setText(d.format(DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM)));
                tip.setText("Preostalo jo\u0161 " + p.getYears() + " god. " + p.getMonths() + " mj.,\n i " + p.getDays() + "  dana do sljede\u0107eg pregleda. \n( ukupno  " + p2 + "  dana )");
                this.setTooltip(tip);
                this.setGraphic(null);
            } else if (p2 <= 30L) {
                this.setStyle("-fx-background-color:-fx-table-cell-border-color, goldenrod ;-fx-background-insets: 0, 0 0 1 0; -fx-padding: 0.0em; -fx-alignment: CENTER;");
                this.setText(d.format(DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM)));
                tip.setText("Preostalo jo\u0161 " + p.getYears() + " god. " + p.getMonths() + " mj,\n i " + p.getDays() + "  dana do sljede\u0107eg pregleda. \n( ukupno  " + p2 + "  dana )");
                this.setTooltip(tip);
                this.setGraphic(null);
            } else if (p2 > 30L) {
                this.setStyle("-fx-background-color:-fx-table-cell-border-color, yellowgreen ;-fx-background-insets: 0, 0 0 1 0; -fx-padding: 0.0em; -fx-alignment: CENTER;");
                this.setText(d.format(DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM)));
                tip.setText("Preostalo jo\u0161 " + p.getYears() + " god. " + p.getMonths() + " mj,\n i " + p.getDays() + "  dana do sljede\u0107eg pregleda. \n( ukupno  " + p2 + "  dana )");
                this.setTooltip(tip);
                this.setGraphic(null);
            } else {
                this.setTooltip(null);
                this.setGraphic(null);
                this.setStyle(null);
                Tooltip.uninstall((Node)this, (Tooltip)tip);
            }
        }
    }

    public class CustomPane
    extends VBox {
        public CustomPane() {
            this.setStyle("-fx-background-color:transparent;");
        }

        public CustomPane getPane() {
            return this;
        }
    }
}

