/*
 * Decompiled with CFR 0.152.
 */
package monitoringnovi;

import Utill.DateUtil;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import monitoring.ObjektNadzor;
import monitoringnovi.BazaMonitoringNovi;
import monitoringnovi.MonitoringNoviController;
import tvrtka.Tvrtka;
import zastitanaradu.GlavniPanelController;

public class ObjektNadzorNoviService
extends Service<ObservableList<ObjektNadzor>> {
    private final MonitoringNoviController mk;

    public ObjektNadzorNoviService(MonitoringNoviController mk) {
        this.mk = mk;
    }

    protected Task<ObservableList<ObjektNadzor>> createTask() {
        return new ObjektNadzorTask();
    }

    private void addObjektUI(final ObservableList<ObjektNadzor> listaObjekt) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                ObjektNadzorNoviService.this.mk.setListaObjekti((ObservableList<ObjektNadzor>)listaObjekt);
            }
        });
    }

    private class ObjektNadzorTask
    extends Task<ObservableList<ObjektNadzor>> {
        private Tvrtka t = GlavniPanelController.getOdabranaTvrtka();
        ObservableList<ObjektNadzor> listaObjekti = FXCollections.observableArrayList();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected ObservableList<ObjektNadzor> call() throws Exception {
            ResultSet rs = BazaMonitoringNovi.dajObjekte(this.t);
            ObjektNadzor oi = null;
            int br = 1;
            try {
                while (rs.next()) {
                    oi = new ObjektNadzor();
                    oi.setId(rs.getInt("id"));
                    oi.setRedBroj(String.valueOf(br));
                    oi.setAdresa(rs.getString("adresa"));
                    oi.setPoslovnaJedinica(rs.getString("nazivposlovnice"));
                    oi.setNazivObjekta(rs.getString("nazivodjela"));
                    oi.setDatumPonovogIspitivanja(DateUtil.getLocalDate(rs.getDate("datumponovogispitivanja")));
                    this.listaObjekti.add((Object)oi);
                    ++br;
                }
            }
            catch (SQLException ex) {
                Logger.getLogger(ObjektNadzorTask.class.getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                try {
                    rs.close();
                }
                catch (SQLException ex) {
                    Logger.getLogger(ObjektNadzorTask.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            this.listaObjekti.stream().sorted(Comparator.comparing(ObjektNadzor::getDatumPonovogIspitivanja, Comparator.nullsFirst(Comparator.naturalOrder())));
            ObjektNadzorNoviService.this.addObjektUI((ObservableList<ObjektNadzor>)this.listaObjekti);
            return this.listaObjekti;
        }

        private void sortirajObjektiTablicu() {
            Map<Object, Object> map = new HashMap<ObjektNadzor, LocalDate>();
            ObservableList listaNajmanjihDatuma = FXCollections.observableArrayList();
            for (int i = 0; i < this.listaObjekti.size(); ++i) {
                if (((ObjektNadzor)this.listaObjekti.get(i)).getDatumPonovogIspitivanja() == null) continue;
                listaNajmanjihDatuma.add((Object)((ObjektNadzor)this.listaObjekti.get(i)).getDatumPonovogIspitivanja());
                FXCollections.sort((ObservableList)listaNajmanjihDatuma, Comparator.nullsLast(Comparator.naturalOrder()));
                if (listaNajmanjihDatuma.get(0) == null) {
                    map.put(this.listaObjekti.get(i), listaNajmanjihDatuma.get(1));
                } else {
                    map.put(this.listaObjekti.get(i), listaNajmanjihDatuma.get(0));
                }
                listaNajmanjihDatuma.clear();
            }
            map.forEach((k, v) -> System.out.println("Key: " + k.getNazivObjekta() + ": Value: " + v));
            map = this.sortByValue(map);
            this.listaObjekti.clear();
            map.forEach((k, v) -> {
                this.listaObjekti.add(k);
                System.out.println("Key: " + k.getNazivObjekta() + ": Value: " + v);
            });
            map.clear();
        }

        public <K, V extends Comparable<? super V>> Map<K, V> sortByValue(Map<K, V> map) {
            LinkedHashMap result = new LinkedHashMap();
            Stream st = map.entrySet().stream();
            st.sorted(Comparator.comparing(e -> (Comparable)e.getValue(), Comparator.nullsLast(Comparator.naturalOrder()))).forEachOrdered(e -> {
                Comparable cfr_ignored_0 = (Comparable)result.put(e.getKey(), e.getValue());
            });
            return result;
        }
    }
}

