/*
 * Decompiled with CFR 0.152.
 */
package monitoringnovi;

import Utill.DateUtil;
import Utill.ResizeComponent;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.Period;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.time.temporal.ChronoUnit;
import java.util.Comparator;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;
import javafx.util.Callback;
import monitoring.ObjektNadzor;
import monitoringnovi.BazaMonitoringNovi;
import monitoringnovi.DjelatnikOsposobljavanjePopupController;
import objektiispitivanja.ObjekatEvidencijaPregleda;
import objektiispitivanja.UnosObjektaController;
import org.controlsfx.control.PopOver;
import zastitanaradu.GlavniPanelController;

public class ObjektNoviPopupController
implements Initializable {
    @FXML
    private Label lblNazivObjekta;
    @FXML
    private Label lblPoslovnaJedinica;
    @FXML
    private Label lblAdresa;
    @FXML
    private TableView<ObjekatEvidencijaPregleda> tablicaIspitivanja;
    @FXML
    private TableColumn<ObjekatEvidencijaPregleda, String> kolNazivIspitivanja;
    @FXML
    private TableColumn<ObjekatEvidencijaPregleda, LocalDate> kolDatumIspitivanja;
    @FXML
    private TableColumn<ObjekatEvidencijaPregleda, LocalDate> kolDatumPonovogIspitivanja;
    @FXML
    private Button btnCancel;
    @FXML
    private Button btnPrikaziObjekt;
    private ObjektNadzor on;
    ObservableList<ObjekatEvidencijaPregleda> listaOep = FXCollections.observableArrayList();
    private static ObjektNoviPopupController instance;
    private PopOver p = null;

    public static ObjektNoviPopupController getInstance() {
        return instance;
    }

    public void initialize(URL url, ResourceBundle rb) {
        instance = this;
        ResizeComponent.makeLabelResize(this.lblNazivObjekta, this.lblAdresa);
        this.urediTablicuIspitivanja();
        this.btnCancel.setOnAction(e -> this.p.hide());
        this.btnPrikaziObjekt.setOnAction(e -> {
            if (!GlavniPanelController.getInstance().getTabByIdifExist("Unos objekta")) {
                GlavniPanelController.getInstance().zatvoriTab("Unos objekta");
                GlavniPanelController.getInstance().nadodajPanel("Unos objekta", "/objektiispitivanja/UnosObjekta.fxml");
                UnosObjektaController.getInstance().izmjenaObjekta(this.on);
            } else {
                GlavniPanelController.getInstance().nadodajPanel("Unos objekta", "/objektiispitivanja/UnosObjekta.fxml");
                UnosObjektaController.getInstance().izmjenaObjekta(this.on);
            }
            UnosObjektaController.getInstance().getTabPanelPodaci().getSelectionModel().select(0);
            this.p.hide();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prikaziObjekt(ObjektNadzor on, PopOver p) {
        this.p = p;
        ResultSet rs = BazaMonitoringNovi.dajObjektePopup(on.getId());
        ObjekatEvidencijaPregleda op = null;
        try {
            while (rs.next()) {
                op = new ObjekatEvidencijaPregleda();
                op.setOznakaIspitivanja(rs.getString("oznaka"));
                op.setNazivIspitivanja(rs.getString("nazivpregleda"));
                op.setDatumObavljenogIspitivanja(DateUtil.getLocalDate(rs.getDate("datumobavljenogispitivanja")));
                op.setDatumPonovogIspitivanja(DateUtil.getLocalDate(rs.getDate("datumponovogispitivanja")));
                this.listaOep.add((Object)op);
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(DjelatnikOsposobljavanjePopupController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(DjelatnikOsposobljavanjePopupController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        on.setListaPregleda(this.listaOep);
        this.lblNazivObjekta.setText(on.getNazivObjekta());
        this.lblPoslovnaJedinica.setText(on.getPoslovnaJedinica());
        this.lblAdresa.setText(on.getAdresa());
        this.listaOep.stream().sorted(Comparator.comparing(ObjekatEvidencijaPregleda::getDatumPonovogIspitivanja, Comparator.nullsFirst(Comparator.naturalOrder())));
        this.tablicaIspitivanja.setItems(this.listaOep);
        this.on = on;
    }

    private void urediTablicuIspitivanja() {
        Callback dateCellFactory = param -> new DatumValueCell();
        this.kolNazivIspitivanja.setCellValueFactory(cellData -> ((ObjekatEvidencijaPregleda)cellData.getValue()).nazivIspitivanjaProperty());
        this.kolNazivIspitivanja.prefWidthProperty().bind((ObservableValue)this.tablicaIspitivanja.widthProperty().divide(3.0303030303030303));
        this.kolNazivIspitivanja.setStyle("-fx-alignment: CENTER;");
        this.kolDatumIspitivanja.setCellValueFactory(cellData -> ((ObjekatEvidencijaPregleda)cellData.getValue()).datumObavljenogIspitivanjaProperty());
        this.kolDatumIspitivanja.prefWidthProperty().bind((ObservableValue)this.tablicaIspitivanja.widthProperty().divide(3.7037037037037037));
        this.kolDatumIspitivanja.setStyle("-fx-alignment: CENTER;");
        this.kolDatumIspitivanja.setCellFactory(dateCellFactory);
        this.kolDatumPonovogIspitivanja.setCellValueFactory(cellData -> ((ObjekatEvidencijaPregleda)cellData.getValue()).datumPonovogIspitivanjaProperty());
        this.kolDatumPonovogIspitivanja.prefWidthProperty().bind((ObservableValue)this.tablicaIspitivanja.widthProperty().divide(2.5641025641025643));
        this.kolDatumPonovogIspitivanja.setStyle("-fx-alignment: CENTER;");
        this.kolDatumPonovogIspitivanja.setCellFactory(dateCellFactory);
    }

    class DatumValueCell
    extends TableCell<ObjekatEvidencijaPregleda, LocalDate> {
        DatumValueCell() {
        }

        protected void updateItem(LocalDate item, boolean empty) {
            super.updateItem((Object)item, empty);
            Object lol = null;
            if (empty) {
                this.setText(null);
                this.setGraphic(null);
                this.setStyle(null);
                this.setTooltip(null);
            } else if (item == null) {
                this.setText("---");
                this.setStyle(null);
                this.setTooltip(null);
                this.setGraphic(null);
            } else if (item != null) {
                if (this.getTableColumn().getText().equals("Datum ispitivanja")) {
                    this.setText(item.format(DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM)));
                } else {
                    this.izracunaj(item);
                }
            } else {
                this.setText(null);
                this.setGraphic(null);
            }
        }

        private void izracunaj(LocalDate d) {
            Tooltip tip = new Tooltip();
            tip.setStyle("-fx-font-size:12pt;-fx-text-fill:white");
            LocalDate datePocetni = LocalDate.now();
            LocalDate dateEnd = d;
            Period p = Period.between(datePocetni, dateEnd);
            long p2 = ChronoUnit.DAYS.between(datePocetni, dateEnd);
            if (p2 < 0L) {
                this.setStyle("-fx-background-color:-fx-table-cell-border-color, darkgray ;-fx-background-insets: 0, 0 0 1 0; -fx-padding: 0.0em; -fx-alignment: CENTER;");
                this.setText(d.format(DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM)));
                tip.setText("Pro\u0161lo je vi\u0161e od " + p.getYears() + " god. " + p.getMonths() + " mj. ,\n i  " + p.getDays() + " dana od isteka.\n ( ukupno  " + p2 + "  dana )");
                this.setTooltip(tip);
                this.setGraphic(null);
            } else if (p2 <= 15L || p2 == 0L) {
                this.setStyle("-fx-background-color:-fx-table-cell-border-color, red ;-fx-background-insets: 0, 0 0 1 0; -fx-padding: 0.0em; -fx-alignment: CENTER;");
                this.setText(d.format(DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM)));
                tip.setText("Preostalo jo\u0161 " + p.getYears() + " god. " + p.getMonths() + " mj.,\n i " + p.getDays() + "  dana do isteka. \n( ukupno  " + p2 + "  dana )");
                this.setTooltip(tip);
                this.setGraphic(null);
            } else if (p2 <= 30L) {
                this.setStyle("-fx-background-color:-fx-table-cell-border-color, goldenrod ;-fx-background-insets: 0, 0 0 1 0; -fx-padding: 0.0em; -fx-alignment: CENTER;");
                this.setText(d.format(DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM)));
                tip.setText("Preostalo jo\u0161 " + p.getYears() + " god. " + p.getMonths() + " mj,\n i " + p.getDays() + "  dana do isteka. \n( ukupno  " + p2 + "  dana )");
                this.setTooltip(tip);
                this.setGraphic(null);
            } else if (p2 > 30L) {
                this.setStyle("-fx-background-color:-fx-table-cell-border-color, yellowgreen ;-fx-background-insets: 0, 0 0 1 0; -fx-padding: 0.0em; -fx-alignment: CENTER;");
                this.setText(d.format(DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM)));
                tip.setText("Preostalo jo\u0161 " + p.getYears() + " god. " + p.getMonths() + " mj,\n i " + p.getDays() + "  dana do isteka. \n( ukupno  " + p2 + "  dana )");
                this.setTooltip(tip);
                this.setGraphic(null);
            } else {
                this.setTooltip(null);
                this.setGraphic(null);
                Tooltip.uninstall((Node)this, (Tooltip)tip);
            }
        }
    }
}

