/*
 * Decompiled with CFR 0.152.
 */
package monitoringnovi;

import java.io.IOException;
import java.net.URL;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.chrono.ChronoLocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.TextAlignment;
import javafx.util.Pair;
import kadrovska.UnosDjelatnikaController;
import mjerniinstrumenti.MjerniInstrumentPodaci;
import mjerniinstrumenti.UnosMjernogInstrumentaController;
import monitoring.DjelatnikPregled;
import monitoring.MonitoringController;
import monitoring.ObjektNadzor;
import monitoringnovi.DjelatnikOsposobljavanjePopupController;
import monitoringnovi.DjelatnikOstaliPreglediPopupController;
import monitoringnovi.DjlatnikOZOPopupController;
import monitoringnovi.ObjektNoviPopupController;
import monitoringnovi.TjedniPregledService;
import org.controlsfx.control.PopOver;
import radnaoprema.StrojEvidencija;
import radnaoprema.UnosStrojevaController;
import radniokolis.MjernoMjestoFRO;
import radniokolis.UnosFROController;
import zastitanaradu.GlavniPanelController;

public class TjedniPregledController
implements Initializable {
    @FXML
    private StackPane stackPaneMask;
    @FXML
    private BorderPane borderPane;
    @FXML
    private Button btnOduzmi;
    @FXML
    private Label lblGodina;
    @FXML
    private Button btnNadodaj;
    private final LocalTime firstSlotStart = LocalTime.of(0, 0);
    private final Duration slotLength = Duration.ofMinutes(15L);
    private final LocalTime lastSlotStart = LocalTime.of(23, 59);
    private final List<MonitoringController.TimeSlot> timeSlots = new ArrayList<MonitoringController.TimeSlot>();
    private GridPane calendarView = null;
    private GridPane calendarDays = null;
    private LocalDate today = LocalDate.now();
    private LocalDate startOfWeek;
    private LocalDate endOfWeek;
    private ScrollPane scrollPane = null;
    private ScrollPane scroller;
    private Map<String, Pair<Object, LocalDate>> listaDatuma = new HashMap<String, Pair<Object, LocalDate>>();
    private DateTimeFormatter dayFormatter = DateTimeFormatter.ofPattern("E\nd MMM ");
    private TimeSlot timeSlot = null;
    private LocalDate date = null;
    private StackPane p = null;
    private int slotIndex = 1;
    private LocalDate dateMarker = null;
    private TjedniPregledService tpservice;
    private Region veil = new Region();
    private ProgressIndicator pmask = new ProgressIndicator();
    private VBox vb = new VBox();
    private boolean isShowing = false;
    private static TjedniPregledController instance;

    public TjedniPregledService getTpservice() {
        return this.tpservice;
    }

    public void setTpservice(TjedniPregledService tpservice) {
        this.tpservice = tpservice;
    }

    public boolean isIsShowing() {
        return this.isShowing;
    }

    public void setIsShowing(boolean isShowing) {
        this.isShowing = isShowing;
    }

    public static TjedniPregledController getInstance() {
        return instance;
    }

    public void initialize(URL url, ResourceBundle rb) {
        instance = this;
        this.setIsShowing(true);
        this.tpservice = new TjedniPregledService(this);
        this.veil.setStyle("-fx-background-color: rgba(0, 0, 0, 0.4)");
        this.pmask.setMaxSize(150.0, 150.0);
        this.stackPaneMask.getChildren().addAll((Object[])new Node[]{this.veil, this.pmask});
        this.pmask.progressProperty().bind((ObservableValue)this.tpservice.progressProperty());
        this.veil.visibleProperty().bind((ObservableValue)this.tpservice.runningProperty());
        this.pmask.visibleProperty().bind((ObservableValue)this.tpservice.runningProperty());
        this.btnNadodaj.setOnAction(e -> Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                TjedniPregledController.this.nadodajTjedan();
            }
        }));
        this.btnOduzmi.setOnAction(e -> Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                TjedniPregledController.this.oduzmiTjedan();
            }
        }));
        this.popuniTjedniPregled();
    }

    void setListaTjedniRaspored(Map<String, Pair<Object, LocalDate>> ld) {
        this.listaDatuma.clear();
        this.listaDatuma = ld;
    }

    private void popuniTjedniPregled() {
        this.tpservice.setOnSucceeded((EventHandler)new EventHandler<WorkerStateEvent>(){

            public void handle(WorkerStateEvent t) {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        TjedniPregledController.this.postaviTjedniRaspored();
                    }
                });
            }
        });
        this.tpservice.start();
    }

    private void postaviTjedniRaspored() {
        this.vb.getChildren().clear();
        this.calendarView = new GridPane();
        this.calendarDays = new GridPane();
        this.scrollPane = new ScrollPane((Node)this.calendarView);
        this.vb.getChildren().addAll((Object[])new Node[]{this.calendarDays, this.scrollPane});
        this.scrollPane.widthProperty().addListener((observable, oldValue, newValue) -> {
            this.calendarView.setPrefWidth(this.scrollPane.getWidth());
            this.calendarDays.setPrefWidth(this.scrollPane.getWidth());
        });
        this.calendarView.getStyleClass().add((Object)"game-grid");
        this.calendarDays.getStyleClass().add((Object)"game-grid");
        this.startOfWeek = this.dateMarker != null ? this.dateMarker.minusDays(this.dateMarker.getDayOfWeek().getValue() - 1) : this.today.minusDays(this.today.getDayOfWeek().getValue() - 1);
        this.endOfWeek = this.startOfWeek.plusDays(6L);
        this.date = this.startOfWeek;
        while (!this.date.isAfter(this.endOfWeek)) {
            this.slotIndex = 1;
            this.listaDatuma.forEach((k, v) -> {
                this.timeSlot = new TimeSlot(this.date.atTime(this.firstSlotStart), this.slotLength, v.getKey(), (String)k);
                if (v.getValue() != null && this.date.isEqual((ChronoLocalDate)v.getValue())) {
                    this.p = new StackPane();
                    this.p.setPrefSize(250.0, 55.0);
                    DayOfWeek day = this.date.getDayOfWeek();
                    if (day == DayOfWeek.SATURDAY || day == DayOfWeek.SUNDAY) {
                        this.p.setStyle("-fx-background-color: lightgray ;-fx-border-color: gray;-fx-border-width: 0.5; ");
                    } else {
                        this.p.setStyle("-fx-background-color: whitesmoke ;-fx-border-color: gray;-fx-border-width: 0.5; ");
                    }
                    if (this.timeSlot.getView() != null) {
                        this.p.getChildren().add((Object)this.timeSlot.getView());
                    }
                    StackPane.setAlignment((Node)this.p, (Pos)Pos.CENTER_LEFT);
                    this.calendarView.add((Node)this.p, this.timeSlot.getDayOfWeek().getValue(), this.slotIndex);
                    ++this.slotIndex;
                }
            });
            while (this.slotIndex < this.listaDatuma.size()) {
                this.p = new StackPane();
                this.p.setPrefSize(250.0, 55.0);
                DayOfWeek day = this.date.getDayOfWeek();
                if (day == DayOfWeek.SATURDAY || day == DayOfWeek.SUNDAY) {
                    this.p.setStyle("-fx-background-color: lightgray    ;-fx-border-color: gray;-fx-border-width: 0.5; ");
                } else {
                    this.p.setStyle("-fx-background-color: whitesmoke ;-fx-border-color: gray;-fx-border-width: 0.5; ");
                }
                StackPane.setAlignment((Node)this.p, (Pos)Pos.CENTER_LEFT);
                this.calendarView.add((Node)this.p, this.timeSlot.getDayOfWeek().getValue(), this.slotIndex);
                ++this.slotIndex;
            }
            this.date = this.date.plusDays(1L);
        }
        LocalDate date = this.startOfWeek;
        while (!date.isAfter(this.endOfWeek)) {
            Label label = new Label(date.format(this.dayFormatter));
            label.setPadding(new Insets(1.0));
            label.setStyle("-fx-font-weight: bold;-fx-font-size: 1.5em;  -fx-font-family:Arial");
            label.setTextAlignment(TextAlignment.CENTER);
            GridPane.setHalignment((Node)label, (HPos)HPos.CENTER);
            StackPane p = new StackPane();
            p.setPrefWidth(250.0);
            p.setMinHeight(60.0);
            StackPane.setAlignment((Node)p, (Pos)Pos.CENTER);
            DayOfWeek day = date.getDayOfWeek();
            if (day == DayOfWeek.SATURDAY || day == DayOfWeek.SUNDAY) {
                label.setTextFill((Paint)Color.RED);
                p.setStyle("-fx-background-color: lightgray ;-fx-border-color: gray;-fx-border-width: 0.5; ");
            } else {
                p.setStyle("-fx-background-color: white ;-fx-border-color: gray;-fx-border-width: 0.5; ");
            }
            if (date.equals(this.today)) {
                p.setStyle("-fx-background-color: lightsteelblue;-fx-border-color: red;-fx-border-width: 2; ");
            }
            p.getChildren().add((Object)label);
            this.lblGodina.setText(String.valueOf(date.getYear()));
            this.calendarDays.add((Node)p, date.getDayOfWeek().getValue(), 0);
            date = date.plusDays(1L);
        }
        StackPane.setAlignment((Node)this.calendarDays, (Pos)Pos.CENTER);
        this.borderPane.setCenter((Node)this.vb);
    }

    private void nadodajTjedan() {
        this.vb.getChildren().clear();
        this.calendarView = new GridPane();
        this.calendarDays = new GridPane();
        this.scrollPane = new ScrollPane((Node)this.calendarView);
        this.vb.getChildren().addAll((Object[])new Node[]{this.calendarDays, this.scrollPane});
        this.calendarView.getStyleClass().add((Object)"game-grid");
        this.calendarDays.getStyleClass().add((Object)"game-grid");
        this.scrollPane.widthProperty().addListener((observable, oldValue, newValue) -> this.calendarView.setPrefWidth(this.scrollPane.getWidth()));
        this.startOfWeek = this.endOfWeek;
        this.dateMarker = this.endOfWeek = this.startOfWeek.plusDays(7L);
        this.date = this.startOfWeek.plusDays(1L);
        while (!this.date.isAfter(this.endOfWeek)) {
            this.slotIndex = 1;
            this.listaDatuma.forEach((k, v) -> {
                this.timeSlot = new TimeSlot(this.date.atTime(this.firstSlotStart), this.slotLength, v.getKey(), (String)k);
                if (v.getValue() != null && this.date.isEqual((ChronoLocalDate)v.getValue())) {
                    this.p = new StackPane();
                    this.p.setPrefSize(250.0, 55.0);
                    DayOfWeek day = this.date.getDayOfWeek();
                    if (day == DayOfWeek.SATURDAY || day == DayOfWeek.SUNDAY) {
                        this.p.setStyle("-fx-background-color: lightgray    ;-fx-border-color: gray;-fx-border-width: 0.5; ");
                    } else {
                        this.p.setStyle("-fx-background-color: whitesmoke ;-fx-border-color: gray;-fx-border-width: 0.5; ");
                    }
                    if (this.timeSlot.getView() != null) {
                        this.p.getChildren().add((Object)this.timeSlot.getView());
                    }
                    StackPane.setAlignment((Node)this.p, (Pos)Pos.CENTER_LEFT);
                    this.calendarView.add((Node)this.p, this.timeSlot.getDayOfWeek().getValue(), this.slotIndex);
                    ++this.slotIndex;
                }
            });
            while (this.slotIndex < this.listaDatuma.size()) {
                this.p = new StackPane();
                this.p.setPrefSize(250.0, 55.0);
                DayOfWeek day = this.date.getDayOfWeek();
                if (day == DayOfWeek.SATURDAY || day == DayOfWeek.SUNDAY) {
                    this.p.setStyle("-fx-background-color: lightgray    ;-fx-border-color: gray;-fx-border-width: 0.5; ");
                } else {
                    this.p.setStyle("-fx-background-color: whitesmoke ;-fx-border-color: gray;-fx-border-width: 0.5; ");
                }
                StackPane.setAlignment((Node)this.p, (Pos)Pos.CENTER_LEFT);
                this.calendarView.add((Node)this.p, this.timeSlot.getDayOfWeek().getValue(), this.slotIndex);
                ++this.slotIndex;
            }
            this.date = this.date.plusDays(1L);
        }
        LocalDate date = this.startOfWeek.plusDays(1L);
        while (!date.isAfter(this.endOfWeek)) {
            Label label = new Label(date.format(this.dayFormatter));
            label.setPadding(new Insets(1.0));
            label.setStyle("-fx-font-weight: bold;-fx-font-size: 1.5em;  -fx-font-family:Arial");
            label.setTextAlignment(TextAlignment.CENTER);
            GridPane.setHalignment((Node)label, (HPos)HPos.CENTER);
            StackPane p = new StackPane();
            p.setPrefWidth(250.0);
            p.setMinHeight(60.0);
            StackPane.setAlignment((Node)p, (Pos)Pos.CENTER_LEFT);
            DayOfWeek day = date.getDayOfWeek();
            if (day == DayOfWeek.SATURDAY || day == DayOfWeek.SUNDAY) {
                label.setTextFill((Paint)Color.RED);
                p.setStyle("-fx-background-color: lightgray ;-fx-border-color: gray;-fx-border-width: 0.5; ");
            } else {
                p.setStyle("-fx-background-color: white ;-fx-border-color: gray;-fx-border-width: 0.5; ");
            }
            if (date.equals(this.today)) {
                p.setStyle("-fx-background-color: lightsteelblue  ;-fx-border-color: red;-fx-border-width: 2; ");
            }
            p.getChildren().add((Object)label);
            this.lblGodina.setText(String.valueOf(date.getYear()));
            this.calendarDays.add((Node)p, date.getDayOfWeek().getValue(), 0);
            date = date.plusDays(1L);
        }
        StackPane.setAlignment((Node)this.calendarDays, (Pos)Pos.CENTER);
        this.borderPane.setCenter((Node)this.vb);
    }

    private void oduzmiTjedan() {
        this.vb.getChildren().clear();
        this.calendarView = new GridPane();
        this.calendarDays = new GridPane();
        this.scrollPane = new ScrollPane((Node)this.calendarView);
        this.vb.getChildren().addAll((Object[])new Node[]{this.calendarDays, this.scrollPane});
        this.calendarView.getStyleClass().add((Object)"game-grid");
        this.calendarDays.getStyleClass().add((Object)"game-grid");
        this.scrollPane.widthProperty().addListener((observable, oldValue, newValue) -> this.calendarView.setPrefWidth(this.scrollPane.getWidth()));
        this.startOfWeek = this.endOfWeek;
        this.endOfWeek = this.startOfWeek.minusDays(7L);
        this.dateMarker = this.startOfWeek;
        this.date = this.startOfWeek;
        while (!this.date.isBefore(this.endOfWeek.plusDays(1L))) {
            this.slotIndex = 1;
            this.listaDatuma.forEach((k, v) -> {
                this.timeSlot = new TimeSlot(this.date.atTime(this.firstSlotStart), this.slotLength, v.getKey(), (String)k);
                if (v.getValue() != null && this.date.isEqual((ChronoLocalDate)v.getValue())) {
                    this.p = new StackPane();
                    this.p.setPrefSize(250.0, 55.0);
                    DayOfWeek day = this.date.getDayOfWeek();
                    if (day == DayOfWeek.SATURDAY || day == DayOfWeek.SUNDAY) {
                        this.p.setStyle("-fx-background-color: lightgray    ;-fx-border-color: gray;-fx-border-width: 0.5; ");
                    } else {
                        this.p.setStyle("-fx-background-color: whitesmoke ;-fx-border-color: gray;-fx-border-width: 0.5; ");
                    }
                    if (this.timeSlot.getView() != null) {
                        this.p.getChildren().add((Object)this.timeSlot.getView());
                    }
                    StackPane.setAlignment((Node)this.p, (Pos)Pos.CENTER_LEFT);
                    this.calendarView.add((Node)this.p, this.timeSlot.getDayOfWeek().getValue(), this.slotIndex);
                    ++this.slotIndex;
                }
            });
            while (this.slotIndex < this.listaDatuma.size()) {
                this.p = new StackPane();
                this.p.setPrefSize(250.0, 55.0);
                DayOfWeek day = this.date.getDayOfWeek();
                if (day == DayOfWeek.SATURDAY || day == DayOfWeek.SUNDAY) {
                    this.p.setStyle("-fx-background-color: lightgray    ;-fx-border-color: gray;-fx-border-width: 0.5; ");
                } else {
                    this.p.setStyle("-fx-background-color: whitesmoke ;-fx-border-color: gray;-fx-border-width: 0.5; ");
                }
                StackPane.setAlignment((Node)this.p, (Pos)Pos.CENTER_LEFT);
                this.calendarView.add((Node)this.p, this.timeSlot.getDayOfWeek().getValue(), this.slotIndex);
                ++this.slotIndex;
            }
            this.date = this.date.minusDays(1L);
        }
        LocalDate date = this.startOfWeek;
        while (!date.isBefore(this.endOfWeek.plusDays(1L))) {
            Label label = new Label(date.format(this.dayFormatter));
            label.setPadding(new Insets(1.0));
            label.setTextAlignment(TextAlignment.CENTER);
            GridPane.setHalignment((Node)label, (HPos)HPos.CENTER);
            label.setStyle("-fx-font-weight: bold;-fx-font-size: 1.5em;  -fx-font-family:Arial");
            StackPane p = new StackPane();
            p.setPrefWidth(250.0);
            p.setMinHeight(60.0);
            StackPane.setAlignment((Node)p, (Pos)Pos.CENTER_LEFT);
            DayOfWeek day = date.getDayOfWeek();
            if (day == DayOfWeek.SATURDAY || day == DayOfWeek.SUNDAY) {
                label.setTextFill((Paint)Color.RED);
                p.setStyle("-fx-background-color: lightgray ;-fx-border-color: gray;-fx-border-width: 0.5; ");
            } else {
                p.setStyle("-fx-background-color: white ;-fx-border-color: gray;-fx-border-width: 0.5; ");
            }
            if (date.equals(this.today)) {
                p.setStyle("-fx-background-color: lightsteelblue  ;-fx-border-color: red;-fx-border-width: 2; ");
            }
            p.getChildren().add((Object)label);
            this.calendarDays.add((Node)p, date.getDayOfWeek().getValue(), 0);
            this.lblGodina.setText(String.valueOf(date.getYear()));
            date = date.minusDays(1L);
        }
        StackPane.setAlignment((Node)this.calendarDays, (Pos)Pos.CENTER);
        this.borderPane.setCenter((Node)this.vb);
    }

    public static class TimeSlot {
        private final LocalDateTime start;
        private Duration duration = null;
        private Button b = null;
        PopOver item = new PopOver();

        public TimeSlot(LocalDateTime start, Duration duration, Object o, String d) {
            this.start = start;
            this.duration = duration;
            StringTokenizer st = new StringTokenizer(d);
            String poruka = st.nextToken();
            if (poruka.equalsIgnoreCase("LIJE\u010cNI\u010cKI")) {
                this.b = this.dajButtonLjecnicki(poruka, o);
            } else if (poruka.equalsIgnoreCase("ozo")) {
                this.b = this.dajButtonOZO(poruka, o);
            } else if (poruka.equalsIgnoreCase("FRO")) {
                this.b = this.dajButtonFRO(poruka, o);
            } else if (poruka.equalsIgnoreCase("OBJEKAT")) {
                this.b = this.dajButtonOBJEKAT(poruka, o);
            } else if (poruka.equalsIgnoreCase("STROJ")) {
                this.b = this.dajButtonSTROJ(poruka, o);
            } else if (poruka.equalsIgnoreCase("OSPOSOBLJAVANJA")) {
                this.b = this.dajButtonOsposobljavanja(poruka, o);
            } else if (poruka.equalsIgnoreCase("SJEDNICA")) {
                this.b = this.dajButtonSjednicaOdbora(poruka, o);
            } else if (poruka.equalsIgnoreCase("MJERNI-URE\u0110AJ")) {
                this.b = this.dajButtonMjerniInstrumenti(poruka, o);
            } else if (poruka.equalsIgnoreCase("PREGLED")) {
                this.b = this.dajButtonDrugiPregled(poruka, o);
            }
        }

        public LocalDateTime getStart() {
            return this.start;
        }

        public LocalTime getTime() {
            return this.start.toLocalTime();
        }

        public DayOfWeek getDayOfWeek() {
            return this.start.getDayOfWeek();
        }

        public Duration getDuration() {
            return this.duration;
        }

        public Node getView() {
            return this.b;
        }

        private Button dajButtonLjecnicki(String poruka, Object o) {
            Button b = null;
            DjelatnikPregled dj = (DjelatnikPregled)o;
            b = new Button(dj.getIme() + " " + dj.getPrezime() + "\n " + poruka);
            b.setTooltip(new Tooltip(dj.getIme() + " " + dj.getPrezime() + " " + poruka));
            b.setPrefWidth(200.0);
            b.setStyle("-fx-background-color: cornflowerblue    ;-fx-border-color: gray;-fx-border-width: 0.5; ");
            b.setOnMouseClicked(e -> {
                if (!GlavniPanelController.getInstance().getTabByIdifExist("Unos Djelatnika")) {
                    GlavniPanelController.getInstance().zatvoriTab("Unos Djelatnika");
                    GlavniPanelController.getInstance().nadodajPanel("Unos Djelatnika", "/kadrovska/UnosDjelatnika.fxml");
                    UnosDjelatnikaController.getInstance().izmjenaDjelatnikaPopup(dj);
                    UnosDjelatnikaController.getInstance().getTabPanePodaci().getSelectionModel().select(2);
                } else {
                    GlavniPanelController.getInstance().nadodajPanel("Unos Djelatnika", "/kadrovska/UnosDjelatnika.fxml");
                    UnosDjelatnikaController.getInstance().izmjenaDjelatnikaPopup(dj);
                    UnosDjelatnikaController.getInstance().getTabPanePodaci().getSelectionModel().select(2);
                }
            });
            return b;
        }

        private Button dajButtonOZO(String poruka, Object o) {
            DjelatnikPregled dj = (DjelatnikPregled)o;
            this.b = new Button(dj.getIme() + " " + dj.getPrezime() + "\n " + poruka);
            this.b.setTooltip(new Tooltip(dj.getIme() + " " + dj.getPrezime() + " " + poruka));
            this.b.setPrefWidth(200.0);
            this.b.setStyle("-fx-background-color: red  ;-fx-border-color: gray;-fx-border-width: 0.5; ");
            this.b.setOnMouseClicked(e -> {
                FXMLLoader loader = new FXMLLoader(this.getClass().getResource("DjlatnikOZOPopup.fxml"));
                Parent root = null;
                try {
                    root = (Parent)loader.load();
                }
                catch (IOException ex) {
                    Logger.getLogger(MonitoringController.class.getName()).log(Level.SEVERE, null, ex);
                }
                this.item.setContentNode((Node)root);
                DjlatnikOZOPopupController.getInstance().prikaziDjelatnika(dj, this.item);
                this.item.setArrowLocation(PopOver.ArrowLocation.LEFT_TOP);
                this.item.setCornerRadius(4.0);
                this.item.setTitle(poruka);
                this.item.show((Node)this.getView().getParent(), e.getScreenX(), e.getScreenY());
            });
            return this.b;
        }

        private Button dajButtonFRO(String poruka, Object o) {
            Button b = null;
            MjernoMjestoFRO mm = (MjernoMjestoFRO)o;
            b = new Button(mm.getNazivMjernogMjesta() + "\n " + poruka);
            b.setTooltip(new Tooltip(mm.getNazivMjernogMjesta() + "\n " + poruka));
            b.setPrefWidth(200.0);
            b.setStyle("-fx-background-color:olivedrab     ;-fx-border-color: gray;-fx-border-width: 0.5; ");
            b.setOnMouseClicked(e -> {
                if (!GlavniPanelController.getInstance().getTabByIdifExist("Unos mjernog mjesta")) {
                    GlavniPanelController.getInstance().zatvoriTab("Unos mjernog mjesta");
                    GlavniPanelController.getInstance().nadodajPanel("Unos mjernog mjesta", "/radniokolis/UnosFRO.fxml");
                    UnosFROController.getInstance().izmjenaFRO(mm);
                    UnosFROController.getInstance().getTabPanePodaci().getSelectionModel().select(1);
                } else {
                    GlavniPanelController.getInstance().nadodajPanel("Unos mjernog mjesta", "/radniokolis/UnosFRO.fxml");
                    UnosFROController.getInstance().izmjenaFRO(mm);
                    UnosFROController.getInstance().getTabPanePodaci().getSelectionModel().select(1);
                }
            });
            return b;
        }

        private Button dajButtonOBJEKAT(String poruka, Object o) {
            Button b = null;
            ObjektNadzor on = (ObjektNadzor)o;
            b = new Button(on.getNazivObjekta() + "\n " + poruka);
            b.setTooltip(new Tooltip(on.getNazivObjekta() + " " + poruka));
            b.setPrefWidth(200.0);
            b.setStyle("-fx-background-color: midnightblue    ;-fx-border-color: gray;-fx-border-width: 0.5; ");
            b.setOnMouseClicked(e -> {
                FXMLLoader loader = new FXMLLoader(this.getClass().getResource("ObjektNoviPopup.fxml"));
                Parent root = null;
                try {
                    root = (Parent)loader.load();
                }
                catch (IOException ex) {
                    Logger.getLogger(MonitoringController.class.getName()).log(Level.SEVERE, null, ex);
                }
                this.item.setContentNode((Node)root);
                ObjektNoviPopupController.getInstance().prikaziObjekt(on, this.item);
                this.item.setArrowLocation(PopOver.ArrowLocation.LEFT_TOP);
                this.item.setCornerRadius(4.0);
                this.item.setTitle(poruka);
                this.item.show((Node)this.getView().getParent(), e.getScreenX(), e.getScreenY());
            });
            return b;
        }

        private Button dajButtonSTROJ(String poruka, Object o) {
            Button b = null;
            StrojEvidencija se = (StrojEvidencija)o;
            b = new Button(se.getNazivstroja() + "\n " + poruka);
            b.setTooltip(new Tooltip(se.getNazivstroja() + "\n " + poruka));
            b.setPrefWidth(200.0);
            b.setStyle("-fx-background-color: olivedrab    ;-fx-border-color: gray;-fx-border-width: 0.5; ");
            b.setOnMouseClicked(e -> {
                if (!GlavniPanelController.getInstance().getTabByIdifExist("Unos Stroja")) {
                    GlavniPanelController.getInstance().zatvoriTab("Unos Stroja");
                    GlavniPanelController.getInstance().nadodajPanel("Unos Stroja", "/radnaoprema/UnosStrojeva.fxml");
                    UnosStrojevaController.getInstance().izmjenaStroja(se);
                    UnosStrojevaController.getInstance().getTabPanePodaci().getSelectionModel().select(2);
                } else {
                    GlavniPanelController.getInstance().nadodajPanel("Unos Stroja", "/radnaoprema/UnosStrojeva.fxml");
                    UnosStrojevaController.getInstance().izmjenaStroja(se);
                    UnosStrojevaController.getInstance().getTabPanePodaci().getSelectionModel().select(2);
                }
            });
            return b;
        }

        private Button dajButtonOsposobljavanja(String poruka, Object o) {
            Button b = null;
            DjelatnikPregled dj = (DjelatnikPregled)o;
            b = new Button(dj.getIme() + " " + dj.getPrezime() + "\n " + poruka);
            b.setTooltip(new Tooltip(dj.getIme() + " " + dj.getPrezime() + " " + poruka));
            b.setPrefWidth(200.0);
            b.setStyle("-fx-background-color: coral  ;-fx-border-color: gray;-fx-border-width: 0.5; ");
            b.setOnMouseClicked(e -> {
                FXMLLoader loader = new FXMLLoader(this.getClass().getResource("DjelatnikOsposobljavanjePopup.fxml"));
                Parent root = null;
                try {
                    root = (Parent)loader.load();
                }
                catch (IOException ex) {
                    Logger.getLogger(MonitoringController.class.getName()).log(Level.SEVERE, null, ex);
                }
                this.item.setContentNode((Node)root);
                DjelatnikOsposobljavanjePopupController.getInstance().prikaziDjelatnika(dj, this.item);
                this.item.setArrowLocation(PopOver.ArrowLocation.LEFT_TOP);
                this.item.setCornerRadius(4.0);
                this.item.setTitle(poruka);
                this.item.show((Node)this.getView().getParent(), e.getScreenX(), e.getScreenY());
            });
            return b;
        }

        private Button dajButtonSjednicaOdbora(String poruka, Object o) {
            Button b = null;
            String dj = o.toString();
            b = new Button("ODBOR\n " + poruka);
            b.setTooltip(new Tooltip(poruka + " ODBORA"));
            b.setPrefWidth(200.0);
            b.setStyle("-fx-background-color: steelblue    ;-fx-border-color: gray;-fx-border-width: 0.5; ");
            b.setOnMouseClicked(e -> GlavniPanelController.getInstance().nadodajPanel("Odbor za\u0161tite na radu", "/odbor/Odbor.fxml"));
            return b;
        }

        private Button dajButtonMjerniInstrumenti(String poruka, Object o) {
            Button b = null;
            MjerniInstrumentPodaci se = (MjerniInstrumentPodaci)o;
            b = new Button(se.getNazivstroja() + "\n " + poruka);
            b.setTooltip(new Tooltip(se.getNazivstroja() + "\n " + poruka));
            b.setPrefWidth(200.0);
            b.setStyle("-fx-background-color: chocolate   ;-fx-border-color: gray;-fx-border-width: 0.5; ");
            b.setOnMouseClicked(e -> {
                if (!GlavniPanelController.getInstance().getTabByIdifExist("Unos ure\u0111aja")) {
                    GlavniPanelController.getInstance().zatvoriTab("Unos ure\u0111aja");
                    GlavniPanelController.getInstance().nadodajPanel("Unos ure\u0111aja", "/mjerniinstrumenti/UnosMjernogInstrumenta.fxml");
                    UnosMjernogInstrumentaController.getInstance().izmjenaUredjaja(se);
                    UnosMjernogInstrumentaController.getInstance().getTabPanePodaci().getSelectionModel().select(2);
                } else {
                    GlavniPanelController.getInstance().nadodajPanel("Unos ure\u0111aja", "/mjerniinstrumenti/UnosMjernogInstrumenta.fxml");
                    UnosMjernogInstrumentaController.getInstance().izmjenaUredjaja(se);
                    UnosMjernogInstrumentaController.getInstance().getTabPanePodaci().getSelectionModel().select(2);
                }
            });
            return b;
        }

        private Button dajButtonDrugiPregled(String poruka, Object o) {
            Button b = null;
            DjelatnikPregled dj = (DjelatnikPregled)o;
            b = new Button(dj.getIme() + " " + dj.getPrezime() + "\n " + poruka);
            b.setTooltip(new Tooltip(dj.getIme() + " " + dj.getPrezime() + " " + poruka));
            b.setPrefWidth(200.0);
            b.setStyle("-fx-background-color: orchid   ;-fx-border-color: gray;-fx-border-width: 0.5; ");
            b.setOnMouseClicked(e -> {
                FXMLLoader loader = new FXMLLoader(this.getClass().getResource("DjelatnikOstaliPreglediPopup.fxml"));
                Parent root = null;
                try {
                    root = (Parent)loader.load();
                }
                catch (IOException ex) {
                    Logger.getLogger(MonitoringController.class.getName()).log(Level.SEVERE, null, ex);
                }
                this.item.setContentNode((Node)root);
                DjelatnikOstaliPreglediPopupController.getInstance().prikaziDjelatnika(dj, this.item);
                this.item.setArrowLocation(PopOver.ArrowLocation.LEFT_TOP);
                this.item.setCornerRadius(4.0);
                this.item.setTitle(poruka);
                this.item.show((Node)this.getView().getParent(), e.getScreenX(), e.getScreenY());
            });
            return b;
        }
    }
}

