/*
 * Decompiled with CFR 0.152.
 */
package monitoringnovi;

import Utill.DateUtil;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.util.Pair;
import monitoring.DjelatnikPregled;
import monitoring.FROPregled;
import monitoring.NadzorMjerniInstrumentPregled;
import monitoring.NadzorStrojPregled;
import monitoring.ObjektNadzor;
import monitoringnovi.BazaMonitoringNovi;
import monitoringnovi.DjelatnikOsposobljavanjePopupController;
import monitoringnovi.NadzorVAtrogasniAparat;
import monitoringnovi.TjedniPregledController;
import objektiispitivanja.ObjekatEvidencijaPregleda;
import zastitanaradu.GlavniPanelController;

public class TjedniPregledService
extends Service<Map<String, Pair<Object, LocalDate>>> {
    private TjedniPregledController mk = null;

    public TjedniPregledService() {
    }

    public TjedniPregledService(TjedniPregledController mk) {
        this.mk = mk;
    }

    protected Task<Map<String, Pair<Object, LocalDate>>> createTask() {
        return new SjednicaOdboraNadzorTask();
    }

    private void addTjedniRasporedUI(final Map<String, Pair<Object, LocalDate>> ld) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (TjedniPregledService.this.mk != null) {
                    TjedniPregledService.this.mk.setListaTjedniRaspored(ld);
                }
            }
        });
    }

    class SjednicaOdboraNadzorTask
    extends Task<Map<String, Pair<Object, LocalDate>>> {
        private final Map<String, Pair<Object, LocalDate>> listaDatuma = new HashMap<String, Pair<Object, LocalDate>>();
        private final ObservableList<DjelatnikPregled> listaDjelatnikOsposobljavanje = FXCollections.observableArrayList();
        private final ObservableList<ObjektNadzor> listaObjekti = FXCollections.observableArrayList();
        private final ObservableList<DjelatnikPregled> ozo = FXCollections.observableArrayList();
        private final ObservableList<ObjekatEvidencijaPregleda> listaOep = FXCollections.observableArrayList();
        private final ObservableList<DjelatnikPregled> listaDjelatnikLjecnicki = FXCollections.observableArrayList();
        private final ObservableList<DjelatnikPregled> listaDjelatnikOstaliPregledi = FXCollections.observableArrayList();
        private final ObservableList<FROPregled> listaFRO = FXCollections.observableArrayList();
        private final ObservableList<NadzorStrojPregled> listaStrojeva = FXCollections.observableArrayList();
        private final ObservableList<NadzorMjerniInstrumentPregled> listaMjerniInstrumenti = FXCollections.observableArrayList();
        private final ObservableList<NadzorVAtrogasniAparat> listaVatrogasniAparati = FXCollections.observableArrayList();
        LocalDate datumSjedniceOdbora = null;

        SjednicaOdboraNadzorTask() {
        }

        protected Map<String, Pair<Object, LocalDate>> call() throws Exception {
            this.popuniDatumeDjelatnika();
            this.filtrirajListuDjelatnika(this.ozo, Opcije.ozo);
            this.filtrirajListuDjelatnika(this.listaDjelatnikOsposobljavanje, Opcije.osposobljavanje);
            this.filtrirajListuDjelatnika(this.listaDjelatnikLjecnicki, Opcije.ljecnicki);
            this.filtrirajListuDjelatnika(this.listaDjelatnikOstaliPregledi, Opcije.ostaliPregledi);
            this.popuniFRO();
            this.popuniObjekt();
            this.popuniStroj();
            this.popuniSjednicu();
            this.popuniMjerneUredjaje();
            this.popuniVatrogasneAparate();
            this.popuniDatume();
            TjedniPregledService.this.addTjedniRasporedUI(this.listaDatuma);
            return this.listaDatuma;
        }

        private void popuniDatume() {
            int j = 0;
            for (DjelatnikPregled dozo : this.ozo) {
                if (dozo.getOzo() == null) continue;
                this.listaDatuma.put("OZO " + j++, (Pair<Object, LocalDate>)new Pair((Object)dozo, (Object)dozo.getOzo()));
            }
            for (DjelatnikPregled dp : this.listaDjelatnikOsposobljavanje) {
                if (dp.getOsposobljavanje() == null) continue;
                this.listaDatuma.put("OSPOSOBLJAVANJA " + j++, (Pair<Object, LocalDate>)new Pair((Object)dp, (Object)dp.getOsposobljavanje()));
            }
            for (DjelatnikPregled dp : this.listaDjelatnikLjecnicki) {
                if (dp.getDatumIstekaLJPregleda() == null) continue;
                this.listaDatuma.put("LIJE\u010cNI\u010cKI " + j++, (Pair<Object, LocalDate>)new Pair((Object)dp, (Object)dp.getDatumIstekaLJPregleda()));
            }
            for (DjelatnikPregled d : this.listaDjelatnikOstaliPregledi) {
                if (d.getOstaliPregled() == null) continue;
                this.listaDatuma.put("PREGLED " + j++, (Pair<Object, LocalDate>)new Pair((Object)d, (Object)d.getOstaliPregled()));
            }
            for (FROPregled fro : this.listaFRO) {
                this.listaDatuma.put("FRO " + j++, (Pair<Object, LocalDate>)new Pair((Object)fro, (Object)fro.getdatumIstekaPregleda()));
            }
            for (ObjektNadzor on : this.listaObjekti) {
                this.listaDatuma.put("OBJEKAT " + j++, (Pair<Object, LocalDate>)new Pair((Object)on, (Object)on.getDatumPonovogIspitivanja()));
            }
            for (NadzorStrojPregled nsp : this.listaStrojeva) {
                this.listaDatuma.put("STROJ " + j++, (Pair<Object, LocalDate>)new Pair((Object)nsp, (Object)nsp.getdatumIstekaPregleda()));
            }
            if (this.datumSjedniceOdbora != null) {
                this.datumSjedniceOdbora = this.datumSjedniceOdbora.plusMonths(3L);
                this.listaDatuma.put("SJEDNICA " + j++, (Pair<Object, LocalDate>)new Pair((Object)this.datumSjedniceOdbora, (Object)this.datumSjedniceOdbora));
            }
            for (NadzorMjerniInstrumentPregled mi : this.listaMjerniInstrumenti) {
                this.listaDatuma.put("MJERNI-URE\u0110AJ " + j++, (Pair<Object, LocalDate>)new Pair((Object)mi, (Object)mi.getdatumIstekaPregleda()));
            }
            for (NadzorVAtrogasniAparat va : this.listaVatrogasniAparati) {
                this.listaDatuma.put("VATROGASNI-APARAT " + j++, (Pair<Object, LocalDate>)new Pair((Object)va, (Object)va.getdatumIstekaPregleda()));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void popuniFRO() {
            ResultSet rs = BazaMonitoringNovi.dajMjernaMjestaTjedni(GlavniPanelController.getOdabranaTvrtka().getId());
            FROPregled mm = null;
            try {
                while (rs.next()) {
                    mm = new FROPregled();
                    mm.setId(rs.getInt("id"));
                    mm.setNazivMjernogMjesta(rs.getString("nazivmjernogmjrsta"));
                    mm.setPoslovnaJedinica(rs.getString("nazivposlovnice"));
                    mm.setOdjel(rs.getString("odjelnaziv"));
                    mm.setMjestoAdresa(rs.getString("mjestoadresa"));
                    mm.setOznakaLokacije(rs.getString("oznakalokacije"));
                    mm.setdatumIstekaPregleda(DateUtil.getLocalDate(rs.getDate("ispitivanje")));
                    this.listaFRO.add((Object)mm);
                }
            }
            catch (SQLException ex) {
                Logger.getLogger(TjedniPregledService.class.getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                try {
                    rs.close();
                }
                catch (SQLException ex) {
                    Logger.getLogger(TjedniPregledService.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void popuniObjekt() {
            ResultSet rs = BazaMonitoringNovi.dajObjekteTjedni(GlavniPanelController.getOdabranaTvrtka());
            ObjektNadzor oi = null;
            try {
                while (rs.next()) {
                    oi = new ObjektNadzor();
                    oi.setId(rs.getInt("id"));
                    oi.setAdresa(rs.getString("adresa"));
                    oi.setPoslovnaJedinica(rs.getString("nazivposlovnice"));
                    oi.setNazivObjekta(rs.getString("nazivodjela"));
                    oi.setDatumPonovogIspitivanja(DateUtil.getLocalDate(rs.getDate("datumponovogispitivanja")));
                    this.listaObjekti.add((Object)oi);
                }
            }
            catch (SQLException ex) {
                Logger.getLogger(TjedniPregledService.class.getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                try {
                    rs.close();
                }
                catch (SQLException ex) {
                    Logger.getLogger(TjedniPregledService.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void popuniVatrogasneAparate() {
            ResultSet rs = BazaMonitoringNovi.dajVatrogasneAparateTjedni(GlavniPanelController.getOdabranaTvrtka());
            try {
                while (rs.next()) {
                    NadzorVAtrogasniAparat va = new NadzorVAtrogasniAparat();
                    va.setId(rs.getInt("id"));
                    va.setSifraAparata(rs.getString("sifraaparata"));
                    va.setNazivAparata(rs.getString("naziv"));
                    va.setProizvodjac(rs.getString("proizvodjac"));
                    va.setModel(rs.getString("model"));
                    va.setTvornickibroj(rs.getString("tvornickibroj"));
                    va.setInventurnibroj(rs.getString("inventurnibroj"));
                    va.setGodinaProizvodnje(rs.getString("godinaproizvodnje"));
                    va.setDatumStavljanjauPogon(DateUtil.getLocalDate(rs.getDate("datumstavljanjauuporabu")));
                    va.setVrstaAparata(rs.getString("vrstaaparatanaziv"));
                    va.setMjestoIAdresa(rs.getString("mjestoadresa"));
                    va.setPoblizaLokacija(rs.getString("oznakalokacije"));
                    va.setAparatUVozilu(rs.getBoolean("aparatuvozilu"));
                    va.setRegistracijaVozila(rs.getString("registracijavozila"));
                    va.setServisnaNaljepnica(rs.getString("servisnanaljepnica"));
                    va.setDatumServisneNaljepnice(DateUtil.getLocalDate(rs.getDate("datumservisnenaljepnice")));
                    va.setNapomena(rs.getString("napomena"));
                    va.setPoslovnajedinica(rs.getString("nazivposlovnice"));
                    va.setOdjel(rs.getString("nazivodjela"));
                    va.setRashodovan(rs.getBoolean("rashodovan"));
                    va.setdatumIstekaPregleda(DateUtil.getLocalDate(rs.getDate("datumponovogpregleda")));
                    this.listaVatrogasniAparati.add((Object)va);
                }
            }
            catch (SQLException ex) {
                Logger.getLogger(TjedniPregledService.class.getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                try {
                    rs.close();
                }
                catch (SQLException ex) {
                    Logger.getLogger(TjedniPregledService.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void popuniStroj() {
            ResultSet rs = BazaMonitoringNovi.dajStrojeveTjedni(GlavniPanelController.getOdabranaTvrtka());
            try {
                while (rs.next()) {
                    NadzorStrojPregled se = new NadzorStrojPregled();
                    se.setId(rs.getInt("id"));
                    se.setSifrastroja(rs.getString("oznaka"));
                    se.setNazivstroja(rs.getString("naziv"));
                    se.setProizvodjac(rs.getString("proizvodjac"));
                    se.setModel(rs.getString("model"));
                    se.setTvornickibroj(rs.getString("tvornickibroj"));
                    se.setInventurnibroj(rs.getString("inventurnibroj"));
                    se.setGodinaProizvodnje(rs.getString("godinaproizvodnje"));
                    se.setDatumStavljanjauPogon(DateUtil.getLocalDate(rs.getDate("datumstavljanjaupogon")));
                    se.setGrupaStroja(rs.getString("grupastrojevanaziv"));
                    se.setVrstaStroja(rs.getString("vrstastroja"));
                    se.setNapomena(rs.getString("napomena"));
                    se.setPoslovnajedinica(rs.getString("poslovnajedinicanaziv"));
                    se.setOdjel(rs.getString("odjelnaziv"));
                    se.setRashodovan(rs.getBoolean("rashodovan"));
                    se.setdatumIstekaPregleda(DateUtil.getLocalDate(rs.getDate("ispitivanje")));
                    this.listaStrojeva.add((Object)se);
                }
            }
            catch (SQLException ex) {
                Logger.getLogger(TjedniPregledService.class.getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                try {
                    rs.close();
                }
                catch (SQLException ex) {
                    Logger.getLogger(TjedniPregledService.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }

        private void popuniSjednicu() {
            ResultSet rs = BazaMonitoringNovi.dajSjednicuTjedni(GlavniPanelController.getOdabranaTvrtka());
            try {
                while (rs.next()) {
                    this.datumSjedniceOdbora = DateUtil.getLocalDate(rs.getDate("datumsjednice"));
                }
            }
            catch (SQLException ex) {
                Logger.getLogger(TjedniPregledService.class.getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                try {
                    rs.close();
                }
                catch (SQLException ex) {
                    Logger.getLogger(TjedniPregledService.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void popuniMjerneUredjaje() {
            ResultSet rs = BazaMonitoringNovi.dajMjerneUredjajeTjedni(GlavniPanelController.getOdabranaTvrtka());
            NadzorMjerniInstrumentPregled mip = null;
            try {
                while (rs.next()) {
                    mip = new NadzorMjerniInstrumentPregled();
                    mip.setId(rs.getInt("id"));
                    mip.setSifrastroja(rs.getString("oznaka"));
                    mip.setNazivstroja(rs.getString("naziv"));
                    mip.setProizvodjac(rs.getString("proizvodjac"));
                    mip.setModel(rs.getString("model"));
                    mip.setTvornickibroj(rs.getString("tvornickibroj"));
                    mip.setInventurnibroj(rs.getString("inventurnibroj"));
                    mip.setDokazOVlasnistvu(rs.getString("dokumentovlasnistvu"));
                    mip.setGodinaProizvodnje(rs.getString("godinaproizvodnje"));
                    mip.setDatumStavljanjauPogon(DateUtil.getLocalDate(rs.getDate("datumstavljanjaupogon")));
                    mip.setGrupaStroja(rs.getString("grupastrojevanaziv"));
                    mip.setVrstaStroja(rs.getString("vrstastroja"));
                    mip.setNapomena(rs.getString("napomena"));
                    mip.setPoslovnajedinica(rs.getString("poslovnajedinica"));
                    mip.setOdjel(rs.getString("nazivodjela"));
                    mip.setRashodovan(rs.getBoolean("rashodovan"));
                    mip.setVlasnistvo(rs.getString("vlasnistvo"));
                    mip.setdatumIstekaPregleda(DateUtil.getLocalDate(rs.getDate("ispitivanje")));
                    this.listaMjerniInstrumenti.add((Object)mip);
                }
            }
            catch (SQLException ex) {
                Logger.getLogger(TjedniPregledService.class.getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                try {
                    rs.close();
                }
                catch (SQLException ex) {
                    Logger.getLogger(TjedniPregledService.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void popuniDatumeDjelatnika() {
            ResultSet rs1 = BazaMonitoringNovi.dajDjelatnikTjedni(GlavniPanelController.getOdabranaTvrtka().getId());
            DjelatnikPregled d = null;
            try {
                while (rs1.next()) {
                    d = new DjelatnikPregled();
                    d.setOzo(DateUtil.getLocalDate(rs1.getDate("ozo")));
                    d.setDatumIstekaLJPregleda(DateUtil.getLocalDate(rs1.getDate("ljecnickipregled")));
                    d.setOsposobljavanje(DateUtil.getLocalDate(rs1.getDate("osposobljavanje")));
                    d.setOstaliPregled(DateUtil.getLocalDate(rs1.getDate("ostalipregledi")));
                    d.setId(rs1.getInt("id"));
                    d.setPoslovnaJedinica(rs1.getString("nazivposlovnice"));
                    d.setOdjel(rs1.getString("nazivodjela"));
                    d.setOIB(rs1.getString("oib"));
                    d.setIme(rs1.getString("ime"));
                    d.setPrezime(rs1.getString("prezime"));
                    this.ozo.add((Object)d);
                    this.listaDjelatnikLjecnicki.add((Object)d);
                    this.listaDjelatnikOsposobljavanje.add((Object)d);
                    this.listaDjelatnikOstaliPregledi.add((Object)d);
                }
            }
            catch (SQLException ex) {
                Logger.getLogger(DjelatnikOsposobljavanjePopupController.class.getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                try {
                    rs1.close();
                }
                catch (SQLException ex) {
                    Logger.getLogger(DjelatnikOsposobljavanjePopupController.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }

        private void filtrirajListuDjelatnika(ObservableList<DjelatnikPregled> items, Opcije o) {
            HashSet filter = new HashSet();
            switch (o) {
                case ozo: {
                    items.removeIf(e -> !filter.add(new Pair((Object)e.getId(), (Object)e.getOzo())));
                    break;
                }
                case osposobljavanje: {
                    items.removeIf(e -> !filter.add(new Pair((Object)e.getId(), (Object)e.getOsposobljavanje())));
                    break;
                }
                case ostaliPregledi: {
                    items.removeIf(e -> !filter.add(new Pair((Object)e.getId(), (Object)e.getOstaliPregled())));
                    break;
                }
                case ljecnicki: {
                    items.removeIf(e -> !filter.add(new Pair((Object)e.getId(), (Object)e.getDatumIstekaLJPregleda())));
                }
            }
        }
    }

    public static enum Opcije {
        ozo,
        osposobljavanje,
        ostaliPregledi,
        ljecnicki;

    }
}

