/*
 * Decompiled with CFR 0.152.
 */
package nr1;

import Utill.DateUtil;
import Utill.FormValidation;
import Utill.FxDialogs;
import Utill.FxUtil;
import Utill.KlasaKorisneMetode;
import Utill.ResizeComponent;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.layout.AnchorPane;
import kadrovska.Djelatnik;
import kadrovska.DjelatnikLjijecnickiPregled;
import nr1.BazaNR1;
import nr1.Nr1;
import nr1.PregledNR1Controller;
import zastitanaradu.GlavniPanelController;

public class Nr1ObrazacController
implements Initializable {
    @FXML
    private Button btnSpremi;
    @FXML
    private AnchorPane anchorPanel;
    @FXML
    private DatePicker dateDatumKreiranja;
    @FXML
    private Button btnPretragaDjelatnika;
    @FXML
    private TextField txtOIB;
    @FXML
    private TextField txtIme;
    @FXML
    private TextField txtPrezime;
    @FXML
    private TextField txtImeOca;
    @FXML
    private DatePicker dateDatumRodjenja;
    @FXML
    private TextField txtBrojOI;
    @FXML
    private ComboBox<String> cboxSkolskaSprema;
    @FXML
    private ComboBox<String> cboxMjesto;
    @FXML
    private TextField txtZanimanje;
    @FXML
    private TextField txtNazivRM;
    @FXML
    private ComboBox<String> cboxTPZdrastveniPregled;
    @FXML
    private DatePicker datumPosljednjPregled;
    @FXML
    private TextField txtZaNocniRad;
    @FXML
    private TextField txtOcijenaZdrastveneSposobnosti;
    @FXML
    private TextArea txtAreaOpisPosla;
    @FXML
    private TextField txtStrojevi;
    @FXML
    private TextField txtPredmeti;
    @FXML
    private CheckBox chBoxMRuZatvorenom;
    @FXML
    private CheckBox chBoxMRnaotvorenom;
    @FXML
    private CheckBox chBoxMRnaVisini;
    @FXML
    private CheckBox chBoxMRuJami;
    @FXML
    private CheckBox chBoxMRuVodi;
    @FXML
    private CheckBox chBoxMRpodVodom;
    @FXML
    private CheckBox chBoxMRuMokrom;
    @FXML
    private CheckBox chBoxORuSmjenama;
    @FXML
    private CheckBox chBoxORNocniRad;
    @FXML
    private CheckBox chBoxORTerenskiRad;
    @FXML
    private CheckBox chBoxORRadiSam;
    @FXML
    private CheckBox chBoxORuGrupi;
    @FXML
    private CheckBox chBoxORsStrankama;
    @FXML
    private CheckBox chBoxORnaTraci;
    @FXML
    private CheckBox chBoxORBrziTempo;
    @FXML
    private CheckBox chBoxORRitamOdredjen;
    @FXML
    private CheckBox chBoxORMonotonija;
    @FXML
    private CheckBox chBoxPTradStojeci;
    @FXML
    private CheckBox chBoxPTradSjedeci;
    @FXML
    private CheckBox chBoxPTraduPokretu;
    @FXML
    private CheckBox chBoxPTKombinirano;
    @FXML
    private CheckBox chBoxPTDizanjeTereta;
    @FXML
    private TextField txtPTdizanjeTereta;
    @FXML
    private CheckBox chBoxPTucestaloSagibanje;
    @FXML
    private CheckBox chBoxPTZakretanjeTrupa;
    @FXML
    private CheckBox chBoxPTKlecanje;
    @FXML
    private CheckBox chBoxPTCuceci;
    @FXML
    private CheckBox chBoxPTPrenosenjeTereta;
    @FXML
    private TextField txtPTPrenosenjeTereta;
    @FXML
    private CheckBox chBoxPTpodvlacenje;
    @FXML
    private CheckBox chBoxPTbalansiranje;
    @FXML
    private CheckBox chBoxPTuspinjanjeLjestvama;
    @FXML
    private CheckBox chBoxPTuspinjanjeStepenicama;
    @FXML
    private CheckBox chBoxPTguranjeTereta;
    @FXML
    private TextField txtPTguranjeTereta;
    @FXML
    private CheckBox chBoxPVraspoznavanjeBoja;
    @FXML
    private CheckBox chBoxPVvidNaDaljinu;
    @FXML
    private CheckBox chBoxPVvidNaBlizinu;
    @FXML
    private CheckBox chBoxPVgovor;
    @FXML
    private CheckBox chBoxPVsluh;
    @FXML
    private CheckBox chBoxURVisokaTemperatura;
    @FXML
    private CheckBox chBoxURVisokaVlaznost;
    @FXML
    private CheckBox chBoxURNiskaTemperatura;
    @FXML
    private CheckBox chBoxURBuka;
    @FXML
    private CheckBox chBoxURVibracijaStroja;
    @FXML
    private CheckBox chBoxURVibracijaPoda;
    @FXML
    private CheckBox chBoxURatmosferskiTlak;
    @FXML
    private CheckBox chBoxURPovecanaIzlozenostOzljedama;
    @FXML
    private CheckBox chBoxURNeoizaciskoZracenje;
    @FXML
    private CheckBox chBoxURIonizZracenje;
    @FXML
    private CheckBox chBoxURPrasina;
    @FXML
    private TextField txtURKemiskeTvari;
    @FXML
    private TextField txtURBioloskeStetnosti;
    ObservableList<String> listaZdrPregled = FXCollections.observableArrayList((Object[])new String[]{"Prethodni", "Kontrolni"});
    private static Nr1ObrazacController instance;
    private Boolean izmjenaNr1 = false;
    Nr1 ra = null;

    public static Nr1ObrazacController getInstance() {
        return instance;
    }

    public void initialize(URL url, ResourceBundle rb) {
        instance = this;
        ResizeComponent.makeTextFieldResize(this.txtZanimanje, this.txtStrojevi, this.txtPredmeti, this.txtURKemiskeTvari, this.txtURBioloskeStetnosti);
        this.popuniCBoxMjesta();
        this.popuniCBoxStrucnaSprema();
        this.popuniCBoxZdrastveniPregled();
        this.dateDatumKreiranja.setValue((Object)LocalDate.now());
        this.txtPTPrenosenjeTereta.disableProperty().bind((ObservableValue)this.chBoxPTPrenosenjeTereta.selectedProperty().not());
        this.txtPTdizanjeTereta.disableProperty().bind((ObservableValue)this.chBoxPTDizanjeTereta.selectedProperty().not());
        this.txtPTguranjeTereta.disableProperty().bind((ObservableValue)this.chBoxPTguranjeTereta.selectedProperty().not());
        this.btnPretragaDjelatnika.setOnAction(e -> {
            Djelatnik d = FxDialogs.getDjelatnikDijalog();
            if (d != null) {
                this.popuniDjelatnika(d);
            }
        });
        this.btnSpremi.setOnAction(e -> this.spremiNr1uputnicu());
    }

    public void popuniDjelatnika(Djelatnik d, DjelatnikLjijecnickiPregled djelatnikPregled) {
        ResultSet rs = BazaNR1.dajDjelatnika(d, GlavniPanelController.getOdabranaTvrtka());
        Nr1 r = null;
        try {
            while (rs.next()) {
                r = new Nr1();
                r.setIddjelatnik(rs.getInt("id"));
                r.setIme(rs.getString("ime"));
                r.setPrezime(rs.getString("prezime"));
                r.setOib(rs.getString("oib"));
                r.setDatumRodjenja(DateUtil.getLocalDate(rs.getDate("datumrodjenja")));
                r.setStrucnaSprema(rs.getString("sprema"));
                r.setImeOca(rs.getString("imeoca"));
                r.setZanimianje(rs.getString("zanimanje"));
                r.setImeMajke(rs.getString("imemajke"));
                r.setMjestoRodjenja(rs.getString("mjestorodjenja"));
                r.setRadnoMjesto(rs.getString("naziv"));
                r.setBrojOsobne(rs.getString("brojosobne"));
                if (djelatnikPregled != null) {
                    r.setDatumPosljednjegPregleda(djelatnikPregled.getDatumPregleda());
                    r.setOcjenaZrastveneSposobnosti(djelatnikPregled.getNapomenaLijecnika());
                }
                r.setOpisPosla(rs.getString("opisposla"));
                r.setStrojevi(rs.getString("strojevi"));
                r.setPredmeti(rs.getString("predmeti"));
                r.setMRuZatvorenom(rs.getBoolean("mruzatvorenom"));
                r.setMRnaOtvorenom(rs.getBoolean("mrnaotvorenom"));
                r.setMRnaVisini(rs.getBoolean("mrnavisini"));
                r.setMRuJami(rs.getBoolean("mrujami"));
                r.setMRuVodi(rs.getBoolean("mruvodi"));
                r.setMRpodVodom(rs.getBoolean("mrpodvodom"));
                r.setMRuMokrom(rs.getBoolean("mrumokrom"));
                r.setORuSmjenama(rs.getBoolean("orusmjenama"));
                r.setORnocniRad(rs.getBoolean("ornocnorad"));
                r.setORterenskiRad(rs.getBoolean("orterenskirad"));
                r.setORradiSam(rs.getBoolean("orradisam"));
                r.setORradUGrupama(rs.getBoolean("orradugrupama"));
                r.setORradSaStrankama(rs.getBoolean("orradsastrankama"));
                r.setORradNaTraci(rs.getBoolean("orradnatraci"));
                r.setORbrziTempoRada(rs.getBoolean("orbrzitemporada"));
                r.setORritamOdredjen(rs.getBoolean("orritamodredjen"));
                r.setORmonotonija(rs.getBoolean("ormonotomija"));
                r.setPTradStojeci(rs.getBoolean("ptradstojeci"));
                r.setPTradSjedeci(rs.getBoolean("ptradsjedeci"));
                r.setPTradUPokretu(rs.getBoolean("ptradupokretu"));
                r.setPTKombinirano(rs.getBoolean("ptkombinirano"));
                r.setPTdizanjeTereta(rs.getBoolean("ptdizanjetereta"));
                r.setPTDizanjeTeretaKg(rs.getString("ptdizanjeteretakg"));
                r.setPTUcestaloSagibanje(rs.getBoolean("ptucestalosagibanje"));
                r.setPTzakretanjeTrupa(rs.getBoolean("ptzakretanjetrupa"));
                r.setPTklecanje(rs.getBoolean("ptklecanje"));
                r.setPTcucanje(rs.getBoolean("ptcucanje"));
                r.setPTprenosTereta(rs.getBoolean("ptprenostereta"));
                r.setPTprenosTeretaKg(rs.getString("ptprenosteretakg"));
                r.setPTpodvlacenje(rs.getBoolean("ptpodvlacenje"));
                r.setPTbalansiranje(rs.getBoolean("ptbalansiranje"));
                r.setPTuspinjanjeLjestvama(rs.getBoolean("ptuspinjanjeljestvama"));
                r.setPTuspinjanjeStepenicama(rs.getBoolean("ptuspinjanjestepenicama"));
                r.setPTguranjeTereta(rs.getBoolean("ptguranjetereta"));
                r.setPTguranjeTeretaKg(rs.getString("ptguranjeteretakg"));
                r.setVidNaDaljinu(rs.getBoolean("vidnadaljinu"));
                r.setVidNaBlizinu(rs.getBoolean("vidnablizinu"));
                r.setRaspoznavanjeBoja(rs.getBoolean("raspoznavanjeboja"));
                r.setDobarSluh(rs.getBoolean("dobarsluh"));
                r.setJasanGovor(rs.getBoolean("jasangovor"));
                r.setVisokaTemperatura(rs.getBoolean("visokatemperatura"));
                r.setVisokaVlaznost(rs.getBoolean("visokavlaznost"));
                r.setNiskaTemperatura(rs.getBoolean("niskatemperatura"));
                r.setBuka(rs.getBoolean("buka"));
                r.setVibracijeStroja(rs.getBoolean("vibracijastroja"));
                r.setVibracijePoda(rs.getBoolean("vibracijapoda"));
                r.setPovisenATTlak(rs.getBoolean("povisenattlak"));
                r.setPovecanaIzloOzljedama(rs.getBoolean("povecanaizlozenostozljedama"));
                r.setIonizaciskoZracenje(rs.getBoolean("ionizaciskozracenje"));
                r.setNeionizaciskoZracenje(rs.getBoolean("neionizaciskozracenje"));
                r.setPrasina(rs.getBoolean("prasina"));
                r.setKemiskeTvari(rs.getString("kemisketveri"));
                r.setBioloskeStetnosti(rs.getString("bioloskestetnosti"));
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(Nr1ObrazacController.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.popuniObrazac(r);
    }

    private void popuniDjelatnika(Djelatnik d) {
        ResultSet rs = BazaNR1.dajDjelatnika(d, GlavniPanelController.getOdabranaTvrtka());
        Nr1 r = null;
        try {
            while (rs.next()) {
                r = new Nr1();
                r.setIddjelatnik(rs.getInt("id"));
                r.setIme(rs.getString("ime"));
                r.setPrezime(rs.getString("prezime"));
                r.setOib(rs.getString("oib"));
                r.setDatumRodjenja(DateUtil.getLocalDate(rs.getDate("datumrodjenja")));
                r.setStrucnaSprema(rs.getString("sprema"));
                r.setImeOca(rs.getString("imeoca"));
                r.setZanimianje(rs.getString("zanimanje"));
                r.setImeMajke(rs.getString("imemajke"));
                r.setMjestoRodjenja(rs.getString("mjestorodjenja"));
                r.setRadnoMjesto(rs.getString("naziv"));
                r.setBrojOsobne(rs.getString("brojosobne"));
                r.setOpisPosla(rs.getString("opisposla"));
                r.setStrojevi(rs.getString("strojevi"));
                r.setPredmeti(rs.getString("predmeti"));
                r.setMRuZatvorenom(rs.getBoolean("mruzatvorenom"));
                r.setMRnaOtvorenom(rs.getBoolean("mrnaotvorenom"));
                r.setMRnaVisini(rs.getBoolean("mrnavisini"));
                r.setMRuJami(rs.getBoolean("mrujami"));
                r.setMRuVodi(rs.getBoolean("mruvodi"));
                r.setMRpodVodom(rs.getBoolean("mrpodvodom"));
                r.setMRuMokrom(rs.getBoolean("mrumokrom"));
                r.setORuSmjenama(rs.getBoolean("orusmjenama"));
                r.setORnocniRad(rs.getBoolean("ornocnorad"));
                r.setORterenskiRad(rs.getBoolean("orterenskirad"));
                r.setORradiSam(rs.getBoolean("orradisam"));
                r.setORradUGrupama(rs.getBoolean("orradugrupama"));
                r.setORradSaStrankama(rs.getBoolean("orradsastrankama"));
                r.setORradNaTraci(rs.getBoolean("orradnatraci"));
                r.setORbrziTempoRada(rs.getBoolean("orbrzitemporada"));
                r.setORritamOdredjen(rs.getBoolean("orritamodredjen"));
                r.setORmonotonija(rs.getBoolean("ormonotomija"));
                r.setPTradStojeci(rs.getBoolean("ptradstojeci"));
                r.setPTradSjedeci(rs.getBoolean("ptradsjedeci"));
                r.setPTradUPokretu(rs.getBoolean("ptradupokretu"));
                r.setPTKombinirano(rs.getBoolean("ptkombinirano"));
                r.setPTdizanjeTereta(rs.getBoolean("ptdizanjetereta"));
                r.setPTDizanjeTeretaKg(rs.getString("ptdizanjeteretakg"));
                r.setPTUcestaloSagibanje(rs.getBoolean("ptucestalosagibanje"));
                r.setPTzakretanjeTrupa(rs.getBoolean("ptzakretanjetrupa"));
                r.setPTklecanje(rs.getBoolean("ptklecanje"));
                r.setPTcucanje(rs.getBoolean("ptcucanje"));
                r.setPTprenosTereta(rs.getBoolean("ptprenostereta"));
                r.setPTprenosTeretaKg(rs.getString("ptprenosteretakg"));
                r.setPTpodvlacenje(rs.getBoolean("ptpodvlacenje"));
                r.setPTbalansiranje(rs.getBoolean("ptbalansiranje"));
                r.setPTuspinjanjeLjestvama(rs.getBoolean("ptuspinjanjeljestvama"));
                r.setPTuspinjanjeStepenicama(rs.getBoolean("ptuspinjanjestepenicama"));
                r.setPTguranjeTereta(rs.getBoolean("ptguranjetereta"));
                r.setPTguranjeTeretaKg(rs.getString("ptguranjeteretakg"));
                r.setVidNaDaljinu(rs.getBoolean("vidnadaljinu"));
                r.setVidNaBlizinu(rs.getBoolean("vidnablizinu"));
                r.setRaspoznavanjeBoja(rs.getBoolean("raspoznavanjeboja"));
                r.setDobarSluh(rs.getBoolean("dobarsluh"));
                r.setJasanGovor(rs.getBoolean("jasangovor"));
                r.setVisokaTemperatura(rs.getBoolean("visokatemperatura"));
                r.setVisokaVlaznost(rs.getBoolean("visokavlaznost"));
                r.setNiskaTemperatura(rs.getBoolean("niskatemperatura"));
                r.setBuka(rs.getBoolean("buka"));
                r.setVibracijeStroja(rs.getBoolean("vibracijastroja"));
                r.setVibracijePoda(rs.getBoolean("vibracijapoda"));
                r.setPovisenATTlak(rs.getBoolean("povisenattlak"));
                r.setPovecanaIzloOzljedama(rs.getBoolean("povecanaizlozenostozljedama"));
                r.setIonizaciskoZracenje(rs.getBoolean("ionizaciskozracenje"));
                r.setNeionizaciskoZracenje(rs.getBoolean("neionizaciskozracenje"));
                r.setPrasina(rs.getBoolean("prasina"));
                r.setKemiskeTvari(rs.getString("kemisketveri"));
                r.setBioloskeStetnosti(rs.getString("bioloskestetnosti"));
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(Nr1ObrazacController.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.popuniObrazac(r);
    }

    public void popuniObrazac(Nr1 ra) {
        this.txtOIB.setText(ra.getOib());
        this.txtIme.setText(ra.getIme());
        this.txtPrezime.setText(ra.getPrezime());
        if (ra.getImeOca().equals("")) {
            this.txtImeOca.setText(ra.getImeMajke());
        } else {
            this.txtImeOca.setText(ra.getImeOca());
        }
        this.dateDatumRodjenja.setValue((Object)ra.getDatumRodjenja());
        this.txtZanimanje.setText(ra.getZanimianje());
        this.cboxSkolskaSprema.setValue((Object)ra.getStrucnaSprema());
        this.cboxMjesto.setValue((Object)ra.getMjestoRodjenja());
        this.txtBrojOI.setText(ra.getBrojOsobne());
        this.txtNazivRM.setText(ra.getRadnoMjesto());
        this.datumPosljednjPregled.setValue((Object)ra.getDatumPosljednjegPregleda());
        this.txtZaNocniRad.setText(ra.getZaNocniRad());
        this.txtOcijenaZdrastveneSposobnosti.setText(ra.getOcjenaZrastveneSposobnosti());
        this.txtAreaOpisPosla.setText(ra.getOpisPosla());
        this.txtStrojevi.setText(ra.getStrojevi());
        this.txtPredmeti.setText(ra.getPredmeti());
        this.chBoxMRuZatvorenom.setSelected(ra.isMRuZatvorenom());
        this.chBoxMRnaotvorenom.setSelected(ra.isMRnaOtvorenom());
        this.chBoxMRnaVisini.setSelected(ra.isMRnaVisini());
        this.chBoxMRuJami.setSelected(ra.isMRuJami());
        this.chBoxMRuVodi.setSelected(ra.isMRuVodi());
        this.chBoxMRpodVodom.setSelected(ra.isMRpodVodom());
        this.chBoxMRuMokrom.setSelected(ra.isMRuMokrom());
        this.chBoxORuSmjenama.setSelected(ra.isORuSmjenama());
        this.chBoxORNocniRad.setSelected(ra.isORnocniRad());
        this.chBoxORTerenskiRad.setSelected(ra.isORterenskiRad());
        this.chBoxORRadiSam.setSelected(ra.isORradiSam());
        this.chBoxORuGrupi.setSelected(ra.isORradUGrupama());
        this.chBoxORsStrankama.setSelected(ra.isORradSaStrankama());
        this.chBoxORsStrankama.setSelected(ra.isORradNaTraci());
        this.chBoxORBrziTempo.setSelected(ra.isORbrziTempoRada());
        this.chBoxORRitamOdredjen.setSelected(ra.isORritamOdredjen());
        this.chBoxORMonotonija.setSelected(ra.isORmonotonija());
        this.chBoxORnaTraci.setSelected(ra.isORradNaTraci());
        this.chBoxPTradStojeci.setSelected(ra.isPTradStojeci());
        this.chBoxPTradSjedeci.setSelected(ra.isPTradSjedeci());
        this.chBoxPTraduPokretu.setSelected(ra.isPTradUPokretu());
        this.chBoxPTKombinirano.setSelected(ra.isPTKombinirano());
        this.chBoxPTDizanjeTereta.setSelected(ra.isPTdizanjeTereta());
        this.txtPTdizanjeTereta.setText(ra.getPTDizanjeTeretaKg());
        this.chBoxPTucestaloSagibanje.setSelected(ra.isPTUcestaloSagibanje());
        this.chBoxPTZakretanjeTrupa.setSelected(ra.isPTzakretanjeTrupa());
        this.chBoxPTCuceci.setSelected(ra.isPTcucanje());
        this.chBoxPTKlecanje.setSelected(ra.isPTklecanje());
        this.chBoxPTPrenosenjeTereta.setSelected(ra.isPTprenosTereta());
        this.txtPTPrenosenjeTereta.setText(ra.getPTprenosTeretaKg());
        this.chBoxPTpodvlacenje.setSelected(ra.isPTpodvlacenje());
        this.chBoxPTbalansiranje.setSelected(ra.isPTbalansiranje());
        this.chBoxPTuspinjanjeLjestvama.setSelected(ra.isPTuspinjanjeLjestvama());
        this.chBoxPTuspinjanjeStepenicama.setSelected(ra.isPTuspinjanjeStepenicama());
        this.chBoxPTguranjeTereta.setSelected(ra.isPTguranjeTereta());
        this.txtPTguranjeTereta.setText(ra.getPTguranjeTeretaKg());
        this.chBoxPVvidNaDaljinu.setSelected(ra.isVidNaDaljinu());
        this.chBoxPVvidNaBlizinu.setSelected(ra.isVidNaBlizinu());
        this.chBoxPVraspoznavanjeBoja.setSelected(ra.isRaspoznavanjeBoja());
        this.chBoxPVsluh.setSelected(ra.isDobarSluh());
        this.chBoxPVgovor.setSelected(ra.isJasanGovor());
        this.chBoxURVisokaTemperatura.setSelected(ra.isVisokaTemperatura());
        this.chBoxURVisokaVlaznost.setSelected(ra.isVisokaVlaznost());
        this.chBoxURNiskaTemperatura.setSelected(ra.isNiskaTemperatura());
        this.chBoxURBuka.setSelected(ra.isBuka());
        this.chBoxURVibracijaStroja.setSelected(ra.isVibracijeStroja());
        this.chBoxURVibracijaPoda.setSelected(ra.isVibracijePoda());
        this.chBoxURatmosferskiTlak.setSelected(ra.isPovisenATTlak());
        this.chBoxURPovecanaIzlozenostOzljedama.setSelected(ra.isPovecanaIzloOzljedama());
        this.chBoxURIonizZracenje.setSelected(ra.isIonizaciskoZracenje());
        this.chBoxURNeoizaciskoZracenje.setSelected(ra.isNeionizaciskoZracenje());
        this.chBoxURPrasina.setSelected(ra.isPrasina());
        this.txtURKemiskeTvari.setText(ra.getKemiskeTvari());
        this.txtURBioloskeStetnosti.setText(ra.getBioloskeStetnosti());
    }

    private void popuniCBoxMjesta() {
        ResultSet rs = BazaNR1.dajMjesta();
        try {
            while (rs.next()) {
                this.cboxMjesto.getItems().add((Object)rs.getString("nazivgrada"));
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(Nr1ObrazacController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(Nr1ObrazacController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        FxUtil.autoCompleteComboBox(this.cboxMjesto, FxUtil.AutoCompleteMode.STARTS_WITH);
    }

    private void popuniCBoxStrucnaSprema() {
        ResultSet rs = BazaNR1.dajStrucnuSpremu();
        try {
            while (rs.next()) {
                this.cboxSkolskaSprema.getItems().add((Object)rs.getString("naziv"));
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(Nr1ObrazacController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(Nr1ObrazacController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void popuniCBoxZdrastveniPregled() {
        this.cboxTPZdrastveniPregled.getItems().addAll(this.listaZdrPregled);
    }

    private void spremiNr1uputnicu() {
        boolean bprezime;
        boolean bime;
        boolean bOib = FormValidation.textFieldValidationonlyText(this.txtOIB);
        if (bOib & (bime = FormValidation.textFieldValidationonlyText(this.txtIme)) & (bprezime = FormValidation.textFieldValidationonlyText(this.txtPrezime))) {
            if (this.izmjenaNr1.booleanValue()) {
                if (BazaNR1.izmjenaNr1(GlavniPanelController.getOdabranaTvrtka(), this.dajNr1(), this.ra.getId())) {
                    PregledNR1Controller.getInstance().popuniTablicuPopisNR1Uputnica(1);
                    GlavniPanelController.getInstance().zatvoriTab("Unos NR-1 uputnice");
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.BOTTOM_RIGHT, "Uspje\u0161na izmjena obrasca", 1, "Information graphic");
                } else {
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161na izmjena obrasca", 2, "Error graphic");
                }
            } else if (BazaNR1.unesiNovuNr1(GlavniPanelController.getOdabranaTvrtka(), this.dajNr1())) {
                KlasaKorisneMetode.kreirajNotifikaciju(Pos.BOTTOM_RIGHT, "Uspje\u0161no unesen obrasc", 1, "Information graphic");
                PregledNR1Controller.getInstance().popuniTablicuPopisNR1Uputnica(1);
                GlavniPanelController.getInstance().zatvoriTab("Unos NR-1 uputnice");
                this.izmjenaNr1 = false;
            } else {
                KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161no unesen obrasc", 2, "Error graphic");
            }
        } else {
            Alert alert = FxDialogs.getDialog(Alert.AlertType.INFORMATION, "Upozorenje", "Morate popuniti sva oznacena polja");
            alert.showAndWait();
        }
    }

    private Nr1 dajNr1() {
        Nr1 ra = new Nr1();
        ra.setDatumIzdavanjaUputnice((LocalDate)this.dateDatumKreiranja.getValue());
        ra.setOib(this.txtOIB.getText());
        ra.setIme(this.txtIme.getText());
        ra.setPrezime(this.txtPrezime.getText());
        ra.setImeOca_Majke(this.txtImeOca.getText());
        ra.setDatumRodjenja((LocalDate)this.dateDatumRodjenja.getValue());
        ra.setMjestoRodjenja((String)this.cboxMjesto.getValue());
        ra.setZanimianje(this.txtZanimanje.getText());
        ra.setStrucnaSprema((String)this.cboxSkolskaSprema.getValue());
        ra.setRadnoMjesto(this.txtNazivRM.getText());
        ra.setBrojOsobne(this.txtBrojOI.getText());
        ra.setZrastveniPregled((String)this.cboxTPZdrastveniPregled.getValue());
        ra.setDatumPosljednjegPregleda((LocalDate)this.datumPosljednjPregled.getValue());
        ra.setZaNocniRad(this.txtZaNocniRad.getText());
        ra.setOcjenaZrastveneSposobnosti(this.txtOcijenaZdrastveneSposobnosti.getText());
        ra.setOpisPosla(this.txtAreaOpisPosla.getText());
        ra.setStrojevi(this.txtStrojevi.getText());
        ra.setPredmeti(this.txtPredmeti.getText());
        ra.setMRuZatvorenom(this.chBoxMRuZatvorenom.isSelected());
        ra.setMRnaOtvorenom(this.chBoxMRnaotvorenom.isSelected());
        ra.setMRnaVisini(this.chBoxMRnaVisini.isSelected());
        ra.setMRuJami(this.chBoxMRuJami.isSelected());
        ra.setMRuVodi(this.chBoxMRuVodi.isSelected());
        ra.setMRpodVodom(this.chBoxMRpodVodom.isSelected());
        ra.setMRuMokrom(this.chBoxMRuMokrom.isSelected());
        ra.setORuSmjenama(this.chBoxORuSmjenama.isSelected());
        ra.setORnocniRad(this.chBoxORNocniRad.isSelected());
        ra.setORterenskiRad(this.chBoxORTerenskiRad.isSelected());
        ra.setORradiSam(this.chBoxORRadiSam.isSelected());
        ra.setORradUGrupama(this.chBoxORuGrupi.isSelected());
        ra.setORradSaStrankama(this.chBoxORsStrankama.isSelected());
        ra.setORradNaTraci(this.chBoxORnaTraci.isSelected());
        ra.setORbrziTempoRada(this.chBoxORBrziTempo.isSelected());
        ra.setORritamOdredjen(this.chBoxORRitamOdredjen.isSelected());
        ra.setORmonotonija(this.chBoxORMonotonija.isSelected());
        ra.setPTradStojeci(this.chBoxPTradStojeci.isSelected());
        ra.setPTradSjedeci(this.chBoxPTradSjedeci.isSelected());
        ra.setPTradUPokretu(this.chBoxPTraduPokretu.isSelected());
        ra.setPTKombinirano(this.chBoxPTKombinirano.isSelected());
        ra.setPTdizanjeTereta(this.chBoxPTDizanjeTereta.isSelected());
        ra.setPTDizanjeTeretaKg(this.txtPTdizanjeTereta.getText());
        ra.setPTUcestaloSagibanje(this.chBoxPTucestaloSagibanje.isSelected());
        ra.setPTzakretanjeTrupa(this.chBoxPTZakretanjeTrupa.isSelected());
        ra.setPTcucanje(this.chBoxPTCuceci.isSelected());
        ra.setPTklecanje(this.chBoxPTKlecanje.isSelected());
        ra.setPTprenosTereta(this.chBoxPTPrenosenjeTereta.isSelected());
        ra.setPTprenosTeretaKg(this.txtPTPrenosenjeTereta.getText());
        ra.setPTpodvlacenje(this.chBoxPTpodvlacenje.isSelected());
        ra.setPTbalansiranje(this.chBoxPTbalansiranje.isSelected());
        ra.setPTuspinjanjeLjestvama(this.chBoxPTuspinjanjeLjestvama.isSelected());
        ra.setPTuspinjanjeStepenicama(this.chBoxPTuspinjanjeStepenicama.isSelected());
        ra.setPTguranjeTereta(this.chBoxPTguranjeTereta.isSelected());
        ra.setPTguranjeTeretaKg(this.txtPTguranjeTereta.getText());
        ra.setVidNaDaljinu(this.chBoxPVvidNaDaljinu.isSelected());
        ra.setVidNaBlizinu(this.chBoxPVvidNaBlizinu.isSelected());
        ra.setRaspoznavanjeBoja(this.chBoxPVraspoznavanjeBoja.isSelected());
        ra.setDobarSluh(this.chBoxPVsluh.isSelected());
        ra.setJasanGovor(this.chBoxPVgovor.isSelected());
        ra.setVisokaTemperatura(this.chBoxURVisokaTemperatura.isSelected());
        ra.setVisokaVlaznost(this.chBoxURVisokaVlaznost.isSelected());
        ra.setNiskaTemperatura(this.chBoxURNiskaTemperatura.isSelected());
        ra.setBuka(this.chBoxURBuka.isSelected());
        ra.setVibracijeStroja(this.chBoxURVibracijaStroja.isSelected());
        ra.setVibracijePoda(this.chBoxURVibracijaPoda.isSelected());
        ra.setPovisenATTlak(this.chBoxURatmosferskiTlak.isSelected());
        ra.setPovecanaIzloOzljedama(this.chBoxURPovecanaIzlozenostOzljedama.isSelected());
        ra.setIonizaciskoZracenje(this.chBoxURIonizZracenje.isSelected());
        ra.setNeionizaciskoZracenje(this.chBoxURNeoizaciskoZracenje.isSelected());
        ra.setPrasina(this.chBoxURPrasina.isSelected());
        ra.setKemiskeTvari(this.txtURKemiskeTvari.getText());
        ra.setBioloskeStetnosti(this.txtURBioloskeStetnosti.getText());
        return ra;
    }

    void izmjenaUputnice(Nr1 ra) {
        this.izmjenaNr1 = true;
        this.ra = ra;
        this.dateDatumKreiranja.setValue((Object)ra.getDatumIzdavanjaUputnice());
        this.txtOIB.setText(ra.getOib());
        this.txtIme.setText(ra.getIme());
        this.txtPrezime.setText(ra.getPrezime());
        this.txtImeOca.setText(ra.getImeOca_Majke());
        this.dateDatumRodjenja.setValue((Object)ra.getDatumRodjenja());
        this.txtZanimanje.setText(ra.getZanimianje());
        this.cboxSkolskaSprema.setValue((Object)ra.getStrucnaSprema());
        this.cboxMjesto.setValue((Object)ra.getMjestoRodjenja());
        this.txtBrojOI.setText(ra.getBrojOsobne());
        this.txtNazivRM.setText(ra.getRadnoMjesto());
        this.cboxTPZdrastveniPregled.setValue((Object)ra.getZrastveniPregled());
        this.datumPosljednjPregled.setValue((Object)ra.getDatumPosljednjegPregleda());
        this.txtZaNocniRad.setText(ra.getZaNocniRad());
        this.txtOcijenaZdrastveneSposobnosti.setText(ra.getOcjenaZrastveneSposobnosti());
        this.txtAreaOpisPosla.setText(ra.getOpisPosla());
        this.txtStrojevi.setText(ra.getStrojevi());
        this.txtPredmeti.setText(ra.getPredmeti());
        this.chBoxMRuZatvorenom.setSelected(ra.isMRuZatvorenom());
        this.chBoxMRnaotvorenom.setSelected(ra.isMRnaOtvorenom());
        this.chBoxMRnaVisini.setSelected(ra.isMRnaVisini());
        this.chBoxMRuJami.setSelected(ra.isMRuJami());
        this.chBoxMRuVodi.setSelected(ra.isMRuVodi());
        this.chBoxMRpodVodom.setSelected(ra.isMRpodVodom());
        this.chBoxMRuMokrom.setSelected(ra.isMRuMokrom());
        this.chBoxORuSmjenama.setSelected(ra.isORuSmjenama());
        this.chBoxORNocniRad.setSelected(ra.isORnocniRad());
        this.chBoxORTerenskiRad.setSelected(ra.isORterenskiRad());
        this.chBoxORRadiSam.setSelected(ra.isORradiSam());
        this.chBoxORuGrupi.setSelected(ra.isORradUGrupama());
        this.chBoxORsStrankama.setSelected(ra.isORradSaStrankama());
        this.chBoxORsStrankama.setSelected(ra.isORradNaTraci());
        this.chBoxORBrziTempo.setSelected(ra.isORbrziTempoRada());
        this.chBoxORRitamOdredjen.setSelected(ra.isORritamOdredjen());
        this.chBoxORMonotonija.setSelected(ra.isORmonotonija());
        this.chBoxORnaTraci.setSelected(ra.isORradNaTraci());
        this.chBoxPTradStojeci.setSelected(ra.isPTradStojeci());
        this.chBoxPTradSjedeci.setSelected(ra.isPTradSjedeci());
        this.chBoxPTraduPokretu.setSelected(ra.isPTradUPokretu());
        this.chBoxPTKombinirano.setSelected(ra.isPTKombinirano());
        this.chBoxPTDizanjeTereta.setSelected(ra.isPTdizanjeTereta());
        this.txtPTdizanjeTereta.setText(ra.getPTDizanjeTeretaKg());
        this.chBoxPTucestaloSagibanje.setSelected(ra.isPTUcestaloSagibanje());
        this.chBoxPTZakretanjeTrupa.setSelected(ra.isPTzakretanjeTrupa());
        this.chBoxPTCuceci.setSelected(ra.isPTcucanje());
        this.chBoxPTKlecanje.setSelected(ra.isPTklecanje());
        this.chBoxPTPrenosenjeTereta.setSelected(ra.isPTprenosTereta());
        this.txtPTPrenosenjeTereta.setText(ra.getPTprenosTeretaKg());
        this.chBoxPTpodvlacenje.setSelected(ra.isPTpodvlacenje());
        this.chBoxPTbalansiranje.setSelected(ra.isPTbalansiranje());
        this.chBoxPTuspinjanjeLjestvama.setSelected(ra.isPTuspinjanjeLjestvama());
        this.chBoxPTuspinjanjeStepenicama.setSelected(ra.isPTuspinjanjeStepenicama());
        this.chBoxPTguranjeTereta.setSelected(ra.isPTguranjeTereta());
        this.txtPTguranjeTereta.setText(ra.getPTguranjeTeretaKg());
        this.chBoxPVvidNaDaljinu.setSelected(ra.isVidNaDaljinu());
        this.chBoxPVvidNaBlizinu.setSelected(ra.isVidNaBlizinu());
        this.chBoxPVraspoznavanjeBoja.setSelected(ra.isRaspoznavanjeBoja());
        this.chBoxPVsluh.setSelected(ra.isDobarSluh());
        this.chBoxPVgovor.setSelected(ra.isJasanGovor());
        this.chBoxURVisokaTemperatura.setSelected(ra.isVisokaTemperatura());
        this.chBoxURVisokaVlaznost.setSelected(ra.isVisokaVlaznost());
        this.chBoxURNiskaTemperatura.setSelected(ra.isNiskaTemperatura());
        this.chBoxURBuka.setSelected(ra.isBuka());
        this.chBoxURVibracijaStroja.setSelected(ra.isVibracijeStroja());
        this.chBoxURVibracijaPoda.setSelected(ra.isVibracijePoda());
        this.chBoxURatmosferskiTlak.setSelected(ra.isPovisenATTlak());
        this.chBoxURPovecanaIzlozenostOzljedama.setSelected(ra.isPovecanaIzloOzljedama());
        this.chBoxURIonizZracenje.setSelected(ra.isIonizaciskoZracenje());
        this.chBoxURNeoizaciskoZracenje.setSelected(ra.isNeionizaciskoZracenje());
        this.chBoxURPrasina.setSelected(ra.isPrasina());
        this.txtURKemiskeTvari.setText(ra.getKemiskeTvari());
        this.txtURBioloskeStetnosti.setText(ra.getBioloskeStetnosti());
    }
}

