/*
 * Decompiled with CFR 0.152.
 */
package objektiispitivanja;

import Utill.FxUtilTest;
import ispitivanja.Ispitivanje;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.TableCell;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.util.Callback;
import javafx.util.StringConverter;
import objektiispitivanja.BazaObjektiIspitivanja;
import objektiispitivanja.ObjekatEvidencijaPregleda;

public class ComboBoxCellIspitivanja
extends TableCell<ObjekatEvidencijaPregleda, String> {
    private ComboBox<Ispitivanje> comboBox;

    ComboBoxCellIspitivanja(ObservableList<Ispitivanje> listaIspitivanja, String pretraga) {
        this.comboBox = new ComboBox(listaIspitivanja);
        this.comboBox.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            if (event.getCode() == KeyCode.DELETE) {
                this.commitEdit(null);
            }
            if (event.getCode() == KeyCode.ESCAPE) {
                this.cancelEdit();
            }
        });
        if (pretraga.toLowerCase().equals("oznaka")) {
            this.comboBox.setPromptText("Pretraga po oznaci");
            this.comboBox.setCellFactory((Callback)new Callback<ListView<Ispitivanje>, ListCell<Ispitivanje>>(){

                public ListCell<Ispitivanje> call(ListView<Ispitivanje> p) {
                    ListCell<Ispitivanje> cell = new ListCell<Ispitivanje>(){

                        protected void updateItem(Ispitivanje t, boolean bln) {
                            super.updateItem((Object)t, bln);
                            if (t != null) {
                                this.setText(t.getOznaka());
                            } else {
                                this.setText(null);
                            }
                        }
                    };
                    return cell;
                }
            });
            FxUtilTest.autoCompleteComboBoxPlus(this.comboBox, (typedText, itemToCompare) -> itemToCompare.getOznaka().toLowerCase().startsWith(typedText.toLowerCase()));
        }
        if (pretraga.toLowerCase().equals("naziv")) {
            this.comboBox.setPromptText("Pretraga po nazivu");
            this.comboBox.setCellFactory((Callback)new Callback<ListView<Ispitivanje>, ListCell<Ispitivanje>>(){

                public ListCell<Ispitivanje> call(ListView<Ispitivanje> p) {
                    ListCell<Ispitivanje> cell = new ListCell<Ispitivanje>(){

                        protected void updateItem(Ispitivanje t, boolean bln) {
                            super.updateItem((Object)t, bln);
                            if (t != null) {
                                this.setText(t.getNaziv());
                            } else {
                                this.setText(null);
                            }
                        }
                    };
                    return cell;
                }
            });
            FxUtilTest.autoCompleteComboBoxPlus(this.comboBox, (typedText, itemToCompare) -> itemToCompare.getNaziv().toLowerCase().startsWith(typedText.toLowerCase()));
        }
        this.comboBox.setConverter((StringConverter)new StringConverter<Ispitivanje>(){

            public String toString(Ispitivanje rm) {
                if (rm == null) {
                    return null;
                }
                return rm.getNaziv();
            }

            public Ispitivanje fromString(String userId) {
                return null;
            }
        });
    }

    public void startEdit() {
        if (!this.isEmpty()) {
            super.startEdit();
            this.comboBox.setMinWidth(this.getWidth() - this.getGraphicTextGap() * 2.0);
            this.comboBox.setOnAction(e -> {
                Ispitivanje d = (Ispitivanje)this.comboBox.getSelectionModel().getSelectedItem();
                if (d != null) {
                    this.commitEdit(FxUtilTest.getComboBoxValue(this.comboBox).getNaziv());
                    ((ObjekatEvidencijaPregleda)this.getTableView().getSelectionModel().getSelectedItem()).setOznakaIspitivanja(d.getOznaka());
                    ((ObjekatEvidencijaPregleda)this.getTableView().getSelectionModel().getSelectedItem()).setNazivIspitivanja(d.getNaziv());
                    BazaObjektiIspitivanja.unesiPromjenuObjektIspitivanja((ObjekatEvidencijaPregleda)this.getTableView().getSelectionModel().getSelectedItem());
                }
            });
            this.setText(null);
            this.setGraphic((Node)this.comboBox);
        }
    }

    public void cancelEdit() {
        super.cancelEdit();
        this.setText((String)this.getItem());
        this.setGraphic(null);
    }

    public void updateItem(String item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (empty) {
            this.setText(null);
            this.setGraphic(null);
        } else if (this.isEditing()) {
            this.setText(null);
            this.setGraphic((Node)this.comboBox);
        } else {
            this.setText((String)this.getItem());
            this.setGraphic(null);
        }
    }

    private String getString() {
        return this.getItem() == null ? "" : (String)this.getItem();
    }
}

