/*
 * Decompiled with CFR 0.152.
 */
package objektiispitivanja;

import TamplatePaneli.Template;
import Utill.FxDialogs;
import Utill.KlasaKorisneMetode;
import filter.MenuButtonReporti;
import ispisJasper.IspisJasperButtonSaSubreportom;
import ispisJasper.JasperViewerFX;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.ToolBar;
import javafx.scene.effect.GaussianBlur;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.stage.Stage;
import javafx.util.Callback;
import net.sf.jasperreports.engine.JasperPrint;
import objektiispitivanja.BazaObjektiIspitivanja;
import objektiispitivanja.ObjekatIspitivanje;
import objektiispitivanja.UnosObjektaController;
import zastitanaradu.GlavniPanelController;

public class PregledObjektIspitivanjeController
implements Initializable {
    @FXML
    private Button btnIspis;
    @FXML
    private Button btnUnos;
    @FXML
    private Button btnPromjena;
    @FXML
    private Button btnBrisanje;
    @FXML
    private TableView<ObjekatIspitivanje> tablicaPopisObjekata;
    @FXML
    private TableColumn<ObjekatIspitivanje, String> kolPretraga;
    @FXML
    private TableColumn<ObjekatIspitivanje, String> kolRedBr;
    @FXML
    private TableColumn<ObjekatIspitivanje, String> kolNazivObjekta;
    @FXML
    private TableColumn<ObjekatIspitivanje, String> kolPoslovnica;
    @FXML
    private TableColumn<ObjekatIspitivanje, String> kolAdresa;
    private static PregledObjektIspitivanjeController instance;
    private ToolBar tbFilter;
    private TextField tfilter;
    private ComboBox cbFilter;
    private final ObservableList<ObjekatIspitivanje> listaObjekta = FXCollections.observableArrayList();
    ProgressIndicator progressIndicator = new ProgressIndicator();

    public static PregledObjektIspitivanjeController getInstance() {
        return instance;
    }

    public void initialize(URL url, ResourceBundle rb) {
        instance = this;
        this.kreirajToolBarFilter();
        this.urediTablicuPopisObjekta();
        this.popuniTablicuPopisObjekta();
        this.urediFilter(this.tablicaPopisObjekata);
        this.btnUnos.setOnAction(e -> {
            if (!GlavniPanelController.getInstance().getTabByIdifExist("Unos objekta")) {
                GlavniPanelController.getInstance().zatvoriTab("Unos objekta");
                GlavniPanelController.getInstance().nadodajPanel("Unos objekta", "/objektiispitivanja/UnosObjekta.fxml");
            } else {
                GlavniPanelController.getInstance().nadodajPanel("Unos objekta", "/objektiispitivanja/UnosObjekta.fxml");
            }
        });
        this.btnPromjena.setOnAction(e -> {
            ObjekatIspitivanje oi;
            int selectdIndex = this.tablicaPopisObjekata.getSelectionModel().getSelectedIndex();
            if (selectdIndex != -1 && (oi = (ObjekatIspitivanje)this.tablicaPopisObjekata.getSelectionModel().getSelectedItem()) != null) {
                if (!GlavniPanelController.getInstance().getTabByIdifExist("Unos objekta")) {
                    GlavniPanelController.getInstance().zatvoriTab("Unos objekta");
                    GlavniPanelController.getInstance().nadodajPanel("Unos objekta", "/objektiispitivanja/UnosObjekta.fxml");
                    UnosObjektaController.getInstance().izmjenaObjekta(oi);
                } else {
                    GlavniPanelController.getInstance().nadodajPanel("Unos objekta", "/objektiispitivanja/UnosObjekta.fxml");
                    UnosObjektaController.getInstance().izmjenaObjekta(oi);
                }
                this.tablicaPopisObjekata.getSelectionModel().clearSelection();
            }
        });
        this.btnBrisanje.setOnAction(e -> {
            Alert alert;
            Optional result;
            int selectdIndex = this.tablicaPopisObjekata.getSelectionModel().getSelectedIndex();
            if (selectdIndex != -1 && (result = (alert = FxDialogs.getDialog(Alert.AlertType.CONFIRMATION, "Brisanje", "\u017delite li obrisati objekat")).showAndWait()).get() == ButtonType.OK) {
                if (BazaObjektiIspitivanja.obrisiObjekt((ObjekatIspitivanje)this.tablicaPopisObjekata.getSelectionModel().getSelectedItem(), GlavniPanelController.getOdabranaTvrtka())) {
                    this.popuniTablicuPopisObjekta();
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.BOTTOM_RIGHT, "Uspje\u0161no obrisan mjerno mjesto", 1, "Information graphic");
                } else {
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161no obrisan mjerno mjesto", 2, "Error graphic");
                }
            }
        });
        this.btnIspis.setOnAction(e -> {
            int selectdIndex = this.tablicaPopisObjekata.getSelectionModel().getSelectedIndex();
            if (selectdIndex != -1) {
                this.ispisKartonObjekta((ObservableList<ObjekatIspitivanje>)this.tablicaPopisObjekata.getSelectionModel().getSelectedItems());
            }
        });
    }

    private void urediFilter(TableView tablicaPregleda) {
        FilteredList filteredData = new FilteredList(this.listaObjekta, p -> true);
        this.tfilter.textProperty().addListener((observable, oldValue, newValue) -> filteredData.setPredicate(pregled -> {
            if (newValue == null || newValue.isEmpty()) {
                return true;
            }
            String lowerCaseFilter = newValue.toLowerCase();
            return this.cbFilter.getSelectionModel().getSelectedItem().equals("Naziv objekta") ? pregled.getNazivObjekta() != null && pregled.getNazivObjekta().toLowerCase().startsWith(lowerCaseFilter) : this.cbFilter.getSelectionModel().getSelectedItem().equals("Poslovna jedinica") && pregled.getPoslovnaJedinica() != null && pregled.getPoslovnaJedinica().toLowerCase().startsWith(lowerCaseFilter);
        }));
        SortedList sortedData = new SortedList((ObservableList)filteredData);
        sortedData.comparatorProperty().bind((ObservableValue)tablicaPregleda.comparatorProperty());
        tablicaPregleda.setItems((ObservableList)sortedData);
    }

    private void kreirajToolBarFilter() {
        this.tbFilter = new ToolBar();
        this.tfilter = new TextField();
        this.tfilter.setPromptText("Filter");
        this.tfilter.setId("textField");
        this.cbFilter = new ComboBox();
        ObservableList filter = FXCollections.observableArrayList((Object[])new String[]{"Naziv objekta", "Poslovna jedinica"});
        this.cbFilter.getItems().addAll((Collection)filter);
        this.cbFilter.setValue((Object)"Naziv objekta");
        this.cbFilter.setPrefWidth(250.0);
        this.cbFilter.setPrefHeight(25.0);
        this.tfilter.setPrefWidth(200.0);
        this.tfilter.setPrefHeight(25.0);
        this.tbFilter.getItems().addAll((Object[])new Node[]{this.tfilter, this.cbFilter, this.getMenuButton(), MenuButtonReporti.getMenuButtonObjektiIspis()});
    }

    private MenuButton getMenuButton() {
        MenuItem m1 = new MenuItem("Prikazi sve objekte");
        m1.setOnAction(event -> this.popuniTablicuPopisObjekta(BazaObjektiIspitivanja.Opcije.sve_objekte));
        MenuItem m2 = new MenuItem("Prikazi otvorene objekte");
        m2.setOnAction(event -> this.popuniTablicuPopisObjekta(BazaObjektiIspitivanja.Opcije.otvorene_objekte));
        MenuItem m3 = new MenuItem("Prikazi zatvorene objekte");
        m3.setOnAction(event -> this.popuniTablicuPopisObjekta(BazaObjektiIspitivanja.Opcije.zatvorene_objekte));
        MenuButton mb = new MenuButton("Pregled objekata", null, new MenuItem[]{m1, m2, m3});
        return mb;
    }

    private void urediTablicuPopisObjekta() {
        this.tablicaPopisObjekata.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.tablicaPopisObjekata.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent e) {
                if (e.getCode() == KeyCode.ESCAPE) {
                    PregledObjektIspitivanjeController.this.tablicaPopisObjekata.getSelectionModel().clearSelection();
                    e.consume();
                    return;
                }
            }
        });
        this.kolRedBr.setCellValueFactory(cellData -> ((ObjekatIspitivanje)cellData.getValue()).redBrojProperty());
        this.kolRedBr.prefWidthProperty().bind((ObservableValue)this.tablicaPopisObjekata.widthProperty().divide(11.11111111111111));
        this.kolRedBr.setStyle("-fx-alignment: CENTER;");
        this.kolNazivObjekta.setCellValueFactory(cellData -> ((ObjekatIspitivanje)cellData.getValue()).nazivObjektaProperty());
        this.kolNazivObjekta.prefWidthProperty().bind((ObservableValue)this.tablicaPopisObjekata.widthProperty().divide(3.3333333333333335));
        this.kolNazivObjekta.setStyle("-fx-alignment: CENTER;");
        this.kolPoslovnica.setCellValueFactory(cellData -> ((ObjekatIspitivanje)cellData.getValue()).poslovnaJedinicaProperty());
        this.kolPoslovnica.prefWidthProperty().bind((ObservableValue)this.tablicaPopisObjekata.widthProperty().divide(5.0));
        this.kolPoslovnica.setStyle("-fx-alignment: CENTER;");
        this.kolAdresa.setCellValueFactory(cellData -> ((ObjekatIspitivanje)cellData.getValue()).adresaProperty());
        this.kolAdresa.prefWidthProperty().bind((ObservableValue)this.tablicaPopisObjekata.widthProperty().divide(3.3333333333333335));
        this.kolAdresa.setStyle("-fx-alignment: CENTER;");
        TableColumn kolPregledDjelatnika = new TableColumn("Pregled");
        kolPregledDjelatnika.setSortable(false);
        kolPregledDjelatnika.prefWidthProperty().bind((ObservableValue)this.tablicaPopisObjekata.widthProperty().divide(10.0));
        kolPregledDjelatnika.setStyle("-fx-alignment: CENTER;");
        kolPregledDjelatnika.setCellFactory((Callback)new Callback<TableColumn<ObjekatIspitivanje, Boolean>, TableCell<ObjekatIspitivanje, Boolean>>(){

            public TableCell<ObjekatIspitivanje, Boolean> call(TableColumn<ObjekatIspitivanje, Boolean> param) {
                return new ButtonCell();
            }
        });
        this.kolPretraga.setGraphic((Node)this.tbFilter);
        this.kolPretraga.getColumns().add((Object)kolPregledDjelatnika);
        this.tablicaPopisObjekata.setItems(this.listaObjekta);
    }

    public void popuniTablicuPopisObjekta(BazaObjektiIspitivanja.Opcije opcija) {
        this.tablicaPopisObjekata.setPlaceholder((Node)this.progressIndicator);
        this.progressIndicator.setMaxSize(200.0, 200.0);
        this.progressIndicator.setVisible(true);
        Task<Void> task = this.createTask(opcija);
        new Thread((Runnable)task).start();
        this.progressIndicator.progressProperty().bind((ObservableValue)task.progressProperty());
        this.listaObjekta.clear();
        this.tablicaPopisObjekata.getItems().clear();
    }

    public void popuniTablicuPopisObjekta() {
        this.tablicaPopisObjekata.setPlaceholder((Node)this.progressIndicator);
        this.progressIndicator.setMaxSize(200.0, 200.0);
        this.progressIndicator.setVisible(true);
        Task<Void> task = this.createTask(BazaObjektiIspitivanja.Opcije.otvorene_objekte);
        new Thread((Runnable)task).start();
        this.progressIndicator.progressProperty().bind((ObservableValue)task.progressProperty());
        this.listaObjekta.clear();
        this.tablicaPopisObjekata.getItems().clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void popuniTablicuPopisObjekata(BazaObjektiIspitivanja.Opcije opcija) {
        ResultSet rs = BazaObjektiIspitivanja.dajObjekte(GlavniPanelController.getOdabranaTvrtka(), opcija);
        ObjekatIspitivanje oi = null;
        int br = 1;
        try {
            while (rs.next()) {
                oi = new ObjekatIspitivanje();
                oi.setId(rs.getInt("id"));
                oi.setRedBroj(String.valueOf(br));
                oi.setPoslovnaJedinica(rs.getString("nazivposlovnice"));
                oi.setNazivObjekta(rs.getString("nazivodjela"));
                oi.setAdresa(rs.getString("adresa"));
                oi.setZatvoren(rs.getBoolean("zatvoren"));
                this.listaObjekta.add((Object)oi);
                ++br;
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(PregledObjektIspitivanjeController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(PregledObjektIspitivanjeController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private Task<Void> createTask(final BazaObjektiIspitivanja.Opcije opcija) {
        return new Task<Void>(){

            public Void call() {
                try {
                    this.updateProgress(-1.0, 1.0);
                    this.updateMessage("Waiting...");
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(PregledObjektIspitivanjeController.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    this.updateMessage("Running...");
                    Platform.runLater(() -> PregledObjektIspitivanjeController.this.popuniTablicuPopisObjekata(opcija));
                }
                finally {
                    Platform.runLater(() -> PregledObjektIspitivanjeController.this.progressIndicator.setVisible(false));
                }
                return null;
            }
        };
    }

    private void ispisKartonObjekta(ObservableList<ObjekatIspitivanje> listaObjekatIspitivanje) {
        String idArray = "";
        for (int i = 0; i < listaObjekatIspitivanje.size(); ++i) {
            idArray = i == 0 ? idArray + String.valueOf(((ObjekatIspitivanje)listaObjekatIspitivanje.get(i)).getId()) : idArray + "," + String.valueOf(((ObjekatIspitivanje)listaObjekatIspitivanje.get(i)).getId());
        }
        String sql = "SELECT \n  odjeli.nazivodjela, \n  objektispitivanje.id, \n  objektispitivanje.adresa, \n  objektispitivanje.idtvrtka, \n  objektispitivanje.podatkeupisao, \n  objektispitivanje.datumkreiranja , objektispitivanje.zatvoren,  \n  poslovnejedinice.nazivposlovnice\nFROM \n  public.objektispitivanje, \n  public.poslovnejedinice, \n  public.odjeli\nWHERE \n  objektispitivanje.poslovnajedinica = poslovnejedinice.id AND\n  objektispitivanje.nazivobjekta = odjeli.id  and objektispitivanje.id IN (select(unnest(ARRAY [" + idArray + "]))) and idtvrtka='" + GlavniPanelController.getOdabranaTvrtka().getId() + "' ";
        final IspisJasperButtonSaSubreportom wb = new IspisJasperButtonSaSubreportom(this.btnIspis, sql, "ObjektIspis.jrxml");
        wb.setOnSucceeded((EventHandler)new EventHandler<WorkerStateEvent>(){

            public void handle(WorkerStateEvent t) {
                if (wb.getValue() != null) {
                    JasperViewerFX viewer = new JasperViewerFX(new Stage(), ((JasperPrint)wb.getValue()).getName(), (JasperPrint)wb.getValue());
                    viewer.show();
                }
            }
        });
        wb.setOnFailed((EventHandler)new EventHandler<WorkerStateEvent>(){

            public void handle(WorkerStateEvent t) {
                System.out.println("Connection error.");
            }
        });
        new Thread((Runnable)((Object)wb)).start();
    }

    private class ButtonCell
    extends TableCell<ObjekatIspitivanje, Boolean> {
        Button cellButton = new Button("Pregled");

        ButtonCell() {
            this.cellButton.setId("btnPregled");
            this.cellButton.setContentDisplay(ContentDisplay.LEFT);
            this.cellButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent t) {
                    ObjekatIspitivanje oi;
                    int selectdIndex = PregledObjektIspitivanjeController.this.tablicaPopisObjekata.getSelectionModel().getSelectedIndex();
                    if (selectdIndex != -1 && (oi = (ObjekatIspitivanje)PregledObjektIspitivanjeController.this.tablicaPopisObjekata.getSelectionModel().getSelectedItem()) != null) {
                        GlavniPanelController.getInstance().setBlurEfekt(new GaussianBlur(10.0));
                        Template.getTamplate().showTemplate("objektiispitivanja/UnosObjekta.fxml", "anchorPanelStroj");
                        UnosObjektaController.getInstance().izmjenaObjekta(oi);
                        PregledObjektIspitivanjeController.this.tablicaPopisObjekata.getSelectionModel().clearSelection();
                    }
                }
            });
        }

        protected void updateItem(Boolean t, boolean empty) {
            super.updateItem((Object)t, empty);
            if (!empty) {
                this.setGraphic((Node)this.cellButton);
                this.cellButton.disableProperty().bind((ObservableValue)PregledObjektIspitivanjeController.this.tablicaPopisObjekata.getSelectionModel().selectedIndexProperty().isNotEqualTo(this.getTableRow().getIndex()));
            } else {
                this.setGraphic(null);
            }
        }
    }
}

