/*
 * Decompiled with CFR 0.152.
 */
package objektiispitivanja;

import Utill.ComboBoxCellDokument;
import Utill.DateCell;
import Utill.DateUtil;
import Utill.FormValidation;
import Utill.FxDialogs;
import Utill.KlasaKorisneMetode;
import Utill.ResizeComponent;
import Utill.ScanDokument;
import dokumentiTvrtke.BazaDokumenti;
import dokumentiTvrtke.DokumentHiperlinkCell;
import ispisJasper.IspisJasperButtonSaSubreportom;
import ispisJasper.IspisReporta;
import ispisJasper.JasperViewerFX;
import ispitivanja.BazaIspitivanja;
import ispitivanja.Ispitivanje;
import java.io.File;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.text.TextAlignment;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.util.Callback;
import javafx.util.StringConverter;
import kadrovska.BazaDjelatnik;
import kadrovska.UnosDjelatnikaController;
import monitoringnovi.ServiceRestart;
import net.sf.jasperreports.engine.JasperPrint;
import objektiispitivanja.BazaObjektiIspitivanja;
import objektiispitivanja.ComboBoxCellIspitivanja;
import objektiispitivanja.ObjekatEvidencijaPregleda;
import objektiispitivanja.ObjekatIspitivanje;
import objektiispitivanja.PregledObjektIspitivanjeController;
import odjeli.BazaOdjeli;
import poslovnejedinice.PoslovneJedinice;
import zastitanaradu.GlavniPanelController;

public class UnosObjektaController
implements Initializable {
    @FXML
    private TabPane tabPanelPodaci;
    @FXML
    private AnchorPane anchorPanelStroj;
    @FXML
    private Button btnSpremi;
    @FXML
    private Tab tabEvidencijaPregleda;
    @FXML
    private Button btnUnosIspitivanje;
    @FXML
    private Button btnBrisanjeIspitivanje;
    @FXML
    private Button btnIspisIspitivanje;
    @FXML
    private TableView<ObjekatEvidencijaPregleda> tablicaEvidencijaPregleda;
    @FXML
    private TableColumn<ObjekatEvidencijaPregleda, String> kolRedBr;
    @FXML
    private TableColumn<ObjekatEvidencijaPregleda, String> kolOznakaIspitivanja;
    @FXML
    private TableColumn<ObjekatEvidencijaPregleda, String> kolNazivIspitivanja;
    @FXML
    private TableColumn<ObjekatEvidencijaPregleda, LocalDate> kolDatumIspitivanja;
    @FXML
    private TableColumn<ObjekatEvidencijaPregleda, LocalDate> kolDatumPonovogIspitivanja;
    @FXML
    private TableColumn<ObjekatEvidencijaPregleda, String> kolUstanova;
    @FXML
    private TableColumn<ObjekatEvidencijaPregleda, String> kolBrZapisnika;
    @FXML
    private TableColumn<ObjekatEvidencijaPregleda, String> kolDokument;
    @FXML
    private TableColumn<ObjekatEvidencijaPregleda, String> kolPodatkeUpisao;
    @FXML
    private Tab tabDokumenti;
    @FXML
    private TextField txtOpis;
    @FXML
    private TableView<ScanDokument> tablicaDokumenti;
    @FXML
    private TableColumn<ScanDokument, String> kolNazivDokumenta;
    @FXML
    private TableColumn<ScanDokument, String> kolRedBrDokument;
    @FXML
    private Button btnSpremiDokument;
    @FXML
    private Button btnBrisanjeDokument;
    @FXML
    private ComboBox<String> cBoxOdjel;
    @FXML
    private ComboBox<PoslovneJedinice> cBoxPoslovnaJedinica;
    @FXML
    private TextField txtMjestoAdresa;
    @FXML
    private CheckBox chBoxZatvoren;
    @FXML
    private MenuButton btnIspis;
    private static UnosObjektaController instance;
    private ObservableList<ScanDokument> listaDokumenti = FXCollections.observableArrayList();
    private ObservableList<ObjekatEvidencijaPregleda> listaObjekataIspitivanja = FXCollections.observableArrayList();
    ProgressIndicator progressIndicator = new ProgressIndicator();
    private Boolean izmjenaObjekta = false;
    BooleanProperty bp = new SimpleBooleanProperty(false);
    private ObjekatIspitivanje oi;

    public TabPane getTabPanelPodaci() {
        return this.tabPanelPodaci;
    }

    public static UnosObjektaController getInstance() {
        return instance;
    }

    public ObjekatIspitivanje getOi() {
        return this.oi;
    }

    public void setOi(ObjekatIspitivanje oi) {
        this.oi = oi;
    }

    public void initialize(URL url, ResourceBundle rb) {
        instance = this;
        ResizeComponent.makeTextFieldResize(this.txtOpis);
        this.popuniCBoxPoslovnice();
        this.cBoxPoslovnaJedinica.valueProperty().addListener((o, ov, nv) -> {
            PoslovneJedinice p = nv;
            this.popuniOdjelePoslovneJedinice(p.getId());
        });
        this.tabDokumenti.disableProperty().bind((ObservableValue)this.bp.not());
        this.tabEvidencijaPregleda.disableProperty().bind((ObservableValue)this.bp.not());
        this.urediTablicuEvidencijaPregleda();
        if (this.izmjenaObjekta.booleanValue()) {
            this.popuniTablicuEvidencijaPregleda();
        }
        this.urediKoloneUTabliciDokumenti();
        this.popuniTablicuDokumenti();
        this.popuniButtonIspis();
        this.btnBrisanjeDokument.disableProperty().bind((ObservableValue)Bindings.equal((ObservableNumberValue)this.tablicaDokumenti.getSelectionModel().selectedIndexProperty(), (int)-1));
        this.btnBrisanjeDokument.setOnAction(event -> {
            int selectedIdx = this.tablicaDokumenti.getSelectionModel().getSelectedIndex();
            ScanDokument sc = (ScanDokument)this.tablicaDokumenti.getSelectionModel().getSelectedItem();
            Alert alert = FxDialogs.getDialog(Alert.AlertType.CONFIRMATION, "Brisanje Dokumenta", "\u017delite li obrisati dokument ?");
            Optional result = alert.showAndWait();
            if (selectedIdx != -1) {
                if (result.get() == ButtonType.OK) {
                    if (BazaDokumenti.deleteDokument(sc)) {
                        this.popuniTablicuDokumenti();
                    } else {
                        Alert error = FxDialogs.getDialog(Alert.AlertType.ERROR, "Brisanje dokumenta", "Neuspjelo brisanje dokumenta");
                        error.showAndWait();
                    }
                } else {
                    this.tablicaDokumenti.getSelectionModel().clearSelection();
                }
            }
        });
        this.btnSpremiDokument.setOnAction(e -> {
            block6: {
                boolean bopis = FormValidation.textFieldValidationonlyText(this.txtOpis);
                if (bopis) {
                    FileChooser fileChooser = new FileChooser();
                    File selectedFile = fileChooser.showOpenDialog(null);
                    if (selectedFile != null) {
                        try {
                            byte[] byteImage = KlasaKorisneMetode.ImageToByte(new File(selectedFile.getAbsolutePath()));
                            if (BazaDokumenti.addDokumentObjekat(this.txtOpis.getText() + " (" + LocalDate.now().format(DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM)) + ")." + KlasaKorisneMetode.getExtension(selectedFile), GlavniPanelController.getOdabranaTvrtka(), this.oi.getId(), byteImage, GlavniPanelController.getInstance().getKorisnik().punoIme())) {
                                KlasaKorisneMetode.kreirajNotifikaciju(Pos.BOTTOM_RIGHT, "Uspje\u0161no unesen dokument", 1, "Information graphic");
                                this.txtOpis.clear();
                                this.popuniTablicuDokumenti();
                                break block6;
                            }
                            KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161no unesen dokument", 2, "Error graphic");
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                        }
                    }
                } else {
                    Alert alert = FxDialogs.getDialog(Alert.AlertType.INFORMATION, "Upozorenje", "Morate unjeti naziv Dokumenta");
                    alert.showAndWait();
                }
            }
        });
        this.btnUnosIspitivanje.setOnAction(e -> {
            ObjekatEvidencijaPregleda ob = new ObjekatEvidencijaPregleda();
            ob.setPodatkeUpisao(GlavniPanelController.getInstance().getKorisnik().punoIme());
            if (BazaObjektiIspitivanja.unesiNovoIspitivanjanje(ob, GlavniPanelController.getOdabranaTvrtka().getId(), this.oi.getId())) {
                this.popuniTablicuEvidencijaPregleda();
            } else {
                FxDialogs.showError("Gre\u0161ka unosa", "Neuspje\u0161an unos pregleda");
            }
        });
        this.btnBrisanjeIspitivanje.setOnAction(e -> {
            Alert alert;
            Optional result;
            int selectdIndex = this.tablicaEvidencijaPregleda.getSelectionModel().getSelectedIndex();
            if (selectdIndex != -1 && (result = (alert = FxDialogs.getDialog(Alert.AlertType.CONFIRMATION, "Brisanje", "\u017delite li obrisati ispitivanje")).showAndWait()).get() == ButtonType.OK) {
                if (BazaObjektiIspitivanja.obrisiObjektIspitivanje((ObjekatEvidencijaPregleda)this.tablicaEvidencijaPregleda.getSelectionModel().getSelectedItem())) {
                    this.popuniTablicuEvidencijaPregleda();
                    ServiceRestart.restartService(ServiceRestart.RService.objekti);
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.BOTTOM_RIGHT, "Uspje\u0161no brisanje ", 1, "Information graphic");
                } else {
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161no brisanje", 2, "Error graphic");
                }
            }
        });
        this.btnSpremi.setOnAction(e -> this.spremiObjekt());
        this.btnIspisIspitivanje.setOnAction(e -> this.ispisKartonObjekta());
    }

    void popuniButtonIspis() {
        MenuItem vazeci = new MenuItem("Ispis va\u017ee\u0107ih pregleda");
        vazeci.setOnAction(event -> {
            String sql = "SELECT \n  odjeli.nazivodjela, \n  objektispitivanje.id, \n  objektispitivanje.adresa, \n  objektispitivanje.idtvrtka, \n  objektispitivanje.podatkeupisao, \n  objektispitivanje.datumkreiranja , objektispitivanje.zatvoren,  \n  poslovnejedinice.nazivposlovnice\nFROM \n  public.objektispitivanje, \n  public.poslovnejedinice, \n  public.odjeli\nWHERE \n  objektispitivanje.poslovnajedinica = poslovnejedinice.id AND\n  objektispitivanje.nazivobjekta = odjeli.id  and objektispitivanje.id='" + this.oi.getId() + "' and idtvrtka='" + GlavniPanelController.getOdabranaTvrtka().getId() + "' ";
            IspisReporta.ispisMenuButtonSaSubReportom(sql, this.btnIspis, "ObjektIspis.jrxml");
        });
        MenuItem svi = new MenuItem("Ispis svih pregleda");
        svi.setOnAction(e -> {
            String sql = "SELECT \n  odjeli.nazivodjela, \n  objektispitivanje.id, \n  objektispitivanje.adresa, \n  objektispitivanje.idtvrtka, \n  objektispitivanje.podatkeupisao, \n  objektispitivanje.datumkreiranja , objektispitivanje.zatvoren,  \n  poslovnejedinice.nazivposlovnice\nFROM \n  public.objektispitivanje, \n  public.poslovnejedinice, \n  public.odjeli\nWHERE \n  objektispitivanje.poslovnajedinica = poslovnejedinice.id AND\n  objektispitivanje.nazivobjekta = odjeli.id  and objektispitivanje.id ='" + this.oi.getId() + "' and idtvrtka='" + GlavniPanelController.getOdabranaTvrtka().getId() + "' ";
            IspisReporta.ispisMenuButtonSaSubReportom(sql, this.btnIspis, "IspisKartonaObjekta.jrxml");
        });
        this.btnIspis.getItems().addAll((Object[])new MenuItem[]{vazeci, new SeparatorMenuItem(), svi});
    }

    public void postaviPoslovnicu(String naziv) {
        this.cBoxPoslovnaJedinica.setValue(this.cBoxPoslovnaJedinica.getConverter().fromString(naziv));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void popuniCBoxPoslovnice() {
        final ObservableMap map = FXCollections.observableHashMap();
        ResultSet rs = BazaDjelatnik.dajPoslovnujednicu(GlavniPanelController.getOdabranaTvrtka());
        try {
            while (rs.next()) {
                PoslovneJedinice pj = new PoslovneJedinice();
                pj.setId(rs.getInt("id"));
                pj.setNazivPoslovnice(rs.getString("nazivposlovnice"));
                pj.setAdresaPoslovnice(rs.getString("adresa"));
                pj.setMjesto(rs.getString("mjesto"));
                map.put((Object)rs.getString("nazivposlovnice"), (Object)pj);
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(UnosDjelatnikaController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(UnosDjelatnikaController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.cBoxPoslovnaJedinica.getItems().addAll(map.values());
        this.cBoxPoslovnaJedinica.setConverter((StringConverter)new StringConverter<PoslovneJedinice>(){

            public String toString(PoslovneJedinice t) {
                if (t != null) {
                    String str = t.getNazivPoslovnice();
                    map.put((Object)str, (Object)t);
                    return str;
                }
                return "";
            }

            public PoslovneJedinice fromString(String string) {
                if (!map.containsKey((Object)string)) {
                    UnosObjektaController.this.cBoxPoslovnaJedinica.setValue(null);
                    UnosObjektaController.this.cBoxPoslovnaJedinica.getEditor().clear();
                    return null;
                }
                return (PoslovneJedinice)map.get((Object)string);
            }
        });
        this.cBoxPoslovnaJedinica.setCellFactory((Callback)new Callback<ListView<PoslovneJedinice>, ListCell<PoslovneJedinice>>(){

            public ListCell<PoslovneJedinice> call(ListView<PoslovneJedinice> p) {
                ListCell<PoslovneJedinice> cell = new ListCell<PoslovneJedinice>(){

                    protected void updateItem(PoslovneJedinice item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (empty) {
                            this.setText("");
                        } else {
                            this.setText(item.getNazivPoslovnice());
                            this.setAlignment(Pos.CENTER);
                            this.setPadding(new Insets(3.0, 3.0, 3.0, 0.0));
                        }
                    }
                };
                return cell;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void popuniOdjelePoslovneJedinice(int idPoslovneJedinice) {
        this.cBoxOdjel.getItems().clear();
        ResultSet rs = BazaOdjeli.dajOdjel(GlavniPanelController.getOdabranaTvrtka(), idPoslovneJedinice);
        try {
            while (rs.next()) {
                this.cBoxOdjel.getItems().add((Object)rs.getString("nazivodjela"));
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(UnosObjektaController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(UnosObjektaController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void urediKoloneUTabliciDokumenti() {
        this.kolRedBrDokument.setCellValueFactory((Callback)new PropertyValueFactory("redBroj"));
        this.kolRedBrDokument.prefWidthProperty().bind((ObservableValue)this.tablicaDokumenti.widthProperty().divide(10.0));
        this.kolRedBrDokument.setStyle("-fx-alignment: CENTER;");
        this.kolNazivDokumenta.setCellValueFactory((Callback)new PropertyValueFactory("opisDokumenta"));
        this.kolNazivDokumenta.prefWidthProperty().bind((ObservableValue)this.tablicaDokumenti.widthProperty().divide(1.1235955056179776));
        this.kolNazivDokumenta.setStyle("-fx-alignment: CENTER;");
        Callback cellScanDokument = param -> new DokumentHiperlinkCell(this.listaDokumenti);
        this.kolNazivDokumenta.setCellFactory(cellScanDokument);
    }

    private void popuniTablicuDokumenti() {
        this.tablicaDokumenti.setPlaceholder((Node)this.progressIndicator);
        this.progressIndicator.setMaxSize(200.0, 200.0);
        this.progressIndicator.setVisible(true);
        Task task = this.createTaskDokumenti();
        new Thread((Runnable)task).start();
        this.progressIndicator.progressProperty().bind((ObservableValue)task.progressProperty());
        this.listaDokumenti.clear();
        this.tablicaDokumenti.getItems().clear();
    }

    private Task createTaskDokumenti() {
        return new Task<Void>(){

            public Void call() {
                try {
                    this.updateProgress(-1.0, 1.0);
                    this.updateMessage("Waiting...");
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(UnosObjektaController.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    this.updateMessage("Running...");
                    UnosObjektaController.this.popuniTablicuDokumentiizBaze();
                }
                finally {
                    Platform.runLater(() -> UnosObjektaController.this.progressIndicator.setVisible(false));
                }
                return null;
            }
        };
    }

    private void popuniTablicuDokumentiizBaze() {
        int br = 1;
        ResultSet rs = BazaDokumenti.getDokumentiObjekt(GlavniPanelController.getOdabranaTvrtka().getId(), this.oi.getId());
        try {
            while (rs.next()) {
                ScanDokument cd = new ScanDokument();
                cd.setId(rs.getInt("id"));
                cd.setRedBroj(String.valueOf(br));
                cd.setOpisDokumenta(rs.getString("naziv"));
                this.listaDokumenti.add((Object)cd);
                ++br;
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(UnosDjelatnikaController.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.tablicaDokumenti.getItems().addAll(this.listaDokumenti);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void urediTablicuEvidencijaPregleda() {
        this.tablicaEvidencijaPregleda.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent e) {
                if (e.getCode() == KeyCode.ESCAPE && UnosObjektaController.this.tablicaEvidencijaPregleda.getEditingCell() == null) {
                    UnosObjektaController.this.tablicaEvidencijaPregleda.getSelectionModel().clearSelection();
                    e.consume();
                }
            }
        });
        this.kolRedBr.setCellValueFactory(cellData -> ((ObjekatEvidencijaPregleda)cellData.getValue()).redBrojProperty());
        this.kolRedBr.prefWidthProperty().bind((ObservableValue)this.tablicaEvidencijaPregleda.widthProperty().divide(33.333333333333336));
        this.kolRedBr.setStyle("-fx-alignment: CENTER;");
        ObservableList listaIspitivanja = FXCollections.observableArrayList();
        ResultSet rs = BazaIspitivanja.dajIspitivanja(GlavniPanelController.getOdabranaTvrtka());
        try {
            while (rs.next()) {
                Ispitivanje i = new Ispitivanje();
                i.setId(rs.getInt("id"));
                i.setOznaka(rs.getString("oznaka"));
                i.setNaziv(rs.getString("nazivpregleda"));
                i.setPeriodika(rs.getString("periodika"));
                listaIspitivanja.add((Object)i);
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(UnosObjektaController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(UnosObjektaController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        Callback comboCellFactoryOznaka = param -> new ComboBoxCellIspitivanja((ObservableList<Ispitivanje>)listaIspitivanja, "oznaka");
        Callback comboCellFactoryNaziv = param -> new ComboBoxCellIspitivanja((ObservableList<Ispitivanje>)listaIspitivanja, "naziv");
        this.kolOznakaIspitivanja.setCellValueFactory(cellData -> ((ObjekatEvidencijaPregleda)cellData.getValue()).oznakaIspitivanjaProperty());
        this.kolOznakaIspitivanja.setCellFactory(comboCellFactoryOznaka);
        this.kolOznakaIspitivanja.prefWidthProperty().bind((ObservableValue)this.tablicaEvidencijaPregleda.widthProperty().divide(10.0));
        this.kolOznakaIspitivanja.setStyle("-fx-alignment: CENTER;");
        this.kolOznakaIspitivanja.setOnEditCommit(t -> ((ObjekatEvidencijaPregleda)t.getTableView().getItems().get(t.getTablePosition().getRow())).setOznakaIspitivanja((String)t.getNewValue()));
        this.kolNazivIspitivanja.setCellValueFactory(cellData -> ((ObjekatEvidencijaPregleda)cellData.getValue()).nazivIspitivanjaProperty());
        this.kolNazivIspitivanja.setCellFactory(comboCellFactoryNaziv);
        this.kolNazivIspitivanja.prefWidthProperty().bind((ObservableValue)this.tablicaEvidencijaPregleda.widthProperty().divide(5.0));
        this.kolNazivIspitivanja.setStyle("-fx-alignment: CENTER;");
        this.kolNazivIspitivanja.setOnEditCommit(t -> ((ObjekatEvidencijaPregleda)t.getTableView().getItems().get(t.getTablePosition().getRow())).setNazivIspitivanja((String)t.getNewValue()));
        Callback dateCellFactory = param -> new DateCell();
        Label l1 = new Label("Datum  obavljenog \n ispitivanja");
        l1.setAlignment(Pos.CENTER);
        l1.setTextAlignment(TextAlignment.CENTER);
        this.kolDatumIspitivanja.setGraphic((Node)l1);
        this.kolDatumIspitivanja.setCellValueFactory(cellData -> ((ObjekatEvidencijaPregleda)cellData.getValue()).datumObavljenogIspitivanjaProperty());
        this.kolDatumIspitivanja.setCellFactory(dateCellFactory);
        this.kolDatumIspitivanja.prefWidthProperty().bind((ObservableValue)this.tablicaEvidencijaPregleda.widthProperty().divide(12.5));
        this.kolDatumIspitivanja.setStyle("-fx-alignment: CENTER;");
        this.kolDatumIspitivanja.setOnEditCommit(t -> {
            ((ObjekatEvidencijaPregleda)t.getTableView().getItems().get(t.getTablePosition().getRow())).setDatumObavljenogIspitivanja((LocalDate)t.getNewValue());
            BazaObjektiIspitivanja.unesiPromjenuObjektIspitivanja((ObjekatEvidencijaPregleda)t.getTableView().getItems().get(t.getTablePosition().getRow()));
        });
        Label l5 = new Label("Datum ponovog \n ispitivanja");
        l5.setAlignment(Pos.CENTER);
        l5.setTextAlignment(TextAlignment.CENTER);
        this.kolDatumPonovogIspitivanja.setGraphic((Node)l5);
        this.kolDatumPonovogIspitivanja.setCellValueFactory(cellData -> ((ObjekatEvidencijaPregleda)cellData.getValue()).datumPonovogIspitivanjaProperty());
        this.kolDatumPonovogIspitivanja.setCellFactory(dateCellFactory);
        this.kolDatumPonovogIspitivanja.prefWidthProperty().bind((ObservableValue)this.tablicaEvidencijaPregleda.widthProperty().divide(12.5));
        this.kolDatumPonovogIspitivanja.setStyle("-fx-alignment: CENTER;");
        this.kolDatumPonovogIspitivanja.setOnEditCommit(t -> {
            ((ObjekatEvidencijaPregleda)t.getTableView().getItems().get(t.getTablePosition().getRow())).setDatumPonovogIspitivanja((LocalDate)t.getNewValue());
            BazaObjektiIspitivanja.unesiPromjenuObjektIspitivanja((ObjekatEvidencijaPregleda)t.getTableView().getItems().get(t.getTablePosition().getRow()));
            ServiceRestart.restartService(ServiceRestart.RService.objekti);
        });
        Callback cellDokument = param -> new ComboBoxCellDokument(this.listaDokumenti);
        this.kolUstanova.setCellValueFactory(cellData -> ((ObjekatEvidencijaPregleda)cellData.getValue()).nazivOrganizacijeIspitivanjaProperty());
        this.kolUstanova.setCellFactory(TextFieldTableCell.forTableColumn());
        this.kolUstanova.prefWidthProperty().bind((ObservableValue)this.tablicaEvidencijaPregleda.widthProperty().divide(5.0));
        this.kolUstanova.setStyle("-fx-alignment: CENTER;");
        this.kolUstanova.setOnEditCommit(t -> {
            ((ObjekatEvidencijaPregleda)t.getTableView().getItems().get(t.getTablePosition().getRow())).setNazivOrganizacijeIspitivanja((String)t.getNewValue());
            BazaObjektiIspitivanja.unesiPromjenuObjektIspitivanja((ObjekatEvidencijaPregleda)t.getTableView().getItems().get(t.getTablePosition().getRow()));
        });
        this.kolBrZapisnika.setCellValueFactory(cellData -> ((ObjekatEvidencijaPregleda)cellData.getValue()).brojZapisnikaProperty());
        this.kolBrZapisnika.setCellFactory(TextFieldTableCell.forTableColumn());
        this.kolBrZapisnika.prefWidthProperty().bind((ObservableValue)this.tablicaEvidencijaPregleda.widthProperty().divide(20.0));
        this.kolBrZapisnika.setStyle("-fx-alignment: CENTER;");
        this.kolBrZapisnika.setOnEditCommit(t -> {
            ((ObjekatEvidencijaPregleda)t.getTableView().getItems().get(t.getTablePosition().getRow())).setBrojZapisnika((String)t.getNewValue());
            BazaObjektiIspitivanja.unesiPromjenuObjektIspitivanja((ObjekatEvidencijaPregleda)t.getTableView().getItems().get(t.getTablePosition().getRow()));
        });
        this.kolDokument.setCellValueFactory(cellData -> ((ObjekatEvidencijaPregleda)cellData.getValue()).nazivDokumentaProperty());
        this.kolDokument.setCellFactory(cellDokument);
        this.kolDokument.prefWidthProperty().bind((ObservableValue)this.tablicaEvidencijaPregleda.widthProperty().divide(6.666666666666667));
        this.kolDokument.setStyle("-fx-alignment: CENTER;");
        this.kolDokument.setOnEditCommit(t -> {
            ((ObjekatEvidencijaPregleda)t.getTableView().getItems().get(t.getTablePosition().getRow())).setNazivDokumenta((String)t.getNewValue());
            BazaObjektiIspitivanja.unesiPromjenuObjektIspitivanja((ObjekatEvidencijaPregleda)t.getTableView().getItems().get(t.getTablePosition().getRow()));
        });
        this.kolPodatkeUpisao.setCellValueFactory(cellData -> ((ObjekatEvidencijaPregleda)cellData.getValue()).podatkeUpisaoProperty());
        this.kolPodatkeUpisao.prefWidthProperty().bind((ObservableValue)this.tablicaEvidencijaPregleda.widthProperty().divide(6.666666666666667));
        this.kolPodatkeUpisao.setStyle("-fx-alignment: CENTER;");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void popuniTablicuPodatkeEvidencijaPregleda() {
        ResultSet rs = BazaObjektiIspitivanja.dajObjektIspitivanja(GlavniPanelController.getOdabranaTvrtka().getId(), this.oi.getId());
        ObjekatEvidencijaPregleda op = null;
        int br = 1;
        try {
            while (rs.next()) {
                op = new ObjekatEvidencijaPregleda();
                op.setId(rs.getInt("id"));
                op.setRedBroj(String.valueOf(br));
                op.setOznakaIspitivanja(rs.getString("oznaka"));
                op.setNazivIspitivanja(rs.getString("nazivpregleda"));
                op.setDatumObavljenogIspitivanja(DateUtil.getLocalDate(rs.getDate("datumobavljenogispitivanja")));
                op.setDatumPonovogIspitivanja(DateUtil.getLocalDate(rs.getDate("datumponovogispitivanja")));
                op.setNazivOrganizacijeIspitivanja(rs.getString("ustanova"));
                op.setBrojZapisnika(rs.getString("brojzapisnika"));
                op.setNazivDokumenta(rs.getString("dokument"));
                op.setPodatkeUpisao(rs.getString("podatkeupisao"));
                this.listaObjekataIspitivanja.add((Object)op);
                ++br;
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(UnosObjektaController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(UnosObjektaController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.tablicaEvidencijaPregleda.setItems(this.listaObjekataIspitivanja);
    }

    private void popuniTablicuEvidencijaPregleda() {
        this.tablicaEvidencijaPregleda.setPlaceholder((Node)this.progressIndicator);
        this.progressIndicator.setMaxSize(200.0, 200.0);
        this.progressIndicator.setVisible(true);
        Task task = this.createTaskObjektIspitivanje();
        new Thread((Runnable)task).start();
        this.progressIndicator.progressProperty().bind((ObservableValue)task.progressProperty());
        this.listaObjekataIspitivanja.clear();
        this.tablicaEvidencijaPregleda.getItems().clear();
    }

    private Task createTaskObjektIspitivanje() {
        return new Task<Void>(){

            public Void call() {
                try {
                    this.updateProgress(-1.0, 1.0);
                    this.updateMessage("Waiting...");
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(UnosObjektaController.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    this.updateMessage("Running...");
                    UnosObjektaController.this.popuniTablicuPodatkeEvidencijaPregleda();
                }
                finally {
                    Platform.runLater(() -> UnosObjektaController.this.progressIndicator.setVisible(false));
                }
                return null;
            }
        };
    }

    public void izmjenaObjekta(ObjekatIspitivanje oi) {
        this.izmjenaObjekta = true;
        this.bp.set(true);
        this.oi = oi;
        this.postaviPoslovnicu(oi.getPoslovnaJedinica());
        this.cBoxOdjel.setValue((Object)oi.getNazivObjekta());
        this.txtMjestoAdresa.setText(oi.getAdresa());
        this.chBoxZatvoren.setSelected(oi.isZatvoren());
        this.popuniTablicuEvidencijaPregleda();
    }

    private ObjekatIspitivanje dajObjekt() {
        ObjekatIspitivanje oi = new ObjekatIspitivanje();
        oi.setPoslovnaJedinica(((PoslovneJedinice)this.cBoxPoslovnaJedinica.getValue()).getNazivPoslovnice());
        oi.setNazivObjekta((String)this.cBoxOdjel.getValue());
        oi.setAdresa(this.txtMjestoAdresa.getText());
        oi.setZatvoren(this.chBoxZatvoren.isSelected());
        return oi;
    }

    private void spremiObjekt() {
        boolean bPoslovnica = FormValidation.comboBoxValidationText(this.cBoxPoslovnaJedinica);
        boolean bOdjel = FormValidation.comboBoxValidationText(this.cBoxOdjel);
        boolean bAdresa = FormValidation.textFieldValidationonlyText(this.txtMjestoAdresa);
        if (bAdresa & bPoslovnica & bOdjel) {
            if (this.izmjenaObjekta.booleanValue()) {
                if (BazaObjektiIspitivanja.izmjenaObjekta(GlavniPanelController.getOdabranaTvrtka(), this.dajObjekt(), this.oi.getId())) {
                    if (!GlavniPanelController.getInstance().getTabByIdifExist("Popis ispitivanja objekata")) {
                        PregledObjektIspitivanjeController.getInstance().popuniTablicuPopisObjekta();
                    }
                    GlavniPanelController.getInstance().zatvoriTab("Unos objekta");
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.BOTTOM_RIGHT, "Uspje\u0161na izmjena objekta", 1, "Information graphic");
                } else {
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161na izmjena objekta", 2, "Error graphic");
                }
            } else if (BazaObjektiIspitivanja.unesiNoviObjekt(GlavniPanelController.getOdabranaTvrtka(), this.dajObjekt())) {
                KlasaKorisneMetode.kreirajNotifikaciju(Pos.BOTTOM_RIGHT, "Uspje\u0161no unesen objekta", 1, "Information graphic");
                PregledObjektIspitivanjeController.getInstance().popuniTablicuPopisObjekta();
                GlavniPanelController.getInstance().zatvoriTab("Unos objekta");
                this.izmjenaObjekta = false;
            } else {
                KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161no unesen objekta", 2, "Error graphic");
            }
        } else {
            Alert alert = FxDialogs.getDialog(Alert.AlertType.INFORMATION, "Upozorenje", "Morate popuniti sva oznacena polja");
            alert.showAndWait();
        }
    }

    private void ispisKartonObjekta() {
        String sql = "SELECT \n  odjeli.nazivodjela, \n  objektispitivanje.id, \n  objektispitivanje.adresa, \n  objektispitivanje.idtvrtka, \n  objektispitivanje.podatkeupisao, \n  objektispitivanje.datumkreiranja , objektispitivanje.zatvoren,  \n  poslovnejedinice.nazivposlovnice\nFROM \n  public.objektispitivanje, \n  public.poslovnejedinice, \n  public.odjeli\nWHERE \n  objektispitivanje.poslovnajedinica = poslovnejedinice.id AND\n  objektispitivanje.nazivobjekta = odjeli.id  and objektispitivanje.id ='" + this.oi.getId() + "' and idtvrtka='" + GlavniPanelController.getOdabranaTvrtka().getId() + "' ";
        final IspisJasperButtonSaSubreportom wb = new IspisJasperButtonSaSubreportom(this.btnIspisIspitivanje, sql, "IspisKartonaObjekta.jrxml");
        wb.setOnSucceeded((EventHandler)new EventHandler<WorkerStateEvent>(){

            public void handle(WorkerStateEvent t) {
                if (wb.getValue() != null) {
                    JasperViewerFX viewer = new JasperViewerFX(new Stage(), ((JasperPrint)wb.getValue()).getName(), (JasperPrint)wb.getValue());
                    viewer.show();
                }
            }
        });
        wb.setOnFailed((EventHandler)new EventHandler<WorkerStateEvent>(){

            public void handle(WorkerStateEvent t) {
                System.out.println("Connection error.");
            }
        });
        new Thread((Runnable)((Object)wb)).start();
    }
}

