/*
 * Decompiled with CFR 0.152.
 */
package odbor;

import Utill.ComboBoxCellDokument;
import Utill.DateCell;
import Utill.DateUtil;
import Utill.FormValidation;
import Utill.FxDialogs;
import Utill.KlasaKorisneMetode;
import Utill.ResizeComponent;
import Utill.ScanDokument;
import dokumentiTvrtke.BazaDokumenti;
import dokumentiTvrtke.DokumentHiperlinkCell;
import ispisJasper.IspisReporta;
import java.io.File;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Optional;
import java.util.Random;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.Tab;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.ComboBoxTableCell;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.stage.FileChooser;
import javafx.util.Callback;
import monitoringnovi.ServiceRestart;
import odbor.Odbor;
import odbor.OdborBaza;
import odbor.Sjednica;
import zastitanaradu.GlavniPanelController;

public class OdborController
implements Initializable {
    @FXML
    private Tab tabEvidencijaPregleda;
    @FXML
    private Button btnUnosOdbor;
    @FXML
    private Button btnBrisanjeOdbor;
    @FXML
    private Button btnIspisOdbor;
    @FXML
    private TableView<Odbor> tablicaOdbor;
    @FXML
    private TableColumn<Odbor, String> kolRedBr;
    @FXML
    private TableColumn<Odbor, String> kolIme;
    @FXML
    private TableColumn<Odbor, String> kolPrezime;
    @FXML
    private TableColumn<Odbor, String> kolTel;
    @FXML
    private TableColumn<Odbor, String> kolEmail;
    @FXML
    private TableColumn<Odbor, String> kolFunkcija;
    @FXML
    private TableColumn<Odbor, LocalDate> kolDatumImenovanja;
    @FXML
    private TableColumn<Odbor, String> kolDokumentImenovanja;
    @FXML
    private Button btnUnosSjednice;
    @FXML
    private Button btnBrisanjeSjednice;
    @FXML
    private Button btnIspisSjednice;
    @FXML
    private TableView<Sjednica> tablicaEvidencijaSjednica;
    @FXML
    private TableColumn<Sjednica, String> kolRedBrSjednice;
    @FXML
    private TableColumn<Sjednica, LocalDate> kolDatumSjednice;
    @FXML
    private TableColumn<Sjednica, String> kolNazivSjednice;
    @FXML
    private TableColumn<Sjednica, String> kolDokumentSjednice;
    @FXML
    private Tab tabDokumenti;
    @FXML
    private TextField txtOpis;
    @FXML
    private TableView<ScanDokument> tablicaDokumenti;
    @FXML
    private TableColumn<ScanDokument, String> kolRedBrDokument;
    @FXML
    private TableColumn<ScanDokument, String> kolNazivDokumenta;
    @FXML
    private Button btnSpremiDokument;
    @FXML
    private Button btnBrisanjeDokument;
    private static OdborController instance;
    private final ObservableList<String> listaFunkcija = FXCollections.observableArrayList((Object[])new String[]{"Direktor", "Ovla\u0161tenik", "Povjerenik", "Stru\u010dnjak za\u0161tite na radu", "Specijalist medicine rada", "Poslodavac", "Ovla\u0161tenik poslodavca", "Povjerenik radnika", "Stru\u010dnjak za\u0161tite na radu I", "Stru\u010dnjak za\u0161tite na radu II"});
    private ObservableList<ScanDokument> listaDokumenti = FXCollections.observableArrayList();
    private ObservableList<Odbor> listaOdbor = FXCollections.observableArrayList();
    private ObservableList<Sjednica> listaSjednica = FXCollections.observableArrayList();
    private ProgressIndicator progressIndicator;
    private ProgressIndicator progressIndicator1;
    private Sjednica sjednica;

    public static OdborController getInstance() {
        return instance;
    }

    public Sjednica getSjednica() {
        return this.sjednica;
    }

    public void setSjednica(Sjednica s) {
        this.sjednica = s;
    }

    public void initialize(URL url, ResourceBundle rb) {
        instance = this;
        ResizeComponent.makeTextFieldResize(this.txtOpis);
        this.urediTablicuOdbor();
        this.popuniTablicuOdbor();
        this.urediTablicuSjednice();
        this.popuniTablicuSjednice();
        this.urediKoloneUTabliciDokumenti();
        this.popuniTablicuDokumenti();
        this.btnBrisanjeDokument.disableProperty().bind((ObservableValue)Bindings.equal((ObservableNumberValue)this.tablicaDokumenti.getSelectionModel().selectedIndexProperty(), (int)-1));
        this.btnBrisanjeDokument.setOnAction(event -> {
            int selectedIdx = this.tablicaDokumenti.getSelectionModel().getSelectedIndex();
            ScanDokument sc = (ScanDokument)this.tablicaDokumenti.getSelectionModel().getSelectedItem();
            Alert alert = FxDialogs.getDialog(Alert.AlertType.CONFIRMATION, "Brisanje Dokumenta", "\u017delite li obrisati dokument ?");
            Optional result = alert.showAndWait();
            if (selectedIdx != -1) {
                if (result.get() == ButtonType.OK) {
                    if (BazaDokumenti.deleteDokument(sc)) {
                        this.popuniTablicuDokumenti();
                    } else {
                        Alert error = FxDialogs.getDialog(Alert.AlertType.ERROR, "Brisanje dokumenta", "Neuspjelo brisanje dokumenta");
                        error.showAndWait();
                    }
                } else {
                    this.tablicaDokumenti.getSelectionModel().clearSelection();
                }
            }
        });
        this.btnSpremiDokument.setOnAction(e -> {
            block6: {
                boolean bopis = FormValidation.textFieldValidationonlyText(this.txtOpis);
                if (bopis) {
                    FileChooser fileChooser = new FileChooser();
                    File selectedFile = fileChooser.showOpenDialog(null);
                    if (selectedFile != null) {
                        try {
                            byte[] byteImage = KlasaKorisneMetode.ImageToByte(new File(selectedFile.getAbsolutePath()));
                            if (OdborBaza.addDokumentSjednica(this.txtOpis.getText() + " (" + LocalDate.now().format(DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM)) + ")." + KlasaKorisneMetode.getExtension(selectedFile), GlavniPanelController.getOdabranaTvrtka(), 1, byteImage, GlavniPanelController.getInstance().getKorisnik().punoIme())) {
                                KlasaKorisneMetode.kreirajNotifikaciju(Pos.BOTTOM_RIGHT, "Uspje\u0161no unesen dokument", 1, "Information graphic");
                                this.txtOpis.clear();
                                this.popuniTablicuDokumenti();
                                break block6;
                            }
                            KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161no unesen dokument", 2, "Error graphic");
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                        }
                    }
                } else {
                    Alert alert = FxDialogs.getDialog(Alert.AlertType.INFORMATION, "Upozorenje", "Morate unjeti naziv Dokumenta");
                    alert.showAndWait();
                }
            }
        });
        this.btnUnosOdbor.setOnAction(e -> {
            Odbor odbor = new Odbor();
            if (OdborBaza.unesiNovogClana(odbor, GlavniPanelController.getOdabranaTvrtka().getId())) {
                this.popuniTablicuOdbor();
            } else {
                FxDialogs.showError("Gre\u0161ka unosa", "Neuspje\u0161an unos ");
            }
        });
        this.btnBrisanjeOdbor.setOnAction(e -> {
            Alert alert;
            Optional result;
            int selectdIndex = this.tablicaOdbor.getSelectionModel().getSelectedIndex();
            if (selectdIndex != -1 && (result = (alert = FxDialogs.getDialog(Alert.AlertType.CONFIRMATION, "Brisanje", "\u017delite li obrisati \u010dlana odbora")).showAndWait()).get() == ButtonType.OK) {
                if (OdborBaza.obrisiClana((Odbor)this.tablicaOdbor.getSelectionModel().getSelectedItem())) {
                    this.popuniTablicuOdbor();
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.BOTTOM_RIGHT, "Uspje\u0161no brisanje ", 1, "Information graphic");
                } else {
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161no brisanje", 2, "Error graphic");
                }
            }
        });
        this.btnUnosSjednice.setOnAction(e -> {
            Sjednica s = new Sjednica();
            if (OdborBaza.unesiNovuSjednicu(s, GlavniPanelController.getOdabranaTvrtka().getId())) {
                this.popuniTablicuSjednice();
            } else {
                FxDialogs.showError("Gre\u0161ka unosa", "Neuspje\u0161an unos ");
            }
        });
        this.btnBrisanjeSjednice.setOnAction(e -> {
            Alert alert;
            Optional result;
            int selectdIndex = this.tablicaEvidencijaSjednica.getSelectionModel().getSelectedIndex();
            if (selectdIndex != -1 && (result = (alert = FxDialogs.getDialog(Alert.AlertType.CONFIRMATION, "Brisanje", "\u017delite li obrisati sjednicu")).showAndWait()).get() == ButtonType.OK) {
                if (OdborBaza.obrisiSjednicu((Sjednica)this.tablicaEvidencijaSjednica.getSelectionModel().getSelectedItem())) {
                    this.popuniTablicuSjednice();
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.BOTTOM_RIGHT, "Uspje\u0161no brisanje ", 1, "Information graphic");
                } else {
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161no brisanje", 2, "Error graphic");
                }
            }
        });
        this.btnIspisOdbor.setOnAction(e -> {
            int selectdIndex = this.tablicaOdbor.getSelectionModel().getSelectedIndex();
            if (selectdIndex != -1) {
                this.ispisPozivnice();
            }
        });
        this.btnIspisSjednice.setOnAction(e -> this.ispisZapisnika());
    }

    private void urediKoloneUTabliciDokumenti() {
        this.kolRedBrDokument.setCellValueFactory((Callback)new PropertyValueFactory("redBroj"));
        this.kolRedBrDokument.prefWidthProperty().bind((ObservableValue)this.tablicaDokumenti.widthProperty().divide(10.0));
        this.kolRedBrDokument.setStyle("-fx-alignment: CENTER;");
        this.kolNazivDokumenta.setCellValueFactory((Callback)new PropertyValueFactory("opisDokumenta"));
        this.kolNazivDokumenta.prefWidthProperty().bind((ObservableValue)this.tablicaDokumenti.widthProperty().divide(1.1235955056179776));
        this.kolNazivDokumenta.setStyle("-fx-alignment: CENTER;");
        Callback cellScanDokument = param -> new DokumentHiperlinkCell(this.listaDokumenti);
        this.kolNazivDokumenta.setCellFactory(cellScanDokument);
    }

    private void popuniTablicuDokumenti() {
        this.tablicaDokumenti.setPlaceholder((Node)this.progressIndicator);
        this.progressIndicator.setMaxSize(200.0, 200.0);
        this.progressIndicator.setVisible(true);
        Task task = this.createTaskDokumenti();
        new Thread((Runnable)task).start();
        this.progressIndicator.progressProperty().bind((ObservableValue)task.progressProperty());
        this.listaDokumenti.clear();
        this.tablicaDokumenti.getItems().clear();
    }

    private Task createTaskDokumenti() {
        return new Task<Void>(){

            public Void call() {
                try {
                    this.updateProgress(-1.0, 1.0);
                    this.updateMessage("Waiting...");
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(OdborController.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    this.updateMessage("Running...");
                    OdborController.this.popuniTablicuDokumentiizBaze();
                }
                finally {
                    Platform.runLater(() -> OdborController.this.progressIndicator.setVisible(false));
                }
                return null;
            }
        };
    }

    private void popuniTablicuDokumentiizBaze() {
        int br = 1;
        ResultSet rs = OdborBaza.getDokumentiOdbor(GlavniPanelController.getOdabranaTvrtka().getId(), 1);
        try {
            while (rs.next()) {
                ScanDokument cd = new ScanDokument();
                cd.setId(rs.getInt("id"));
                cd.setRedBroj(String.valueOf(br));
                cd.setOpisDokumenta(rs.getString("naziv"));
                this.listaDokumenti.add((Object)cd);
                ++br;
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(OdborController.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.tablicaDokumenti.getItems().addAll(this.listaDokumenti);
    }

    private void urediTablicuOdbor() {
        this.tablicaOdbor.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.tablicaOdbor.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent e) {
                if (e.getCode() == KeyCode.ESCAPE && OdborController.this.tablicaOdbor.getEditingCell() == null) {
                    OdborController.this.tablicaOdbor.getSelectionModel().clearSelection();
                    e.consume();
                }
            }
        });
        this.kolRedBr.setCellValueFactory(cellData -> ((Odbor)cellData.getValue()).redBrojProperty());
        this.kolRedBr.prefWidthProperty().bind((ObservableValue)this.tablicaOdbor.widthProperty().divide(16.666666666666668));
        this.kolRedBr.setStyle("-fx-alignment: CENTER;");
        this.kolIme.setCellValueFactory(cellData -> ((Odbor)cellData.getValue()).imeProperty());
        this.kolIme.setCellFactory(TextFieldTableCell.forTableColumn());
        this.kolIme.prefWidthProperty().bind((ObservableValue)this.tablicaOdbor.widthProperty().divide(6.666666666666667));
        this.kolIme.setStyle("-fx-alignment: CENTER;");
        this.kolIme.setOnEditCommit(t -> {
            ((Odbor)t.getTableView().getItems().get(t.getTablePosition().getRow())).setIme((String)t.getNewValue());
            OdborBaza.unesiPromjenuOdbor((Odbor)t.getTableView().getItems().get(t.getTablePosition().getRow()));
        });
        this.kolPrezime.setCellValueFactory(cellData -> ((Odbor)cellData.getValue()).prezimeProperty());
        this.kolPrezime.setCellFactory(TextFieldTableCell.forTableColumn());
        this.kolPrezime.prefWidthProperty().bind((ObservableValue)this.tablicaOdbor.widthProperty().divide(6.666666666666667));
        this.kolPrezime.setStyle("-fx-alignment: CENTER;");
        this.kolPrezime.setOnEditCommit(t -> {
            ((Odbor)t.getTableView().getItems().get(t.getTablePosition().getRow())).setPrezime((String)t.getNewValue());
            OdborBaza.unesiPromjenuOdbor((Odbor)t.getTableView().getItems().get(t.getTablePosition().getRow()));
        });
        this.kolTel.setCellValueFactory(cellData -> ((Odbor)cellData.getValue()).telefonProperty());
        this.kolTel.setCellFactory(TextFieldTableCell.forTableColumn());
        this.kolTel.prefWidthProperty().bind((ObservableValue)this.tablicaOdbor.widthProperty().divide(12.5));
        this.kolTel.setStyle("-fx-alignment: CENTER;");
        this.kolTel.setOnEditCommit(t -> {
            ((Odbor)t.getTableView().getItems().get(t.getTablePosition().getRow())).setTelefon((String)t.getNewValue());
            OdborBaza.unesiPromjenuOdbor((Odbor)t.getTableView().getItems().get(t.getTablePosition().getRow()));
        });
        this.kolEmail.setCellValueFactory(cellData -> ((Odbor)cellData.getValue()).emailProperty());
        this.kolEmail.setCellFactory(TextFieldTableCell.forTableColumn());
        this.kolEmail.prefWidthProperty().bind((ObservableValue)this.tablicaOdbor.widthProperty().divide(7.142857142857143));
        this.kolEmail.setStyle("-fx-alignment: CENTER;");
        this.kolEmail.setOnEditCommit(t -> {
            ((Odbor)t.getTableView().getItems().get(t.getTablePosition().getRow())).setEmail((String)t.getNewValue());
            OdborBaza.unesiPromjenuOdbor((Odbor)t.getTableView().getItems().get(t.getTablePosition().getRow()));
        });
        this.kolFunkcija.setCellValueFactory(cellData -> ((Odbor)cellData.getValue()).funkcijaProperty());
        this.kolFunkcija.setCellFactory(t -> {
            ComboBoxTableCell myComboBoxTableCell = new ComboBoxTableCell(this.listaFunkcija);
            myComboBoxTableCell.setOnKeyPressed(e -> {
                if (e.getCode() == KeyCode.DELETE) {
                    myComboBoxTableCell.commitEdit(null);
                }
                if (e.getCode() == KeyCode.ESCAPE) {
                    myComboBoxTableCell.cancelEdit();
                }
            });
            return myComboBoxTableCell;
        });
        this.kolFunkcija.prefWidthProperty().bind((ObservableValue)this.tablicaOdbor.widthProperty().divide(6.666666666666667));
        this.kolFunkcija.setStyle("-fx-alignment: CENTER;");
        this.kolFunkcija.setOnEditCommit(t -> {
            ((Odbor)t.getTableView().getItems().get(t.getTablePosition().getRow())).setFunkcija((String)t.getNewValue());
            OdborBaza.unesiPromjenuOdbor((Odbor)t.getTableView().getItems().get(t.getTablePosition().getRow()));
        });
        Callback dateCellFactory = param -> new DateCell();
        this.kolDatumImenovanja.setCellValueFactory(cellData -> ((Odbor)cellData.getValue()).datumImenovanjaProperty());
        this.kolDatumImenovanja.setCellFactory(dateCellFactory);
        this.kolDatumImenovanja.prefWidthProperty().bind((ObservableValue)this.tablicaOdbor.widthProperty().divide(10.0));
        this.kolDatumImenovanja.setStyle("-fx-alignment: CENTER;");
        this.kolDatumImenovanja.setOnEditCommit(t -> {
            ((Odbor)t.getTableView().getItems().get(t.getTablePosition().getRow())).setDatumImenovanja((LocalDate)t.getNewValue());
            OdborBaza.unesiPromjenuOdbor((Odbor)t.getTableView().getItems().get(t.getTablePosition().getRow()));
        });
        this.kolDokumentImenovanja.setCellValueFactory(cell -> ((Odbor)cell.getValue()).dokumentImenovanjaProperty());
        Callback cellDokument = param -> new ComboBoxCellDokument(this.listaDokumenti);
        this.kolDokumentImenovanja.setCellFactory(cellDokument);
        this.kolDokumentImenovanja.prefWidthProperty().bind((ObservableValue)this.tablicaEvidencijaSjednica.widthProperty().divide(5.882352941176471));
        this.kolDokumentImenovanja.setStyle("-fx-alignment: CENTER;");
        this.kolDokumentImenovanja.setOnEditCommit(t -> {
            ((Odbor)t.getTableView().getItems().get(t.getTablePosition().getRow())).setDokumentImenovanja((String)t.getNewValue());
            OdborBaza.unesiPromjenuOdbor((Odbor)t.getTableView().getItems().get(t.getTablePosition().getRow()));
        });
    }

    private void popuniTablicuOdbor() {
        this.progressIndicator = new ProgressIndicator();
        this.tablicaOdbor.setPlaceholder((Node)this.progressIndicator);
        this.progressIndicator.setMaxSize(200.0, 200.0);
        this.progressIndicator.setVisible(true);
        Task task = this.createTaskOdbor();
        new Thread((Runnable)task).start();
        this.progressIndicator.progressProperty().bind((ObservableValue)task.progressProperty());
        this.listaOdbor.clear();
        this.tablicaOdbor.getItems().clear();
    }

    private void popuniTablicuOdborizBaze() {
        int br = 1;
        ResultSet rs = OdborBaza.getOdbor(GlavniPanelController.getOdabranaTvrtka().getId());
        try {
            while (rs.next()) {
                Odbor o = new Odbor();
                o.setId(rs.getInt("id"));
                o.setRedBroj(String.valueOf(br));
                o.setIme(rs.getString("ime"));
                o.setPrezime(rs.getString("prezime"));
                o.setTelefon(rs.getString("telefon"));
                o.setEmail(rs.getString("email"));
                o.setFunkcija(rs.getString("funkcija"));
                o.setDatumImenovanja(DateUtil.getLocalDate(rs.getDate("datumimenovanja")));
                o.setDokumentImenovanja(rs.getString("dokumentimenovanja"));
                this.listaOdbor.add((Object)o);
                ++br;
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(OdborController.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.tablicaOdbor.getItems().addAll(this.listaOdbor);
    }

    private Task createTaskOdbor() {
        return new Task<Void>(){

            public Void call() {
                try {
                    this.updateProgress(-1.0, 1.0);
                    this.updateMessage("Waiting...");
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(OdborController.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    this.updateMessage("Running...");
                    OdborController.this.popuniTablicuOdborizBaze();
                }
                finally {
                    Platform.runLater(() -> OdborController.this.progressIndicator.setVisible(false));
                }
                return null;
            }
        };
    }

    private void popuniTablicuSjednicaizBaze() {
        int br = 1;
        ResultSet rs = OdborBaza.getSjednice(GlavniPanelController.getOdabranaTvrtka().getId());
        try {
            while (rs.next()) {
                Sjednica s = new Sjednica();
                s.setId(rs.getInt("id"));
                s.setRedBroj(String.valueOf(br));
                s.setNazivSjednice(rs.getString("nazivsjednice"));
                s.setDatumSjednice(DateUtil.getLocalDate(rs.getDate("datum")));
                s.setNazivDokumenta(rs.getString("zapisnik"));
                this.listaSjednica.add((Object)s);
                ++br;
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(OdborController.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.tablicaEvidencijaSjednica.getItems().addAll(this.listaSjednica);
    }

    private Task createTaskSjednica() {
        return new Task<Void>(){

            public Void call() {
                try {
                    this.updateProgress(-1.0, 1.0);
                    this.updateMessage("Waiting...");
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(OdborController.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    this.updateMessage("Running...");
                    OdborController.this.popuniTablicuSjednicaizBaze();
                }
                finally {
                    Platform.runLater(() -> OdborController.this.progressIndicator1.setVisible(false));
                }
                return null;
            }
        };
    }

    private void popuniTablicuSjednice() {
        this.progressIndicator1 = new ProgressIndicator();
        this.tablicaEvidencijaSjednica.setPlaceholder((Node)this.progressIndicator1);
        this.progressIndicator1.setMaxSize(200.0, 200.0);
        this.progressIndicator1.setVisible(true);
        Random rng = new Random();
        Task task = this.createTaskSjednica();
        new Thread((Runnable)task).start();
        this.progressIndicator1.progressProperty().bind((ObservableValue)task.progressProperty());
        this.listaSjednica.clear();
        this.tablicaEvidencijaSjednica.getItems().clear();
    }

    private void urediTablicuSjednice() {
        this.tablicaEvidencijaSjednica.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent e) {
                if (e.getCode() == KeyCode.ESCAPE && OdborController.this.tablicaEvidencijaSjednica.getEditingCell() == null) {
                    OdborController.this.tablicaEvidencijaSjednica.getSelectionModel().clearSelection();
                    e.consume();
                }
            }
        });
        this.kolRedBrSjednice.setCellValueFactory(cellData -> ((Sjednica)cellData.getValue()).redBrojProperty());
        this.kolRedBrSjednice.prefWidthProperty().bind((ObservableValue)this.tablicaEvidencijaSjednica.widthProperty().divide(10.0));
        this.kolRedBrSjednice.setStyle("-fx-alignment: CENTER;");
        Callback dateCellFactory = param -> new DateCell();
        this.kolDatumSjednice.setCellValueFactory(cellData -> ((Sjednica)cellData.getValue()).datumSjedniceProperty());
        this.kolDatumSjednice.setCellFactory(dateCellFactory);
        this.kolDatumSjednice.prefWidthProperty().bind((ObservableValue)this.tablicaOdbor.widthProperty().divide(5.0));
        this.kolDatumSjednice.setStyle("-fx-alignment: CENTER;");
        this.kolDatumSjednice.setOnEditCommit(t -> {
            ((Sjednica)t.getTableView().getItems().get(t.getTablePosition().getRow())).setDatumSjednice((LocalDate)t.getNewValue());
            OdborBaza.unesiPromjenuSjednica((Sjednica)t.getTableView().getItems().get(t.getTablePosition().getRow()));
            ServiceRestart.restartService(ServiceRestart.RService.sjednica);
        });
        this.kolNazivSjednice.setCellValueFactory(cellData -> ((Sjednica)cellData.getValue()).nazivSjedniceProperty());
        this.kolNazivSjednice.setCellFactory(TextFieldTableCell.forTableColumn());
        this.kolNazivSjednice.prefWidthProperty().bind((ObservableValue)this.tablicaOdbor.widthProperty().divide(3.3333333333333335));
        this.kolNazivSjednice.setStyle("-fx-alignment: CENTER;");
        this.kolNazivSjednice.setOnEditCommit(t -> {
            ((Sjednica)t.getTableView().getItems().get(t.getTablePosition().getRow())).setNazivSjednice((String)t.getNewValue());
            OdborBaza.unesiPromjenuSjednica((Sjednica)t.getTableView().getItems().get(t.getTablePosition().getRow()));
        });
        Callback cellDokument = param -> new ComboBoxCellDokument(this.listaDokumenti);
        this.kolDokumentSjednice.setCellValueFactory(cellData -> ((Sjednica)cellData.getValue()).nazivDokumentaProperty());
        this.kolDokumentSjednice.setCellFactory(cellDokument);
        this.kolDokumentSjednice.prefWidthProperty().bind((ObservableValue)this.tablicaEvidencijaSjednica.widthProperty().divide(3.3333333333333335));
        this.kolDokumentSjednice.setStyle("-fx-alignment: CENTER;");
        this.kolDokumentSjednice.setOnEditCommit(t -> {
            ((Sjednica)t.getTableView().getItems().get(t.getTablePosition().getRow())).setNazivDokumenta((String)t.getNewValue());
            OdborBaza.unesiPromjenuSjednica((Sjednica)t.getTableView().getItems().get(t.getTablePosition().getRow()));
        });
    }

    private void ispisPozivnice() {
        ObservableList listaOdbor = this.tablicaOdbor.getSelectionModel().getSelectedItems();
        String idArray = "";
        for (int i = 0; i < listaOdbor.size(); ++i) {
            idArray = i == 0 ? idArray + String.valueOf(((Odbor)listaOdbor.get(i)).getId()) : idArray + "," + String.valueOf(((Odbor)listaOdbor.get(i)).getId());
        }
        String sql = "select * from odborznr where  idtvrtka='" + GlavniPanelController.getOdabranaTvrtka().getId() + "' and id IN (select(unnest(ARRAY [" + idArray + "])))";
        System.out.println(sql);
        IspisReporta.ispisButtonSaSubreportom(sql, this.btnIspisOdbor, "PozivnicaOdborZNR.jrxml");
    }

    private void ispisZapisnika() {
        String sql = "select * from tvrtka where  id='" + GlavniPanelController.getOdabranaTvrtka().getId() + "' ";
        IspisReporta.ispisButtonSaSubreportom(sql, this.btnIspisSjednice, "Zapisnik.jrxml");
    }
}

