/*
 * Decompiled with CFR 0.152.
 */
package odjeli;

import Utill.FormValidation;
import Utill.FxDialogs;
import Utill.KlasaKorisneMetode;
import Utill.ResizeComponent;
import Utill.UtillBaza;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TextField;
import kadrovska.BazaDjelatnik;
import odjeli.BazaOdjeli;
import odjeli.Odjel;
import odjeli.PopisOdjelaController;
import zastitanaradu.GlavniPanelController;

public class UnosOdjelaController
implements Initializable {
    @FXML
    private ComboBox<String> cboxPoslovnaJedinica;
    @FXML
    private Button btnSpremi;
    @FXML
    private TextField txtOznaka;
    @FXML
    private TextField txtNaziv;
    private static UnosOdjelaController instance;
    private boolean izmjenaOdjela = false;
    Odjel odjelIzmjena;

    public static UnosOdjelaController getInstance() {
        return instance;
    }

    public void initialize(URL url, ResourceBundle rb) {
        instance = this;
        ResizeComponent.makeTextFieldResize(this.txtNaziv, this.txtOznaka);
        ResizeComponent.makeComboBoxResize(this.cboxPoslovnaJedinica);
        this.btnSpremi.setOnAction(e -> this.unosOdjela());
        this.popuniCBoxPoslovnice();
    }

    private Odjel dajOdjel() {
        Odjel o = new Odjel();
        o.setOznakaOdjela(this.txtOznaka.getText());
        o.setNazivOdjela(this.txtNaziv.getText());
        o.setPoslovnaJedinica((String)this.cboxPoslovnaJedinica.getValue());
        return o;
    }

    private void popuniCBoxPoslovnice() {
        ResultSet rs = BazaDjelatnik.dajPoslovnujednicu(GlavniPanelController.getOdabranaTvrtka());
        try {
            while (rs.next()) {
                this.cboxPoslovnaJedinica.getItems().add((Object)rs.getString("nazivposlovnice"));
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(UnosOdjelaController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(UnosOdjelaController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        ResizeComponent.sizeComboBoxToText(this.cboxPoslovnaJedinica, (String)this.cboxPoslovnaJedinica.getValue());
    }

    private void unosOdjela() {
        boolean bPoslovnaJedinica;
        boolean bNazivOdjela = FormValidation.textFieldValidationonlyText(this.txtNaziv);
        if (bNazivOdjela & (bPoslovnaJedinica = FormValidation.comboBoxValidationText(this.cboxPoslovnaJedinica))) {
            if (this.izmjenaOdjela) {
                if (BazaOdjeli.izmjenaOdjela(GlavniPanelController.getOdabranaTvrtka(), this.dajOdjel(), this.odjelIzmjena.getId())) {
                    PopisOdjelaController.getInstance().popuniTablicuOdjeli();
                    GlavniPanelController.getInstance().zatvoriTab("Unos odjela");
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.BOTTOM_RIGHT, "Uspje\u0161na izmjena odjela", 1, "Information graphic");
                } else {
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161na izmjena odjela", 2, "Error graphic");
                }
            } else if (UtillBaza.provjeraUnosa("select nazivodjela from odjeli where nazivodjela='" + this.txtNaziv.getText() + "'and nazivtvrtke='" + GlavniPanelController.getOdabranaTvrtka().getId() + "';", this.txtNaziv.getText())) {
                if (BazaOdjeli.unesiNoviOdjel(GlavniPanelController.getOdabranaTvrtka(), this.dajOdjel())) {
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.BOTTOM_RIGHT, "Uspje\u0161no unesena odjela", 1, "Information graphic");
                    PopisOdjelaController.getInstance().popuniTablicuOdjeli();
                    GlavniPanelController.getInstance().zatvoriTab("Unos odjela");
                    this.izmjenaOdjela = false;
                } else {
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161no unesena odjel", 2, "Error graphic");
                    System.out.println("neuspje\u0161no izmjenjena  djelatnika");
                }
            }
        } else {
            Alert alert = FxDialogs.getDialog(Alert.AlertType.INFORMATION, "Upozorenje", "Morate unjeti naziv Odjela");
            alert.showAndWait();
        }
    }

    public void izmjenaOdjela(Odjel o) {
        this.izmjenaOdjela = true;
        this.odjelIzmjena = o;
        this.txtNaziv.setText(o.getNazivOdjela());
        this.txtOznaka.setText(o.getOznakaOdjela());
        this.cboxPoslovnaJedinica.getSelectionModel().select((Object)o.getPoslovnaJedinica());
    }
}

