/*
 * Decompiled with CFR 0.152.
 */
package oir1;

import Utill.DateUtil;
import Utill.FormValidation;
import Utill.FxDialogs;
import Utill.KlasaKorisneMetode;
import Utill.ResizeComponent;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.DatePicker;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import oir1.BazaOir1;
import oir1.Oir1;
import oir1.PopisOir1Controller;
import ozljedanaradu.OzljedaNaRadu;
import zastitanaradu.GlavniPanelController;

public class Oir1Controller
implements Initializable {
    @FXML
    private Button btnSpremi;
    @FXML
    private AnchorPane anchorPanel;
    @FXML
    private TextField txtNazivInspekcije1;
    @FXML
    private TextField txtNazivInspekcije2;
    @FXML
    private TextField txtDogadjaj;
    @FXML
    private DatePicker dateDatumNastanka;
    @FXML
    private TextField txtSat;
    @FXML
    private Button btnUnos;
    @FXML
    private Button btnBrisanje;
    @FXML
    private TableView<Oir1> tablicaOzljedjeniRadnici;
    @FXML
    private TableColumn<Oir1, String> kolRadnikOzljeda;
    @FXML
    private TableColumn<Oir1, String> kolMjestoRadnika;
    @FXML
    private Button btnUnosP;
    @FXML
    private Button btnBrisanjeP;
    @FXML
    private TableView<Oir1> tablicaPoginuliRadnici;
    @FXML
    private TableColumn<Oir1, String> kolRadmikP;
    @FXML
    private TextArea txtAreaOpisDogadjaja;
    @FXML
    private TextArea txtAreaRukovoditelj;
    @FXML
    private TextArea txtAreaPrimjereneMjere;
    @FXML
    private TextArea txtAreaPrisutniZaposlenici;
    @FXML
    private TextField txtPodnositelj;
    @FXML
    private TextField txtMjestoPrijave;
    @FXML
    private DatePicker dateDatumPrijave;
    private static Oir1Controller instance;
    private final ObservableList<Oir1> listaOzljeda = FXCollections.observableArrayList();
    private final ObservableList<Oir1> listaOzljedaPoginuli = FXCollections.observableArrayList();
    private boolean izmjenaOir = false;
    private Oir1 oirIzmjena;

    public static Oir1Controller getInstance() {
        return instance;
    }

    public void initialize(URL url, ResourceBundle rb) {
        instance = this;
        ResizeComponent.makeTextFieldResize(this.txtNazivInspekcije1, this.txtNazivInspekcije2, this.txtDogadjaj);
        this.urediTablicuPopisOzljedjenih();
        this.urediTablicuPopisPoginulih();
        this.dateDatumPrijave.setValue((Object)LocalDate.now());
        this.dateDatumNastanka.setValue((Object)LocalDate.now());
        this.tablicaOzljedjeniRadnici.setItems(this.listaOzljeda);
        this.tablicaPoginuliRadnici.setItems(this.listaOzljedaPoginuli);
        this.btnUnos.setOnAction(e -> {
            OzljedaNaRadu o = FxDialogs.getORDijalog();
            if (o != null) {
                Oir1 ro = new Oir1();
                ro.setIdOzljedeNaRadu(o.getId());
                ro.setNazivRadnika(o.getTxt9() + "-" + o.getDatumPodnosenjaPrijave().format(DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM)));
                this.listaOzljeda.add((Object)ro);
            }
        });
        this.btnBrisanje.disableProperty().bind((ObservableValue)this.tablicaOzljedjeniRadnici.getSelectionModel().selectedItemProperty().isNull());
        this.btnBrisanje.setOnAction(e -> {
            Alert alert;
            Optional result;
            int index = this.tablicaOzljedjeniRadnici.getSelectionModel().getSelectedIndex();
            if (index != -1 && (result = (alert = FxDialogs.getDialog(Alert.AlertType.CONFIRMATION, "Brisanje", "\u017delite li obrisati radnika")).showAndWait()).get() == ButtonType.OK) {
                this.listaOzljeda.remove(index);
            }
        });
        this.btnUnosP.setOnAction(e -> {
            OzljedaNaRadu o = FxDialogs.getORDijalog();
            if (o != null) {
                Oir1 ro = new Oir1();
                ro.setIdPoginule(o.getId());
                ro.setNazivRadnika(o.getTxt9() + "-" + o.getDatumPodnosenjaPrijave().format(DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM)));
                this.listaOzljedaPoginuli.add((Object)ro);
            }
        });
        this.btnBrisanjeP.disableProperty().bind((ObservableValue)this.tablicaPoginuliRadnici.getSelectionModel().selectedItemProperty().isNull());
        this.btnBrisanjeP.setOnAction(e -> {
            Alert alert;
            Optional result;
            int index = this.tablicaPoginuliRadnici.getSelectionModel().getSelectedIndex();
            if (index != -1 && (result = (alert = FxDialogs.getDialog(Alert.AlertType.CONFIRMATION, "Brisanje", "\u017delite li obrisati radnika")).showAndWait()).get() == ButtonType.OK) {
                this.listaOzljedaPoginuli.remove(index);
            }
        });
        this.btnSpremi.setOnAction(e -> this.unosOir1());
    }

    private void urediTablicuPopisOzljedjenih() {
        this.tablicaOzljedjeniRadnici.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent e) {
                if (e.getCode() == KeyCode.ESCAPE) {
                    Oir1Controller.this.tablicaOzljedjeniRadnici.getSelectionModel().clearSelection();
                    e.consume();
                    return;
                }
            }
        });
        this.kolRadnikOzljeda.setCellValueFactory(cellData -> ((Oir1)cellData.getValue()).nazivRadnikaProperty());
        this.kolRadnikOzljeda.prefWidthProperty().bind((ObservableValue)this.tablicaOzljedjeniRadnici.widthProperty().divide(2.5641025641025643));
        this.kolRadnikOzljeda.setStyle("-fx-alignment: CENTER;");
        this.kolMjestoRadnika.setCellValueFactory(cellData -> ((Oir1)cellData.getValue()).mjestoradnikaProperty());
        this.kolMjestoRadnika.prefWidthProperty().bind((ObservableValue)this.tablicaOzljedjeniRadnici.widthProperty().divide(1.6666666666666667));
        this.kolMjestoRadnika.setCellFactory(TextFieldTableCell.forTableColumn());
        this.kolMjestoRadnika.setStyle("-fx-alignment: CENTER;");
    }

    private void urediTablicuPopisPoginulih() {
        this.tablicaPoginuliRadnici.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent e) {
                if (e.getCode() == KeyCode.ESCAPE) {
                    Oir1Controller.this.tablicaPoginuliRadnici.getSelectionModel().clearSelection();
                    e.consume();
                    return;
                }
            }
        });
        this.kolRadmikP.setCellValueFactory(cellData -> ((Oir1)cellData.getValue()).nazivRadnikaProperty());
        this.kolRadmikP.prefWidthProperty().bind((ObservableValue)this.tablicaPoginuliRadnici.widthProperty().divide(1.0101010101010102));
        this.kolRadmikP.setStyle("-fx-alignment: CENTER;");
    }

    private void unosOir1() {
        boolean bNazivOdjela = FormValidation.textFieldValidationonlyText(this.txtNazivInspekcije1);
        if (bNazivOdjela) {
            if (this.izmjenaOir) {
                if (BazaOir1.izmjenaOir1(GlavniPanelController.getOdabranaTvrtka(), this.dajOir1(), this.oirIzmjena.getId())) {
                    PopisOir1Controller.getInstance().popuniTablicuPopisOir1();
                    GlavniPanelController.getInstance().zatvoriTab("Obrazac OIR-1");
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.BOTTOM_RIGHT, "Uspje\u0161na izmjena oir", 1, "Information graphic");
                } else {
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161na izmjena oir", 2, "Error graphic");
                }
            } else if (BazaOir1.unesiNoviOir1(GlavniPanelController.getOdabranaTvrtka(), this.dajOir1())) {
                KlasaKorisneMetode.kreirajNotifikaciju(Pos.BOTTOM_RIGHT, "Uspje\u0161no unesen oir", 1, "Information graphic");
                PopisOir1Controller.getInstance().popuniTablicuPopisOir1();
                GlavniPanelController.getInstance().zatvoriTab("Obrazac OIR-1");
                this.izmjenaOir = false;
            } else {
                KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161no uneseno oir", 2, "Error graphic");
            }
        } else {
            Alert alert = FxDialogs.getDialog(Alert.AlertType.INFORMATION, "Upozorenje", "Morate unjeti text");
            alert.showAndWait();
        }
    }

    Oir1 dajOir1() {
        Oir1 o = new Oir1();
        o.setInspekcijaRada1(this.txtNazivInspekcije1.getText());
        o.setInspekcijaRada2(this.txtNazivInspekcije2.getText());
        o.setDogadjajNastao(this.txtDogadjaj.getText());
        o.setDatumDogadjaja((LocalDate)this.dateDatumNastanka.getValue());
        o.setSati(this.txtSat.getText());
        o.setIdOzljeda(this.getIdArrayOzljedene(this.listaOzljeda));
        o.setIdPoginuli(this.getIdArrayPoginuli(this.listaOzljedaPoginuli));
        o.setOpisDogadaja(this.txtAreaOpisDogadjaja.getText());
        o.setRukovoditelj(this.txtAreaRukovoditelj.getText());
        o.setPrimjenjeneMjere(this.txtAreaPrimjereneMjere.getText());
        o.setPrisutniZaposlenici(this.txtAreaPrisutniZaposlenici.getText());
        o.setPodnositelj(this.txtPodnositelj.getText());
        o.setMjestoPrijave(this.txtMjestoPrijave.getText());
        o.setDatumPrijave((LocalDate)this.dateDatumPrijave.getValue());
        return o;
    }

    String getIdArrayOzljedene(ObservableList<Oir1> lista) {
        String idArray = "";
        for (int i = 0; i < lista.size(); ++i) {
            idArray = i == 0 ? idArray + "['" + String.valueOf(((Oir1)lista.get(i)).getIdOzljedeNaRadu() + "','" + ((Oir1)lista.get(i)).getMjestoradnika() + "']") : idArray + ",['" + String.valueOf(((Oir1)lista.get(i)).getIdOzljedeNaRadu() + "','" + ((Oir1)lista.get(i)).getMjestoradnika() + "']");
        }
        return idArray;
    }

    String getIdArrayPoginuli(ObservableList<Oir1> lista) {
        String idArray = "";
        for (int i = 0; i < lista.size(); ++i) {
            idArray = i == 0 ? idArray + String.valueOf(((Oir1)lista.get(i)).getIdPoginule()) : idArray + "," + String.valueOf(((Oir1)lista.get(i)).getIdPoginule());
        }
        return idArray;
    }

    void izmjenaUputnice(Oir1 oirIzmjena) {
        this.izmjenaOir = true;
        this.oirIzmjena = oirIzmjena;
        this.txtNazivInspekcije1.setText(oirIzmjena.getInspekcijaRada1());
        this.txtNazivInspekcije2.setText(oirIzmjena.getInspekcijaRada2());
        this.txtDogadjaj.setText(oirIzmjena.getDogadjajNastao());
        this.dateDatumNastanka.setValue((Object)oirIzmjena.getDatumDogadjaja());
        this.txtSat.setText(oirIzmjena.getSati());
        this.popuniTablicuOzljedeni(oirIzmjena);
        this.popuniTablicuPoginuli(oirIzmjena);
        this.txtAreaOpisDogadjaja.setText(oirIzmjena.getOpisDogadaja());
        this.txtAreaRukovoditelj.setText(oirIzmjena.getRukovoditelj());
        this.txtAreaPrimjereneMjere.setText(oirIzmjena.getPrimjenjeneMjere());
        this.txtAreaPrisutniZaposlenici.setText(oirIzmjena.getPrisutniZaposlenici());
        this.txtPodnositelj.setText(oirIzmjena.getPodnositelj());
        this.txtMjestoPrijave.setText(oirIzmjena.getMjestoPrijave());
        this.dateDatumPrijave.setValue((Object)oirIzmjena.getDatumPrijave());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void popuniTablicuOzljedeni(Oir1 oirIzmjena) {
        ResultSet rs = BazaOir1.dajOzljede(GlavniPanelController.getOdabranaTvrtka(), oirIzmjena);
        try {
            while (rs.next()) {
                Oir1 o = new Oir1();
                o.setIdOzljedeNaRadu(rs.getInt("id"));
                o.setNazivRadnika(rs.getString("b9") + "-" + DateUtil.getLocalDate(rs.getDate("datumpodnosenjaprijave")).format(DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM)));
                o.setMjestoradnika(rs.getString("textopis"));
                this.listaOzljeda.add((Object)o);
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(Oir1.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(Oir1.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void popuniTablicuPoginuli(Oir1 oirIzmjena) {
        ResultSet rs = BazaOir1.dajPoginule(GlavniPanelController.getOdabranaTvrtka(), oirIzmjena);
        try {
            while (rs.next()) {
                Oir1 o = new Oir1();
                o.setIdPoginule(rs.getInt("id"));
                o.setNazivRadnika(rs.getString("b9") + "-" + DateUtil.getLocalDate(rs.getDate("datumpodnosenjaprijave")).format(DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM)));
                this.listaOzljedaPoginuli.add((Object)o);
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(Oir1.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(Oir1.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

